<!DOCTYPE html>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width">
        <title>Liquiloan | Política de Privacidade</title>
        <link href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400..700;1,400..700&display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Anton&display=swap" rel="stylesheet">
        
        <meta property="og:title" content="Liquiloan | Política de Privacidade" />
        <meta property="og:image" content="brandLogo.svg"/>
        
        <meta property="og:description" content="Liquiloan | Política de Privacidade">
        <meta name="description" content="Liquiloan | Política de Privacidade">
        <meta name="twitter:title" content="Liquiloan | Política de Privacidade">
        <meta name="twitter:image:src" content="brandLogo.svg"/>

        <link rel="stylesheet" href="main/style/bootstrap.css">
        <link rel="stylesheet" href="main/style/bootstrap-icons.css">
        <link rel="stylesheet" href="main/style/jquery.fancybox.css">
        <link rel="stylesheet" href="main/style/animate.min.css">
        <script src="main/jscript/jquery-3.7.1.min.js"></script>
        <script src="main/jscript/wow.min.js"> </script>

        

        <link rel="shortcut icon" href="brandLogo.svg" type="image/x-icon">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        
        <style>


            body{
                direction: ltr;
                font-family: 'Roboto Condensed', sans-serif !important;
                font-size: 17px;
                margin: 0;
                padding: 0px;
                color: #727272;
                background-color: #3B0944;
                position: relative;
            }

            a {
                text-decoration: none;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
                margin-top: 0;
                margin-bottom: 0;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
            color: #081828;
            }

            ul {
                padding-left: 0;
                margin-top: 0;
                margin-bottom: 0;
                list-style: none;
                padding-inline-start: 0;
            }

            img {
                display: block;
            }

            .no-scroll {
            overflow-y: hidden;
            }

            .link {
                text-decoration: none;
            }

            .link:hover,
            .link:focus {
                color: inherit;
                cursor: pointer;
            }

            .title {
                font-size: 30px;
                color: var(--text-sec-color);
                font-weight: 700;
                line-height: 1.2;
                text-align: center;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                .title {
                    font-size: 45px;
                }
            }

            .sub-title {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                .sub-title {
                    font-size: 18px;
                }
            }

            .main-btn {
                font-size: 16px;
                line-height: 1.5;
                font-weight: 600;
                padding: 12px;
                --bs-bg-opacity: 1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-sec-color);
                display: block;
                text-align: center;
                border: none;
            }

            .main-btn:hover,
            .main-btn:focus {
                --bs-bg-opacity: 0.8;
                color: var(--text-sec-color);
            }

            :root {
              --brand-color: #009500;
              --brand-color-rgb: 0;
              --text-color: rgb(149, 156, 177);
              --text-sec-color: #ffffff;
            }
           
            header .container-sp,
            section .container-sp,
            footer .container-sp {
                padding-left: 12px;
                padding-right: 12px;
                margin-left: auto;
                margin-right: auto;
                max-width: 1200px !important;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                section .container-sp {
                    padding-left: 15px;
                    padding-right: 15px;
                }
            }

            @media screen and (min-width: 992px) {
                section .container-sp {
                    padding-left: 19px;
                    padding-right: 19px;
                }
            }

            .header-sp {
                position: absolute;
                z-index: 10;
                width: 100%;
                background-color: transparent;
            }

            .nav-inner-sp {
                display: flex;
                align-items: center;
                justify-content: space-between;
                gap: 30px;
            }

            @media screen and (min-width: 992px) {
                .nav-inner-sp {
                    padding: 0 15px;
                }
            }

            .logo-link-sp {
                color: #ffffff;
                display: flex;
                align-items: center;
                gap: 10px;
                font-size: 24px;
                line-height: 1.1;
                padding: 2rem 0;
            }

            @media screen and (min-width: 576px) {
                .logo-link-sp {
                    font-size: 30px;
                }
            }

            @media screen and (min-width: 992px) {
                .logo-link-sp {
                    font-size: 32px;
                }
            }

            .logo-link-sp:hover {
                color: #ffffff;
            }

            .logo-link-sp__img {
                height: 24px;
            }

            @media screen and (min-width: 576px) {
                .logo-link-sp__img {
                    height: 30px;
                }
            }

            @media screen and (min-width: 992px) {
                .logo-link-sp__img {
                    height: 34px;
                }
            }

            .menu-btn-sp {
                padding: 6px 12px;
                width: 30px;
                height: 30px;
                position: relative;
                z-index:2;
                overflow: hidden;
                border: none;
                background-color: transparent;
            }

            @media screen and (min-width: 992px) {
                .menu-btn-sp {
                    display: none;
                }
            }

            .menu-btn-sp span {
                width: 30px;
                height: 2px;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background-color: #ffffff;
                transition: all 0.5s;
            }

            .menu-btn-sp span:nth-of-type(2) {
                top: calc(50% - 5px);
            }
            .menu-btn-sp span:nth-of-type(3) {
                top: calc(50% + 5px);
            }
          
            .menu-btn-sp.active span:nth-of-type(1) {
                display: none;
            }

            .menu-btn-sp.active span:nth-of-type(2) {
                top: 50%;
                transform: translate(-50%, 0%) rotate(45deg);  
            }

            .menu-btn-sp.active span:nth-of-type(3) {
                top: 50%;
                transform: translate(-50%, 0%) rotate(-45deg); 
            }

            .span-btn {
                width: 30px;
                height: 2px;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background-color: white;
                transition: all 0.5s;
            }

            .menu-btn span:nth-of-type(2) {
                top: calc(50% - 10px);
            }

            .menu-btn span:nth-of-type(3) {
                top: calc(50% + 10px);
            }

            .menu-btn.active span:nth-of-type(1) {
                display: none;
            }

            .menu-btn.active span:nth-of-type(2) {
                top: 50%;
                background-color:  white;
                transform: translate(-50%, 0%) rotate(45deg);
            }

            .menu-btn.active span:nth-of-type(3) {
                top: 50%;
                background-color:  white;
                transform: translate(-50%, 0%) rotate(-45deg);
            }
 
            .mob-menu-sp {
                display: none;
                position: absolute;
                top: 88px !important;
                width: 60%;
                --bs-bg-opacity: 0.95;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                z-index: 9;
                box-shadow: 0px 15px 20px 0px rgba(0, 0, 0, 0.1);
                padding: 10px 20px;
                max-height: 350px;
                overflow-y: scroll;
                border-radius: 6px;
                transform: translateX(-100%);
	            transition: transform 0.5s; 
            }

            .mob-menu-sp.active {
                display: block;
                transform: translateX(0);
            }

            .mob-menu-sp li {
                list-style-type: none;
            }

            .mob-nav-bar-sp {
                display: flex;
                flex-direction: column;
                padding-left: 0;
                list-style: none;
            }

            .mob-nav-bar-sp__list a {
                padding: 12px 16px !important;
                color: #ffffff;
                display: block;
            }
            .mob-nav-bar-sp__item {
                position: relative;
            } 

            @media screen and (min-width: 992px) {
                .menu-btn-sp {
                    display: none;
                }
            }

            .is-hidden {
                display: none;
            }

            @media screen and (max-width: 991px) {
                .nav-bar-sp {
                    display: none;
                }
            }

            .nav-bar-sp__list {
                display: flex;
                gap: 47px;
                padding: 35px 0;
            }

            .nav-bar-sp__link {
                color: #ffffff;
                text-align: center;
            }

            .nav-bar-sp__link:hover,
            .header-sp.active .nav-bar-sp__link:hover {
                color: var(--text-color);
            } 

            .header-sp.active {
                --bs-bg-opacity: 0.2;
                background-color: rgba(var(--brand-color-rgb), var(--bs-bg-opacity)) !important;
                position: fixed;
                backdrop-filter: blur(5px);
                box-shadow: inset 0 -1px 0 0 rgba(0, 0, 0, 0.1);
            }

            .header-sp.active .nav-bar-sp__list {
                padding: 24px 0;
            }

            .hero-area-sp {
                position: relative;
                background-image: linear-gradient(to right, rgba(47, 48, 58, 0.4), rgba(47, 48, 58, 0.4)), url("album/depictions_header_665e085f0656e6.97491084.jpg");
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                background-color: #081828;
                z-index: 0;
                padding-top: 210px;
                padding-bottom: 200px;
                overflow: hidden;
            }

            .hero-bg-el-1 {
                position: absolute;
                right: 0;
                top: 0;
            }

            .hero-bg-el-2 {
                position: absolute;
                left: 0;
                bottom: 0;
            }

            .hero-inner-sp {
                margin-right: auto;
                margin-left: auto;
                text-align: center;
                position: relative;
                z-index: 5;
            }

            @media screen and (min-width: 575px) {
                .hero-inner-sp {
                    max-width: 80%;
                }
            }

            @media screen and (min-width: 992px) {
                .hero-inner-sp {
                    max-width: 60%;
                }
            }

            .welcome-title-sp {
                text-align: center;
                font-size: 20px;
                line-height: 1.625;
                margin-bottom: 48px;
                color: var(--text-sec-color);
                font-weight: 500;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 575px) {
                .welcome-title-sp {
                    font-size: 22px;
                }
            }

            @media screen and (min-width: 992px) {
                .welcome-title-sp {
                    font-size: 24px;
                }
            }

            .welcome-btn-sp {
                padding: 16px 32px;
                background-color: var(--brand-color);
                color: var(--text-sec-color);
                font-size: 14px;
                line-height: 1.5;
                font-weight: 600;
                border-radius: 6px;
                transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
                transition-duration: 300ms;
                visibility: visible;
                animation-delay: 0.4s;
            }

            @media screen and (min-width: 575px) {
                .welcome-btn-sp {
                    font-size: 16px;
                }
            }

            .welcome-btn-sp:hover,
            .welcome-btn-sp:focus {
                background-color: #009500cc;
                color: var(--text-sec-color);
            }

            .features-sp {
                padding-top: 80px;
                padding-bottom: 30px;
                --bs-bg-opacity: 0.1;
                background-color: rgba(var(--brand-color-rgb), var(--bs-bg-opacity));
            }

            @media screen and (min-width: 575px) {
                .features-sp {
                padding-top: 80px;
                padding-bottom: 50px;
                }
            }

            .features-sp-title {
                margin-bottom: 30px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .marg {
                margin-bottom: 80px;
                text-align: center;
                visibility: visible;
                animation-delay: 0.2s;
            }
            
            .features-sp-list {
                display: flex;
                flex-direction: column;
                gap: 40px;
                margin-bottom: 40px;
            }

            @media screen and (min-width: 575px) {
                .features-sp-list {
                    display: flex;
                    flex-direction: row;
                    flex-wrap: wrap;
                    gap: 40px;
                    margin-bottom: 40px;
                }
            }

            .features-sp-it {
                display: flex;
                width: 100%;
                gap: 20px;
                padding: 0 10px;
                visibility: visible;
                animation-delay: 0.15s;
            }

            @media screen and (min-width: 575px) {
                .features-sp-it {
                    display: flex;
                    flex-basis: calc(100% / 2 - 20px);
                    gap: 20px;
                    padding: 0;
                }
            }

            .features-sp-ic__wr {
                width: 70px;
                height: 70px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 15px;
                color: var(--brand-color);
            }
            
            .features-sp-item__text {
                color: var(--text-color);
            }

            .conclusion {
                margin-top: 50px;
                text-align: center;
                border-top: solid 1px;
                border-bottom: solid 1px;
                border-color: #ffffff1a;
                padding: 20px;
            }

            .main-sp {
                padding: 100px 0;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
            }

            @media screen and (min-width: 575px) {
                .main-sp {
                    padding: 60px 0;
                }
            }

            .main-sp-img {
                width: 100%;
                border-radius: 6px;
            }

            .main-sp-img-wraper {
                width: 80%;
                margin-right: auto;
                margin-left: auto;
                margin-bottom: 40px;
                border-radius: 6px;
                --bs-shadow-opacity-4: 0.4;
                --bs-shadow-opacity-3: 0.3;
                --bs-shadow-opacity-2: 0.2;
                --bs-shadow-opacity-1: 0.1;
                --bs-shadow-opacity-5: 0.05;
                box-shadow: rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-4)) -5px 5px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-3)) -10px 10px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-2)) -15px 15px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-1)) -20px 20px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-5)) -25px 25px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .main-sp-text {
                margin-top: 32px;
                color: var(--text-color);
                font-size: 15px;
            }

            @media screen and (min-width: 575px) and (max-width: 991px) {
                .main-sp-text {
                    font-size: 16px;
                    padding: 0 15px;
                }
            }

            .main-sp-text h5 {
                color: var(--text-color);
                text-align: center;
            }

            .main-sp-text ul {
                margin-bottom: 16px;
                padding-left: 30px;
                list-style: circle;
                padding-inline-start: 35px;
            }

            .main-sp-price-wrap {
                text-align: center;
            }

            .main-sp-price {
                font-size: 20px;
                display: inline-block;
                padding: 12px 48px;
                margin-top: 32px;
                box-shadow: rgba(0, 0, 0, 0.2) 0px 20px 30px;
            }

            @media screen and (min-width: 575px) {
                .main-sp-price {
                    font-size: 24px;
                }
            }

            .video-sp {
                padding: 120px 0;
                position: relative;
            }

            @media screen and (min-width: 575px) {
                .video-sp {
                    padding: 60px 0;
                }
            }

            .video-bg {
                position: absolute;
                bottom: 0;
                left: 0;
                max-width: 100%;
            }

            .inner-content-sp {
                text-align: center;
            }

            .video-title-wraper-sp {
                margin-bottom: 80px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .intro-video-play-sp {
                position: relative;
                border-radius: 6px;
                max-width: 770px;
                margin-left: auto;
                margin-right: auto;
                visibility: visible;
                animation-delay: 0.2s;
            }
                .intro-video-play-sp video {
                    height: 350px;
                }
                @media (max-width: 680px) {
                    .intro-video-play-sp video {
                    height: 150px;
                }
                }
            .intro-video-sp__img {
                width: 100%;
                height: auto;
                border-radius: 6px;

            }

            .play-thumb-sp {
                position: absolute;
                right: 0;
                top: 0;
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
                height: 100%;
            }

            .play-btn-sp {
                --bs-bg-opacity: 0.75;
                background-color: rgb(255 255 255 / var(--bs-bg-opacity));
                border-radius: 50%;
                text-align: center;
                width: 70px;
                height: 70px;
                border: none;
            }

            .play-btn-sp:hover, 
            .play-btn-sp:focus {
                --bs-bg-opacity: 1;
                background-color: rgb(255 255 255 / var(--bs-bg-opacity));
            }

            .bi-play-fill {
                font-size: 26px;
                line-height: 1;
                color: var(--brand-color); 
            }

            .backdrop {
                position: fixed;
                top: 0;
                left: 0;
                z-index: 11;
                width: 100vw;
                height: 100vh;
                background-color: rgba(0, 0, 0, 0.95);
                transition: opacity 250ms cubic-bezier(0.4, 0, 0.2, 1), visibility 250ms cubic-bezier(0.4, 0, 0.2, 1);
            }

            .backdrop.is-hidden {
                opacity: 0;
                pointer-events: none;
                visibility: hidden;
            }

            .modal-btn {
                position: absolute;
                top: 8px;
                right: 8px;
                display: flex;
                justify-content: center;
                align-items: center;
                padding: 0;
                background-color: transparent;
                border: 1px solid rgba(0, 0, 0, 0.1);
                transition: fill 250ms cubic-bezier(0.4, 0, 0.2, 1);
            }

            .modal-btn:hover svg,
            .modal-btn:focus svg {
                transform: scale(1.1);
                cursor: pointer;
            }

            .modal-btn svg {
                fill:#ffffff;
            }

            .video-wraper {
                width: 90vw;
                height: auto;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
            }

            @media screen and (min-width: 992px) {
                .video-wraper {
                    max-width: 70%;
                }
            }

            .video-wraper video {
                width: 100%;
            }

            .partners {
                padding: 64px 0;
            }

            @media screen and (min-width: 576px) {
                .partners {
                    padding: 64px;
                }
            }
            @media screen and (min-width: 992px) {
                .partners {
                    padding: 64px;
                }
            }

            .partners-wraper {
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 60px 20px;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 576px) {
                .partners-wraper {
                    padding: 60px 40px;
                }
            }

            @media screen and (min-width: 992px) {
                .partners-wraper {
                    padding: 60px 50px;
                }
            }

            .partners-list {
                display: flex;
                flex-direction: column-reverse;
                justify-content: center;
                align-items: center;
            }

            @media screen and (min-width: 576px) {
                .partners-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                    gap: 20px;
                }
            }

            @media screen and (min-width: 992px) {
                .partners-list {
                    flex-wrap: nowrap;
                }
            }

            .partners-item {
                flex-basis: calc(100% / 5 - 30px);
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .partners-link {
                height: 150px;
                cursor: auto;
                display: block;
                width: 100%;
                padding: 15px 0;
            }

            .partners-link img {
                object-fit: contain;
                margin-left: auto;
                margin-right: auto;
            }

            .greyscale {
                --bs-grayscale: grayscale(100%);
                filter: var(--bs-grayscale);
            }

            .greyscale:hover,
            .greyscale:focus {
                --bs-grayscale: grayscale(0%);
            }

            .comments-sp {
                position: relative;
                padding-bottom: 50px;
                padding-top: 80px;
                --bs-bg-opacity: 0.03;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
            }

            @media screen and (min-width: 576px) {
                .comments-sp {
                    padding-bottom: 80px;
                    padding-top: 120px;
                }
            }

            .comments-sp-header {
                visibility: visible;
                animation-delay: 0.2s;
            }
            .comments-sp-header__text {
                margin-top: 16px;
                margin-bottom: 60px;
                text-align: center;
            }

            .comments-sp-wraper {
                visibility: visible;
                animation-delay: 0.4s;
            }

            .comments-sp-list {
                display: flex;
                flex-direction: column-reverse;
                gap: 32px;
                justify-content: center;
            }

            @media screen and (min-width: 576px) {
                .comments-sp-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                }
            }

            @media screen and (min-width: 992px) {
                .comments-sp-list {
                    flex-wrap: nowrap;
                }
            }

            .comments-sp-item {
                width: 100%;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 16px;
                display: flex;
            }

            @media screen and (min-width: 576px) {
                .comments-sp-item {
                    flex-basis: calc(100% / 2 - 16px);
                    padding: 32px;
                }
            }

            @media screen and (min-width: 992px) {
                .comments-sp-item {
                    flex-basis: calc(100% / 3 - 16px);
                }
            }

            .comments-sp-item-stars {
                display: flex;
                align-items: center;
                padding-bottom: 20px;
            }
            
            .comments-star {
                margin-right: 4px;
                fill: #fbb040;
            }

            .comments-sp-text {
                color: var(--text-sec-color);
                font-size: 16px;
                line-height: 26px;
                margin-bottom: 0;
            }

            .comments-sp-author {
                display: flex;
                justify-content: flex-start;
                align-items: center;
                gap: 16px;
                border-color: #ffffff1a;
            }

            .comments-sp-avatar {
                display: block;
                border-radius: 50;
                width: 50px;
                height: 50px;
            }

            .comments-sp-name {
                font-size: 18px;
                color: var(--text-sec-color);
                line-height: 28px;
                font-weight: 600;
                margin-bottom: 4px;
            }

            .comments-sp-position {
                color: var(--text-color);
                font-size: 14px;
                margin-bottom: 0;
            }

            .comments-dec1 {
                position: absolute;
                top: 20px;
                right: 0;
                z-index: -1;
            }

            .comments-dec2 {
                position: absolute;
                bottom: 20px;
                left: 0;
                z-index: -1;
            }

            .tarifs-sp {
                position: relative;
                padding-top: 120px;
                padding-bottom: 80px;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp {
                    padding-top: 80px;
                    padding-bottom: 50px;
                }
            }

            .tarifs-sp-list {
                display: flex;
                flex-direction: column-reverse;
                gap: 16px;
                visibility: visible;
                animation-delay: 0.2s;
                justify-content: center;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                    gap: 32px;
                }
            }

            @media screen and (min-width: 992px) {
                .tarifs-sp-list {
                    flex-wrap: nowrap;
                    gap: 32px;
                }
            }

            .tarifs-sp-item {
                position: relative;
                width: 100%;
                padding: 40px 32px;
                border-radius: 6px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                display: flex;
                flex-direction: column;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp-item {
                    flex-basis: calc(100% / 2 - 16px);
                }
            }

            @media screen and (min-width: 992px) {
                .tarifs-sp-item {
                    flex-basis: calc(100% / 3 - 16px);
                }
            }

            .tarifs-sp-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .tarifs-sp-price {
                font-size: 20px;
                line-height: 1.2;
                font-weight: 700;
                color: var(--text-sec-color);
            }

            .tarifs-sp-price span {
                color: var(--text-color);
                text-transform: lowercase;
            }

            .tarifs-sp-title {
                font-size: 20px;
                line-height: 1.4;
                font-weight: 700;
                color: var(--text-sec-color);
                text-align: end;
            }

            .tarifs-sp-middle {
                padding-bottom: 32px;
                margin: 32px 0;
                border-bottom: solid 1px;
                border-color: #ffffff1a;
            }

            .tarifs-sp-link {
                font-size: 16px;
                line-height: 1.5;
                font-weight: 600;
                padding: 12px;
                --bs-bg-opacity: 1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-sec-color);
                display: block;
                text-align: center;
            }

            .tarifs-sp-link:hover,
            .tarifs-sp-link:focus {
                --bs-bg-opacity: 0.8;
                color: var(--text-sec-color);
            }

            .tarifs-sp-details-list {
                display: flex;
                flex-direction: column;
                gap: 12px;
            }

            .tarifs-sp-details-item {
                display: flex;
                align-items: center;
            }

            .tarifs-sp-details-item p {
                margin-bottom: 0;
                color: var(--text-color);
                font-size: 16px;
            }

            .tarifs-sp-details-item .prev-details {
                text-align: center;
                color: #ffffff;
                margin-left: 20px;
            }

            .tarifs-sp-details-on {
                position: relative;
                border-radius: 50%;
                min-width: 18px;
                height: 18px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                margin-right: 12px;
            }

            .tarifs-sp-details-on i {
                position: absolute;
                font-size: 18px;
                --bs-text-opacity: 1;
                color: rgb(var(--brand-color-rgb) / var(--bs-text-opacity));
                text-align: center;
                line-height: 0.7;
            }

            .tarifs-sp-item-dec {
                position: absolute;
                right: 0;
                bottom: 0;
                z-index: -1;
            }

            .tarifs-sp-dec {
                position: absolute;
                left: 0;
                bottom: 0;
                z-index: -1;
            }

            .forms {
                padding-top: 120px;
                padding-bottom: 80px;
            }

            @media screen and (min-width: 576px) {
                .forms {
                    padding-top: 80px;
                    padding-bottom: 50px;
                }
            }

            .forms .container-sp {
                display: flex;
                flex-direction: column;
                gap: 32px;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 992px) {
                .forms .container-sp {
                    flex-direction: row;
                }
            }

            .form-sp-wrap {
                width: 100%;
                padding: 44px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
            }

            @media screen and (min-width: 576px) {
                .form-sp-wrap {
                    width: 100%;
                    max-width: 688px;
                    padding: 55px;
                    margin-left: auto;
                    margin-right: auto;
                }
            }

            @media screen and (min-width: 992px) {
                .form-sp-wrap {
                    max-width: 66.66%;
                }
            }

            .form-sp {
                display: flex;
                flex-direction: column;
                margin-top: 48px;
            }

            .input-f51389365,
            .textarea-f51389365 {
                display: block;
                padding: 12px 24px;
                box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
                border: solid 1px transparent;
                outline: 2px solid transparent;
                outline-offset: 2px;
                --bs-bg-opacity: 0.05;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
                margin-bottom: 32px;
            }

            .input-f51389365::placeholder,
            .textarea-f51389365::placeholder {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
            }

            .textarea-f51389365 {
                display: block;
                height: 132pxpx;
                padding-top: 15px;
            }

            .input-f51389365:focus,
            .textarea-f51389365:focus {
                border-color: var(--brand-color);
                outline: none;
            }

            .form-sp label {
                color: var(--text-sec-color);
                font-size: 14px;
                line-height: 1.43;
                font-weight: 500;
                margin-bottom: 12px;
            }

            .form-sp-btn {
                padding-left: 36px;
                padding-right: 36px;
                border: none;
            }

            .form .form-sp-check-label,
            .form-sp-check-label a {
                font-size: 14px;
            }
            
            .form-sp-check-label a {
                color: var(--text-sec-color);
                font-weight: 500;
            }

            @media screen and (min-width: 375px) {
                .form-check-label a {
                    font-weight: 700;
                }
            }

            .form-sp-check-input {
                margin-top: 0;
            }

            .form-sp-check-input {
                margin-right: 15px;
            }

            .form-sp-check-label a {
                color: var(--brand-color);
            }

            .signup-sp {
                position: relative;
                width: 100%;
                padding: 60px 44px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                overflow: hidden;
            }

            @media screen and (min-width: 576px) {
                .signup-sp {
                    width: 100%;
                    max-width: 688px;
                    padding: 60px 44px;
                    margin-left: auto;
                    margin-right: auto;
                }
            }

            @media screen and (min-width: 992px) {
                .signup-sp {
                    max-width: 33.33%;
                }
            }

            .signup-only {
                max-width: 100%;
            }

            @media screen and (min-width: 576px) {
                .signup-only {
                    width: 80%;
                max-width: 500px;
                }
            }

            @media screen and (min-width: 992px) {
                .signup-only {
                max-width: 60%;
                }
            }

            .signup-sp__text {
                font-size: 20px;
                line-height: 1.25;
                color: var(--text-sec-color);
                padding-bottom: 44px;
                margin-bottom: 44px;
                border-bottom: solid 1px;
                border-color: #ffffff33;
            }

            @media screen and (min-width: 576px) {
                .signup-sp__text {
                    font-size: 24px;
                    padding-bottom: 55px;
                    margin-bottom: 55px;
                }
            }

            .signup-sp__form {
                display: flex;
                flex-direction: column;
                width: 100%;
            }

            .signup-sp__mail {
                padding: 12px 24px;
                border: none;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
                border: solid 1px #ffffff1a;
                border-radius: 6px;
                margin-bottom: 30px;
            }

            .signup-sp__mail::placeholder {
                color: var(--text-color);
            }

            .singup-sp__submit {
                padding: 12px 24px;
                width: 100%;
            }

            .signup-sp-dec1 {
                position: absolute;
                top: 0;
                left: 0;
                z-index: -1;
            }

            .signup-sp-dec2 {
                position: absolute;
                bottom: 0;
                right: 0;
                z-index: -1;
            }

            .footer-sp {
                position: relative;
                padding-top: 100px;
                padding-bottom: 60px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                visibility: visible;
                animation-delay: 0.2s;
            }

            .ftop-sp {
                display: flex;
                flex-direction: column;
                gap: 80px;
                justify-content: space-between;
            }

            @media screen and (min-width: 576px) {
                .ftop-sp {
                    flex-direction: row;
                    flex-wrap: wrap;
                    gap: 80px;
                }
            }

            @media screen and (min-width: 992px) {
                .ftop-sp {
                    flex-wrap: nowrap;
                    gap: 20px;
                }
            }

            .footer-sp-item .logo-link-sp {
                height: 28px;
            }

            .footer-sp-item {
                max-width: 100%;
            }

            @media screen and (min-width: 576px) {
                .footer-sp-item {
                    padding-left: 20px;
                    flex: 1;
                }
            }

            .footer-sp__text {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
                margin-top: 20px;
            }

            .footer-sp-title {
                font-size: 20px;
                line-height: 1.4;
                font-weight: 700;
                color: var(--text-sec-color);
                margin-bottom: 30px;
                margin-top: 25px;
            }

            .footer-sp-contacts__item {
                display: flex;
                gap: 15px;
            }

            .footer-sp-contacts__item:hover a,
            .footer-sp-contacts__item:focus a {
                color: var(--text-color);
            }

            .footer-contact {
                margin: 0;
            }

            .fbottom-pol {
                padding-top: 80px;
            }

            .fbottom-pol a {
                display: block;
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
                margin-bottom: 20px;
            }

            .footer-sp-dec1 {
                position: absolute;
                left: 0;
                bottom: 0;
                z-index: -1;
            }

            .footer-sp-dec2 {
                position: absolute;
                right: 0;
                top: 56px;
                z-index: -1;
            }

            .back-to-top {
                display: flex;
                justify-content: center;
                align-items: center;
                position: fixed;
                border: transparent;
                border-radius: 6px;
                background-color: var(--brand-color);
                cursor: pointer;
                z-index: 9999;
                font-size: 40px;
                right: 30px;
                bottom: 30px;
                border-radius: 5px;
                height: 40px;
                width: 40px;
                line-height: 25px;
                text-align: center;
                color: #ffffff;
                visibility: hidden;
            }

            .back-to-top i,
            .back-to-top i {
                font-size: 24px;
            }

            .back-to-top:hover i,
            .back-to-top:focus i {
                color: #ffffff;
            }

            .back-to-top.active {
                visibility: visible;
            }

            .visually-hidden {
                position: absolute;
                white-space: nowrap;
                width: 1px;
                height: 1px;
                overflow: hidden;
                border: 0;
                padding: 0;
                clip: rect(0 0 0 0);
                clip-path: inset(50%);
                margin: -1px;
            }

            .content-block h1,
            .content-block h2, 
            .content-block h3,
            .content-block h4 {
                color: var(--text-sec-color) !important;
            }

            @media (max-width: 767px){
                .comments-sp-list {
                    flex-direction: column !important;
                }
                .tarifs-sp-list {
                    flex-direction: column !important;
                }
        }

        @media (max-width: 1200px){

.pro-text {
 width: 80% !important;
 margin: auto;
}
 
.our-bnft-decpic img {
     width: 680px;
}


}


@media (max-width: 992px) {

 .pro-bg {
     background-size: cover !important;
 }

 .our-bnft-list {
     flex-wrap: wrap !important;
 }

 .our-bnft-item {
     width: 47% !important;
 }

 .our-bnft-title {
     padding: 25px 30px;
     width: fit-content;
     background-color: rgb(0 0 0 / 70%);
     border-radius: 15px;
 }

 .our-bnft-decpic {
     top: -60px;
 }

 .our-bnft-decpic img {
     height: 430px;
 }

 .serv-item {
     width: 45% !important;
     margin: 0 !important;
 }

 .serv-list {
     position: relative;
 }

 .packages {
     justify-content: space-around !important;
     flex-wrap: wrap;
     gap: 25px;
 }

 .tarif-pack {
     width: 45%;
 }

 .footer-head-nav a {
     font-size: 16px;
 }

 .stat-rand-item h4 {
     font-size: 14px;
 }

 .stat-rand-item {
     padding: 15px 10px;
 }

 .stat-rand-list {
     gap: 15px;
     margin-bottom: 120px;
 }

 .ques-form {
     align-items: center;
 }

 .footer-liner-block {
     flex-direction: column !important;
 }

.home-article-price {
 display: flex;
 width: fit-content;
}


.form-md-content {
 width: 80%;
}



}


@media (max-width: 767px) {

.hdr-logo-name {
 font-size: 16px;
}

.hdr-block {
 flex-direction: column !important;
}

.hdr-nav-link {
 font-size: 14px;
}

.hdr-main-title {
 font-size: 22px;
 margin-bottom: 20px;
}

.our-bnft-decpic img {
 height: 360px;
 width: 490px;
}

.our-bnft-decpic img {
 font-size: 20px;
}

.our-bnft-item {
 padding: 10px;
}

.home-article-img {
 float: none;
 width: 100%;
 margin-right: 0 ;
 margin-left: 0 ;
}

.packages {
 flex-direction: column;
}

.tarif-pack {
 width: 100%;
}

.ques-form {
 flex-direction: column;
}

.footer-conts-list {
 flex-direction: column;
}

.ques-block {
 width: 100%;
}

.stat-rand-block {
 width: 100%;
}

.footer-conts-item {
 width: 100%;
}

.form-half {
 width: 100%;
}

.footer-head-nav a {
 font-size: 14px;
}




}


@media(max-width: 576px){

 .hdr-nav-list {
     display: flex;
     flex-wrap: wrap;
     justify-content: center;
 }

 .our-bnft-decpic {
 top: -30px;
} 

.our-bnft-decpic img {
 height: 270px;
 width: 290px;
} 

.our-bnft-list {
 flex-direction: column;
}

.our-bnft-item {
 width: 100% !important;
}

.serv-img {
 display: none;
}

.serv-title-block {
 width: 100%;
}

.serv-list {
 flex-direction: column;
}

.serv-item {
 width: 100% !important;
}

.footer-head-nav {
 flex-direction: column;
 align-items: center;
}

}

             
        </style>
       
        
    </head>

    <body>
     
        <header class="header-sp header__T95SP__style">
            <div class="container-sp">
                <div class="nav-inner-sp flex-row-reverse">
                    <a class="logo-link-sp link" href="./">
                        <img class="logo-link-sp__img" src="brandLogo.svg" width="37px" alt="">Liquiloan
                    </a>
                    <button class="menu-btn-sp" type="button">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>

                    <div class="mob-menu-sp" id="mobile-menu" data-menu>
                        <nav class="mob-nav-bar-sp">
                            <ul class="mob-nav-bar-sp__list list">
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./">Página inicial</a>
                                </li>
                                
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./#comments">Comentários</a>
                                </li>
                                
                                
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./#tariffs">As nossas tarifas</a>
                                </li>
                                
                                
                            </ul>
                        </nav>
                    </div>

                    <nav class="nav-bar-sp">
                        <ul class="nav-bar-sp__list list">
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./">Página inicial</a>
                            </li>
                            
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./#comments">Comentários</a>
                            </li>
                            
                            
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./#tariffs">As nossas tarifas</a>
                            </li>
                            
                            
                        </ul>
                    </nav>
                </div>
            </div>
        </header>

       <section class="hero-area-sp btn--IudN6--style">
            <svg class="hero-bg-el-1" width="450" height="556" viewBox="0 0 450 556" fill="none" xmlns="http://www.w3.org/2000/svg">
            <circle cx="277" cy="63" r="225" fill="url(#paint0_linear_25:217)"></circle>
            <circle cx="17.9997" cy="182" r="18" fill="url(#paint1_radial_25:217)"></circle>
            <circle cx="76.9997" cy="288" r="34" fill="url(#paint2_radial_25:217)"></circle>
            <circle cx="325.486" cy="302.87" r="180" transform="rotate(-37.6852 325.486 302.87)" fill="url(#paint3_linear_25:217)"></circle>
            <circle opacity="0.8" cx="184.521" cy="315.521" r="132.862" transform="rotate(114.874 184.521 315.521)" stroke="url(#paint4_linear_25:217)"></circle>
            <circle opacity="0.8" cx="356" cy="290" r="179.5" transform="rotate(-30 356 290)" stroke="url(#paint5_linear_25:217)"></circle>
            <circle opacity="0.8" cx="191.659" cy="302.659" r="133.362" transform="rotate(133.319 191.659 302.659)" fill="url(#paint6_linear_25:217)"></circle>
            <defs>
            <linearGradient id="paint0_linear_25:217" x1="-54.5003" y1="-178" x2="222" y2="288" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            <radialGradient id="paint1_radial_25:217" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(17.9997 182) rotate(90) scale(18)">
            <stop offset="0.145833" stop-color="#009500" stop-opacity="0"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0.08"></stop>
            </radialGradient>
            <radialGradient id="paint2_radial_25:217" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(76.9997 288) rotate(90) scale(34)">
            <stop offset="0.145833" stop-color="#009500" stop-opacity="0"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0.08"></stop>
            </radialGradient>
            <linearGradient id="paint3_linear_25:217" x1="226.775" y1="-66.1548" x2="292.157" y2="351.421" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint4_linear_25:217" x1="184.521" y1="182.159" x2="184.521" y2="448.882" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint5_linear_25:217" x1="356" y1="110" x2="356" y2="470" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint6_linear_25:217" x1="118.524" y1="29.2497" x2="166.965" y2="338.63" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            </defs>
            </svg>
            <svg class="hero-bg-el-2" width="364" height="201" viewBox="0 0 364 201" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5.88928 72.3303C33.6599 66.4798 101.397 64.9086 150.178 105.427C211.155 156.076 229.59 162.093 264.333 166.607C299.076 171.12 337.718 183.657 362.889 212.24" stroke="url(#paint0_linear_25:218)"></path>
                <path d="M-22.1107 72.3303C5.65989 66.4798 73.3965 64.9086 122.178 105.427C183.155 156.076 201.59 162.093 236.333 166.607C271.076 171.12 309.718 183.657 334.889 212.24" stroke="url(#paint1_linear_25:218)"></path>
                <path d="M-53.1107 72.3303C-25.3401 66.4798 42.3965 64.9086 91.1783 105.427C152.155 156.076 170.59 162.093 205.333 166.607C240.076 171.12 278.718 183.657 303.889 212.24" stroke="url(#paint2_linear_25:218)"></path>
                <path d="M-98.1618 65.0889C-68.1416 60.0601 4.73364 60.4882 56.0734 102.431C120.248 154.86 139.905 161.419 177.137 166.956C214.37 172.493 255.575 186.165 281.856 215.481" stroke="url(#paint3_linear_25:218)"></path>
                <circle opacity="0.8" cx="214.505" cy="60.5054" r="49.7205" transform="rotate(-13.421 214.505 60.5054)" stroke="url(#paint4_linear_25:218)"></circle>
                <circle cx="220" cy="63" r="43" fill="url(#paint5_radial_25:218)"></circle>
                <defs>
                <linearGradient id="paint0_linear_25:218" x1="184.389" y1="69.2405" x2="184.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint1_linear_25:218" x1="156.389" y1="69.2405" x2="156.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint2_linear_25:218" x1="125.389" y1="69.2405" x2="125.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint3_linear_25:218" x1="93.8507" y1="67.2674" x2="89.9278" y2="210.214" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint4_linear_25:218" x1="214.505" y1="10.2849" x2="212.684" y2="99.5816" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500"></stop>
                <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                </linearGradient>
                <radialGradient id="paint5_radial_25:218" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(220 63) rotate(90) scale(43)">
                <stop offset="0.145833" stop-color="white" stop-opacity="0"></stop>
                <stop offset="1" stop-color="white" stop-opacity="0.08"></stop>
                </radialGradient>
                </defs>
                </svg>
            <div class="container-sp">
                <div class="hero-inner-sp">
                    <h2 class="welcome-title-sp">Bem-vindo ao Liquiloan! A nossa experiência e especialização são a sua chave para o sucesso financeiro. Trabalhamos para garantir que os seus fundos tragam o máximo retorno.</h2>
                    
                </div>
            </div>
       </section>
       

<div class="container" style="padding: 110px 0px;">
    <div class="content-block">
        <h2 class="stilTitle" style="padding: 0 12px;">Liquiloan | Política de Privacidade</h2>
        <div class="content" style="padding: 0 12px; color: rgb(149, 156, 177);"><p>Esta Política de Privacidade descreve Nossas políticas e procedimentos sobre a coleta, uso e divulgação de Suas informações quando Você usa o Serviço e informa sobre Seus direitos de privacidade e como a lei o protege.</p>
<p>Utilizamos os seus dados pessoais para fornecer e melhorar o Serviço. Ao usar o Serviço, Você concorda com a coleta e uso de informações de acordo com esta Política de Privacidade.</p>
<h1>Interpretação e definições</h1>
<h2>Interpretação</h2>
<p>As palavras cuja letra inicial está em maiúsculas têm significados definidos nas seguintes condições. As definições que se seguem têm o mesmo significado, independentemente de figurarem no singular ou no plural.</p>
<h2>Definições</h2>
<p>Para efeitos da presente Política de Privacidade, entende-se por:</p>
<ul>
	<li>
		<p><strong>Conta</strong> significa uma conta exclusiva criada para Você acessar nosso Serviço ou partes de nosso Serviço.</p>
	</li>
	<li>
		<p>
			<strong>A empresa</strong>, para efeitos da CCPA (California Consumer Privacy Act), refere-se à Empresa como a entidade jurídica que recolhe as informações pessoais dos Consumidores e determina as finalidades e os meios da
			tratamento de informações pessoais dos Consumidores, ou em nome das quais essas informações são recolhidas e que, por si só, ou em conjunto com outros, determina as finalidades e os meios do tratamento das informações pessoais dos consumidores,
			que faz negócios no Estado da Califórnia.</p>
	</li>
	<li>
		<p>Empresa (referida como "a <strong>Empresa</strong>", "Nós", "Nos" ou "Nosso" neste Contrato) refere-se a Sítio Web, </p>
		<p>Para efeitos do RGPD, a Empresa é o Responsável pelo Tratamento de Dados.</p>
	</li>
	<li>
		<p>
			<strong>Consumidor</strong>, para efeitos da CCPA (California Consumer Privacy Act), significa uma pessoa singular residente na Califórnia. Um residente, conforme definido na lei, inclui (1) todos os indivíduos que estão nos EUA
			para fins não temporários ou transitórios, e (2) qualquer indivíduo domiciliado nos EUA que esteja fora dos EUA para um fim temporário ou transitório.</p>
	</li>
	<li>
		<p><strong>Cookies</strong> são pequenos arquivos que são colocados no Seu computador, dispositivo móvel ou qualquer outro dispositivo por um site, contendo os detalhes do Seu histórico de navegação nesse site entre seus muitos usos.</p>
	</li>
	<li>
		<p><strong>País</strong> refere-se a: </p>
	</li>
	<li>
		<p>
			<strong>O Controlador de Dados</strong>, para os fins do GDPR (Regulamento Geral de Proteção de Dados), refere-se à Empresa como a pessoa jurídica que, sozinha ou em conjunto com outros, determina as finalidades e os meios do
			tratamento de Dados Pessoais.</p>
	</li>
	<li>
		<p><strong>Dispositivo</strong> significa qualquer dispositivo que possa aceder ao Serviço, como um computador, um telemóvel ou um tablet digital.</p>
	</li>
	<li>
		<p>
			<strong>Do Not Track</strong> (DNT) é um conceito que tem sido promovido pelas autoridades reguladoras dos EUA, em particular a Comissão Federal de Comércio dos EUA (FTC), para que a indústria da Internet desenvolva e implemente um mecanismo para
			permitir que os utilizadores da Internet controlem o rastreio das suas atividades em linha nos sítios Web.</p>
	</li>
	<li>
		<p><strong>Dados Pessoais</strong> são qualquer informação que se relacione com um indivíduo identificado ou identificável.</p>
		<p>Para efeitos do RGPD, Dados Pessoais significa qualquer informação relacionada consigo, como um nome, um número de identificação, dados de localização, identificador online ou um ou mais fatores específicos do físico, fisiológico,
			identidade genética, mental, económica, cultural ou social.</p>
		<p>Para os fins do CCPA, Dados Pessoais significa qualquer informação que identifique, se relacione, descreva ou possa ser associada a, ou possa ser razoavelmente vinculada, direta ou indiretamente, a Você.</p>
	</li>
	<li>
		<p>
			<strong>Venda</strong>, para efeitos da CCPA (California Consumer Privacy Act), significa vender, alugar, libertar, divulgar, disponibilizar, transferir ou de outra forma comunicar oralmente, por escrito,
			ou por meios eletrónicos ou outros, as informações pessoais de um Consumidor a outra empresa ou a terceiros mediante contrapartida monetária ou outra retribuição valiosa.</p>
	</li>
	<li>
		<p><strong>Serviço</strong> refere-se ao site.</p>
	</li>
	<li>
		<p>
			<strong>Provedor de Serviços</strong> significa qualquer pessoa física ou jurídica que processa os dados em nome da Empresa. Refere-se a empresas terceiras ou indivíduos contratados pela Empresa para facilitar o Serviço, para fornecer
			o Serviço em nome da Empresa, para executar serviços relacionados ao Serviço ou para ajudar a Empresa a analisar como o Serviço é usado. Para efeitos do RGPD, os Prestadores de Serviços são considerados Subcontratantes.</p>
	</li>
	<li>
		<p>Serviço de <strong>Mídia Social de Terceiros refere-se</strong> a qualquer site ou qualquer site de rede social através do qual um Usuário pode fazer login ou criar uma conta para usar o Serviço.</p>
	</li>
	<li>
		<p><strong>Dados de Utilização</strong> referem-se a dados recolhidos automaticamente, gerados pela utilização do Serviço ou da própria infraestrutura do Serviço (por exemplo, a duração de uma visita à página).</p>
	</li>
	<li>
		<p><strong>Website</strong> acessível a partir de Sítio Web</p>
	</li>
	<li>
		<p><strong>Você</strong> significa o indivíduo que acessa ou usa o Serviço, ou a empresa, ou outra entidade legal em nome da qual esse indivíduo está acessando ou usando o Serviço, conforme aplicável.</p>
		<p>Nos termos do RGPD (Regulamento Geral sobre a Proteção de Dados), pode ser referido como o Titular dos Dados ou como o Utilizador, uma vez que é o indivíduo que utiliza o Serviço.</p>
	</li>
</ul>
<h1>Recolha e Utilização dos seus Dados Pessoais</h1>
<h2>Tipos de dados recolhidos</h2>
<h3>Dados Pessoais</h3>
<p>Ao utilizar o Nosso Serviço, podemos pedir-lhe que nos forneça determinadas informações pessoais identificáveis que podem ser utilizadas para o contactar ou identificar. Informações de identificação pessoal podem incluir, mas não estão limitadas a:</p>
<ul>
	<li>Endereço de e-mail</li>
	<li>Nome próprio e apelido</li>
	<li>Número de telefone</li>
	<li>Endereço, Estado, Província, CEP, Cidade</li>
	<li>Informações do perfil de mídia social (ou seja, em Conectar com o Facebook, Entrar com o Twitter)</li>
	<li>Outros</li>
</ul>
<h3>Dados de Utilização</h3>
<p>Os Dados de Utilização são recolhidos automaticamente quando se utiliza o Serviço.</p>
<p>Os Dados de Utilização podem incluir informações como o endereço de Protocolo de Internet do seu Dispositivo (por exemplo, endereço IP), o tipo de navegador, a versão do navegador, as páginas do nosso Serviço que o Utilizador visita, a hora e data da sua visita, o tempo gasto neles
	páginas, identificadores únicos de dispositivos e outros dados de diagnóstico.</p>
<p>Quando acede ao Serviço através de ou através de um dispositivo móvel, podemos recolher determinadas informações automaticamente, incluindo, entre outras, o tipo de dispositivo móvel que utiliza, o ID exclusivo do seu dispositivo móvel, o endereço IP do seu telemóvel
	dispositivo, seu sistema operacional móvel, o tipo de navegador de Internet móvel que você usa, identificadores exclusivos de dispositivo e outros dados de diagnóstico.</p>
<p>Também podemos recolher informações que o seu navegador envia sempre que visita o nosso Serviço ou quando acede ao Serviço por ou através de um dispositivo móvel.</p>
<h3>Informações de Serviços de Redes Sociais de Terceiros</h3>
<p>A Empresa permite que Você crie uma conta e faça login para usar o Serviço através dos seguintes Serviços de Mídia Social de Terceiros:</p>
<ul>
	<li>Google</li>
	<li>Linkedin</li>
	<li>Linkedin</li>
</ul>
<p>Se decidir registar-se através ou de outra forma conceder-nos acesso a um Serviço de Redes Sociais de Terceiros, poderemos recolher dados pessoais que já estejam associados à conta do seu Serviço de Redes Sociais de Terceiros, tais como o Seu nome, o Seu
	endereço de e-mail, suas atividades ou sua lista de contatos associada a essa conta.</p>
<p>Você também pode ter a opção de compartilhar informações adicionais com a Empresa por meio da conta do Seu Serviço de Mídia Social de Terceiros. Se optar por fornecer essas informações e Dados Pessoais, durante o registo ou de outra forma,
	estão dando permissão à Empresa para usá-lo, compartilhá-lo e armazená-lo de forma consistente com esta Política de Privacidade.</p>
<h3>Tecnologias de rastreamento e cookies</h3>
<p>Usamos Cookies e tecnologias de rastreamento semelhantes para rastrear a atividade em Nosso Serviço e armazenar determinadas informações. As tecnologias de rastreamento usadas são beacons, tags e scripts para coletar e rastrear informações e para melhorar e analisar
	O nosso serviço. As tecnologias que utilizamos podem incluir:</p>
<ul>
	<li>
		<strong>Cookies ou cookies do navegador.</strong> Um cookie é um pequeno ficheiro colocado no seu dispositivo. Pode instruir o seu navegador para recusar todos os Cookies ou para indicar quando um Cookie está a ser enviado. No entanto, se não aceitar Cookies,
		pode não ser capaz de usar algumas partes do nosso Serviço. A menos que tenha ajustado as definições do seu navegador para recusar Cookies, o nosso Serviço poderá utilizar Cookies.</li>
	<li>
		<strong>Web Beacons.</strong> Certas seções do nosso Serviço e nossos e-mails podem conter pequenos arquivos eletrônicos conhecidos como web beacons (também referidos como clear gifs, pixel tags e gifs de pixel único) que permitem à Empresa
		por exemplo, para contar os utilizadores que visitaram essas páginas ou abriram um e-mail e para outras estatísticas relacionadas do site (por exemplo, registar a popularidade de uma determinada secção e verificar a integridade do sistema e do servidor).</li>
</ul>
<p>Os cookies podem ser cookies "persistentes" ou "de sessão". Os Cookies Persistentes permanecem no Seu computador pessoal ou dispositivo móvel quando Fica offline, enquanto os Cookies de Sessão são eliminados assim que fecha o seu browser.</p>
<p>Utilizamos Cookies de Sessão e Cookies Persistentes para os fins abaixo descritos:</p>
<ul>
	<li>
		<p><strong>Cookies Necessários / Essenciais</strong></p>
		<p>Tipo: Cookies de sessão</p>
		<p>Administrado por: Nós</p>
		<p>Finalidade: Estes Cookies são essenciais para lhe fornecer serviços disponíveis através do Website e para lhe permitir utilizar algumas das suas funcionalidades. Eles ajudam a autenticar os usuários e evitar o uso fraudulento de contas de usuário. Sem
			estes Cookies, os serviços que solicitou não podem ser fornecidos, e apenas utilizamos estes Cookies para lhe fornecer esses serviços.</p>
	</li>
	<li>
		<p><strong>Política de Cookies / Aviso de Aceitação de Cookies</strong></p>
		<p>Tipo: Cookies persistentes</p>
		<p>Administrado por: Nós</p>
		<p>Finalidade: Estes Cookies identificam se os utilizadores aceitaram a utilização de cookies no Website.</p>
	</li>
	<li>
		<p><strong>Cookies de funcionalidade</strong></p>
		<p>Tipo: Cookies persistentes</p>
		<p>Administrado por: Nós</p>
		<p>Finalidade: Estes Cookies permitem-nos recordar as escolhas que faz quando utiliza o Website, tais como memorizar os seus dados de início de sessão ou preferência de idioma. O objetivo destes Cookies é proporcionar-lhe uma experiência mais pessoal
			e para evitar que tenha de voltar a introduzir as suas preferências sempre que utilizar o Website.</p>
	</li>
	<p><strong>Cookies de rastreamento e desempenho</strong></p>
	<p>Tipo: Cookies persistentes</p>
	<p>Administrado por: Terceiros</p>
	<p>Finalidade: Estes Cookies são usados para rastrear informações sobre o tráfego para o site e como os usuários usam o site. As informações recolhidas através destes Cookies podem identificá-lo direta ou indiretamente como um visitante individual. Isto é
		porque as informações recolhidas estão normalmente ligadas a um identificador pseudónimo associado ao dispositivo que utiliza para aceder ao Website. Também podemos usar esses Cookies para testar novas páginas, recursos ou novas funcionalidades do
		Website para ver como os nossos utilizadores reagem a eles.</p>

	<li>
		<p><strong>Cookies de segmentação e publicidade</strong></p>
		<p>Tipo: Cookies persistentes</p>
		<p>Administrado por: Terceiros</p>
		<p>Finalidade: Estes Cookies rastreiam os seus hábitos de navegação para nos permitir mostrar publicidade que é mais provável que seja do seu interesse. Estes Cookies utilizam informações sobre o seu histórico de navegação para o agrupar com outros utilizadores que tenham
			interesses semelhantes. Com base nessas informações, e com a Nossa permissão, os anunciantes terceiros podem colocar Cookies para permitir que mostrem anúncios que acreditamos serem relevantes para os seus interesses enquanto estiver em terceiros
			sítios Web.</p>
	</li>
</ul>
<p>Para mais informações sobre os cookies que utilizamos e as suas escolhas em relação aos cookies, visite a nossa Política de Cookies ou a secção Cookies da nossa Política de Privacidade.</p>
<h2>Utilização dos seus Dados Pessoais</h2>
<p>A Empresa poderá utilizar os Dados Pessoais para as seguintes finalidades:</p>
<ul>
	<li><strong>Para fornecer e manter o</strong> nosso Serviço, incluindo para monitorizar a utilização do nosso Serviço.</li>
	<li>
		<strong>Para gerir a Sua Conta: para gerir</strong> o Seu registo como utilizador do Serviço. Os Dados Pessoais que fornece podem dar-lhe acesso a diferentes funcionalidades do Serviço que estão disponíveis para si enquanto registado
		utilizador.</li>
	<li>
		<strong>Para a execução de um contrato:</strong> o desenvolvimento, cumprimento e realização do contrato de compra dos produtos, itens ou serviços que Você adquiriu ou de qualquer outro contrato conosco através do Serviço.</li>
	<li>
		<strong>Para entrar em contato com você:</strong> Para entrar em contato com Você por e-mail, chamadas telefônicas, SMS ou outras formas equivalentes de comunicação eletrônica, como notificações push de um aplicativo móvel sobre atualizações ou comunicações informativas
		relacionados com as funcionalidades, produtos ou serviços contratados, incluindo as atualizações de segurança, quando necessário ou razoável para a sua implementação.</li>
	<li>
		<strong>Para lhe fornecer</strong> notícias, ofertas especiais e informações gerais sobre outros bens, serviços e eventos que oferecemos que são semelhantes aos que você já comprou ou perguntou, a menos que você tenha
		optou por não receber essas informações.</li>
	<li><strong>Para gerir os seus pedidos:</strong> Para atender e gerenciar Suas solicitações para Nós.</li>
	<li>
		<strong>Para lhe fornecer publicidade direcionada</strong>: Podemos utilizar as suas informações para desenvolver e apresentar conteúdo e publicidade (e trabalhar com fornecedores terceiros que o façam) adaptados aos seus interesses e/ou localização e para
		medir a sua eficácia.</li>
	<li>
		<strong>Para transferências de empresas:</strong> Podemos usar suas informações para avaliar ou conduzir uma fusão, alienação, reestruturação, reorganização, dissolução ou outra venda ou transferência de alguns ou todos os Nossos ativos, seja como um
		em curso ou como parte de falência, liquidação ou processo semelhante, em que os Dados Pessoais detidos por Nós sobre os nossos utilizadores do Serviço estão entre os ativos transferidos.</li>
	<li>
		Para outros fins: Podemos utilizar as suas informações para <strong>outros fins</strong>, tais como análise de dados, identificação de tendências de utilização, determinação da eficácia das nossas campanhas promocionais e para avaliar e melhorar as nossas
		Serviço, produtos, serviços, marketing e sua experiência.</li>
</ul>
<p>Podemos partilhar os seus dados pessoais nas seguintes situações:</p>
<ul>
	<li>
		<strong>Com Prestadores de Serviços:</strong> Podemos partilhar as suas informações pessoais com Prestadores de Serviços para monitorizar e analisar a utilização do nosso Serviço, para lhe mostrar anúncios para ajudar a apoiar e manter o Nosso Serviço, para
		anunciar em sites de terceiros para Você depois que Você visitou nosso Serviço, para processamento de pagamento, para contatá-lo.</li>
	<li>
		<strong>Para transferências de empresas:</strong> Podemos compartilhar ou transferir suas informações pessoais em conexão com, ou durante negociações de, qualquer fusão, venda de ativos da Empresa, financiamento ou aquisição de todo ou parte de Nossa
		negócios para outra empresa.</li>
	<li>
		<strong>Com Afiliados:</strong> Podemos compartilhar suas informações com nossos afiliados, caso em que exigiremos que esses afiliados honrem esta Política de Privacidade. As afiliadas incluem a nossa empresa-mãe e quaisquer outras subsidiárias,
		parceiros de joint venture ou outras empresas que Nós controlamos ou que estão sob controle comum Conosco.</li>
	<li><strong>Com parceiros de negócios:</strong> Podemos partilhar as suas informações com os nossos parceiros comerciais para lhe oferecer determinados produtos, serviços ou promoções.</li>
	<li>
		<strong>Com</strong> outros usuários: quando você compartilha informações pessoais ou interage de outra forma nas áreas públicas com outros usuários, essas informações podem ser visualizadas por todos os usuários e podem ser distribuídas publicamente fora. Se você interagir
		com outros utilizadores ou registar-se através de um Serviço de Redes Sociais de Terceiros, os Seus contactos no Serviço de Redes Sociais de Terceiros poderão ver o Seu nome, perfil, imagens e descrição da Sua atividade. Da mesma forma, outros usuários serão
		capaz de visualizar descrições da sua atividade, comunicar consigo e visualizar o seu perfil.</li>
	<li>Com o seu consentimento: Podemos divulgar as suas informações pessoais para qualquer outra finalidade com <strong>o seu consentimento</strong>.</li>
</ul>
<h2>Retenção dos seus Dados Pessoais</h2>
<p>A Empresa conservará os seus Dados Pessoais apenas durante o tempo necessário para os fins estabelecidos nesta Política de Privacidade. Iremos reter e utilizar os seus Dados Pessoais na medida do necessário para cumprir as nossas obrigações legais (para
	por exemplo, se formos obrigados a reter os seus dados para cumprir as leis aplicáveis), resolver litígios e fazer cumprir os nossos acordos e políticas legais.</p>
<p>A Empresa também reterá Dados de Uso para fins de análise interna. Os Dados de Utilização são geralmente retidos por um período de tempo mais curto, exceto quando estes dados são utilizados para reforçar a segurança ou para melhorar a funcionalidade do Nosso
	Serviço, ou Somos legalmente obrigados a reter esses dados por períodos de tempo mais longos.</p>
<h2>Transferência dos seus dados pessoais</h2>
<p>As suas informações, incluindo Dados Pessoais, são processadas nos escritórios operacionais da Empresa e em quaisquer outros locais onde as partes envolvidas no processamento estejam localizadas. Isso significa que essas informações podem ser transferidas para — e
	mantidos em — computadores localizados fora do Seu estado, província, país ou outra jurisdição governamental onde as leis de proteção de dados podem diferir das da Sua jurisdição.</p>
<p>O seu consentimento a esta Política de Privacidade seguido do envio de tais informações representa a sua concordância com essa transferência.</p>
<p>A Empresa tomará todas as medidas razoavelmente necessárias para garantir que os Seus dados sejam tratados de forma segura e de acordo com esta Política de Privacidade e nenhuma transferência dos Seus Dados Pessoais ocorrerá para uma organização ou um país, a menos que
	existem controlos adequados em vigor, incluindo a segurança dos seus dados e outras informações pessoais.</p>
<h2>Divulgação dos seus Dados Pessoais</h2>
<h3>Transações Comerciais</h3>
<p>Se a Empresa estiver envolvida numa fusão, aquisição ou venda de ativos, os seus Dados Pessoais poderão ser transferidos. Enviaremos um aviso antes de os seus Dados Pessoais serem transferidos e ficarem sujeitos a uma Política de Privacidade diferente.</p>
<h3>Aplicação da lei</h3>
<p>Em determinadas circunstâncias, a Empresa pode ser obrigada a divulgar os seus Dados Pessoais se tal for exigido por lei ou em resposta a pedidos válidos de autoridades públicas (por exemplo, um tribunal ou uma agência governamental).</p>
<h3>Outros requisitos legais</h3>
<p>A Empresa pode divulgar os seus Dados Pessoais acreditando, de boa fé, que tal ação é necessária para:</p>
<ul>
	<li>Cumprir uma obrigação legal</li>
	<li>Proteger e defender os direitos ou propriedade da Empresa</li>
	<li>Prevenir ou investigar possíveis irregularidades relacionadas com o Serviço</li>
	<li>Proteger a segurança pessoal dos Utilizadores do Serviço ou do público</li>
	<li>Proteja-se contra responsabilidade legal</li>
</ul>
<h2>Segurança dos seus Dados Pessoais</h2>
<p>A segurança dos seus Dados Pessoais é importante para Nós, mas lembre-se que nenhum método de transmissão pela Internet, ou método de armazenamento eletrónico é 100% seguro. Enquanto nos esforçamos para usar meios comercialmente aceitáveis para proteger o Seu
	Dados Pessoais, Não podemos garantir a sua segurança absoluta.</p>
<h1>Informações detalhadas sobre o tratamento dos seus dados pessoais</h1>
<p>Os Prestadores de Serviços que utilizamos podem ter acesso aos seus Dados Pessoais. Estes fornecedores terceiros recolhem, armazenam, utilizam, processam e transferem informações sobre a sua atividade no Nosso Serviço de acordo com as respetivas Políticas de Privacidade.</p>
<h2>Análise</h2>
<p>Podemos usar provedores de serviços terceirizados para monitorar e analisar o uso do nosso Serviço.</p>
<ul>
	<li>
		<p><strong>Google Analytics</strong></p>
		<p>O Google Analytics é um serviço de análise da web oferecido pelo Google que rastreia e relata o tráfego do site. O Google usa os dados coletados para rastrear e monitorar o uso do nosso Serviço. Esses dados são compartilhados com outros serviços do Google.
			A Google poderá utilizar os dados recolhidos para contextualizar e personalizar os anúncios da sua própria rede de publicidade.</p>
		<p>Pode optar por não disponibilizar a sua atividade no Serviço ao Google Analytics instalando o complemento do navegador para desativação do Google Analytics. O complemento impede que o JavaScript do Google Analytics (ga.js, analytics.js e
			dc.js) de compartilhar informações com o Google Analytics sobre a atividade de visitas.</p>
		<p>Para obter mais informações sobre as práticas de privacidade do Google, visite a página da Web Google Privacy &amp; Terms:
			<a href="https://policies.google.com/privacy" rel="external nofollow noopener" target="_blank">https://policies.google.com/privacy</a>
		</p>
	</li>
</ul>
<h2>Pagamentos</h2>
<p>Podemos fornecer produtos e/ou serviços pagos dentro do Serviço. Nesse caso, podemos usar serviços de terceiros para processamento de pagamentos (por exemplo, processadores de pagamento).</p>
<p>Não armazenaremos nem recolheremos os dados do seu cartão de pagamento. Essas informações são fornecidas diretamente aos nossos processadores de pagamento terceirizados, cujo uso de suas informações pessoais é regido por sua Política de Privacidade. Estes processadores de pagamento
	aderir aos padrões estabelecidos pelo PCI-DSS, conforme gerenciado pelo PCI Security Standards Council, que é um esforço conjunto de marcas como Visa, Mastercard, American Express e Discover. Os requisitos do PCI-DSS ajudam a garantir o manuseio seguro de
	informações de pagamento.</p>
<ul>
	<li>
		<p><strong>Transferência Bancária</strong></p>
	</li>
	<li>
		<p><strong>Authorize.net</strong></p>
		<p>A sua Política de Privacidade pode ser consultada em <a href="https://www.authorize.net/company/privacy/" target="_blank">https://www.authorize.net/company/privacy/</a></p>
	</li>
	<li>
		<p><strong>PayPal</strong></p>
		<p>A sua Política de Privacidade pode ser consultada em <a href="https://www.paypal.com/myaccount/privacy/privacyhub" target="_blank">https://www.paypal.com/myaccount/privacy/privacyhub</a></p>
	</li>
	<li>
		<p><strong>Pagamentos no aplicativo do Google Play</strong></p>
		<p>A sua Política de Privacidade pode ser consultada em
			<a href="https://payments.google.com/payments/apis-secure/get_legal_document?ldo=0&amp;ldt=privacynotice" target="_blank">https://payments.google.com/payments/apis-secure/get_legal_document?ldo=0&amp;ldt=privacynotice</a>
		</p>
	</li>
</ul>
<h1>Privacidade do RGPD</h1>
<h2>Base jurídica para o tratamento de dados pessoais ao abrigo do RGPD</h2>
<p>Podemos processar Dados Pessoais nas seguintes condições:</p>
<ul>
	<li><strong>Consentimento:</strong> Deu o seu consentimento para o tratamento de Dados Pessoais para uma ou mais finalidades específicas.</li>
	<li><strong>Execução de um contrato:</strong> O fornecimento de Dados Pessoais é necessário para a execução de um contrato consigo e/ou para quaisquer obrigações pré-contratuais do mesmo.</li>
	<li><strong>Obrigações legais:</strong> O tratamento de Dados Pessoais é necessário para o cumprimento de uma obrigação legal a que a Empresa esteja sujeita.</li>
	<li><strong>Interesses vitais:</strong> O tratamento de Dados Pessoais é necessário para proteger os seus interesses vitais ou de outra pessoa singular.</li>
	<li><strong>Interesse público:</strong> O tratamento de Dados Pessoais está relacionado com uma tarefa que é realizada no interesse público ou no exercício da autoridade oficial investida na Empresa.</li>
	<li><strong>Interesses legítimos:</strong> O tratamento de Dados Pessoais é necessário para efeitos dos interesses legítimos prosseguidos pela Empresa.</li>
</ul>
<p>Em qualquer caso, a Empresa terá todo o prazer em ajudar a esclarecer a base jurídica específica que se aplica ao processamento e, em particular, se o fornecimento de Dados Pessoais é um requisito legal ou contratual, ou um requisito necessário
	para celebrar um contrato.</p>
<h2>Os seus direitos ao abrigo do RGPD</h2>
<p>A Empresa compromete-se a respeitar a confidencialidade dos seus Dados Pessoais e a garantir que pode exercer os seus direitos.</p>
<p>Ao abrigo desta Política de Privacidade, e por lei se estiver dentro da UE, tem o direito de:</p>
<ul>
	<li>
		<strong>Solicitar acesso aos seus Dados Pessoais.</strong> O direito de aceder, atualizar ou eliminar as informações que temos sobre si. Sempre que possível, pode aceder, atualizar ou solicitar a eliminação dos seus Dados Pessoais diretamente no
		A secção de definições da sua conta. Se você não conseguir realizar essas ações sozinho, entre em contato conosco para ajudá-lo. Isto também lhe permite receber uma cópia dos Dados Pessoais que mantemos sobre si.</li>
	<li><strong>Solicitar a correção dos Dados Pessoais que mantemos sobre si.</strong> Você tem o direito de ter qualquer informação incompleta ou imprecisa que mantemos sobre você corrigida.</li>
	<li>
		<strong>Opor-se ao tratamento dos seus Dados Pessoais.</strong> Este direito existe quando confiamos num interesse legítimo como base legal para o nosso processamento e há algo na sua situação particular, que faz com que
		Pretende opor-se ao nosso tratamento dos seus Dados Pessoais por este motivo. Você também tem o direito de se opor quando estamos processando seus Dados Pessoais para fins de marketing direto.</li>
	<li><strong>Solicitar a eliminação dos seus Dados Pessoais.</strong> Tem o direito de nos pedir para eliminar ou remover Dados Pessoais quando não houver uma boa razão para continuarmos a processá-los.</li>
	<li>
		<strong>Solicitar a transferência dos seus Dados Pessoais.</strong> Forneceremos a Você, ou a um terceiro que Você escolheu, Seus Dados Pessoais em um formato estruturado, comumente usado e legível por máquina. Por favor, note que este direito apenas
		aplica-se a informações automatizadas que Você inicialmente forneceu consentimento para Nós usarmos ou onde Nós usamos as informações para executar um contrato com Você.</li>
	<li>
		<strong>Retirar o seu consentimento.</strong> Tem o direito de retirar o seu consentimento sobre a utilização dos seus Dados Pessoais. Se retirar o seu consentimento, poderemos não ser capazes de lhe fornecer acesso a determinadas funcionalidades específicas do
		Serviço.</li>
</ul>
<h2>Exercício dos seus direitos de proteção de dados RGPD</h2>
<p>Pode exercer os seus direitos de acesso, retificação, cancelamento e oposição contactando-nos. Tenha em atenção que poderemos pedir-lhe que verifique a sua identidade antes de responder a tais pedidos. Se você fizer um pedido, vamos tentar o nosso melhor
	para lhe responder o mais rapidamente possível.</p>
<p>Tem o direito de reclamar junto de uma Autoridade de Proteção de Dados sobre a nossa recolha e utilização dos seus Dados Pessoais. Para mais informações, se estiver no Espaço Económico Europeu (EEE), contacte a sua autoridade local de proteção de dados
	no EEE.</p>
<h1>Privacidade CCPA</h1>
<p>Esta seção de aviso de privacidade para residentes da Califórnia complementa as informações contidas em Nossa Política de Privacidade e se aplica exclusivamente a todos os visitantes, usuários e outros que residem no Estado da Califórnia.</p>
<h2>Categorias de Informações Pessoais Recolhidas</h2>
<p>Recolhemos informações que identificam, relacionam, descrevem, referenciam, podem ser associadas ou podem razoavelmente estar ligadas, direta ou indiretamente, a um determinado Consumidor ou Dispositivo. Segue-se uma lista de
	categorias de informações pessoais que podemos coletar ou podem ter sido coletadas de residentes da Califórnia nos últimos doze (12) meses.</p>
<p>Tenha em atenção que as categorias e exemplos fornecidos na lista abaixo são os definidos no CCPA. Isso não significa que todos os exemplos dessa categoria de informações pessoais foram de fato coletados por Nós, mas reflete nosso bem
	crença de fé, tanto quanto sabemos, de que algumas dessas informações da categoria aplicável podem ser e podem ter sido coletadas. Por exemplo, certas categorias de informações pessoais só seriam recolhidas se fornecesse
	tais informações pessoais diretamente para nós.</p>
<ul>
	<li>
		<p><strong>Categoria A: Identificadores.</strong></p>
		<p>Exemplos: Um nome real, alias, endereço postal, identificador pessoal único, identificador online, endereço de Protocolo Internet, endereço de e-mail, nome da conta, número da carta de condução, número do passaporte ou outros identificadores semelhantes.</p>
		<p>Recolhido: Sim.</p>
	</li>
	<li>
		<p><strong>Categoria B: Categorias de informações pessoais listadas no estatuto de Registros de Clientes da Califórnia (Cal. Civ. Code § 1798.80(e)).</strong></p>
		<p>Exemplos: Nome, assinatura, número de Segurança Social, características físicas ou descrição, morada, número de telefone, número de passaporte, número de carta de condução ou de cartão de identificação do Estado, número da apólice de seguro, educação,
			emprego, histórico de emprego, número de conta bancária, número de cartão de crédito, número de cartão de débito ou qualquer outra informação financeira, informação médica ou informação de seguro de saúde. Algumas informações pessoais incluídas neste
			categoria pode sobrepor-se a outras categorias.</p>
		<p>Recolhido: Sim.</p>
	</li>
	<li>
		<p><strong>Categoria C: Características de classificação protegidas pela lei da Califórnia ou federal.</strong></p>
		<p>Exemplos: idade (40 anos ou mais), raça, cor, ascendência, origem nacional, cidadania, religião ou credo, estado civil, condição médica, deficiência física ou mental, sexo (incluindo género, identidade de género, género
			expressão, gravidez ou parto e condições médicas relacionadas), orientação sexual, estatuto de veterano ou militar, informação genética (incluindo informação genética familiar).</p>
		<p>Recolhido: Não.</p>
	</li>
	<li>
		<p><strong>Categoria D: Informação comercial.</strong></p>
		<p>Exemplos: Registos e histórico de produtos ou serviços adquiridos ou considerados.</p>
		<p>Recolhido: Sim.</p>
	</li>
	<li>
		<p><strong>Categoria E: Informações biométricas.</strong></p>
		<p>Exemplos: características genéticas, fisiológicas, comportamentais e biológicas, ou padrões de atividade usados para extrair um modelo ou outro identificador ou informações de identificação, como impressões digitais, impressões faciais e impressões vocais,
			exames de íris ou retina, pressionamento de teclas, marcha ou outros padrões físicos e dados de sono, saúde ou exercício.</p>
		<p>Recolhido: Não.</p>
	</li>
	<li>
		<p><strong>Categoria F: Internet ou outra atividade de rede semelhante.</strong></p>
		<p>Exemplos: Interação com o nosso Serviço ou anúncio.</p>
		<p>Recolhido: Sim.</p>
	</li>
	<li>
		<p><strong>Categoria G: Dados de geolocalização.</strong></p>
		<p>Exemplos: Localização física aproximada.</p>
		<p>Recolhido: Não.</p>
	</li>
	<li>
		<p><strong>Categoria H: Dados sensoriais.</strong></p>
		<p>Exemplos: informações áudio, eletrônicas, visuais, térmicas, olfativas ou similares.</p>
		<p>Recolhido: Não.</p>
	</li>
	<li>
		<p><strong>Categoria I: Informações profissionais ou relacionadas com o emprego.</strong></p>
		<p>Exemplos: histórico de trabalho atual ou passado ou avaliações de desempenho.</p>
		<p>Recolhido: Não.</p>
	</li>
	<li>
		<p><strong>Categoria J: Informação educativa não pública (de acordo com a Lei dos Direitos Educativos e Privacidade da Família (20 U.S.C. Section 1232g, 34 C.F.R. Part 99)).</strong></p>
		<p>Exemplos: registros educacionais diretamente relacionados a um aluno mantidos por uma instituição de ensino ou parte agindo em seu nome, como notas, transcrições, listas de aulas, horários de alunos, códigos de identificação de alunos, aluno
			informações financeiras ou registos disciplinares dos alunos.</p>
		<p>Recolhido: Não.</p>
	</li>
	<li>
		<p><strong>Categoria K: Inferências extraídas de outras informações pessoais.</strong></p>
		<p>Exemplos: Perfil que reflete as preferências, características, tendências psicológicas, predisposições, comportamentos, atitudes, inteligência, habilidades e aptidões de uma pessoa.</p>
		<p>Recolhido: Não.</p>
	</li>
</ul>
<p>De acordo com o CCPA, as informações pessoais não incluem:</p>
<ul>
	<li>Informações publicamente disponíveis a partir de registos governamentais</li>
	<li>Informações desidentificadas ou agregadas aos consumidores</li>
	<li>Informações excluídas do âmbito de aplicação do CCPA, tais como:<ul>
			<li>Informações médicas ou de saúde cobertas pelo Health Insurance Portability and Accountability Act of 1996 (HIPAA) e pelo California Confidentiality of Medical Information Act (CMIA) ou dados de ensaios clínicos</li>
			<li>Informações pessoais cobertas por determinadas leis de privacidade específicas do setor, incluindo o Fair Credit Reporting Act (FRCA), o Gramm-Leach-Bliley Act (GLBA) ou o California Financial Information Privacy Act (FIPA) e o Driver's
				Lei de Proteção da Privacidade de 1994</li>
		</ul>
	</li>
</ul>
<h2>Fontes de Informação Pessoal</h2>
<p>Obtemos as categorias de informações pessoais listadas acima das seguintes categorias de fontes:</p>
<ul>
	<li><strong>Diretamente de Você</strong>. Por exemplo, a partir dos formulários que preenche no nosso Serviço, preferências que expressa ou fornece através do nosso Serviço, ou a partir das suas compras no nosso Serviço.</li>
	<li><strong>Indiretamente de Você</strong>. Por exemplo, de observar a sua atividade no nosso Serviço.</li>
	<li><strong>Automaticamente de Você</strong>. Por exemplo, através de cookies que Nós ou os nossos Prestadores de Serviços definimos no seu Dispositivo à medida que navega pelo nosso Serviço.</li>
	<li>
		<strong>De Prestadores de Serviços</strong>. Por exemplo, fornecedores terceirizados para monitorar e analisar o uso do nosso Serviço, fornecedores terceirizados para fornecer publicidade em nosso Serviço, fornecedores terceirizados para fornecer publicidade direcionada
		a Você, fornecedores terceirizados para processamento de pagamentos ou outros fornecedores terceirizados que Nós usamos para fornecer o Serviço a Você.</li>
</ul>
<h2>Uso de Informações Pessoais para Fins Comerciais ou Comerciais</h2>
<p>Podemos usar ou divulgar informações pessoais que coletamos para "fins comerciais" ou "fins comerciais" (conforme definido no CCPA), que podem incluir os seguintes exemplos:</p>
<ul>
	<li>Para operar o nosso Serviço e fornecer-lhe o nosso Serviço.</li>
	<li>Para lhe prestar apoio e responder às suas questões, incluindo investigar e resolver as suas preocupações e monitorizar e melhorar o nosso Serviço.</li>
	<li>Para cumprir ou atender o motivo pelo qual Você forneceu as informações. Por exemplo, se você compartilhar suas informações de contato para fazer uma pergunta sobre nosso serviço, usaremos essas informações pessoais para responder à sua pergunta. Se fornecer
		Suas informações pessoais para comprar um produto ou serviço, usaremos essas informações para processar seu pagamento e facilitar a entrega.</li>
	<li>Para responder a solicitações de aplicação da lei e conforme exigido pela lei aplicável, ordem judicial ou regulamentos governamentais.</li>
	<li>Conforme descrito a Você ao coletar Suas informações pessoais ou conforme estabelecido de outra forma no CCPA.</li>
	<li>Para fins administrativos e de auditoria interna.</li>
	<li>Para detetar incidentes de segurança e proteger contra atividades maliciosas, enganosas, fraudulentas ou ilegais, incluindo, quando necessário, processar os responsáveis por tais atividades.</li>
</ul>
<p>Note-se que os exemplos apresentados acima são ilustrativos e não pretendem ser exaustivos. Para obter mais detalhes sobre como usamos essas informações, consulte a seção "Uso de seus dados pessoais".</p>
<p>Se decidirmos recolher categorias adicionais de informações pessoais ou utilizar as informações pessoais que recolhemos para fins materialmente diferentes, não relacionados ou incompatíveis, atualizaremos esta Política de Privacidade.</p>
<h2>Divulgação de Informações Pessoais para Fins Comerciais ou Comerciais</h2>
<p>Podemos usar ou divulgar e podemos ter usado ou divulgado nos últimos doze (12) meses as seguintes categorias de informações pessoais para fins comerciais ou comerciais:</p>
<ul>
	<li>Categoria A: Identificadores</li>
	<li>Categoria B: Categorias de informações pessoais listadas no estatuto de Registros de Clientes da Califórnia (Cal. Civ. Code § 1798.80(e))</li>
	<li>Categoria D: Informação comercial</li>
	<li>Categoria F: Internet ou outra atividade de rede semelhante</li>
</ul>
<p>Por favor, note que as categorias listadas acima são as definidas no CCPA. Isso não significa que todos os exemplos dessa categoria de informações pessoais foram de fato divulgados, mas reflete nossa crença de boa-fé da melhor forma possível.
	conhecimento de que algumas dessas informações da categoria aplicável podem ser e podem ter sido divulgadas.</p>
<p>Quando divulgamos informações pessoais para fins comerciais ou comerciais, celebramos um contrato que descreve a finalidade e exige que o destinatário mantenha essas informações pessoais confidenciais e não as use para nenhum
	finalidade, exceto a execução do contrato.</p>

<h2>Partilha de Informação Pessoal</h2>
<p>Podemos compartilhar suas informações pessoais identificadas nas categorias acima com as seguintes categorias de terceiros:</p>
<ul>
	<li>Prestadores de Serviços</li>
	<li>Processadores de pagamento</li>
	<li>Os nossos afiliados</li>
	<li>Os nossos parceiros de negócio</li>
	<li>Fornecedores terceiros a quem Você ou Seus agentes nos autorizam a divulgar Suas informações pessoais em conexão com produtos ou serviços que fornecemos a Você</li>
</ul>

<h2>Os seus direitos ao abrigo da CCPA</h2>
<p>O CCPA fornece aos residentes da Califórnia direitos específicos em relação às suas informações pessoais. Se você é residente da Califórnia, você tem os seguintes direitos:</p>
<ul>
	<li><strong>O direito à notificação.</strong> Tem o direito de ser notificado sobre as categorias de Dados Pessoais que estão a ser recolhidas e as finalidades para as quais os Dados Pessoais estão a ser utilizados.</li>
	<li>
		<strong>O direito de solicitar.</strong> Ao abrigo da CCPA, tem o direito de solicitar que lhe divulguemos informações sobre a nossa recolha, utilização, venda, divulgação para fins comerciais e partilha de informações pessoais. Uma vez que nós
		receber e confirmar o seu pedido, iremos divulgar-lhe:<ul>
			<li>As categorias de informações pessoais que recolhemos sobre si</li>
			<li>As categorias de fontes para as informações pessoais que recolhemos sobre si</li>
			<li>O nosso objetivo comercial ou comercial para recolher ou vender essas informações pessoais</li>
			<li>As categorias de terceiros com quem partilhamos essas informações pessoais</li>
			<li>As informações pessoais específicas que recolhemos sobre si</li>
			<li>Se vendermos as suas informações pessoais ou divulgarmos as suas informações pessoais para fins comerciais, iremos divulgar-lhe:<ul>
					<li>As categorias de informações pessoais vendidas</li>
					<li>As categorias de informações pessoais divulgadas</li>
				</ul>
			</li>
		</ul>
	</li>
	<li><strong>O direito de dizer não à venda de Dados Pessoais (opt-out).</strong> Você tem o direito de nos orientar a não vender suas informações pessoais. Para enviar um pedido de exclusão, entre em contato conosco.</li>
	<li>
		<strong>O direito de apagar Dados Pessoais.</strong> Tem o direito de solicitar a eliminação dos seus Dados Pessoais, sujeito a determinadas exceções. Assim que recebermos e confirmarmos o seu pedido, eliminaremos (e direcionaremos o Nosso Serviço
		Provedores para excluir) Suas informações pessoais de nossos registros, a menos que uma exceção se aplique. Podemos negar o seu pedido de eliminação se a retenção das informações for necessária para Nós ou para os Nossos Prestadores de Serviços:<ul>
			<li>Concluir a transação para a qual recolhemos as informações pessoais, fornecer um bem ou serviço que solicitou, tomar medidas razoavelmente previstas no contexto da nossa relação comercial contínua consigo, ou
				caso contrário, executar o nosso contrato consigo.</li>
			<li>Detetar incidentes de segurança, proteger contra atividades maliciosas, enganosas, fraudulentas ou ilegais ou processar os responsáveis por tais atividades.</li>
			<li>Depure produtos para identificar e reparar erros que prejudiquem a funcionalidade pretendida existente.</li>
			<li>Exercer a liberdade de expressão, garantir o direito de outro consumidor exercer o seu direito de liberdade de expressão, ou exercer outro direito previsto na lei.</li>
			<li>Cumprir a Lei de Privacidade das Comunicações Eletrônicas da Califórnia (Cal. Código Penal § 1546 et. seq.).</li>
			<li>Envolver-se em pesquisas científicas, históricas ou estatísticas públicas ou revisadas por pares no interesse público que aderem a todas as outras leis de ética e privacidade aplicáveis, quando a exclusão das informações puder resultar em
				impossível ou prejudicar seriamente a realização da pesquisa, se Você forneceu previamente o consentimento informado.</li>
			<li>Permitir apenas utilizações internas que estejam razoavelmente alinhadas com as expectativas dos consumidores com base na sua relação connosco.</li>
			<li>Cumprir uma obrigação legal.</li>
			<li>Fazer outros usos internos e lícitos dessas informações que sejam compatíveis com o contexto em que Você as forneceu.</li>
		</ul>
	</li>
	<li>
		<strong>O direito a não ser discriminado.</strong> Tem o direito de não ser discriminado por exercer qualquer um dos seus direitos de consumidor, incluindo por:<ul>
			<li>Recusar-lhe bens ou serviços</li>
			<li>Cobrança de preços ou taxas diferentes por bens ou serviços, incluindo a utilização de descontos ou outros benefícios ou imposição de sanções</li>
			<li>Fornecer-lhe um nível ou qualidade diferente de bens ou serviços</li>
			<li>Sugerir que receberá um preço ou uma tarifa diferente para bens ou serviços ou um nível ou qualidade diferente de bens ou serviços</li>
		</ul>
	</li>
</ul>
<h2>Exercer os seus direitos de proteção de dados CCPA</h2>
<p>Para exercer qualquer um dos Seus direitos sob o CCPA, e se Você for residente na Califórnia, Você pode entrar em contato conosco:</p>
<ul>
	<li>
		<p>Por e-mail: </p>
	</li>
</ul>
<p>Somente Você, ou uma pessoa registrada no Secretário de Estado da Califórnia que Você autoriza a agir em Seu nome, pode fazer uma solicitação verificável relacionada às Suas informações pessoais.</p>
<p>O seu pedido deve:</p>
<ul>
	<li>Fornecer informações suficientes que nos permitam verificar razoavelmente que Você é a pessoa sobre a qual coletamos informações pessoais ou um representante autorizado</li>
	<li>Descreva o seu pedido com detalhes suficientes que nos permitam compreendê-lo, avaliá-lo e respondê-lo adequadamente</li>
</ul>
<p>Não podemos responder ao seu pedido ou fornecer-lhe as informações necessárias se não pudermos:</p>
<ul>
	<li>Verificar a sua identidade ou autoridade para fazer o pedido</li>
	<li>E confirmar que as informações pessoais se relacionam consigo</li>
</ul>
<p>Divulgaremos e entregaremos as informações necessárias gratuitamente dentro de 45 dias após o recebimento de Sua solicitação verificável. O prazo para fornecer as informações requeridas pode ser prorrogado uma vez por mais 45 dias, se tal for razoável
	necessário e com aviso prévio.</p>
<p>Quaisquer divulgações que fornecermos cobrirão apenas o período de 12 meses anterior ao recebimento da solicitação verificável.</p>
<p>Para solicitações de portabilidade de dados, selecionaremos um formato para fornecer suas informações pessoais que seja prontamente utilizável e permita que você transmita as informações de uma entidade para outra entidade sem obstáculos.</p>
<h1>Os seus direitos de privacidade na Califórnia (lei Shine the Light da Califórnia)</h1>
<p>De acordo com a Seção 1798 do Código Civil da Califórnia (lei Shine the Light da Califórnia), os residentes da Califórnia com um relacionamento comercial estabelecido conosco podem solicitar informações uma vez por ano sobre o compartilhamento de seus Dados Pessoais com terceiros
	para fins de marketing direto de terceiros.</p>
<p>Se você quiser solicitar mais informações sob a lei California Shine the Light, e se você for residente da Califórnia, entre em contato conosco usando as informações de contato fornecidas abaixo.</p>
<h1>Direitos de privacidade da Califórnia para usuários menores (Seção 22581 do Código de Negócios e Profissões da Califórnia)</h1>
<p>A seção 22581 do Código de Negócios e Profissões da Califórnia permite que os residentes da Califórnia com menos de 18 anos que são usuários registrados de sites, serviços ou aplicativos on-line solicitem e obtenham a remoção de conteúdo ou informações que possuam
	postado publicamente.</p>
<p>Para solicitar a remoção de tais dados, e se você for residente na Califórnia, você pode entrar em contato conosco usando as informações de contato fornecidas abaixo e incluir o endereço de e-mail associado à sua conta.</p>
<p>Esteja ciente de que Sua solicitação não garante a remoção completa ou abrangente de conteúdo ou informações publicadas on-line e que a lei pode não permitir ou exigir a remoção em determinadas circunstâncias.</p>
<h1>Links para outros sites</h1>
<p>Nosso Serviço pode conter links para outros sites que não são operados por Nós. Se clicar num link de terceiros, será direcionado para o site desse terceiro. Aconselhamo-lo vivamente a rever a Política de Privacidade de cada site que você
	visite.</p>
<p>Não temos qualquer controlo e não assumimos qualquer responsabilidade pelo conteúdo, políticas de privacidade ou práticas de quaisquer sites ou serviços de terceiros.</p>
<h1>Alterações a esta Política de Privacidade</h1>
<p>Podemos atualizar nossa Política de Privacidade de tempos em tempos. Iremos notificá-lo de quaisquer alterações, publicando a nova Política de Privacidade nesta página.</p>
<p>Iremos informá-lo por e-mail e/ou um aviso proeminente no Nosso Serviço, antes de a alteração entrar em vigor e atualizar a data da "Última atualização" na parte superior desta Política de Privacidade.</p>
<p>Aconselhamo-lo a rever esta Política de Privacidade periodicamente para verificar quaisquer alterações. As alterações a esta Política de Privacidade entram em vigor quando são publicadas nesta página.</p>
<h1>Sobre esta Política de Privacidade</h1>

<h1>Contacte-nos</h1>
<p>Se tiver alguma questão sobre esta Política de Privacidade, pode contactar-nos:</p>
<ul>
	<li>
		<p>Por e-mail: </p>
	</li>
</ul>

</div>
    </div>
</div>



        <footer class="footer-sp img-MbDiK-div">
            <div class="container-sp">
                <div class="ftop-sp">
                    <div class="footer-sp-item">
                        <a class="logo-link-sp" href="./">
                            <img class="logo-img" src="brandLogo.svg" width="37px" alt="">
                            Liquiloan
                        </a>
                        <p class="footer-sp__text">Bem-vindo à Liquiloan, o seu parceiro de confiança em planeamento financeiro e estratégias. Nós somos uma empresa dedicada a fornecer soluções financeiras personalizadas para ajudá-lo a alcançar os seus objetivos econômicos a longo prazo. Com anos de experiência na indústria financeira, a nossa equipa de especialistas está preparada para oferecer orientação segura e eficaz para a gestão dos seus ativos, investimentos e finanças pessoais. Na Liquiloan, acreditamos que o planeamento financeiro eficaz é a chave para uma vida tranquila e segura. Esforçamo-nos para proporcionar uma abordagem transparente, honesta e direcionada ao cliente, assegurando que todos os seus projetos pessoais e profissionais se realizem com sucesso. Confie na Liquiloan para elaborar uma estratégia financeira robusta que atenderá a todas as suas expectativas e necessidades. Deixe-nos ser o seu guia no caminho para a independência financeira e prosperidade.</p>
                    </div>
                    
                    <div class="footer-sp-item fbottom-pol">
                        <a href="privacy-info.php">Política de privacidade</a>
                        <a href="legalTerms.php">  Termo e condições</a>
                        <a href="content-disclaimer.php">Isenções de responsabilidade</a>
                    </div>
                </div>
                <div class="footer-sp-dec1">
                    <svg width="79" height="94" viewBox="0 0 79 94" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.3" x="-41" y="26.9426" width="66.6675" height="66.6675" transform="rotate(-22.9007 -41 26.9426)" fill="url(#paint0_linear_94:889)"></rect>
                    <rect x="-41" y="26.9426" width="66.6675" height="66.6675" transform="rotate(-22.9007 -41 26.9426)" stroke="url(#paint1_linear_94:889)" stroke-width="0.7"></rect>
                    <path opacity="0.3" d="M50.5215 7.42229L20.325 1.14771L46.2077 62.3249L77.1885 68.2073L50.5215 7.42229Z" fill="url(#paint2_linear_94:889)"></path>
                    <path d="M50.5215 7.42229L20.325 1.14771L46.2077 62.3249L76.7963 68.2073L50.5215 7.42229Z" stroke="url(#paint3_linear_94:889)" stroke-width="0.7"></path>
                    <path opacity="0.3" d="M17.9721 93.3057L-14.9695 88.2076L46.2077 62.325L77.1885 68.2074L17.9721 93.3057Z" fill="url(#paint4_linear_94:889)"></path>
                    <path d="M17.972 93.3057L-14.1852 88.2076L46.2077 62.325L77.1884 68.2074L17.972 93.3057Z" stroke="url(#paint5_linear_94:889)" stroke-width="0.7"></path>
                    <defs>
                    <linearGradient id="paint0_linear_94:889" x1="-41" y1="21.8445" x2="36.9671" y2="59.8878" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint1_linear_94:889" x1="25.6675" y1="95.9631" x2="-42.9608" y2="20.668" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    <linearGradient id="paint2_linear_94:889" x1="20.325" y1="-3.98039" x2="90.6248" y2="25.1062" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint3_linear_94:889" x1="18.3642" y1="-1.59742" x2="113.9" y2="80.6826" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    <linearGradient id="paint4_linear_94:889" x1="61.1098" y1="62.3249" x2="-8.82468" y2="58.2156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint5_linear_94:889" x1="65.4236" y1="65.0701" x2="24.0178" y2="41.6598" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    </defs>
                    </svg>
                </div>
                <div class=" footer-sp-dec2">
                    <svg width="55" height="99" viewBox="0 0 55 99" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="#959CB1"></circle>
                    <mask id="mask0_94:899" style="mask-type: alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="99" height="99">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="#009500"></circle>
                    </mask>
                    <g mask="url(#mask0_94:899)">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="url(#paint0_radial_94:899)"></circle>
                    <g opacity="0.8" filter="url(#filter0_f_94:899)">
                    <circle cx="53.8676" cy="26.2061" r="20.3824" fill="white"></circle>
                    </g>
                    </g>
                    <defs>
                    <filter id="filter0_f_94:899" x="12.4852" y="-15.1763" width="82.7646" height="82.7646" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                    <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
                    <feGaussianBlur stdDeviation="10.5" result="effect1_foregroundBlur_94:899"></feGaussianBlur>
                    </filter>
                    <radialGradient id="paint0_radial_94:899" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(49.5 49.5) rotate(90) scale(53.1397)">
                    <stop stop-opacity="0.47"></stop>
                    <stop offset="1" stop-opacity="0"></stop>
                    </radialGradient>
                    </defs>
                    </svg>
                </div>
            </div>
        </footer>


 
      

        <a href="#" class="back-to-top">
            <i class="bi bi-chevron-up"></i>
        </a>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const toggleNav = document.querySelector('.menu-btn-sp');
    const navigation = document.querySelector('.mob-menu-sp');

    toggleNav.addEventListener('click', function(){
        toggleNav.classList.toggle('nav-expanded');
        navigation.classList.toggle('nav-visible');
    });
});


document.addEventListener("scroll", () => {
    const mainHeader = document.querySelector('.header-sp');
    const scrollToTopButton = document.querySelector('.back-to-top');
    const scrollPosition = window.scrollY;

    mainHeader.classList.toggle("header-scrolled", scrollPosition > 0);
    scrollToTopButton.classList.toggle("visible", scrollPosition > 100);
});

document.addEventListener("DOMContentLoaded", function() {
    const userForm = document.querySelector('.form-sp');
    const userSignup = document.querySelector('.signup-sp');

    if (!userForm) {
        userSignup.classList.add("exclusive-signup");
    }
});

document.addEventListener("DOMContentLoaded", function() {
    const commentBlock = document.querySelector('.comments-sp-item');
    const commentAuthor = document.querySelector('.comments-sp-author');

    if (commentBlock.classList.contains("flex-column")) {
        commentAuthor.style.cssText = "padding-top: 32px; margin-top: 32px; border-top: solid 1px;";
    } else {
        commentAuthor.style.cssText = "padding-bottom: 32px; margin-bottom: 32px; border-bottom: solid 1px;";
    }
});

(() => {
    document.querySelectorAll('.hero-inner-sp .welcome-title-sp, .hero-inner-sp .welcome-btn-sp, .features-sp-title, .marg, .features-sp-it, .main-sp-img-wraper, .video-title-wraper-sp, .intro-video-play-sp, .partners-wraper, .comments-sp-header, .comments-sp-wraper, .tarifs-sp-list, .forms .container-sp, .footer-sp').forEach(el => {
        el.classList.add('wow', 'animate__fadeInUp');
    });

    new WOW({
        animateClass: 'animate__animated',
    }).init();
})();


let menuBtn = document.querySelector('.menu-btn-sp');
let menu = document.querySelector('.mob-menu-sp');

menuBtn.addEventListener('click', function(){
    menuBtn.classList.toggle('active');
    menu.classList.toggle('active');
})
let headerDirection = document.querySelector('.nav-inner-sp');
let mobMenu = $('.mob-menu-sp');

if (headerDirection.classList.contains("flex-row")) {  
    mobMenu.css('right', "0");
} else {
    mobMenu.css('left', "0");
}
</script>

           

</body>
</html>
