


<!DOCTYPE html>
<html>
   
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Nickelfin | Capacitando a Tomada de Decisão Financeira: Apresentando os Serviços Especializados da Nickelfin em Modelagem e Previsão Financeira</title>
        <meta property="og:title" content="Nickelfin | Capacitando a Tomada de Decisão Financeira: Apresentando os Serviços Especializados da Nickelfin em Modelagem e Previsão Financeira" />
        <meta property="og:image" content="665e076830ac0_5475233_view.jpeg"/>
        
        <meta property="og:description" content="A Nickelfin é uma fornecedora líder de serviços especializados no domínio da modelagem e previsão financeira. Com um...">
        <meta name="description" content="A Nickelfin é uma fornecedora líder de serviços especializados no domínio da modelagem e previsão financeira. Com um...">
        <link rel="stylesheet" type="text/css" href="vendor/css/slick.css" />
        <link rel="stylesheet" type="text/css" href="vendor/css/slick-theme.css" />
        <link rel="stylesheet" href="vendor/css/bootstrap.css">
        <link rel="stylesheet" href="vendor/css/bootstrap-icons.css">
        <link rel="stylesheet" href="vendor/css/buttons.css">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
         
        <link rel="shortcut icon" href="business-logo.svg" type="image/x-icon">
        <script src="vendor/jsCcomponents/jquery.min.js"></script>
        <script type="text/javascript" src="vendor/jsCcomponents/slick.js"></script>
        <link href="https://fonts.googleapis.com/css2?family=Noticia+Text:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Bakbak+One&display=swap" rel="stylesheet">
        <style>
            body{
                direction: ltr;
                font-family: 'Noticia Text', sans-serif !important;
                font-size: 17px;
                margin: 0;
                padding: 0px;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
                margin: 0;
            }

            ul {
                margin: 0;
                padding: 0;
            }

            button {
                cursor: pointer;
            }

            img {
                display: block;
            }

            a {
                text-decoration: none;
            }

            li {
                list-style: none;
            }

            video, img {
                max-width: 100%;
            }

            .head {
                padding: 40px 0;
                display: flex;
                gap: 10px;
                align-items: center;
                justify-content: space-between;
                flex-direction: row;
            }

            .logo {
                display: flex;
                align-items: center;
            }

            .log_img {
                width:55px;
                padding: 0;
                margin: 0 15px;
            }

            .s_name {
                color: inherit;
                font-weight: 400;
                font-size: 21px;
            }

            .nav-wrap {
                display: flex;
                align-items: center;
                gap: 15px;
                flex-direction: row;
            }

            .head-nav {
                display: flex;
                gap: 23px;
                box-shadow: inset -1px 0 0 rgb(71, 71, 71);
                padding: 0 11px;
                flex-wrap: wrap;
                align-items: center;
                justify-content: center;
            }

            .nav-link {
                color: inherit;
                font-size: 16px;
                font-weight: 400;
                text-transform: uppercase
            }

            .search-form {
                display: flex;

            }

            .search-link {
                padding: 11px;
            }

            .bi-search {
                color: black;
                font-size: 16px;
            }

            .main-view {
                position: relative;
                width: 100%;
                height: auto;
                display: flex;
                justify-content: center;
                align-items: center;
                overflow: hidden;
                padding:  389px 0;
            }

            .back-video {
                position: absolute;
                width: 100%;
                height: 100%;

            }

            .color-overlay {
                position: absolute;
                width: 100%;
                height: 100%;
                background-color: rgba(54, 51, 83, 0.6);
                opacity: 0.5;
            }

            .back-video > video {
                display: block;
                height: 100%;
                width: 100%;
                object-fit: cover;
            }

            .main-block {
                display: flex;
                flex-direction: column;
                align-items: center;
                z-index: 1;
            }

            .main-title {
                color: #ffffff;
                font-size:  48px;
                font-weight: 400;
                text-transform: uppercase;
                line-height: 1.2;
                margin-bottom: 65px;
                text-align: center;
            }

            .statistics {
                position: relative;
                padding-top: 157px;
                padding-bottom:  157px;
                display: flex;
                justify-content: center;
                gap: 30px;
                flex-direction: row-reverse;
            }

            .left, .right {
                width: calc(100% / 2 - 15px);
            }

            .left {
                position: relative;
                display: flex;
                justify-content: center;
                flex-direction: row-reverse;
            }

            .up-block {
                display: flex;
                flex-direction: column;
                justify-content: center;
            }

            .down-block {
                display: flex;
                flex-direction: column;

            }

            .stats-box {
                padding: 23px 23px;
                margin: 24px;
                width: 174px;
                border-radius: 30px;
                background: #ffffff;
                box-shadow: 0 1.5px 12px 2px rgb(0 0 0 / 6%);
            }

            .stats-img {
                font-size: 50px;

            }

            .stats-value {
                font-size: 21px;
                font-weight: 600;
                margin: 9px 0px;
            }

            .stats-text {
                font-size: 16px;
                font-weight: bold;
                word-break: break-word;
            }

            .back-hexa-opacity {
                position: absolute;
                z-index: -2;
                left: 0;
                top: 157px;
            }

            .back-hexa {
                position: absolute;
                z-index: -1;
                bottom: 0;
            }

            .right {
                display: flex;
                flex-direction:  column-reverse;
            }

            .stats-title {
                margin-top: 40px;
                font-size: 44px;
                font-weight: 400;
                text-transform: uppercase;
                margin-bottom: 40px;
            }

            .stats-text-second-title {
                font-size: 26px;
                margin-bottom: 23px;
            }

            .video-box {
                margin-bottom: 23px;
                border-radius: 20px;
                overflow: hidden;
            }


            .primary-content-box {
                display: flex;
                flex-direction: column;
                gap: 23px;
                align-items: center;
            }


            .content-wrap-img {
                width: 50%;
                display: flex;
                justify-content: center;
                overflow: hidden;
            }

            .content-img  {
                object-fit: cover;
            }

            .content-wrap-text {
                padding-left: 24px;
                padding-right: 24px;
                width: 100%;
            }


            .content-text {
                font-family: 400;
                font-style: fw-normal;
                font-size: 15px;
                color: inherit;
            }

            .content-title {
                font-weight: 400;
                text-transform: uppercase;
                font-size: 44px;
                text-align: center;
                color: inherit;
                margin-bottom:  24px;
            }

            .price {
                margin-top: 23px;
                font-family: 400;
                font-style: fw-normal;
                font-size: 26px;
                color: inherit;
            }


            .work-stages {
                padding-top: 157px;
                padding-bottom: 157px;
            }

            .work-stages-title {
                font-weight: 400;
                text-transform: uppercase;
                font-size: 44px;
                text-align: center;
                color: inherit;
                margin-bottom:  24px;
            }


            .work-stages-wrap-row {
                display: flex;
                justify-content: center;
                gap: 30px;
                flex-direction:row-reverse;
                align-items: center;
            }

            .work-stages-item, .work-stages-img {
                width: calc(100% / 2 - 15px);
            }

            .work-stages-item {
                display: flex;
                flex-direction: column;
            }

            .work-stages-img img {
                max-width: 429px;
                max-height:  389px;
                display: block;
                margin: 0 auto;
            }

            .work-stages-text {
                margin-top: 24px;
                font-size: 20px;
                text-transform: uppercase;
                font-weight: 600;
            }

            .customer-review-title {
                font-weight: 400;
                text-transform: uppercase;
                font-size: 44px;
                text-align: center;
                color: inherit;
                margin-bottom:118px;
            }

            .comment-box {
                margin: 65px 0 24px 0;
                padding: 40px 120px 40px 120px;
                box-shadow: 0 0 15px rgb(0 0 0 / 10%);
                border: 2px solid #2DB8C7;
                border-radius: 20px;
                direction: ltr;
            }

            .slider__item {
                display: flex;
                flex-direction: column;
                justify-content: center;
                position: relative;
            }

            .pic img {
                margin: 0 auto;
                border-radius: 0%;
                position: absolute;
                top: -50px;
                left: 50%;
                transform: translate(-50%, -50%);
                border: 4px solid #2DB8C7;
                box-shadow: 0px 0px 0px #2DB8C7;

            }

            .slick-slide{
                height: auto;
            }

            .slick-prev {
                left: -80px;
            }

            .slick-next {
                right: -80px;
            }

            .slick-prev:before, .slick-next:before{
                color: #2DB8C7;
                font-size: 44px;
            }

            .slick-prev {
                left: -65px;
            }

            .slick-next {
                right: -65px;
            }

            .slick-list {
                overflow-x: clip;
                overflow-y: inherit;
            }

            .comment-person {
                text-align: center;
                margin-top: 23px;
                margin-bottom: 23px;
                font-weight: 400;
                font-size:   21px;
                color: inherit;
            }

            .comment-text {
                text-align: center;
                margin-bottom: 23px;
                font-size:   16px;
                color: inherit;
            }

            .contact-us {
                display: flex;
                gap: 30px;
                padding-top: 157px;
                padding-bottom: 157px;
                flex-direction: column;
            }

            .contact-us-img {
                background: url(portrait/depictions_header_665e075d3b7853.55899272.jpg);
                background-position: center;
                background-size: cover;
                width: 100%;
            }

            .contact-us-form {
                display: flex;
                flex-direction: column;
            }

            .form {
                display: flex;
                flex-direction: column;
            }

            .form-field {
                display: flex;
                gap: 10px;
                margin-bottom: 23px;
            }

            .form-input {
                display: block;
                width: 100%;
                height: auto;
                padding: 6px 12px;
                font-size: 17px;
                color: #555;
                border: 1px solid #2DB8C7;
            }

            .form-field textarea {
                border: 1px solid #2DB8C7;
                width: 100%;
            }


            .address-title, .mail-title, .phone-title {
                margin-bottom: 23px;
                font-size: 17px;
                font-weight: 600;
                color: inherit;
            }

            .contact-us-form a{
                word-break: break-all;
                margin-bottom: 40px;
                font-size:  26px;
                font-weight: 400;
                color: inherit;
            }

            .address, .mail, .phone {
                margin-bottom: 40px;
                font-size:  26px;
                font-weight: 400;
                color: inherit;
            }

            .spesial-link {
                display: flex;
                flex-direction: row-reverse;
                justify-content: center;
                gap:  157px;
                padding-top: 23px;
                padding-bottom: 23px;
            }

            .spesial-link a {
                font-size: 17px;
                font-weight: 400;
                color: #555;
            }

            .input-container {
                position: relative;
                display: flex;
                flex-direction: column;
                gap: 11px;
            }
            .checkInput a {
                color: #1D2D50;
            }
            .checkInput {
                text-align: start;
            }
            #cookie-txt-lYpnK-class{
                display: none;
                justify-content: space-between;
                align-items: center;
                position: fixed;
                bottom: 23px;
                left: 50%;
                width: 1294px;
                max-width: 90%;
                transform: translateX(-50%);
                padding: 23px;
                background-color:  #1D2D50;
                border-radius: 20px;
                box-shadow: 2px 3px 10px rgba(0, 0, 0, 0.9);
                gap: 23px;
                z-index: 999999;
            }
            #cookie-txt-lYpnK-class button{
                max-width: 200px;
                width: 100%;
            }

            #cookie-txt-lYpnK-class p{
                margin: 0;
                font-size: 15px;
                color: #fff;
            }


            @media (min-width: 576px){
                #cookie-txt-lYpnK-class.show{
                    display: flex;
                }
            }

            @media (max-width: 575px){
                #cookie-txt-lYpnK-class.show{
                    display: flex;
                    flex-direction: column;
                }
                button{
                    width: 100%;
                }
            }
        </style>
        <link rel="stylesheet" href="vendor/css/media.css">
        
        </head>

        <body>
            
            <section>
                <div class="container head">
                    <div class="logo">
                        <img class="log_img" src="business-logo.svg" alt="">
                        <h2 class="s_name"> Nickelfin </h2>
                    </div>
                    <div class="nav-wrap">
                        <nav>
                            <ul class="head-nav img--GDFcH--div ">
                                <li>
                                    <a class="nav-link" href="./">  Página inicial </a>
                                </li>
                                <li>
                                    <a class="nav-link" href="./#stats"> As nossas estatísticas </a>
                                </li>
                                <li>
                                    <a class="nav-link" href="./#how-work">Passos para a independência financeira com a nossa equipa</a>
                                </li>
                                
                            </ul>
                        </nav>
                        <div class="search-form">
                            <input type="text" class="search form-control" placeholder="Pesquisar">
                            <a href="#" class="search-link"><i class="bi bi-search"></i></a>
                        </div>
                    </div>
                </div>
                <div class="main-view">
                    <div class="container main-block">
                        <h1 class="main-title"> Olá e bem-vindo ao Nickelfin! A sua jornada financeira será fácil e direta com o nosso apoio. Estamos aqui para lhe prestar o melhor serviço e satisfação com os resultados alcançados. </h1>
                        
                    </div>
                    <div class="back-video">
                    <div class="color-overlay"></div>
                    <video src="portrait/icons_video_665e0761d71412.73669970.mp4" autoplay muted loop></video>
                    </div>
                </div>
            </section>
            
            <section>
                <div id="stats" class="container statistics">
                    <div class="back-hexa-opacity bigFigure">
                        <svg width="500px" height="550px" viewBox="0 0 38 43" version="1.1" fill-opacity="0.5">
                            <defs>
                                <linearGradient id="secondary-hexa" x1="56.1985951%" y1="11.7667404%" x2="20.6835068%" y2="110.664023%">
                                    <stop stop-color=" #2DB8C7 " offset="0%"></stop>
                                    <stop stop-color=" #6C00FF " offset="100%"></stop>
                                </linearGradient>
                            </defs>
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <path
                                    d="M0,30.0245126 C0,31.6146901 0.838820037,33.0841534 2.20054545,33.8792422 L16.7994545,42.4036834 C18.16118,43.1987722 19.83882,43.1987722 21.2005455,42.4036834 L35.7994545,33.8792422 C37.16118,33.0841534 38,31.6146901 38,30.0245126 L38,12.9755587 C38,11.3853099 37.16118,9.91591793 35.7994545,9.12075784 L21.2005455,0.596316588 C19.83882,-0.198772196 18.16118,-0.198772196 16.7994545,0.596316588 L2.20054545,9.12075784 C0.838820037,9.91591793 0,11.3853099 0,12.9755587 L0,30.0245126 Z"
                                    fill="url(#secondary-hexa)"></path>
                            </g>
                        </svg>
                    </div>
                    <div class="left">
                        <div class="up-block">
                            <div class="stats-box">
                                <i class="bi stats-img bi-archive"></i>
                                <h5 class="stats-value"> 6534 </h5>
                                <p class="stats-text">Candidaturas processadas</p>
                            </div>
                            <div class="stats-box">
                                <i class="bi stats-img bi-bag-check"></i>
                                <h5 class="stats-value"> 1062 </h5>
                                <p class="stats-text">Perguntas encerradas</p>
                            </div>
                        </div>
                        <div class="down-block">
                            <div class="stats-box">
                                <i class="bi stats-img bi-person-check"></i>
                                <h5 class="stats-value"> 187 </h5>
                                <p class="stats-text">Candidaturas aceites</p>
                            </div>
                            <div class="stats-box">
                                <i class="bi stats-img bi-pie-chart"></i>
                                <h5 class="stats-value"> 2005 </h5>
                                <p class="stats-text">Projetos concluídos com sucesso</p>
                            </div>
                        </div>
                        <div class="back-hexa">
                            <svg width="410px" height="484px" viewBox="0 0 377 440" version="1.1">
                                <defs>
                                    <linearGradient id="primary-hexa" x1="34.1359172%" y1="14.3140713%" x2="132.662444%" y2="100%">
                                        <stop stop-color="#FFECEF " offset="0%"></stop>
                                        <stop stop-color="#FF99D7" offset="100%"></stop>
                                    </linearGradient>
                                    <linearGradient id="secondary-hexa" x1="56.1985951%" y1="11.7667404%" x2="20.6835068%" y2="110.664023%">
                                        <stop stop-color=" #2DB8C7 " offset="0%"></stop>
                                        <stop stop-color=" #6C00FF " offset="100%"></stop>
                                    </linearGradient>
                                    <linearGradient id="accent-hexa" x1="56.2159946%" y1="11.7667404%" x2="20.6012149%" y2="110.664023%">
                                        <stop stop-color="#FFCEFE" offset="0%"></stop>
                                        <stop stop-color="#D9ACF5" offset="100%"></stop>
                                    </linearGradient>
                                </defs>
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <g id="Main-Feature" transform="translate(-208.000000, -968.000000)">
                                        <g transform="translate(112.000000, 782.000000)">
                                            <g id="Group-3" transform="translate(96.000000, 186.000000)">
                                                <path
                                                    d="M0,293.262681 C0,308.794648 8.32197774,323.147545 21.8317273,330.913528 L166.668273,414.175512 C180.178022,421.941496 196.821978,421.941496 210.331727,414.175512 L355.168273,330.913528 C368.678022,323.147545 377,308.794648 377,293.262681 L377,126.738016 C377,111.205352 368.678022,96.8531518 355.168273,89.0864719 L210.331727,5.8244876 C196.821978,-1.94149587 180.178022,-1.94149587 166.668273,5.8244876 L21.8317273,89.0864719 C8.32197774,96.8531518 0,111.205352 0,126.738016 L0,293.262681 Z"
                                                    fill="url(#secondary-hexa)"></path>
                                                <path
                                                    d="M315,360.877113 C315,363.465775 316.368601,365.857924 318.590364,367.152255 L342.409636,381.029252 C344.631399,382.323583 347.368601,382.323583 349.590364,381.029252 L373.409636,367.152255 C375.631399,365.857924 377,363.465775 377,360.877113 L377,333.123003 C377,330.534225 375.631399,328.142192 373.409636,326.847745 L349.590364,312.970748 C347.368601,311.676417 344.631399,311.676417 342.409636,312.970748 L318.590364,326.847745 C316.368601,328.142192 315,330.534225 315,333.123003 L315,360.877113 Z"
                                                    fill="url(#primary-hexa)"></path>
                                                <path
                                                    d="M15,405.298115 C15,409.550915 17.2515696,413.480875 20.9067273,415.607276 L60.0932727,438.4052 C63.7484304,440.5316 68.2515696,440.5316 71.9067273,438.4052 L111.093273,415.607276 C114.74843,413.480875 117,409.550915 117,405.298115 L117,359.702076 C117,355.449085 114.74843,351.519315 111.093273,349.392724 L71.9067273,326.5948 C68.2515696,324.4684 63.7484304,324.4684 60.0932727,326.5948 L20.9067273,349.392724 C17.2515696,351.519315 15,355.449085 15,359.702076 L15,405.298115 Z"
                                                    fill="url(#accent-hexa)"></path>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </div>
                    </div>
                    <div class="right">
                        <div class="stats-title-wrap">
                            <svg width="49px" height="55px" viewBox="0 0 38 43" version="1.1">
                                <defs>
                                    <linearGradient id="secondary-hexa" x1="56.1985951%" y1="11.7667404%" x2="20.6835068%" y2="110.664023%">
                                        <stop stop-color=" #2DB8C7 " offset="0%"></stop>
                                        <stop stop-color=" #6C00FF " offset="100%"></stop>
                                    </linearGradient>
                                </defs>
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <path
                                        d="M0,30.0245126 C0,31.6146901 0.838820037,33.0841534 2.20054545,33.8792422 L16.7994545,42.4036834 C18.16118,43.1987722 19.83882,43.1987722 21.2005455,42.4036834 L35.7994545,33.8792422 C37.16118,33.0841534 38,31.6146901 38,30.0245126 L38,12.9755587 C38,11.3853099 37.16118,9.91591793 35.7994545,9.12075784 L21.2005455,0.596316588 C19.83882,-0.198772196 18.16118,-0.198772196 16.7994545,0.596316588 L2.20054545,9.12075784 C0.838820037,9.91591793 0,11.3853099 0,12.9755587 L0,30.0245126 Z"
                                        fill="url(#secondary-hexa)"></path>
                                </g>
                            </svg>
                            <h2 class="stats-title header--LQI4z--div "> As nossas estatísticas</h2>
                            <p class="stats-text-second-title"> Com base em anos de experiência e inúmeros clientes satisfeitos, estamos felizes em compartilhar nosso conhecimento e apoiar seus projetos. </p>
                        </div>
                        <div class="video-box">
                            <video src="video/0-motion-wmJB.mp4" muted loop controls="controls"></video>
                        </div>
                    </div>
                </div>
            </section>


            <section>
                <div class="container primary-content">
                    <div class="primary-content-box">
                        <div class="content-wrap-img">
                            <img class="content-img " src="665e076830ac0_5475233_view.jpeg" alt="Capacitando a Tomada de Decisão Financeira: Apresentando os Serviços Especializados da Nickelfin em Modelagem e Previsão Financeira">
                        </div>
                        <div class="content-wrap-text ">
                            <h2 class="content-title"> Capacitando a Tomada de Decisão Financeira: Apresentando os Serviços Especializados da Nickelfin em Modelagem e Previsão Financeira</h2>
                            <div class="content-text"> <p>A Nickelfin é uma fornecedora líder de serviços especializados no domínio da modelagem e previsão financeira. Com um compromisso com a excelência e um foco na precisão, capacitamos as empresas a tomar decisões informadas, otimizar o desempenho e navegar nas complexidades do cenário financeiro atual com confiança.</p>
<p style="text-align: center;"><strong>Os nossos serviços:</strong></p>
<ul>
<li>Modelagem Financeira: Nossa equipe de especialistas elabora modelos financeiros abrangentes adaptados às necessidades e objetivos únicos de cada cliente. De startups em busca de investimento a corporações estabelecidas que planejam iniciativas estratégicas, fornecemos modelos robustos que fornecem insights valiosos e facilitam a tomada de decisões informadas.</li>
<li>Previsão: Antecipar as tendências financeiras futuras é crucial para o crescimento sustentável e a gestão de riscos. Na Nickelfin, aproveitamos técnicas avançadas de previsão e experiência específica do setor para ajudar os clientes a prever a dinâmica do mercado, identificar oportunidades e mitigar desafios potenciais.</li>
<li>Análise de cenários: Em um ambiente de negócios em constante mudança, a análise de cenários é essencial para avaliar o impacto de vários fatores no desempenho financeiro. Ajudamos os clientes a simular diferentes cenários, avaliar resultados e desenvolver estratégias resilientes para se adaptarem às circunstâncias em mudança.</li>
<li>Planejamento e Análise Financeira (FP&amp;A): Nossos serviços de FP&amp;A permitem que os clientes obtenham uma compreensão mais profunda de sua saúde financeira, otimizem a alocação de recursos e alinhem as metas financeiras com os objetivos gerais de negócios. Ao fornecer insights acionáveis e recomendações estratégicas, capacitamos as organizações a impulsionar o crescimento sustentável e maximizar a lucratividade.</li>
</ul>
<p style="text-align: center;"><strong>Valores da Empresa:</strong></p>
<ul>
<li>Excelência: Estamos empenhados em manter os mais elevados padrões de qualidade e rigor em tudo o que fazemos. Nossa equipe busca continuamente a excelência, alavancando ferramentas e metodologias de ponta para entregar resultados superiores que excedem as expectativas dos clientes.</li>
<li>Integridade: A integridade é a base do nosso negócio. Conduzimo-nos com honestidade, transparência e profissionalismo em todas as interações, fomentando a confiança entre clientes, parceiros e partes interessadas.</li>
<li>Inovação: A inovação impulsiona o progresso e abraçamos a criatividade e o pensamento de futuro na nossa abordagem à modelação e previsão financeiras. Ao mantermo-nos a par das tendências e tecnologias emergentes, refinamos continuamente os nossos processos e soluções para satisfazer as necessidades em evolução dos nossos clientes.</li>
<li>Colaboração: Acreditamos no poder da colaboração e do trabalho em equipa. Ao promover uma cultura de comunicação aberta e colaboração, aproveitamos a experiência coletiva de nossa equipe diversificada para oferecer soluções abrangentes e integradas que geram resultados tangíveis para nossos clientes.</li>
<li>Foco no cliente: Na Nickelfin, nossos clientes estão no centro de tudo o que fazemos. Dedicamo-nos a compreender os seus desafios e objetivos únicos, e adaptamos os nossos serviços para atender às suas necessidades específicas, garantindo que o seu sucesso e satisfação são as nossas principais prioridades.</li>
</ul>
<p>Com um compromisso firme com a excelência, integridade, inovação, colaboração e foco no cliente, a Nickelfin está preparada para ser seu parceiro confiável em modelagem e previsão financeira, capacitando-o a alcançar seus objetivos de negócios com confiança e clareza.</p> </div>
                             
                        </div>
                    </div>
                </div>
            </section>


            <section>
                <div id="how-work" class="container work-stages">
                    <h2 class="work-stages-title"> Passos para a independência financeira com a nossa equipa</h2>
                        <div class="work-stages-wrap-row dfgdfg1">
                            <div class="work-stages-item">
                                <svg width="49px" height="55px" viewBox="0 0 38 43" version="1.1">
                                    <defs>
                                        <linearGradient id="primary-hexa" x1="34.1359172%" y1="14.3140713%" x2="132.662444%" y2="100%">
                                            <stop stop-color="#FFECEF " offset="0%"></stop>
                                            <stop stop-color="#FF99D7" offset="100%"></stop>
                                        </linearGradient>
                                    </defs>
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <path
                                            d="M0,30.0245126 C0,31.6146901 0.838820037,33.0841534 2.20054545,33.8792422 L16.7994545,42.4036834 C18.16118,43.1987722 19.83882,43.1987722 21.2005455,42.4036834 L35.7994545,33.8792422 C37.16118,33.0841534 38,31.6146901 38,30.0245126 L38,12.9755587 C38,11.3853099 37.16118,9.91591793 35.7994545,9.12075784 L21.2005455,0.596316588 C19.83882,-0.198772196 18.16118,-0.198772196 16.7994545,0.596316588 L2.20054545,9.12075784 C0.838820037,9.91591793 0,11.3853099 0,12.9755587 L0,30.0245126 Z"
                                            fill="url(#secondary-hexa)"></path>
                                    </g>
                                </svg>
                                <p class="work-stages-text"> Análise Financeira Detalhada: Iniciamos com um diagnóstico completo das suas finanças.</p>
                            </div>
                            <div class="work-stages-img">
                                <img src="bg/0-vectorDesign-7R4T.svg" alt="">
                            </div>
                        </div>
                        <div class="work-stages-wrap-row dfgdfg2">
                            <div class="work-stages-img">
                                <img src="bg/1-vectorDesign-7R4T.svg" alt="">
                            </div>
                            <div class="work-stages-item">
                                <svg width="49px" height="55px" viewBox="0 0 38 43" version="1.1">
                                    <defs>
                                        <linearGradient id="secondary-hexa" x1="56.1985951%" y1="11.7667404%" x2="20.6835068%" y2="110.664023%">
                                            <stop stop-color=" #2DB8C7 " offset="0%"></stop>
                                            <stop stop-color=" #6C00FF " offset="100%"></stop>
                                        </linearGradient>
                                    </defs>
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <path
                                            d="M0,30.0245126 C0,31.6146901 0.838820037,33.0841534 2.20054545,33.8792422 L16.7994545,42.4036834 C18.16118,43.1987722 19.83882,43.1987722 21.2005455,42.4036834 L35.7994545,33.8792422 C37.16118,33.0841534 38,31.6146901 38,30.0245126 L38,12.9755587 C38,11.3853099 37.16118,9.91591793 35.7994545,9.12075784 L21.2005455,0.596316588 C19.83882,-0.198772196 18.16118,-0.198772196 16.7994545,0.596316588 L2.20054545,9.12075784 C0.838820037,9.91591793 0,11.3853099 0,12.9755587 L0,30.0245126 Z"
                                            fill="url(#secondary-hexa)"></path>
                                    </g>
                                </svg>
                                <p class="work-stages-text"> Planeamento Personalizado: Construímos um plano adaptado às suas necessidades específicas.</p>
                            </div>
                        </div>
                        <div class="work-stages-wrap-row dfgdfg3">
                            <div class="work-stages-item">
                                <svg width="49px" height="55px" viewBox="0 0 38 43" version="1.1">
                                    <defs>
                                        <linearGradient id="accent-hexa" x1="56.2159946%" y1="11.7667404%" x2="20.6012149%" y2="110.664023%">
                                            <stop stop-color="#FFCEFE" offset="0%"></stop>
                                            <stop stop-color="#D9ACF5" offset="100%"></stop>
                                        </linearGradient>
                                    </defs>
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <path
                                            d="M0,30.0245126 C0,31.6146901 0.838820037,33.0841534 2.20054545,33.8792422 L16.7994545,42.4036834 C18.16118,43.1987722 19.83882,43.1987722 21.2005455,42.4036834 L35.7994545,33.8792422 C37.16118,33.0841534 38,31.6146901 38,30.0245126 L38,12.9755587 C38,11.3853099 37.16118,9.91591793 35.7994545,9.12075784 L21.2005455,0.596316588 C19.83882,-0.198772196 18.16118,-0.198772196 16.7994545,0.596316588 L2.20054545,9.12075784 C0.838820037,9.91591793 0,11.3853099 0,12.9755587 L0,30.0245126 Z"
                                            fill="url(#secondary-hexa)"></path>
                                    </g>
                                </svg>
                                <p class="work-stages-text"> Implementação das Soluções: Orientamos nas escolhas financeiras ideais para o seu negócio.</p>
                            </div>
                            <div class="work-stages-img">
                                <img src="bg/2-vectorDesign-7R4T.svg" alt="">
                            </div>
                        </div>
                </div>
            </section>
            
            <section>
                <div class="container customer-review">
                    <h2 class="customer-review-title btn-EQoFx-element ">Comentários</h2>
                        <div class="comment-box">
                            <div class="slider—block">
                                <div class="slider__box">
                                    <div class="slider__item">
                                        <div class="pic">
                                            <img src="avatar/avatarPic-732Q-0.jpg" alt="client" width=" 65">
                                        </div>
                                        <h5 class="comment-person">João Ferreira</h5>
                                        <p class="comment-text fst-italic">Serviço excelente! Graças à Nickelfin a minha empresa recuperou o equilíbrio financeiro.</p>
                                    </div>
                                </div>
                                <div class="slider__box">
                                    <div class="slider__item">
                                        <div>
                                            <div class="pic">
                                                <img src="avatar/avatarPic-732Q-1.jpg" alt="client" width=" 65">
                                            </div>
                                            <h5 class="comment-person">Miguel Correia</h5>
                                            <p class="comment-text fst-italic">A consultoria financeira da Nickelfin ajudou-me a identificar áreas chave de poupança.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="slider__box">
                                    <div class="slider__item">
                                        <div class="pic">
                                            <img src="avatar/avatarPic-732Q-2.jpg" alt="client" width=" 65">
                                        </div>
                                        <h5 class="comment-person">Ricardo Pinto</h5>
                                        <p class="comment-text fst-italic">Estou extremamente satisfeito com o serviço ao cliente excepcional da Nickelfin.</p>
                                    </div>
                                </div>
                                <div class="slider__box">
                                    <div class="slider__item">
                                        <div class="pic">
                                            <img src=" avatar/profilephoto-hibo-0.jpg" alt="client" width=" 65">
                                        </div>
                                        <h5 class="comment-person">Maria Pereira</h5>
                                        <p class="comment-text fst-italic">Nickelfin proporcionou uma visão clara e completa das finanças da minha empresa.</p>
                                    </div>
                                </div>
                                <div class="slider__box">
                                    <div class="slider__item">
                                        <div class="pic">
                                            <img src="avatar/avatarPic-732Q-3.jpg" alt="client" width=" 65">
                                        </div>
                                        <h5 class="comment-person">Tiago Costa</h5>
                                        <p class="comment-text fst-italic">Confio plenamente na análise e recomendações feitas pela equipa da Nickelfin.</p>
                                    </div>
                                </div>
                                <div class="slider__box">
                                    <div class="slider__item">
                                        <div class="pic">
                                            <img src=" avatar/profilephoto-hibo-1.jpg" alt="client" width=" 65">
                                        </div>
                                        <h5 class="comment-person">Ana Silva</h5>
                                        <p class="comment-text fst-italic">Graças à auditoria financeiras da Nickelfin conseguimos traçar uma estratégia eficaz.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            </section>
            
            
            <section>
                <div id="contacts" class=" container contact-us">
                    <div class="contact-us-img "></div>
                    <div class="contact-us-form">
                        
                        
                        
                        
                        
                        
                        
                    </div>
                </div>
                
            </section>

            <section>
                <div class="container spesial-link">
                    <a href="privacy-agreement.php"  target="_blank"> Política de privacidade</a>
                    <a href="userAgreement.php"  target="_blank"> Termo e condições </a>
                    <a href="content-disclaimer.php"  target="_blank">Isenções de responsabilidade</a>
                </div>
            </section>

        <script>
            if($('.main-block').css('flex-direction') == 'row') {
                $('.main-title').css({'font-size' : '45px', 'text-align' : 'start', 'margin-bottom': '0' });
                $('.main-block').css('gap' , '30px');
                $('.main-title').css('width' , 'calc(100% / 2 - 15px)');
                $('.head-btn').css('width', 'calc(100% / 2 - 15px)');
            }
            if($('.statistics').css('flex-direction') == 'row-reverse') {
                $('.back-hexa-opacity').css({'right': '0', 'left' : 'initial'})
            }
            if($('.bigFigure svg').attr('fill-opacity') == '0.0'){
                $('.left').css('height','100%');
            }

        $('.search-link').click(function(){
                let valSearch = $('.search').val();
                if(valSearch != ''){
                    $(this).attr('href','https://www.google.com/search?q='+valSearch);
                }
            });
            if($('.up-block').css('justify-content') == 'flex-start') {
                $('.down-block').css('justify-content', 'center')
            }

            if($('.primary-content-box').css('flex-direction') == 'column' || $('.primary-content-box').css('flex-direction') == 'column-reverse') {
                $('.content-wrap-img img').css({'max-width': '800px'});
            }

        </script>

        <script>

            $(document).ready(function () {

            $('.slider—block').slick({
            dots: false,
            slidesToShow: 1,
            arrows: true,
            responsive: [
                {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    infinite: true,
                    dots: true,
                    arrows: false
                }
                },
                {
                breakpoint: 600,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    dots: true,
                    arrows: false
                }
                },
                {
                breakpoint: 480,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    dots: true,
                    arrows: false
                }
                }
            ]
            });
        });
        </script>

        <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const contactUs = document.querySelector('.contact-us');
                    if (window.getComputedStyle(contactUs).flexDirection === 'column') {
                        const contactUsImg = document.querySelector('.contact-us-img');
                        const formButton = document.querySelector('.form-button');
                        if (contactUsImg) contactUsImg.style.height = '600px';
                        if (formButton) {
                            formButton.style.display = 'flex';
                            formButton.style.justifyContent = 'center';
                        }
                    }

                    const contentImg = document.querySelector('.content-img');
                    if (contentImg) {
                        const myHeStyle = contentImg.naturalHeight;
                        const myWiStyle = contentImg.naturalWidth;

                        if (myHeStyle === myWiStyle && myWiStyle > 600) {
                            contentImg.style.width = '50%';
                        } else if (myHeStyle > myWiStyle) {
                            if (myHeStyle < 2000 && myHeStyle > 700) {
                                contentImg.style.width = '20%';
                            } else if (myHeStyle < 700 && myHeStyle > 500) {
                                contentImg.style.width = '50%';
                            }
                        } else if (myHeStyle < myWiStyle && myWiStyle < 600) {
                            contentImg.style.width = '500px';
                        } else {
                            contentImg.style.width = '100%';
                        }
                    }
                });
        </script>

            
            
    </body>
    
</html>

