<?php
session_start();
require_once 'src/_hash.php';
require_once 'src/_lgn.php';
require_once 'funcoes.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['hash'])) {
    header("Location: _lgn.php");
    exit;
}

$userSessionId = $_SESSION['user_id'];
$userId = substr($userSessionId, strlen('userlogged_'));

if (!isset($_SESSION['hash']) || !vrHash($userId, $_SESSION['hash'])) {
    header("Location: _lgn.php");
    exit;
}

$userData = obterUsr($userId);
if ($userData) {
    $userLogin = $userData['lgn'];
    $ultimoAcesso = $userData['ultimo_acesso'];
} else {
    echo "Erro ao obter dados do usuário.";
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>FL.® v1.5</title>
  <!-- Bootstrap CSS -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/pako/2.0.3/pako.min.js"></script>

  <!-- Fonte -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;700&display=swap" rel="stylesheet">
<style>
  body {
  font-family: 'Poppins', sans-serif;
  background-color: #343a40;
  color: #fff;
}

/* Estilo para o sidebar */
.sidebar {
  position: fixed;
  top: 0;
  bottom: 0;
  left: 0;
  z-index: 100;
  padding: 72px 0 0; /* Altura do topheader */
  width: 250px; /* Largura do sidebar padrão */
  box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
  background-color: #343a40; /* Cor do tema escuro */
  transition: all 0.3s ease; /* Adicionando transição para recolher/expadir */
}

/* Estilo para os links do sidebar */
.sidebar a {
  display: block;
  padding: 10px 15px;
  color: #fff; /* Cor do texto branco */
}

.sidebar a:hover {
  background-color: rgba(255, 255, 255, 0.1); /* Efeito ao passar o mouse */
}

.sidebar .active {
  background-color: rgba(255, 255, 255, 0.2); /* Cor quando clicado/acessado */
}

/* Estilo para o conteúdo */
.content {
  padding: 20px;
  transition: all 0.3s ease; /* Adicionando transição para recolher/expadir */
}

/* Ajuste para o topheader sobrepor o conteúdo */
.topheader {
  z-index: 200;
}

/* Estilo para o texto do usuário logado */
.usrLgd {
  margin-left: -10px;
}

/* Estilo para o sidebar recolhido */
.sidebar.collapsed {
  width: 60px; /* Largura do sidebar recolhido */
}

.sidebar.collapsed .nav-link span,
.sidebar.collapsed .usrLgd {
  display: none; /* Ocultar o texto do menu recolhido e do usuário logado */
}

.sidebar.collapsed .nav-link i {
  margin-right: 0; /* Remover a margem direita dos ícones do menu recolhido */
}
.content {
  transition: margin-left 0.3s ease; /* Ajuste apenas a margem esquerda */
  margin-left: 250px; /* Largura do menu expandido */
}


/* Ajuste do conteúdo ao expandir/recolher o sidebar */
.content-expanded {
  margin-left: 250px; /* Ajuste conforme a largura do menu expandido */
}

.sidebar-collapsed .content-expanded {
  margin-left: 60px; /* Ajuste conforme a largura do menu recolhido */
}

/* Estilo para as guias de navegação */
.nav-tabs .nav-link.active.custom-tab {
  background-color: #424750; /* Cor de fundo do sidebar */
  color: #fff3cd; /* Cor do texto */
}

.hidden-info {
    position: absolute;
    background-color: #fff; /* Cor de fundo */
    padding: 10px; /* Espaçamento interno */
    border: 1px solid #ccc; /* Borda */
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Sombra */
    z-index: 1000; /* Z-index alto para sobrepor outros elementos */
    display: none; /* Inicialmente oculto */
}


  </style>
</head>
<body>
  <!-- Topheader -->
  <header class="bg-dark text-white fixed-top topheader">
    <div class="container-fluid d-flex justify-content-between align-items-center py-2">
      <div>
        <span class="fs-5 text-primary">FL.®</span><span class="small text-primary">v1.5</span>
      </div>
	
      <div class="dropdown">
        <a class="btn btn-secondary dropdown-toggle" href="#" role="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
          X
        </a>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
		  <li><a class="dropdown-item" href="#">Ultimo acesso em <?php echo $ultimoAcesso; ?></a></li>
          <li><a class="dropdown-item" href="#">Alterar Senha</a></li>
          <li><a class="dropdown-item" href="logout.php">Logout</a></li>
        </ul>
      </div>
    </div>
  </header>

  <!-- Sidebar -->
  <div class="sidebar bg-dark text-white">
  

	
   <ul class="nav flex-column">
      <li class="nav-item">
          <button class="btn-dark btn text-primary" id="menu-toggle">&nbsp;<i class="fas fa-user me-2"></i> </button><span class="usrLgd text-primary"><?php echo $userLogin; ?></span>		
      </li>
	  
    <ul class="nav flex-column mt-1">
      <li class="nav-item">
        <a class="nav-link active" href="#dashboard">
          <i class="fas fa-chart-bar"></i>&nbsp;<span>Dashboard</span>
        </a>
      </li>
      <li class="nav-item">
        <a class="nav-link" href="#configuracoes">
            <i class="fas fa-cogs"></i>&nbsp;<span>Configurações</span>
        </a>
      </li>
    </ul>
  </div>

  <!-- Conteúdo -->
  <div class="content mt-5">
    <!-- Dashboard -->
    <div id="dashboard">
      <h1 class="my-4">Dashboard</h1>
     <div class="row">
    <div class="col-md-4">
        <div class="card bg-dark text-white text-center">
            <div class="card-body">
                <i class="fas fa-globe fa-3x"></i>
                <h5 class="card-title mt-2">Acessos gerais</h5>
                <p class="card-text display-2" id="qtdAcessosGerais"><?php echo contarAcessos('gerais'); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-dark text-white text-center">
            <div class="card-body">
                <i class="fas fa-check-circle fa-3x"></i>
                <h5 class="card-title mt-2">Acessos permitidos</h5>
                <p class="card-text display-2" id="qtdAcessosPermitidos"><?php echo contarAcessos('permitidos'); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-dark text-white text-center">
            <div class="card-body">
                <i class="fas fa-times-circle fa-3x"></i>
                <h5 class="card-title mt-2">Acessos bloqueados</h5>
                <p class="card-text display-2" id="qtdAcessosBloqueados"><?php echo contarAcessos('bloqueados'); ?></p>
            </div>
        </div>
    </div>
	
</div>
	
	
<!-- Acessos -->
<div class="col-md-12">
  <div class="card bg-dark text-white mt-4">
    <div class="card-header d-flex justify-content-between align-items-center">
      <ul class="nav nav-tabs bg-dark card-header-tabs" id="acessos-tabs">
       <li class="nav-item">
    <a class="nav-link active custom-tab" id="acessos-gerais-tab" href="#acessos-gerais">Acessos gerais</a>
			</li>
		<li class="nav-item">
			<a class="nav-link custom-tab" id="acessos-permitidos-tab" href="#acessos-permitidos">Acessos permitidos</a>
		</li>
		<li class="nav-item">
			<a class="nav-link custom-tab" id="acessos-bloqueados-tab" href="#acessos-bloqueados">Acessos bloqueados</a>
		</li>

      </ul>
      <!-- Controles adicionais à direita -->
      <div id="acsConfig" > 
        <!-- Checkbox para atualização automática -->
        <div class="form-check d-inline-block">
          <input class="form-check-input" type="checkbox" id="auto_atualizar" checked>
          <label class="form-check-label" for="auto_atualizar">Auto-atualizar</label>
        </div>
        <!-- Seletor de intervalo de atualização -->
        <div class="form-group d-inline-block mx-2">
          <select class="form-control" id="intervalo_atualizacao">
			<option value="" disabled selected>Selecione o intervalo</option>
            <option value="10">10 segundos</option>
            <option value="20">20 segundos</option>
            <option value="30">30 segundos</option>
            <option value="40">40 segundos</option>
            <option value="50">50 segundos</option>
            <option value="60">60 segundos</option>
          </select>
        </div>
        <!-- Botões de atualizar e zerar acessos -->
        <button class="btn btn-primary" id="atualizar-acessos">Atualizar</button>
        <button class="btn btn-danger ml-2" id="zerar-acessos">Zerar acessos</button>
      </div>
      <!-- Fim dos controles adicionais -->
    </div>
    <div class="card-body">
	<div class="card-footer d-flex justify-content-end">
		<button id="btnAnteriorAcs" class="btn btn-primary mr-2" disabled>Anterior</button>
		<button id="btnProximoAcs" class="btn btn-primary mx-1">Próximo</button>
	</div>
      <!-- Conteúdo das abas -->
      <div class="tab-content" id="abas-acessos">
        <div id="acessos-gerais" class="tab-pane fade show active">
         <table class="table table-dark table-striped">
		 <thead>
             <tr>
     		<th>#</th>
    		<th>Clicks</th>
    		<th>Data/Hora</th>
    		<th style="display: none !important;">Números</th>
    		<th style="display: none !important;">Nome</th>
    		<th>IP</th>
    		<th>ISP</th>
    		<th>Cidade</th>
    		<th>Estado</th>
    		<th>País</th>
    		<th>Sistema</th>
    		<th>Dispositivo</th>
    		<th>Status</th>
               </tr>
            </thead>
            <tbody>
                <tr>
                    <th></th>
                    <td></td>
                    <td></td>
                    <td ></td>
                    <td></td>
                    <td></td>
					<td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
					<td></td>
                </tr>
            </tbody>
			</table>
        </div>
        <div id="acessos-permitidos" class="tab-pane fade">
           <table class="table table-dark table-striped">
		 <thead>
             <tr>
     		<th>#</th>
    		<th>Clicks</th>
    		<th>Data/Hora</th>
    		<th style="display: none !important;">Número</th>
    		<th style="display: none !important;">Nome</th>
    		<th>IP</th>
    		<th>ISP</th>
    		<th>Cidade</th>
    		<th>Estado</th>
    		<th>País</th>
    		<th>Sistema</th>
    		<th>Dispositivo</th>
    		<th>Status</th>
               </tr>
            </thead>
            <tbody>
                <tr>
                    <th></th>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
					<td></td>
                </tr>
            </tbody>
			</table>
        </div>
        <div id="acessos-bloqueados" class="tab-pane fade">
           <table class="table table-dark table-striped">
		 <thead>
             <tr>
     		<th>#</th>
    		<th>Clicks</th>
    		<th>Data/Hora</th>
    		<th style="display: none !important;">Número</th>
    		<th style="display: none !important;">Nome</th>
    		<th>IP</th>
    		<th>ISP</th>
    		<th>Cidade</th>
    		<th>Estado</th>
    		<th>País</th>
    		<th>Sistema</th>
    		<th>Dispositivo</th>
    		<th>Status</th>
               </tr>
            </thead>
            <tbody>
                <tr>
                    <th></th>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
					<td></td>
                </tr>
            </tbody>
			</table>
        </div>
      </div>
    </div>

  </div>
</div>



</div>
    <!-- Configurações -->
	
    <!-- Card das Configurações -->
	 <div id="configuracoes" style="display: none;">
      <h1 class="my-4">Configurações</h1>
<div class="card bg-dark text-white mt-4">
  <div class="card-header">
    <ul class="nav nav-tabs bg-dark card-header-tabs" id="configTabs">
      <li class="nav-item">
        <a class="nav-link active custom-tab"  href="#config">Configurações</a>
      </li>
      <li class="nav-item">
        <a class="nav-link custom-tab" href="#numeros-celular">Números de celular</a>
      </li>
	        <li class="nav-item">
        <a class="nav-link custom-tab" href="#emails">E-mails</a>
      </li>
      <li class="nav-item">
        <a class="nav-link custom-tab" href="#restringir-paises">Restringir Países</a>
      </li>
	   <li class="nav-item">
        <a class="nav-link custom-tab" href="#bloqueio-asns">Bloqueio de ASNs</a>
      </li>
      <li class="nav-item">
        <a class="nav-link custom-tab" href="#bloqueio-ips">Bloqueio de IPs</a>
      </li>
      <li class="nav-item">
        <a class="nav-link custom-tab" href="#bloqueio-isps">Bloqueio de ISPs</a>
      </li>
      <li class="nav-item">
        <a class="nav-link custom-tab" href="#bloqueio-hostnames">Bloqueio de Hostnames</a>
      </li>
	 <li class="nav-item">
        <a class="nav-link custom-tab" href="#bloqueio-useragents">Bloqueio de Useragents</a>
      </li>
      <li class="nav-item">
        <a class="nav-link custom-tab" href="#bloqueio-palavras">Bloqueio de Palavras</a>
      </li>
    </ul>
  </div>
  <div class="card-body">
    <!-- Conteúdo das abas -->
    <div class="tab-content">
        <div id="config" class="tab-pane fade show active">
            <div class="row">
                <!-- Cards Restrições e Bloqueios -->
                <div class="col-md-6">
                    <div class="card bg-dark text-white mb-4">
                        <div class="card-header">Restrições</div>
                        <div class="card-body">
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="restringir_paises">
                                <label class="form-check-label" for="restringir_paises">Restringir acesso por Países</label>
                            </div>
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="restringir_mobile">
                                <label class="form-check-label" for="restringir_mobile">Restringir acesso somente para dispositivos móveis</label>
                            </div>
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="restringir_numeros">
                                <label class="form-check-label" for="restringir_numeros">Restringir acesso somente para números cadastrados</label>
                            </div>
							<div class="form-group d-flex align-items-center">
							<p class="mb-0 mr-2">GET para restrição de números:</p>
							<div class="col-md-5">
								<input type="text" class="form-control bg-dark text-white mx-3" id="get_id" placeholder="Informe o GET (ex: id = ?id=numero)">
							</div>
						</div>
						
						 <div class="form-switch mb-3 mt-5">
                                <input type="checkbox" class="form-check-input" id="restringir_emails">
                                <label class="form-check-label" for="restringir_emails">Restringir acesso somente para emails cadastrados</label>
                            </div>
							<div class="form-group d-flex align-items-center">
							<p class="mb-0 mr-2">GET para restrição de emails:&nbsp;</p>
							<div class="col-md-5">
								<input type="text" class="form-control bg-dark text-white mx-3" id="get_mid" placeholder="Informe o GET (ex: id = ?id=hash)">
							</div>
						</div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card bg-dark text-white mb-4">
                        <div class="card-header">Bloqueios</div>
                        <div class="card-body">
						   <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="bloquear_asns">
                                <label class="form-check-label" for="bloquear_asn">Bloquear acesso de ASNs cadastrados</label>
                            </div>
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="bloquear_ips">
                                <label class="form-check-label" for="bloquear_ips">Bloquear acesso de IPs cadastrados</label>
                            </div>
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="bloquear_isps">
                                <label class="form-check-label" for="bloquear_isps">Bloquear acesso de ISPs cadastrados</label>
                            </div>
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="bloquear_hostnames">
                                <label class="form-check-label" for="bloquear_hostnames">Bloquear acesso de Hostnames cadastrados</label>
                            </div>
						 <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="bloquear_useragents">
                                <label class="form-check-label" for="bloquear_useragents">Bloquear acesso de Useragents cadastrados</label>
                            </div>
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="bloquear_palavras">
                                <label class="form-check-label" for="bloquear_palavras">Bloquear acesso filtrando palavras no ISP/Host</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Cards GeoIP APIs e Redirecionadores -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card bg-dark text-white mb-4">
                        <div class="card-header">GeoIP APIs</div>
                        <div class="card-body">
						         <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="maxmind_api">
                                <label class="form-check-label" for="maxmind_api">Utilizar API MaxMind</label>
                            </div>
                           <hr class="w-100">
                            <div class="form-switch mb-3">
                                <input type="checkbox" class="form-check-input" id="geoip_api">
                                <label class="form-check-label" for="geoip_api">Utilizar API ip-api.com</label>
                            </div>
                            <div class="form-group">
                                <input type="text" class="form-control bg-dark text-white" id="geoip_apikey" placeholder="API Key" disabled>
                            </div>
                           
                   
                        </div>
                    </div>
                </div>
           <div class="col-md-6">
    <div class="card bg-dark text-white mb-4">
        <div class="card-header">Opções de URL</div>
        <div class="card-body">
            <!-- Card Mobile -->
            <div class="card bg-dark text-white mb-3">
                <div class="card-header">Redirecionamento para dispositivos Mobile</div>
                <div class="card-body">
                    <div class="form-group form-switch d-flex align-items-center">
                        <input type="checkbox" class="form-check-input me-3" id="redir_mobile_url">
                        <label class="form-check-label me-2">URL:&nbsp;</label>
                        <input type="text" class="form-control bg-dark text-white flex-grow-1" id="url_mobile" placeholder="https://url.mobile">
                    </div>
					
					  <div class="form-group form-switch d-flex align-items-center">
                        <input type="checkbox" class="form-check-input me-1" id="redir_mobile_wurl">
                        <label class="form-check-label me-2">WURL:</label>
                        <input type="text" class="form-control bg-dark text-white flex-grow-1" id="wurl_mobile" placeholder="Pasta ou URL da whitepage">
                    </div>
					
                    <div class="form-group form-switch d-flex align-items-center mt-1">
                        <input type="checkbox" class="form-check-input me-2" id="redir_mobile_erro">
                        <label class="form-check-label me-2">ERRO:</label>
                        <select class="form-control bg-dark text-white flex-grow-1" id="tipo_erro_mobile">
                            <option value="404">404 - Not found</option>
                            <option value="403">403 - Forbidden</option>
                            <option value="444">444 - No Response</option>
                            <option value="500">500 - Internal Server Error</option>
                            <option value="502">502 - Bad Gateway</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Card Desktop -->
            <div class="card bg-dark text-white mb-3">
                <div class="card-header">Redirecionamento para dispositivos Desktop</div>
                <div class="card-body">
                    <div class="form-group form-switch d-flex align-items-center">
                        <input type="checkbox" class="form-check-input me-3" id="redir_desktop_url">
                        <label class="form-check-label me-2">URL:&nbsp;</label>
                        <input type="text" class="form-control bg-dark text-white flex-grow-1" id="url_desktop" placeholder="https://url.desktop">
                    </div>
					
					 <div class="form-group form-switch d-flex align-items-center">
                        <input type="checkbox" class="form-check-input me-1" id="redir_desktop_wurl">
                        <label class="form-check-label me-2">WURL:</label>
                        <input type="text" class="form-control bg-dark text-white flex-grow-1" id="wurl_desktop" placeholder="Pasta ou URL da whitepage">
                    </div>
					
                    <div class="form-group form-switch d-flex align-items-center mt-1">
                        <input type="checkbox" class="form-check-input me-2" id="redir_desktop_erro">
                        <label class="form-check-label me-2">ERRO:</label>
                        <select class="form-control bg-dark text-white flex-grow-1" id="tipo_erro_desktop">
                            <option value="404">404 - Not found</option>
                            <option value="403">403 - Forbidden</option>
                            <option value="444">444 - No Response</option>
                            <option value="500">500 - Internal Server Error</option>
                            <option value="502">502 - Bad Gateway</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Card Bloqueados -->
            <div class="card bg-dark text-white mb-3">
                <div class="card-header">Redirecionamento para dispositivos Bloqueados</div>
                <div class="card-body">
                    <div class="form-group form-switch d-flex align-items-center">
                        <input type="checkbox" class="form-check-input me-3" id="redir_bloqueados_url">
                        <label class="form-check-label me-2">URL:&nbsp;</label>
                        <input type="text" class="form-control bg-dark text-white flex-grow-1" id="url_bloqueados" placeholder="https://url.bloqueados">
                    </div>
					
					  <div class="form-group form-switch d-flex align-items-center">
                        <input type="checkbox" class="form-check-input me-1" id="redir_bloqueados_wurl">
                        <label class="form-check-label me-2">WURL:</label>
                        <input type="text" class="form-control bg-dark text-white flex-grow-1" id="wurl_bloqueados" placeholder="Pasta ou URL da whitepage">
                    </div>
					
                    <div class="form-group form-switch d-flex align-items-center mt-1" >
                        <input type="checkbox" class="form-check-input me-2" id="redir_bloqueados_erro">
                        <label class="form-check-label me-2">ERRO:</label>
                        <select class="form-control bg-dark text-white flex-grow-1" id="tipo_erro_bloqueados">
                            <option value="404">404 - Not found</option>
                            <option value="403">403 - Forbidden</option>
                            <option value="444">444 - No Response</option>
                            <option value="500">500 - Internal Server Error</option>
                            <option value="502">502 - Bad Gateway</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


				
            </div>
        </div>
	
<div id="numeros-celular" class="tab-pane fade">
  <div class="container mt-4">
    <!-- Card de Cadastro de Números -->
    <div class="card bg-dark text-white mb-4">
  <div class="card-header d-flex justify-content-between align-items-center">
        Cadastrar Números
   <input type="file" id="arqNumeros" class="form-control-file" style="display: none;">
        <button class="btn btn-primary float-end" id="importarNumeros">Importar</button>
     </div>      
	 <div class="card-body">
        <textarea id="numeros-textarea" class="form-control bg-dark text-white" rows="20" placeholder="Inserir um número por linha, utilize separadores | ; : para os itens caso necessite"></textarea>
        <div id="contadorNumeros" style="display: none;" class="text-center mt-2">
		 <div class="spinner-border text-primary" id="numSpin" style="display: none;" role="status">
				<span class="visually-hidden">Carregando...</span>
			</div>
			<span id="progressoNum" style="display: block; text-align: center;"></span>
		         <button id="cadastrarNumeros" class="btn btn-info" >Cadastrar Números</button>
				<button id="impNumeros" class="btn btn-info" >Importar Números</button>

		</div>
      </div>
    </div>
  </div>
</div>
<div id="emails" class="tab-pane fade">
  <div class="container mt-4">
    <!-- Card de Cadastro de Emails -->
    <div class="card bg-dark text-white mb-4">
  <div class="card-header d-flex justify-content-between align-items-center">
        Cadastrar Emails
   <input type="file" id="arqEmails" class="form-control-file" style="display: none;">
        <button class="btn btn-primary float-end" id="importarEmails">Importar</button>
     </div>      
	 <div class="card-body">
        <textarea id="emails-textarea" class="form-control bg-dark text-white" rows="20" placeholder="Inserir um email por linha, utilize separadores | ; : para os itens caso necessite"></textarea>
        <div id="contadorEmails" style="display: none;" class="text-center mt-2">
		 <div class="spinner-border text-primary" id="mailSpin" style="display: none;" role="status">
				<span class="visually-hidden">Carregando...</span>
			</div>
			<span id="progressoEmail" style="display: block; text-align: center;"></span>
		         <button id="cadastrarEmails" class="btn btn-info" >Cadastrar Emails</button>
				<button id="impEmails" class="btn btn-info" >Importar Emails</button>

		</div>
      </div>
    </div>
  </div>
</div>
      <div id="restringir-paises" class="tab-pane fade">
    <div class="container mt-4">
        <!-- Card de Restrição de Países -->
        <div class="card bg-dark text-white mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                Restringir Países
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="regiaoSelecionada" class="form-label">Selecione a Região:</label>
                    <select class="form-control" id="regionSelector">
					 <option value="" disabled selected>Selecione uma região</option>
                        <option value="Europa">Europa</option>
                        <option value="América do Norte">América do Norte</option>
                        <option value="América do Sul">América do Sul</option>
                        <option value="Ásia">Ásia</option>
                        <option value="África">África</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="paisSelecionado" class="form-label">Selecione o País:</label>
                    <select class="form-control" id="countrySelector">
                    </select>
                </div>
				 <div class="text-center">
					<button id="permitirPais" class="btn btn-primary text-center">Permitir País</button>
					</div>
            </div>
        </div>
    </div>
</div>
 <!-- Card`s Padrao para todas as abas de  bloqueio -->
<div id="tab-default" style="display: none;">
<div  class="container mt-4" >
    <div class="card bg-dark text-white mb-4">
  <div class="card-header d-flex justify-content-between align-items-center">
		<div class="card-header-div"></div>
        <input type="file" id="arqRec" class="form-control-file" style="display: none;">
        <button class="btn btn-primary float-end" id="importarArquivo">Importar</button>
     </div>      
	 <div class="card-body">
        <textarea id="tab-textarea" class="form-control bg-dark text-white" rows="20" placeholder=""></textarea>
        <div id="contadorTab" style="display: none;" class="text-center mt-2">
		 <div class="spinner-border text-primary" id="tabSpin" style="display: none;" role="status">
				<span class="visually-hidden">Carregando...</span>
			</div>
			<span id="progressotab" style="display: block; text-align: center;"></span>
		         <button id="bloquearTab" class="btn btn-info" ></button>
				<button id="impArquivoTab" class="btn btn-info" ></button>

		</div>
      </div>
    </div>
  </div>
</div>
     <div id="bloqueio-asns" class="tab-pane fade">
      </div>
      <div id="bloqueio-ips" class="tab-pane fade">
      </div>
      <div id="bloqueio-isps" class="tab-pane fade">
      </div>
      <div id="bloqueio-hostnames" class="tab-pane fade">
      </div>
	   <div id="bloqueio-useragents" class="tab-pane fade">
      </div>
      <div id="bloqueio-palavras" class="tab-pane fade">
      </div>
    </div>
  </div>
</div>
  </div>    
  
<!-- Numeros cadastrados -->
<div id="numsCad" style="display: none;" class="card bg-dark text-white mt-2">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div id="numHeader">Números Cadastrados</div>
        <div class="d-flex align-items-center">
            <div class="mr-2">
                <input type="text" class="form-control form-control-sm bg-dark text-white" id="buscarNum" placeholder="Buscar...">
            </div>
            <div class="d-flex">
                <button class="btn btn-danger btn-sm mx-1" id="delNumSel">Remover selecionados</button>
                <button class="btn btn-danger btn-sm mx-1" id="delAllNumb">Remover tudo</button>
            </div>
        </div>
    </div>

    <div class="card-body" id="numerosCadastrados">
        <table class="table table-dark table-striped">
            <thead>
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Número com código</th>
                    <th scope="col">Número sem código</th>
                    <th scope="col">Nome</th>
                    <th scope="col">Col4</th>
                    <th scope="col">Col5</th>
					<th scope="col">Col6</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th scope="row"><input type="checkbox"> </th>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
                </tr>
            </tbody>
			
			<div class="card-footer d-flex justify-content-end">
    <button id="btnAnterior" class="btn btn-primary mr-2" disabled>Anterior</button>
    <button id="btnProximo" class="btn btn-primary mx-1">Próximo</button>
</div>

        </table>
    </div>
</div>
  
<!-- Emails cadastrados -->
<div id="emailsCad" style="display: none;" class="card bg-dark text-white mt-2">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div id="emailsHeader">Emails Cadastrados</div>
        <div class="d-flex align-items-center">
            <div class="mr-2">
                <input type="text" class="form-control form-control-sm bg-dark text-white" id="buscarMail" placeholder="Buscar...">
            </div>
            <div class="d-flex">
                <button class="btn btn-danger btn-sm mx-1" id="delMailSel">Remover selecionados</button>
                <button class="btn btn-danger btn-sm mx-1" id="delAllMail">Remover tudo</button>
            </div>
        </div>
    </div>

    <div class="card-body" id="emailsCadastrados">
        <table class="table table-dark table-striped">
            <thead>
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col">E-mail</th>
                    <th scope="col">Hash</th>
                    <th scope="col">Nome</th>
                    <th scope="col">Col4</th>
                    <th scope="col">Col5</th>
					<th scope="col">Col6</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th scope="row"><input type="checkbox"> </th>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
					<td></td>
                </tr>
            </tbody>
			
			<div class="card-footer d-flex justify-content-end">
    <button id="btnAnterior" class="btn btn-primary mr-2" disabled>Anterior</button>
    <button id="btnProximo" class="btn btn-primary mx-1">Próximo</button>
</div>

        </table>
    </div>
</div>

<!-- Itens cadastrados -->
<div id="itensCad" style="display: none;" class="card bg-dark text-white mt-2">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div id="itensHeader"></div>
        <div class="d-flex align-items-center">
            <div class="mr-2">
                <input type="text" class="form-control form-control-sm bg-dark text-white" id="buscarItem" placeholder="Buscar...">
            </div>
            <div class="d-flex">
                <button class="btn btn-danger btn-sm mx-1" id="delItemSel">Remover selecionados</button>
                <button class="btn btn-danger btn-sm mx-1" id="delAllItens">Remover tudo</button>
            </div>
        </div>
    </div>

    <div class="card-body" id="itensCadastrados">
        <table class="table table-dark table-striped">
            <thead>
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col"></th>
    
                </tr>
            </thead>
            <tbody>
                <tr>
                    <th scope="row"><input type="checkbox"> </th>
                    <td></td>
                </tr>
            </tbody>
	
			<div class="card-footer d-flex justify-content-end">
    <button id="btnAnteriorItem" class="btn btn-primary mr-2" disabled>Anterior</button>
    <button id="btnProximoItem" class="btn btn-primary mx-1">Próximo</button>
</div>

        </table>
    </div>
</div>

  <!-- Modal -->
<div class="modal fade" id="dispModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content bg-dark text-white">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTitle"></h5>
      </div>
      <div class="modal-body" id="modalBody">
      </div>
    </div>
  </div>
</div>



<script>
function Copiar(elemento) {
            const tempInput = document.createElement('input');
            tempInput.value = elemento.textContent || elemento.innerText;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
}

$(document).ready(function() {
  
  var ultimaAba = ""; 


		
$("#menu-toggle").click(function(e) {
    e.preventDefault();
    $("body").toggleClass("sidebar-collapsed");
    $(".sidebar").toggleClass("collapsed");
    $(".content").toggleClass("content-expanded");
  });
		
function showModal(title, message, duration) {
    $('#myModal .modal-title').text(title);
    $('#myModal .modal-body').text(message);
    $('#myModal').modal('show');

    if (duration) {
        setTimeout(function() {
            $('#myModal').modal('hide');
        }, duration);
    }
}
function hideModal() {
    $('#myModal').modal('hide');
}

$(document).on('click', '.eye-icon', function() {
    var $cell = $(this).closest('td');
    var $hiddenInfo = $cell.find('.hidden-info');
    $hiddenInfo.toggle();
});


$('a[href^="#bloqueio-"]').on('click', function() {
    var nomeAba = $(this).text(); 
    //console.log(nomeAba);
	atualizarCardPadrao(nomeAba);
});

var paginasPorAba = {
        'acessos-gerais': 1,
        'acessos-permitidos': 1,
        'acessos-bloqueados': 1
    };

    var acessosOriginais; // Variável para armazenar a lista original de acessos
    var acessosPorPagina = 50; // Quantidade de acessos por página
    var acessos;
    var totalPaginasPorAba = {
        'acessos-gerais': 0,
        'acessos-permitidos': 0,
        'acessos-bloqueados': 0
    };

function listarAcessos(tipoAba) {
    var abaSemPrefixo = tipoAba.replace("acessos-", ""); // Remove o prefixo 'acessos-'
    $.ajax({
        url: 'funcoes.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'listarAcessos',
            aba: abaSemPrefixo
        },
        success: function(response) {
            if (Array.isArray(response)) {
                acessosOriginais = response;
                acessos = response; 
                totalPaginasPorAba[tipoAba] = Math.ceil(acessos.length / acessosPorPagina);
                atualizarTabelaAcessos(tipoAba);
                atualizarBotoesNavegacaoAcessos(tipoAba);
            } else {
                console.error('Dados recebidos não são uma lista válida:', response);
            }
        },
        error: function(xhr, status, error) {
            console.error('Erro ao obter acessos:', error);
        }
    });
}


     // Função para atualizar a tabela de acessos
function atualizarTabelaAcessos(tipoAba) {
    var tabela = "#" + tipoAba + ' table tbody';
    var htmlContent = '';
    if (acessos && acessos.length > 0) {  // Verifica se acessos está definido e tem conteúdo
        var paginaAtual = paginasPorAba[tipoAba];
        var startIndex = (paginaAtual - 1) * acessosPorPagina;
        var endIndex = Math.min(startIndex + acessosPorPagina, acessos.length);

        for (var i = startIndex; i < endIndex; i++) {
            var acesso = acessos[i];
            htmlContent += `<tr>
                <td><i class='fas fa-eye eye-icon'></i>&nbsp;<span class='number'>${i + 1}</span>
                    <div class='hidden-info' style='display: none;'>
                        <table class='table table-sm'>
                            <tr><th>Data/Hora</th><td onclick="Copiar(this)">${acesso.dthr}</td></tr>
                            ${acesso.numero ? `<tr><th>Número</th><td onclick="Copiar(this)">${acesso.numero}</td></tr>` : ''}
                            ${acesso.nome ? `<tr><th>Nome</th><td onclick="Copiar(this)">${acesso.nome}</td></tr>` : ''}
                            <tr><th>IP</th><td onclick="Copiar(this)">${acesso.ip}</td></tr>
                            <tr><th>ISP</th><td onclick="Copiar(this)">${acesso.isp}</td></tr>
                            <tr><th>Hostname</th><td onclick="Copiar(this)">${acesso.hostname}</td></tr>
                            <tr><th>ASN</th><td onclick="Copiar(this)">${acesso.asn}</td></tr>
                            <tr><th>Cidade</th><td onclick="Copiar(this)">${acesso.cidade}</td></tr>
                            <tr><th>Estado</th><td onclick="Copiar(this)">${acesso.estado}</td></tr>
                            <tr><th>País</th><td onclick="Copiar(this)">${acesso.pais}</td></tr>
                            <tr><th>Sistema</th><td onclick="Copiar(this)">${acesso.sistema}</td></tr>
                            <tr><th>Dispositivo</th><td onclick="Copiar(this)">${acesso.dispositivo}</td></tr>
                            <tr><th>Conexão</th><td onclick="Copiar(this)">${acesso.conexao}</td></tr>
                            <tr><th>Referer/URI</th><td onclick="Copiar(this)">${acesso.referer}</td></tr>
                            <tr><th>User Agent</th><td onclick="Copiar(this)">${acesso.useragent}</td></tr>
							<tr><th>Status</th><td onclick="Copiar(this)">${acesso.status}</td></tr>
                        </table>
                    </div>
                </td>
                <td onclick="Copiar(this)">${acesso.clicks}</td>
                <td onclick="Copiar(this)">${acesso.dthr}</td>
                <td style="display: none !important;" onclick="Copiar(this)">${acesso.numero || 'N/A'}</td>
                <td style="display: none !important;" onclick="Copiar(this)">${acesso.nome || 'N/A'}</td>
                <td onclick="Copiar(this)">${acesso.ip}</td>
                <td onclick="Copiar(this)">${acesso.isp}</td>
                <td onclick="Copiar(this)">${acesso.cidade}</td>
                <td onclick="Copiar(this)">${acesso.estado}</td>
                <td onclick="Copiar(this)">${acesso.pais}</td>
                <td onclick="Copiar(this)">${acesso.sistema}</td>
                <td onclick="Copiar(this)">${acesso.dispositivo}</td>
                <td onclick="Copiar(this)">${acesso.status}</td>
            </tr>`;
        }

        $(tabela).html(htmlContent);
        atualizarBotoesNavegacaoAcessos(tipoAba);
    } else {
        $(tabela).html('<tr><td colspan="13">Nenhum acesso encontrado.</td></tr>');
    }
}


   function atualizarBotoesNavegacaoAcessos(tipoAba) {
        var paginaAtual = paginasPorAba[tipoAba];
        var totalPaginasAcs = totalPaginasPorAba[tipoAba];
        $('#btnAnteriorAcs').prop('disabled', paginaAtual === 1);
        $('#btnProximoAcs').prop('disabled', paginaAtual >= totalPaginasAcs);
    }
	
$('#atualizar-acessos').click(function() {
    // Determina qual aba atualizar baseado na aba ativa
    var abaAtiva;

    // Verifica se o dashboard está ativo
    if ($('.nav-link[href="#dashboard"]').hasClass('active')) {
        abaAtiva = '#dashboard';
    } else {
        abaAtiva = $(".nav-tabs .nav-link.active").attr("href");
    }

    var tipoAba = abaAtiva === '#dashboard' ? 'acessos-gerais' : 'acessos-' + abaAtiva.substring(1);

    listarAcessos(tipoAba); // Atualiza a tabela para a aba apropriada
    atualizarCtdAcessos();  // Atualiza a contagem de acessos, se necessário
});



    $('#btnAnteriorAcs, #btnProximoAcs').click(function() {
        var tipoAba = $(".nav-tabs .nav-link.active").attr("href").substring(1);
        if (this.id === 'btnAnteriorAcs' && paginasPorAba[tipoAba] > 1) {
            paginasPorAba[tipoAba]--;
        } else if (this.id === 'btnProximoAcs' && paginasPorAba[tipoAba] < totalPaginasPorAba[tipoAba]) {
            paginasPorAba[tipoAba]++;
        }
        atualizarTabelaAcessos(tipoAba);
    });

$('#acessos-tabs .custom-tab').on('click', function() {
    var novaAba = $(this).attr("href").substring(1);
    //console.log('Mudando para a aba:', novaAba);
    listarAcessos(novaAba);
    paginasPorAba[novaAba] = 1; // Reseta a página ao mudar de aba
    atualizarBotoesNavegacaoAcessos(novaAba);
});

function atualizarCtdAcessos() {      
    $.ajax({
        url: 'funcoes.php', 
        type: 'POST',
        data: { action: 'atualizarCtdAcessos' }, 
        success: function(response) {
            var jsonData = JSON.parse(response);
            $('#qtdAcessosGerais').text(jsonData.Gerais);
            $('#qtdAcessosPermitidos').text(jsonData.Permitidos);
            $('#qtdAcessosBloqueados').text(jsonData.Bloqueados);
        },
        error: function(xhr, status, error) {
            console.error(error);
        }
    });
}

$("#intervalo_atualizacao").change(function() {
    var id = $(this).attr("id");
    var value = $(this).val();
    atualizarConfiguracao(id, value);
});

$("#auto_atualizar").change(function() {
    var id = $(this).attr("id");
    var value = $(this).prop("checked") ? "true" : "false";
    atualizarConfiguracao(id, value);

    if ($(this).prop("checked")) {
        var intervalo = parseInt($('#intervalo_atualizacao').val());
        console.log("Iniciando auto-atualizador com intervalo: " + intervalo);
        iniciarAutoAtualizacao(intervalo);
        $("#intervalo_atualizacao").prop("disabled", false);
    } else {
        console.log("Parando auto-atualizador");
        pararAutoAtualizador();
        $("#intervalo_atualizacao").prop("disabled", true);
    }
});

var intervaloID = null; 
var autoAtualizadorAtivo = false;

function iniciarAutoAtualizacao(intervalo) {
	 if (intervaloID) {
        console.log("Auto-Atualizador já está em execução");
        return;
    }
	
    console.log("Auto-Atualizador ligado");
    intervaloID = setInterval(function() {
        var abaAtiva;
        abaAtiva = $(".nav-tabs .nav-link.active").attr("href"); 
        //console.log(abaAtiva); 
        if (abaAtiva === '#acessos-gerais' || abaAtiva === '#acessos-permitidos' || abaAtiva === '#acessos-bloqueados') {
            var tipo = abaAtiva.substring(1);
            console.log("Atualizando tabela para: " + tipo);
            listarAcessos(tipo);
            atualizarCtdAcessos();
			autoAtualizadorAtivo = true;
        }
    }, intervalo * 1000);
}

function obterIntervalo(callback) {
    $.ajax({
        url: 'funcoes.php',	
        type: 'POST',
        dataType: 'json',
        data: { action: 'obterIntervalo' },
        success: function(response) {
            if (response && response.intervalo) {
                callback(response.intervalo);
            } else {
                console.error('Erro ao obter o intervalo:', response);
                callback(null);
            }
        },
        error: function(xhr, status, error) {
            console.error('Erro ao obter o intervalo:', error);
            callback(null);
        }
    });
}


function verificarAutoAtualizador() {
	 var autoAtualizar = false;

    $.ajax({
        url: 'funcoes.php',
        type: 'POST',
        dataType: 'json',
        data: { action: 'verificarAutoAtualizador' },
        async: false, // Modo síncrono
        success: function(response) {
            if (response && typeof response.auto_atualizar !== 'undefined') {
                autoAtualizar = response.auto_atualizar;
            } else {
                console.error('Erro ao obter o estado de auto_atualizar:', response);
            }
        },
        error: function(xhr, status, error) {
            console.error('Erro ao obter o estado de auto_atualizar:', error);
        }
    });

    return autoAtualizar;
}

function pararAutoAtualizador() {
    if (intervaloID) {
        console.log("Auto-Atualizador parado");
        clearInterval(intervaloID);
        intervaloID = null; 
		autoAtualizadorAtivo = false; 
    }
}


$('#zerar-acessos').click(function() {
    if (confirm("Tem certeza que deseja zerar os acessos?")) {
        var abaAtiva;

        // Verifica se o dashboard está ativo
        if ($('.nav-link[href="#dashboard"]').hasClass('active')) {
            abaAtiva = '#dashboard';
        } else {
            abaAtiva = $(".nav-tabs .nav-link.active").attr("href");
        }

        var tipo = abaAtiva === '#dashboard' ? 'gerais' : abaAtiva.substring(9);
        $.ajax({
            url: 'funcoes.php',
            type: 'POST',
            data: { action: 'zerarAcessos', tabela: tipo },
            success: function(response) {
                //alert(response);
                // Atualiza a tabela chamando listarAcessos novamente
                atualizarCtdAcessos();
                listarAcessos("acessos-" + tipo); // Adiciona o prefixo 'acessos-' ao tipo
            },
            error: function(xhr, status, error) {
                console.error('Erro ao zerar acessos:', error);
            }
        });
    }
});

function atualizarConfiguracao(id, value) {
    $.ajax({
      url: 'api.php',
      type: 'POST',
      dataType: 'json',
      data: {
        action: 'atualizarConfiguracoes',
        config: id,
        valor: value
      },
      success: function(response) {
        console.log('Configuração atualizada com sucesso:', response);
      },
      error: function(xhr, status, error) {
        console.error('Erro ao atualizar configuração:', error);
      }
    });
  }

  // Função para carregar as configurações do banco de dados e atualizar os elementos HTML correspondentes
var intervalo;
function carregarConfiguracoes() {
    $.ajax({
      url: 'api.php',
      type: 'POST',
      dataType: 'json',
      data: {
        action: 'carregarConfiguracoes'
      },
      success: function(response) {
        $("#restringir_paises").prop("checked", response.restringir_paises === "true");
        $("#restringir_mobile").prop("checked", response.restringir_mobile === "true");
        $("#restringir_numeros").prop("checked", response.restringir_numeros === "true");
		$("#restringir_emails").prop("checked", response.restringir_emails === "true");
		$("#bloquear_asns").prop("checked", response.bloquear_asns === "true");
        $("#bloquear_ips").prop("checked", response.bloquear_ips === "true");
        $("#bloquear_isps").prop("checked", response.bloquear_isps === "true");
        $("#bloquear_hostnames").prop("checked", response.bloquear_hostnames === "true");
        $("#bloquear_useragents").prop("checked", response.bloquear_useragents === "true");
        $("#bloquear_palavras").prop("checked", response.bloquear_palavras === "true");
        $("#geoip_api").prop("checked", response.geoip_api === "true");
        $("#geoip_apikey").val(response.geoip_apikey);
		$("#get_id").val(response.get_id);
		$("#get_mid").val(response.get_mid);
		
        $("#url_mobile").val(response.url_mobile);
		$("#wurl_mobile").val(response.wurl_mobile);
		
        $("#url_desktop").val(response.url_desktop);
		$("#wurl_desktop").val(response.wurl_desktop);
		
        $("#url_bloqueados").val(response.url_bloqueados);
	    $("#wurl_bloqueados").val(response.wurl_bloqueados);
		
		$("#tipo_erro_mobile").val(response.tipo_erro_mobile);
		$("#tipo_erro_desktop").val(response.tipo_erro_desktop);
		$("#tipo_erro_bloqueados").val(response.tipo_erro_bloqueados);

	    $("#redir_mobile_url").prop("checked", response.redir_mobile_url === "true");
		$("#redir_mobile_wurl").prop("checked", response.redir_mobile_wurl === "true");
		$("#redir_mobile_erro").prop("checked", response.redir_mobile_erro === "true");
		
		$("#url_mobile").prop("disabled", response.redir_mobile_wurl === "true" || response.redir_mobile_erro === "true");
		$("#wurl_mobile").prop("disabled", response.redir_mobile_url === "true" || response.redir_mobile_erro === "true");
		$("#tipo_erro_mobile").prop("disabled", response.redir_mobile_url === "true" || response.redir_mobile_wurl === "true");

		$("#redir_desktop_url").prop("checked", response.redir_desktop_url === "true");
		$("#redir_desktop_wurl").prop("checked", response.redir_desktop_wurl === "true");
		$("#redir_desktop_erro").prop("checked", response.redir_desktop_erro === "true");
		
		$("#url_desktop").prop("disabled", response.redir_desktop_wurl === "true" || response.redir_desktop_erro === "true");
		$("#wurl_desktop").prop("disabled", response.redir_desktop_url === "true" || response.redir_desktop_erro === "true");
		$("#tipo_erro_desktop").prop("disabled", response.redir_desktop_url === "true" || response.redir_desktop_wurl === "true");

		$("#redir_bloqueados_url").prop("checked", response.redir_bloqueados_url === "true");
		$("#redir_bloqueados_wurl").prop("checked", response.redir_bloqueados_wurl === "true");
		$("#redir_bloqueados_erro").prop("checked", response.redir_bloqueados_erro === "true");
		
		$("#url_bloqueados").prop("disabled", response.redir_bloqueados_wurl === "true" || response.redir_bloqueados_erro === "true");
		$("#wurl_bloqueados").prop("disabled", response.redir_bloqueados_url === "true" || response.redir_bloqueados_erro === "true");
		$("#tipo_erro_bloqueados").prop("disabled", response.redir_bloqueados_url === "true" || response.redir_bloqueados_wurl === "true");
		
		$("#maxmind_api").prop("checked", response.maxmind_api === "true");
        $("#geoip_apikey").prop("disabled", !$("#geoip_api").prop("checked"));
		$("#get_id").prop("disabled", !$("#restringir_numeros").prop("checked"));
		$("#get_mid").prop("disabled", !$("#restringir_emails").prop("checked"));
		$("#auto_atualizar").prop("checked", response.auto_atualizar === "true");
		$("#intervalo_atualizacao").val(response.intervalo_atualizacao);
		$("#intervalo_atualizacao").prop("disabled", !$("#auto_atualizar").prop("checked"));
		intervalo = parseInt(response.intervalo_atualizacao);
		if ($("#auto_atualizar").prop("checked")) {
			var abaAtiva = $(".nav-tabs .nav-link.active").attr("href");
			if (abaAtiva === '#acessos-gerais' || abaAtiva === '#acessos-permitidos' || abaAtiva === '#acessos-bloqueados') {
			iniciarAutoAtualizacao(intervalo);
			}
		}

      },
      error: function(xhr, status, error) {
        console.error('Erro ao carregar configurações:', error);
      }
    });
 }
  

// Função para atualizar o card padrão com base na aba selecionada
function atualizarCardPadrao(nomeAba) {
    var tabDefault = $('#tab-default'); // Selecionar o elemento com o ID 'tab-default'
    var cardHeader = tabDefault.find('.card-header-div');
    cardHeader.text(nomeAba);
    $(nomeAba).append(tabDefault.show());
}

function obterPaisesPorRegiao(regiao) {
        console.log("Chamando obterPaisesPorRegiao com região:", regiao);
        $.post('api.php', {
            action: 'obterPaisesPorRegiao',
            region: regiao
        }, function(data) {
            console.log("Resposta do servidor:", data);
            // Limpar o seletor de países
            $('#countrySelector').empty();
            // Adicionar as opções de países recebidas do servidor ao seletor
            $.each(JSON.parse(data), function(index, pais) {
                $('#countrySelector').append($('<option>', {
                    value: pais,
                    text: pais
                }));
            });
        });
    }

$('#regionSelector').change(function() {
        var region = $(this).val();
        console.log("Região selecionada:", region);
        // Chamar a função para obter os países por região
        obterPaisesPorRegiao(region);
    });
	
function cadastrarNumeros() {
    // Obter os números do textarea e dividi-los em um array
    var numeros = $("#numeros-textarea").val().split(/\r?\n/);
    $.ajax({
        url: 'api.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'adicionarNumeros', // Ação para adicionar números
            numeros: numeros // Array de números a serem adicionados
        },
        success: function(response) {
            // Callback de sucesso
            showModal("Sucesso", "Números adicionados com sucesso.", 2000);
            listarNumeros(); // Atualizar a tabela
            $("#numeros-textarea").val(''); // Limpar o textarea
        },
        error: function(xhr, status, error) {
            // Callback de erro
            console.error('Erro ao adicionar números:', error);
            // Exibir mensagem de erro no modal
            showModal("Erro", "Erro ao adicionar números.");
        }
    });
}


function enviarNumerosEmLotes(numeros, batchSize) {
    if (numeros.length <= 500) {
        // Se houver menos de 500 números, enviar todos de uma vez
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'adicionarNumeros',
                numeros: numeros
            },
            success: function(response) {
                console.log('Números adicionados com sucesso:', response);
                // Exibir mensagem de sucesso por 2 segundos
                showModal("Sucesso", "Números adicionados com sucesso.", 2000);
                // Limpar o textarea
                $('#numeros-textarea').val('');
                // Esconde o spinner
                $('#numSpin').hide();
				$('#progressoNum').hide();
                // Mostra o botão novamente
                $('#cadastrarNumeros').hide();
				$('#progressoNum').text('0%');
                // Atualizar a tabela
                listarNumeros();
            },
            error: function(xhr, status, error) {
                console.error('Erro ao adicionar números:', error);
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao adicionar números.");
                // Esconde o spinner
                $('#numSpin').hide();
				$('#progressoNum').hide();
				$('#progressoNum').text('0%');
                // Mostra o botão novamente
                $('#cadastrarNumeros').show();
            }
        });
    } else {
        // Se houver mais de 500 números, enviar por lotes
        var index = 0;

        // Mostrar a animação de carregamento
        $('#numSpin').show();

        function enviarProximoLote() {
            var lote = numeros.slice(index, index + batchSize);
            index += batchSize;

            $.ajax({
                url: 'api.php',
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'adicionarNumeros',
                    numeros: lote
                },
                success: function(response) {
                    console.log('Lote enviado com sucesso:', response);
                    // Calcular a porcentagem
                    var percentagem = Math.floor((index / numeros.length) * 100);
                    // Exibir a porcentagem
                    $('#progressoNum').text(percentagem + '%');

                    if (index < numeros.length) {
                        enviarProximoLote();
                    } else {
                        console.log('Todos os lotes foram enviados.');
                        // Ocultar a animação de carregamento
                        hideModal();
                        // Mostrar a mensagem de sucesso por 2 segundos
                        showModal("Sucesso", "Números adicionados com sucesso.", 2000);
                        // Limpar o textarea
                        $('#numeros-textarea').val('');
                        // Esconde o spinner
                        $('#numSpin').hide();
						$('#progressoNum').hide();
						$('#progressoNum').text('0%');
                        // Esconde o botão novamente
                        $('#cadastrarNumeros').hide();
                        // Atualizar a tabela
                        listarNumeros();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro ao enviar lote:', error);
                    // Ocultar a animação de carregamento
                    hideModal();
                    // Exibir mensagem de erro
                    showModal("Erro", "Erro ao adicionar números.");
                    // Esconde o spinner
                    $('#numSpin').hide();
					$('#progressoNum').hide();
					$('#progressoNum').text('0%');
                    // Mostra o botão novamente
                    $('#cadastrarNumeros').show();
                }
            });
        }

        enviarProximoLote();
    }
}

$('#arqNumeros').change(function(event) {
    var file = event.target.files[0];

    if (file) {
        var reader = new FileReader();

        // Mostra o spinner e a porcentagem
        $('#cadastrarNumeros').hide();
		$('#impNumeros').hide()
        $("#contadorNumeros").show();
        $('#numSpin').show();
        $('#progressoNum').show();

        reader.onload = function(e) {
            var dados = e.target.result;

            // Esconde o spinner e a porcentagem
            $('#numSpin').hide();
            $('#progressoNum').hide();

            // Mostra o botão cadastrarNumeros com a quantidade de números
            var linhas = dados.split("\n").filter(Boolean).length;
            var buttonText = (linhas === 1) ? 'Importar 1 número' : 'Importar ' + linhas.toLocaleString() + ' números';
            $("#impNumeros").text(buttonText).show();
        };
        reader.onprogress = function(e) {
            if (e.lengthComputable) {
                var percentLoaded = Math.round((e.loaded / e.total) * 100);
                $('#progressoNum').text(percentLoaded + '%');
			if(percentLoaded === 100) { $('#progressoNum').text('0%'); }
            }
        };
        reader.readAsText(file);
    } else {
        alert('Selecione um arquivo antes de importar.');
    }
});


// Manipulador de evento para o botão de importar
$('#importarNumeros').click(function() {
    // Simula o clique no input file para abrir a janela de seleção de arquivos
    $('#arqNumeros').click();
});

// Função para importar os números do arquivo
function importarNumeros(dados) {
    $.ajax({
        url: 'api.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'importarNumeros', // Ação para importar números
            dados: dados // Dados a serem importados
        },
        xhr: function() {
            var xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function(evt) {
                if (evt.lengthComputable) {
                    var percentLoaded = Math.round((evt.loaded / evt.total) * 100);
                    // Exibir a porcentagem no numSpin
                    $('#progressoNum').text(percentLoaded + '%');
                }
            }, false);
            return xhr;
        },
        success: function(response) {
            console.log('Números importados com sucesso:', response);
            // Exibir mensagem de sucesso
            showModal("Sucesso", "Números importados com sucesso.", 2000);
            // Esconde o spinner e a porcentagem
            $('#numSpin').hide();
            $('#progressoNum').hide();
			$('#progressoNum').text('0%');
            // Atualizar a tabela em tempo real
            listarNumeros();
        },
        error: function(xhr, status, error) {
            console.error('Erro ao importar números:', error);
            // Exibir mensagem de erro
            showModal("Erro", "Erro ao importar números.");
            // Esconde o spinner e a porcentagem em caso de erro
            $('#numSpin').hide();
            $('#progressoNum').hide();
        }
    });
	    $conexao = null;

}

$("#cadastrarNumeros").click(function() {
    // Esconde o botão e mostra o spinner
    $('#cadastrarNumeros').hide();
    $('#numSpin').show();
	$('#progressoNum').show();

    var numeros = $("#numeros-textarea").val().split(/\r?\n/);
    var batchSize = 800; // Tamanho do lote
    enviarNumerosEmLotes(numeros, batchSize);
});

// Evento de clique para o botão impNumeros
$('#impNumeros').click(function() {
    var fileInput = document.getElementById('arqNumeros');
    var file = fileInput.files[0];

    if (file) {
        var reader = new FileReader();

        // Mostrar o spinner e a porcentagem
        $('#impNumeros').hide();
        $('#progressoNum').text('0%');
        $('#numSpin').show();
        $('#progressoNum').show();

        reader.onload = function(e) {
            var dados = e.target.result;

            $.ajax({
                url: 'api.php',
                type: 'POST',
                data: {
                    action: 'importarNumeros',
                    dados: dados
                },
                success: function(response) {
                    console.log('Resposta do servidor:', response); // Adicione esta linha para monitorar as respostas no console

                    // Exibir mensagem indicando que os dados estão sendo importados
                    $('#progressoNum').text('Importando dados...');

                    // Iniciar atualização da porcentagem em tempo real
                    var progresso = 0;
                    var progressoInterval = setInterval(function() {
                        progresso += 10; // Simulando progresso (aumenta 10% a cada segundo)

                        $('#progressoNum').text(progresso + '%');

                        if (progresso >= 100) {
                            // Lidar com a conclusão da importação
                            // Esconder o spinner e a porcentagem após a conclusão
                            $('#impNumeros').hide();
                            $('#numSpin').hide();
                            $('#progressoNum').hide();
                            clearInterval(progressoInterval); // Parar a atualização da porcentagem
                            listarNumeros(); // Ou qualquer outra ação necessária após a importação
                        }
                    }, 1000); // Atualizar a cada segundo
                },
                error: function(xhr, status, error) {
                    console.error('Erro na requisição AJAX:', error);
                    // Lidar com o erro da requisição AJAX conforme necessário

                    // Esconder o spinner e a porcentagem em caso de erro
                    $('#impNumeros').hide();
                    $('#numSpin').hide();
                    $('#progressoNum').hide();
                }
            });
        };

        reader.readAsText(file);
    } else {
        alert('Selecione um arquivo antes de importar.');
    }
});

var numerosOriginais; // Variável para armazenar a lista original de números
var numerosPorPagina = 20;
var paginaAtual = 1;
var totalPaginas = 0;
var numeros;

function listarNumeros() {
    $.ajax({
        url: 'api.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'listarNumeros' // Ação para listar números
        },
        success: function(response) {
            // Salvar os números retornados na variável global
			numerosOriginais = response; // Salvar a lista original de números
            numeros = response;

            // Calcular o número total de páginas
            totalPaginas = Math.ceil(numeros.length / numerosPorPagina);

            // Atualizar a exibição da tabela
            atualizarCabecalho(numeros, 'número');

            atualizarTabela(numeros, 'número', 'numerosCadastrados');

        },
        error: function(xhr, status, error) {
            console.error('Erro ao obter números:', error);
        }
    });
}

function enviarEmailsEmLotes(emails, batchSize) {
    if (emails.length <= 500) {
        // Se houver menos de 500 emails, enviar todos de uma vez
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'adicionarEmails',
                emails: emails
            },
            success: function(response) {
                console.log('Emails adicionados com sucesso:', response);
                // Exibir mensagem de sucesso por 2 segundos
                showModal("Sucesso", "Emails adicionados com sucesso.", 2000);
                // Limpar o textarea
                $('#emails-textarea').val('');
                // Esconde o spinner
                $('#emailSpin').hide();
				$('#progressoEmail').hide();
                // Mostra o botão novamente
                $('#cadastrarEmails').hide();
				$('#progressoEmail').text('0%');
                // Atualizar a tabela
                listarEmails();
            },
            error: function(xhr, status, error) {
                console.error('Erro ao adicionar emails:', error);
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao adicionar emails.");
                // Esconde o spinner
                $('#emailSpin').hide();
				$('#progressoEmail').hide();
				$('#progressoEmail').text('0%');
                // Mostra o botão novamente
                $('#cadastrarEmails').show();
            }
        });
    } else {
        // Se houver mais de 500 emails, enviar por lotes
        var index = 0;

        // Mostrar a animação de carregamento
        $('#emailSpin').show();

        function enviarProximoLote() {
            var lote = emails.slice(index, index + batchSize);
            index += batchSize;

            $.ajax({
                url: 'api.php',
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'adicionarEmails',
                    emails: lote
                },
                success: function(response) {
                    console.log('Lote enviado com sucesso:', response);
                    // Calcular a porcentagem
                    var percentagem = Math.floor((index / emails.length) * 100);
                    // Exibir a porcentagem
                    $('#progressoEmail').text(percentagem + '%');

                    if (index < emails.length) {
                        enviarProximoLote();
                    } else {
                        console.log('Todos os lotes foram enviados.');
                        // Ocultar a animação de carregamento
                        hideModal();
                        // Mostrar a mensagem de sucesso por 2 segundos
                        showModal("Sucesso", "Emails adicionados com sucesso.", 2000);
                        // Limpar o textarea
                        $('#emails-textarea').val('');
                        // Esconde o spinner
                        $('#emailSpin').hide();
						$('#progressoEmail').hide();
						$('#progressoEmail').text('0%');
                        // Esconde o botão novamente
                        $('#cadastrarEmails').hide();
                        // Atualizar a tabela
                        listarEmails();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro ao enviar lote:', error);
                    // Ocultar a animação de carregamento
                    hideModal();
                    // Exibir mensagem de erro
                    showModal("Erro", "Erro ao adicionar emails.");
                    // Esconde o spinner
                    $('#emailSpin').hide();
					$('#progressoEmail').hide();
					$('#progressoEmail').text('0%');
                    // Mostra o botão novamente
                    $('#cadastrarEmails').show();
                }
            });
        }

        enviarProximoLote();
    }
}


var emailsOriginais; // Variável para armazenar a lista original de números
var emailsPorPagina = 20;
var emails;

function listarEmails() {
    $.ajax({
        url: 'api.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'listarEmails' // Ação para listar emails
        },
        success: function(response) {
            // Salvar os emails retornados na variável global
			emailsOriginais = response; // Salvar a lista original de emails
            emails = response;

            // Calcular o número total de páginas
            totalPaginas = Math.ceil(emails.length / emailsPorPagina);

            // Atualizar a exibição da tabela
            atualizarCabecalho(emails, 'email');
            atualizarTabela(emails, 'email', 'emailsCadastrados');
        },
        error: function(xhr, status, error) {
            console.error('Erro ao obter emails:', error);
        }
    });
}

$('#arqEmails').change(function(event) {
    var file = event.target.files[0];

    if (file) {
        var reader = new FileReader();

        // Mostrar o spinner e a porcentagem
        $('#cadastrarEmails').hide();
		$('#impEmails').hide();
        $("#contadorEmails").show();
        $('#emailSpin').show();
        $('#progressoEmail').show();

        reader.onload = function(e) {
            var dados = e.target.result;

            // Esconder o spinner e a porcentagem
            $('#emailSpin').hide();
            $('#progressoEmail').hide();

            // Mostra o botão cadastrarEmails com a quantidade de emails
            var linhas = dados.split("\n").filter(Boolean).length;
            var buttonText = (linhas === 1) ? 'Importar 1 email' : 'Importar ' + linhas.toLocaleString() + ' emails';
            $("#impEmails").text(buttonText).show();
        };

        reader.onprogress = function(e) {
            if (e.lengthComputable) {
                var percentLoaded = Math.round((e.loaded / e.total) * 100);
                $('#progressoEmail').text(percentLoaded + '%');
			    if (percentLoaded === 100) { $('#progressoEmail').text('0%'); }
            }
        };

        reader.readAsText(file);
    } else {
        alert('Selecione um arquivo antes de importar.');
    }
});

$('#impEmails').click(function() {
    var fileInput = document.getElementById('arqEmails');
    var file = fileInput.files[0];

    if (file) {
        var reader = new FileReader();

        // Mostrar o spinner e a porcentagem
        $('#impEmails').hide();
        $('#progressoEmail').text('0%');
        $('#emailSpin').show();
        $('#progressoEmail').show();

        reader.onload = function(e) {
            var dados = e.target.result;

            $.ajax({
                url: 'api.php',
                type: 'POST',
                data: {
                    action: 'importarEmails',
                    dados: dados
                },
                success: function(response) {
                    console.log('Resposta do servidor:', response);

                    // Exibir mensagem indicando que os dados estão sendo importados
                    $('#progressoEmail').text('Importando dados...');

                    // Iniciar atualização da porcentagem em tempo real
                    var progresso = 0;
                    var progressoInterval = setInterval(function() {
                        progresso += 10; // Simulando progresso (aumenta 10% a cada segundo)

                        $('#progressoEmail').text(progresso + '%');

                        if (progresso >= 100) {
                            // Lidar com a conclusão da importação
                            // Esconder o spinner e a porcentagem após a conclusão
                            $('#impEmails').hide();
                            $('#emailSpin').hide();
                            $('#progressoEmail').hide();
                            clearInterval(progressoInterval); // Parar a atualização da porcentagem
                            listarEmails(); // Atualizar a tabela de emails
                        }
                    }, 1000); // Atualizar a cada segundo
                },
                error: function(xhr, status, error) {
                    console.error('Erro na requisição AJAX:', error);

                    // Esconder o spinner e a porcentagem em caso de erro
                    $('#impEmails').hide();
                    $('#emailSpin').hide();
                    $('#progressoEmail').hide();
                }
            });
        };

        reader.readAsText(file);
    } else {
        alert('Selecione um arquivo antes de importar.');
    }
});

$("#cadastrarEmails").click(function() {
    // Esconde o botão e mostra o spinner
    $('#cadastrarEmails').hide();
    $('#emailSpin').show();
	$('#progressoEmail').show();

    var emails = $("#emails-textarea").val().split(/\r?\n/); // Dividir os emails por linha
    var batchSize = 800; // Tamanho do lote
    enviarEmailsEmLotes(emails, batchSize);
});


function atualizarTabela(lista, tipo, idTabela) {
    // Limpar o conteúdo da tabela
    $(`#${idTabela} tbody`).empty();

    // Calcular o índice inicial e final dos itens a serem exibidos na página atual
    var itensPorPagina = tipo === 'número' ? numerosPorPagina : emailsPorPagina;
    var startIndex = (paginaAtual - 1) * itensPorPagina;
    var endIndex = Math.min(startIndex + itensPorPagina, lista.length);

    // Adicionar os itens correspondentes à página atual à tabela
    for (var i = startIndex; i < endIndex; i++) {
        var item = lista[i];

        if (tipo === 'número') {
            // Inserir os números na tabela
            $(`#${idTabela} tbody`).append(`
                <tr>
                    <th scope="row"><input type="checkbox" class="numCheckbox" value="${item.id}">&nbsp;${item.id}</th>
                    <td>${item.numero_comcod}</td>
                    <td>${item.numero_semcod}</td>
                    <td>${item.nome}</td>
                    <td>${item.col4}</td>
                    <td>${item.col5}</td>
                    <td>${item.col6}</td>
                </tr>
            `);
        } else if (tipo === 'email') {
            // Inserir os emails na tabela
            $(`#${idTabela} tbody`).append(`
                <tr>
                    <th scope="row"><input type="checkbox" class="emailCheckbox" value="${item.id}">&nbsp;${item.id}</th>
                    <td>${item.email}</td>
                    <td>${item.hash}</td>
                    <td>${item.nome}</td>
                    <td>${item.col4}</td>
                    <td>${item.col5}</td>
                    <td>${item.col6}</td>
                </tr>
            `);
        }
    }

    // Atualizar os botões de navegação
    tipoAtualizacao = 'busca';
    atualizarBotoesNavegacao(tipo);
}


function atualizarTabela_old() {
    // Limpar o conteúdo da tabela
    $('#numerosCadastrados tbody').empty();

    // Calcular o índice inicial e final dos números a serem exibidos na página atual
    var startIndex = (paginaAtual - 1) * numerosPorPagina;
    var endIndex = Math.min(startIndex + numerosPorPagina, numeros.length);

    // Adicionar os números à tabela
    for (var i = startIndex; i < endIndex; i++) {
        var numero = numeros[i];
        $('#numerosCadastrados tbody').append(`
            <tr>
                <th scope="row"><input type="checkbox" class="numCheckbox" value="${numero.id}">&nbsp;${numero.id}</th>
                <td onclick="Copiar(this)">${numero.numero_comcod}</td>
                <td onclick="Copiar(this)">${numero.numero_semcod}</td>
                <td onclick="Copiar(this)">${numero.nome}</td>
                <td onclick="Copiar(this)">${numero.col4}</td>
                <td onclick="Copiar(this)">${numero.col5}</td>
                <td onclick="Copiar(this)">${numero.col6}</td>
            </tr>
        `);
    }

    // Atualizar os botões de navegação
    atualizarBotoesNavegacao();
}
function atualizarCabecalho(lista, tipo) {
    var quantidade = lista.length;
    var headerText = '';

    // Definir o texto conforme a quantidade e o tipo (numeros ou emails)
    if (quantidade === 0) {
        headerText = 'Nenhum ' + tipo + ' cadastrado';
    } else if (quantidade === 1) {
        headerText = '1 ' + tipo + ' cadastrado';
    } else {
        headerText = quantidade + ' ' + tipo + 's cadastrados';
    }

    // Verificar o tipo para atualizar o cabeçalho correto
    if (tipo === 'número') {
        $('#numHeader').text(headerText);  // Atualiza o cabeçalho dos números
    } else if (tipo === 'email') {
        $('#emailsHeader').text(headerText);  // Atualiza o cabeçalho dos emails
    }
}


var tipoAtualizacao = ''; // Variável para armazenar o tipo de atualização (busca ou página)

function atualizarBotoesNavegacao(tipo) {
    var totalPaginasAtuais = tipo === 'número' ? Math.ceil(numeros.length / numerosPorPagina) : Math.ceil(emails.length / emailsPorPagina);

    // Verificar se é busca de números ou de emails
    if (tipoAtualizacao === 'buscaNum') {
        console.log("Botões atualizados para busca de números");
        $('#btnAnterior').prop('disabled', paginaAtual === 1);
        $('#btnProximo').prop('disabled', paginaAtual === totalPaginas);
    } else if (tipoAtualizacao === 'buscaMail') {
        console.log("Botões atualizados para busca de emails");
        $('#btnAnterior').prop('disabled', paginaAtual === 1);
        $('#btnProximo').prop('disabled', paginaAtual === totalPaginas);
    } else {
        // Modo normal (sem busca)
        console.log("Botões atualizados para modo normal - Tipo: " + tipo);
        $('#btnAnterior').prop('disabled', paginaAtual === 1);
        $('#btnProximo').prop('disabled', paginaAtual === totalPaginasAtuais);
    }
}

$('#btnAnterior').click(function() {
    if (paginaAtual > 1) {
        paginaAtual--;
        if (tipoAtualizacao === 'buscaNum') {
            atualizarTabela(numeros, 'número', 'numerosCadastrados'); // Atualiza a tabela de números
        } else if (tipoAtualizacao === 'buscaMail') {
            atualizarTabela(emails, 'email', 'emailsCadastrados'); // Atualiza a tabela de emails
        } else {
            if (tipo === 'número') {
                atualizarTabela(numeros, 'número', 'numerosCadastrados'); // Atualiza a tabela de números
            } else if (tipo === 'email') {
                atualizarTabela(emails, 'email', 'emailsCadastrados'); // Atualiza a tabela de emails
            }
        }
    }
});

$('#btnProximo').click(function() {
    if (paginaAtual < totalPaginas) {
        paginaAtual++;
        if (tipoAtualizacao === 'buscaNum') {
            atualizarTabela(numeros, 'número', 'numerosCadastrados'); // Atualiza a tabela de números
        } else if (tipoAtualizacao === 'buscaMail') {
            atualizarTabela(emails, 'email', 'emailsCadastrados'); // Atualiza a tabela de emails
        } else {
            if (tipo === 'número') {
                atualizarTabela(numeros, 'número', 'numerosCadastrados'); // Atualiza a tabela de números
            } else if (tipo === 'email') {
                atualizarTabela(emails, 'email', 'emailsCadastrados'); // Atualiza a tabela de emails
            }
        }
    }
});


function atualizarBotoesNavegacao_old() {
    // Se for uma busca, verifique se estamos na primeira página ou última página
    if (tipoAtualizacao === 'busca') {
        console.log("botoes atualizados para modo busca");
        $('#btnAnterior').prop('disabled', paginaAtual === 1);
        $('#btnProximo').prop('disabled', paginaAtual === totalPaginas);
    } else { // Se não for uma busca, verifique se estamos na primeira página ou última página dos resultados originais
        console.log("botoes atualizados para modo normal");
        $('#btnAnterior').prop('disabled', paginaAtual === 1);
        $('#btnProximo').prop('disabled', paginaAtual === Math.ceil(numeros.length / numerosPorPagina));
    }
}

$('#btnAnterior_old').click(function() {
    if (paginaAtual > 1) {
        paginaAtual--;
        if (tipoAtualizacao === 'busca') {
            atualizarTabelaNumeros();
        } else {
            atualizarTabela();
        }
    }
});

$('#btnProximo_old').click(function() {
    if (paginaAtual < totalPaginas) {
        paginaAtual++;
        if (tipoAtualizacao === 'busca') {
            atualizarTabelaNumeros();
            console.log("atualizar tabela numeros foi chamado no proximo");
        } else {
            atualizarTabela();
            console.log("atualizar tabela foi chamado no proximo");
        }
    }
});

$('#buscarNum').on('input', function() {
    var termoBusca = $(this).val().trim();

    if (termoBusca !== '') {
        tipoAtualizacao = 'buscaNum';
        // Envie uma solicitação AJAX para buscar os números correspondentes ao termo de busca
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'buscarNumeros',
                termoBusca: termoBusca
            },
            success: function(response) {
                if (response.success) {
                    // Atualize a tabela com os números retornados
                    numeros = response.numeros;
                    atualizarTabela(numeros, 'número', 'numerosCadastrados');
                    console.log("Busca de números concluída. Total de resultados: " + numeros.length);
                } else {
                    console.error('Erro ao buscar números:', response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error('Erro ao buscar números:', error);
            }
        });
    } else {
        tipoAtualizacao = ''; // Limpa o tipo de atualização se o termo de busca estiver vazio
        paginaAtual = 1; 
        numeros = numerosOriginais; // Restaura a lista original de números
        atualizarTabela(numeros, 'número', 'numerosCadastrados'); // Atualiza a tabela normalmente
        console.log("Tabela de números atualizada com a lista original");
    }
});

$('#buscarMail').on('input', function() {
    var termoBusca = $(this).val().trim();

    if (termoBusca !== '') {
        tipoAtualizacao = 'buscaMail';
        // Envie uma solicitação AJAX para buscar os emails correspondentes ao termo de busca
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'buscarEmails',
                termoBusca: termoBusca
            },
            success: function(response) {
                if (response.success) {
                    // Atualize a tabela com os emails retornados
                    emails = response.emails;
                    atualizarTabela(emails, 'email', 'emailsCadastrados');
                    console.log("Busca de emails concluída. Total de resultados: " + emails.length);
                } else {
                    console.error('Erro ao buscar emails:', response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error('Erro ao buscar emails:', error);
            }
        });
    } else {
        tipoAtualizacao = ''; // Limpa o tipo de atualização se o termo de busca estiver vazio
        paginaAtual = 1; 
        emails = emailsOriginais; // Restaura a lista original de emails
        atualizarTabela(emails, 'email', 'emailsCadastrados'); // Atualiza a tabela normalmente
        console.log("Tabela de emails atualizada com a lista original");
    }
});


function atualizarTabelaNumeros() {
    // Limpar o conteúdo da tabela
    $('#numerosCadastrados tbody').empty();

    // Calcular o índice inicial e final dos números a serem exibidos na página atual
    var startIndex = (paginaAtual - 1) * numerosPorPagina;
    var endIndex = Math.min(startIndex + numerosPorPagina, numeros.length);

    // Adicionar os números correspondentes à página atual à tabela
    for (var i = startIndex; i < endIndex; i++) {
        var numero = numeros[i];
        $('#numerosCadastrados tbody').append(`
            <tr>
                <th scope="row"><input type="checkbox" class="numCheckbox" value="${numero.id}">&nbsp;${numero.id}</th>
                <td>${numero.numero_comcod}</td>
                <td>${numero.numero_semcod}</td>
                <td>${numero.nome}</td>
                <td>${numero.col4}</td>
                <td>${numero.col5}</td>
                <td>${numero.col6}</td>
            </tr>
        `);
    }

    // Atualizar os botões de navegação
    tipoAtualizacao = 'busca';
    atualizarBotoesNavegacao();
}

function removerMailSelecionados() {
    var idsSelecionados = [];

    // Iterar sobre todos os checkboxes
    $('#emailsCadastrados tbody input[type="checkbox"]').each(function() {
        // Verificar se o checkbox está marcado
        if ($(this).prop('checked')) {
            // Adicionar o valor (ID) do checkbox à lista de IDs selecionados
            idsSelecionados.push($(this).val());
        }
    });

    // Verificar se há itens selecionados
    if (idsSelecionados.length > 0) {
        // Enviar os IDs selecionados para o servidor para remoção
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'removerMailSelecionados',
                ids: idsSelecionados
            },
            success: function(response) {
                // Atualizar a tabela após a remoção dos itens
                listarEmails();
                // Exibir mensagem de sucesso
                showModal("Sucesso", "Itens selecionados removidos com sucesso.");
            },
            error: function(xhr, status, error) {
                console.error('Erro ao remover itens selecionados:', error);
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao remover itens selecionados.");
            }
        });
    } else {
        // Se nenhum item estiver selecionado, exibir uma mensagem de aviso
        showModal("ERRO", "Nenhum item selecionado.");
    }
}
function removerNumSelecionados() {
    var idsSelecionados = [];

    // Iterar sobre todos os checkboxes
    $('#numerosCadastrados tbody input[type="checkbox"]').each(function() {
        // Verificar se o checkbox está marcado
        if ($(this).prop('checked')) {
            // Adicionar o valor (ID) do checkbox à lista de IDs selecionados
            idsSelecionados.push($(this).val());
        }
    });

    // Verificar se há itens selecionados
    if (idsSelecionados.length > 0) {
        // Enviar os IDs selecionados para o servidor para remoção
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'removerNumSelecionados',
                ids: idsSelecionados
            },
            success: function(response) {
                // Atualizar a tabela após a remoção dos itens
                listarNumeros();
                // Exibir mensagem de sucesso
                showModal("Sucesso", "Itens selecionados removidos com sucesso.");
            },
            error: function(xhr, status, error) {
                console.error('Erro ao remover itens selecionados:', error);
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao remover itens selecionados.");
            }
        });
    } else {
        // Se nenhum item estiver selecionado, exibir uma mensagem de aviso
        showModal("ERRO", "Nenhum item selecionado.");
    }
}

function removerTodosOsNumeros() {
    // Exibir um prompt de confirmação
    var confirmacao = confirm("Tem certeza que deseja remover todos os números? Esta ação não pode ser desfeita.");

    // Se o usuário confirmar a remoção
    if (confirmacao) {
        // Mostrar o spinner e a porcentagem
		
        $('#progressoNum').text('0%');
		$('#cadastrarNumeros').hide();
	    $('#impNumeros').hide();
		$('#contadorNumeros').show();			
        $('#numSpin').show();
        $('#progressoNum').show();

        // Enviar uma solicitação para o servidor para remover todos os números
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'removerTodosOsNumeros'
            },
            success: function(response) {
                // Atualizar a tabela após a remoção de todos os itens
                listarNumeros();

                // Esconder o spinner e a porcentagem após a conclusão
		
				$('#contadorNumeros').hide();
				
                // Exibir mensagem de sucesso
                showModal("Sucesso", "Todos os números foram removidos com sucesso.");
            },
            error: function(xhr, status, error) {
                console.error('Erro ao remover todos os números:', error);
                // Esconder o spinner e a porcentagem em caso de erro
               $('#contadorNumeros').hide();
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao remover todos os números.");
            }
        });
    }
}
function removerTodosOsMails() {
    // Exibir um prompt de confirmação
    var confirmacao = confirm("Tem certeza que deseja remover todos os emails? Esta ação não pode ser desfeita.");

    // Se o usuário confirmar a remoção
    if (confirmacao) {
        // Mostrar o spinner e a porcentagem
		
        $('#progressoNum').text('0%');
		$('#cadastrarEmails, #impEmails').hide();
		$('#contadorEmails, #mailSpin, #progressoEmail').show();			

        // Enviar uma solicitação para o servidor para remover todos os números
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'removerTodosOsMails'
            },
            success: function(response) {
                // Atualizar a tabela após a remoção de todos os itens
                listarEmails();

                // Esconder o spinner e a porcentagem após a conclusão
		
				$('#contadorEmails').hide();
				
                // Exibir mensagem de sucesso
                showModal("Sucesso", "Todos os emails foram removidos com sucesso.");
            },
            error: function(xhr, status, error) {
                console.error('Erro ao remover todos os números:', error);
                // Esconder o spinner e a porcentagem em caso de erro
               $('#contadorEmails').hide();
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao remover todos os números.");
            }
        });
    }
}

$("#delNumSel").click(function() {  removerNumSelecionados(); });
$("#delAllNumb").click(function() { removerTodosOsNumeros(); });
$("#delMailSel").click(function() {  removerMailSelecionados(); });
$("#delAllMail").click(function() { removerTodosOsMails(); });

function adicionarItensEmLotes(itens, batchSize, tabela, coluna) {
    if (itens.length <= batchSize) {
        // Se houver menos de batchSize itens, enviar todos de uma vez
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'adicionarItem',
                tabela: tabela,
                coluna: coluna,
                itens: itens
            },
            success: function(response) {
                console.log('Itens adicionados com sucesso:', response);
                // Exibir mensagem de sucesso por 2 segundos
		
                showModal("Sucesso", "Itens adicionados com sucesso.", 2000);
                // Limpar o textarea
                $('#tab-textarea').val('');
                // Esconder o spinner
				$('#progressotab').hide();
				$('#progressotab').text('0%');
                $('#tabSpin').hide();
                // Mostrar o botão novamente
                $('#bloquearTab').hide();
                // Listar os itens após adicionar
                listarItens(tabela, coluna);
            },
            error: function(xhr, status, error) {
                console.error('Erro ao adicionar itens:', error);
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao adicionar itens.");
                // Esconder o spinner
				$('#progressotab').hide();
				$('#progressotab').text('0%');
                $('#tabSpin').hide();
                // Mostrar o botão novamente
                $('#bloquearTab').show();
            }
        });
    } else {
        // Se houver mais de batchSize itens, enviar por lotes
        var index = 0;

        // Mostrar a animação de carregamento
        $('#tabSpin').show();

        function enviarProximoLote() {
            var lote = itens.slice(index, index + batchSize);
            index += batchSize;

            $.ajax({
                url: 'api.php',
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'adicionarItem',
                    tabela: tabela,
                    coluna: coluna,
                    itens: lote
                },
                success: function(response) {
                    console.log('Lote enviado com sucesso:', response);
                    // Calcular a porcentagem
                    var percentagem = Math.floor((index / itens.length) * 100);
                    // Exibir a porcentagem
                    $('#progressotab').text(percentagem + '%');

                    if (index < itens.length) {
                        enviarProximoLote();
                    } else {
                        console.log('Todos os lotes foram enviados.');
                        // Ocultar a animação de carregamento
                        hideModal();
                        // Mostrar a mensagem de sucesso por 2 segundos
			
                        showModal("Sucesso", "Itens adicionados com sucesso.", 2000);
                        // Limpar o textarea
                        $('#tab-textarea').val('');
                        // Esconder o spinner
						$('#progressotab').hide();
						$('#progressotab').text('0%');
                        $('#tabSpin').hide();
                        // Esconder o botão novamente
                        $('#bloquearTab').hide();
                        // Listar os itens após adicionar
                        listarItens(tabela, coluna);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erro ao enviar lote:', error);
                    // Ocultar a animação de carregamento
                    hideModal();
                    // Exibir mensagem de erro
                    showModal("Erro", "Erro ao adicionar itens.");
                    // Esconder o spinner
                    $('#tabSpin').hide();
					$('#progressotab').hide();
					$('#progressotab').text('0%');
                    // Mostrar o botão novamente
                    $('#bloquearTab').show();
                }
            });
        }

        enviarProximoLote();
    }
}


$("#permitirPais").click(function() {
        var pais = $("#countrySelector").val();
        
        // Verificar se foi selecionado um país
        if (pais) {
            $.ajax({
                url: 'api.php',
                type: 'POST',
                data: {
                    action: 'adicionarItem',
                    tabela: 'paises_permitidos',
                    coluna: 'pais', 
                    itens: [pais]
                },
                dataType: 'json',
                success: function(response) {
                    // Verificar se a operação foi bem-sucedida
                    if (response.success) {
                        listarItens('paises_permitidos', 'pais');
                        console.log('País adicionado com sucesso.');
                    } else {
                        // A operação não foi bem-sucedida, exibir uma mensagem de erro ou realizar outras ações conforme necessário
                        console.error('Erro ao adicionar país.');
                    }
                },
                error: function(xhr, status, error) {
                    // Em caso de erro na requisição AJAX, exibir uma mensagem de erro ou realizar outras ações conforme necessário
                    console.error('Erro na requisição AJAX:', error);
                }
            });
        } else {
            // Se nenhum país foi selecionado, exibir uma mensagem de erro ou realizar outras ações conforme necessário
            console.error('Nenhum país selecionado.');
        }
    });
	
$("#bloquearTab").click(function() {
    // Esconder o botão e mostrar o spinner
    $('#bloquearTab').hide();
    $('#tabSpin').show();
    $('#progressotab').show();

    var itens = $("#tab-textarea").val().split(/\r?\n/);
    var batchSize = 800; // Tamanho do lote
    var target = $('.nav-tabs .active').attr('href');
    var tabela = '';
    var coluna = '';
    
    // Detectar qual aba está ativa e definir a tabela e a coluna correspondente
    switch (target) {
        case '#restringir-paises':
            tabela = 'paises_permitidos';
            coluna = 'pais';
            break;
		case '#bloqueio-asns':
            tabela = 'asns_bloqueados';
            coluna = 'asn';
            break;
        case '#bloqueio-ips':
            tabela = 'ips_bloqueados';
            coluna = 'ip';
            break;
        case '#bloqueio-isps':
            tabela = 'isps_bloqueados';
            coluna = 'isp';
            break;
        case '#bloqueio-hostnames':
            tabela = 'hostnames_bloqueados';
            coluna = 'hostname';
            break;
        case '#bloqueio-useragents':
            tabela = 'useragents_bloqueados';
            coluna = 'useragent';
            break;
        case '#bloqueio-palavras':
            tabela = 'palavras_bloqueadas';
            coluna = 'palavra';
            break;
        // Adicione mais casos conforme necessário
    }

    adicionarItensEmLotes(itens, batchSize, tabela, coluna);
});

function listarItens(tabela, coluna) {
    $.ajax({
        url: 'api.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'listarItens', // Ação para listar itens
            tabela: tabela, // Nome da tabela
            coluna: coluna // Nome da coluna
        },
        success: function(response) {
            if (response.success) {
                // Salvar os itens retornados na variável global
                itens = response.itens;

                // Atualizar a exibição da tabela e do cabeçalho
                atualizarCabecalhoItens(itens.length, tabela, coluna);
                atualizarTabelaItens(coluna);
            } else {
                console.error('Erro ao obter itens:', response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Erro ao obter itens:', error);
        }
    });
}

var itensPorPagina = 20;
var paginaAtualItens = 1;
var totalPaginasItens = 0;

function atualizarTabelaItens(coluna) {
    // Limpar o conteúdo da tabela
    $('#itensCadastrados thead').empty();
    $('#itensCadastrados tbody').empty();

    // Definir o texto do cabeçalho com base na coluna
    var cabecalhoTexto;
    if (coluna === 'pais') {
        cabecalhoTexto = 'Pais';
    } else if (coluna === 'asn') {
        cabecalhoTexto = 'ASN';
    } else if (coluna === 'ip') {
        cabecalhoTexto = 'IP';
    } else if (coluna === 'isp') {
        cabecalhoTexto = 'ISP';
    } else if (coluna === 'hostname') {
        cabecalhoTexto = 'Hostname';
    } else if (coluna === 'useragent') {
        cabecalhoTexto = 'Useragent';
    } else if (coluna === 'palavra') {
        cabecalhoTexto = 'Palavra';
    }	
    // Adicionar os cabeçalhos à tabela
    $('#itensCadastrados thead').append(`
        <tr>
            <th scope="col">ID</th>
            <th scope="col">${cabecalhoTexto}</th> <!-- Usar o nome da coluna dinamicamente -->
        </tr>
    `);

    // Calcular o índice inicial e final dos itens a serem exibidos na página atual
    var startIndex = (paginaAtualItens - 1) * itensPorPagina;
    var endIndex = Math.min(startIndex + itensPorPagina, itens.length);

    // Adicionar os itens à tabela
    for (var i = startIndex; i < endIndex; i++) {
        var item = itens[i];
        $('#itensCadastrados tbody').append(`
            <tr>
                <th scope="row"><input type="checkbox" class="itemCheckbox" value="${item.id}">&nbsp;${item.id}</th>
                <td onclick="Copiar(this)">${item[coluna]}</td> <!-- Usar o nome da coluna dinamicamente -->
            </tr>
        `);
    }

    // Calcular o número total de páginas
    totalPaginasItens = Math.ceil(itens.length / itensPorPagina);

    // Atualizar os botões de navegação
    atualizarBotoesNavegacaoItens();
}

function atualizarCabecalhoItens(quantidadeItens, tipoItem, coluna) {
    var headerText = '';

    // Determinar o cabeçalho com base no tipo de item e na coluna
    if (tipoItem === 'paises_permitidos' && coluna === 'pais') {
        headerText = (quantidadeItens === 0) ? 'Nenhum Pais cadastrado' : (quantidadeItens === 1) ? '1 Pais cadastrado' : quantidadeItens + ' Paises cadastrados';
    } 
	 else if (tipoItem === 'asns_bloqueados' && coluna === 'asn') {
        headerText = (quantidadeItens === 0) ? 'Nenhum ASN cadastrado' : (quantidadeItens === 1) ? '1 ASN cadastrado' : quantidadeItens + ' ASN`s cadastrados';
    } else if (tipoItem === 'ips_bloqueados' && coluna === 'ip') {
        headerText = (quantidadeItens === 0) ? 'Nenhum IP cadastrado' : (quantidadeItens === 1) ? '1 IP cadastrado' : quantidadeItens + ' IP`s cadastrados';
    } else if (tipoItem === 'isps_bloqueados' && coluna === 'isp') {
        headerText = (quantidadeItens === 0) ? 'Nenhum ISP cadastrado' : (quantidadeItens === 1) ? '1 ISP cadastrado' : quantidadeItens + ' ISP`s cadastrados';
    } else if (tipoItem === 'hostnames_bloqueados' && coluna === 'hostname') {
        headerText = (quantidadeItens === 0) ? 'Nenhum Hostname cadastrado' : (quantidadeItens === 1) ? '1 Hostname cadastrado' : quantidadeItens + ' Hostnames cadastrados';
    } else if (tipoItem === 'useragents_bloqueados' && coluna === 'useragent') {
        headerText = (quantidadeItens === 0) ? 'Nenhum Useragent cadastrado' : (quantidadeItens === 1) ? '1 Useragent cadastrado' : quantidadeItens + ' Useragents cadastrados';
    } else if (tipoItem === 'palavras_bloqueadas' && coluna === 'palavra') {
        headerText = (quantidadeItens === 0) ? 'Nenhum Palavra cadastrada' : (quantidadeItens === 1) ? '1 Palavra cadastrada' : quantidadeItens + ' Palavras cadastradas';
    }
	else {
        headerText = (quantidadeItens === 0) ? 'Nenhum Item cadastrado' : (quantidadeItens === 1) ? '1 Item cadastrado' : quantidadeItens + ' Itens cadastrados';
    }

    // Definir o cabeçalho na tabela
    $('#itensHeader').text(headerText);
}

function atualizarBotoesNavegacaoItens() {
    // Atualizar a visibilidade dos botões de acordo com a página atual
    $('#btnAnteriorItem').prop('disabled', paginaAtualItens === 1);
    $('#btnProximoItem').prop('disabled', paginaAtualItens === totalPaginasItens);
}

$('#btnAnteriorItem').click(function() {
    if (paginaAtualItens > 1) {
        paginaAtualItens--;
		
		var target = $('.nav-tabs .active').attr('href');
		var tipoTabela, coluna; // Declare as variáveis aqui para evitar problemas de escopo
		
		switch (target) {
            case '#restringir-paises':
                tipoTabela = 'paises_permitidos';
                coluna = 'pais'; // Nome da coluna correspondente
                break;
		case '#bloqueio-asns':
            tipoTabela = 'asns_bloqueados';
            coluna = 'asn'; // Nome da coluna correspondente
            break;
		case '#bloqueio-ips':
            tipoTabela = 'ips_bloqueados';
            coluna = 'ip'; // Nome da coluna correspondente
            break;
      	case '#bloqueio-isps':
            tipoTabela = 'isps_bloqueados';
            coluna = 'isp';
            break;
		case '#bloqueio-hostnames':
            tipoTabela = 'hostnames_bloqueados';
            coluna = 'hostname';
            break;
		case '#bloqueio-useragents':
            tipoTabela = 'useragents_bloqueados';
            coluna = 'useragent';
            break;
		case '#bloqueio-palavras':
            tipoTabela = 'palavras_bloqueadas';
            coluna = 'palavra';
            break;
            // Adicione mais casos conforme necessário para outras abas
        }
		
        // Chame a função atualizarTabelaItens dentro do switch
        atualizarTabelaItens(coluna);
    }
});

$('#btnProximoItem').click(function() {
    if (paginaAtualItens < totalPaginasItens) {
        paginaAtualItens++;
		
		var target = $('.nav-tabs .active').attr('href');
		var tipoTabela, coluna; // Declare as variáveis aqui para evitar problemas de escopo
		
		switch (target) {
            case '#restringir-paises':
                tipoTabela = 'paises_permitidos';
                coluna = 'pais'; // Nome da coluna correspondente
                break;
		case '#bloqueio-asns':
            tipoTabela = 'asns_bloqueados';
            coluna = 'asn'; // Nome da coluna correspondente
           break;
		case '#bloqueio-ips':
            tipoTabela = 'ips_bloqueados';
            coluna = 'ip'; // Nome da coluna correspondente
           break;
      	case '#bloqueio-isps':
            tipoTabela = 'isps_bloqueados';
            coluna = 'isp';
            break;
		case '#bloqueio-hostnames':
            tipoTabela = 'hostnames_bloqueados';
            coluna = 'hostname';
            break;
		case '#bloqueio-useragents':
            tipoTabela = 'useragents_bloqueados';
            coluna = 'useragent';
            break;
		case '#bloqueio-palavras':
            tipoTabela = 'palavras_bloqueadas';
            coluna = 'palavra';
            break;
            // Adicione mais casos conforme necessário para outras abas
        }
		
        // Chame a função atualizarTabelaItens dentro do switch
        atualizarTabelaItens(coluna);
    }
});

function removerItensSelecionados(tipoTabela, coluna) {
    var idsSelecionados = [];

    // Iterar sobre todos os checkboxes
    $('#itensCadastrados tbody input[type="checkbox"]').each(function() {
        // Verificar se o checkbox está marcado
        if ($(this).prop('checked')) {
            // Adicionar o valor (ID) do checkbox à lista de IDs selecionados
            idsSelecionados.push($(this).val());
        }
    });

    // Verificar se há itens selecionados
    if (idsSelecionados.length > 0) {
        // Enviar os IDs selecionados para o servidor para remoção
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'removerItensSelecionados',
                tipoTabela: tipoTabela, // Tipo de tabela (pais, ip, isp, etc.)
                coluna: coluna, // Nome da coluna
                ids: idsSelecionados
            },
            success: function(response) {
                // Atualizar a tabela após a remoção dos itens
                listarItens(tipoTabela, coluna); // Atualize a tabela após a remoção
                // Exibir mensagem de sucesso
                showModal("Sucesso", "Itens selecionados removidos com sucesso.");
            },
            error: function(xhr, status, error) {
                console.error('Erro ao remover itens selecionados:', error);
                // Exibir mensagem de erro
                showModal("Erro", "Erro ao remover itens selecionados.");
            }
        });
    } else {
        // Se nenhum item estiver selecionado, exibir uma mensagem de aviso
        showModal("ERRO", "Nenhum item selecionado.");
    }
}

function removerTodosOsItens(tipoTabela, coluna) {
    var confirmacao = confirm("Tem certeza que deseja remover todos os itens? Esta ação não pode ser desfeita.");

    if (confirmacao) {
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'removerTodosOsItens',
                tipoTabela: tipoTabela
            },
            success: function(response) {
                listarItens(tipoTabela, coluna); // Atualize a tabela após a remoção
                showModal("Sucesso", "Todos os itens foram removidos com sucesso.");
            },
            error: function(xhr, status, error) {
                console.error('Erro ao remover todos os itens:', error);
                showModal("Erro", "Erro ao remover todos os itens.");
            }
        });
    }
}



$('#delItemSel').click(function() {
    // Obter o ID da aba ativa
    var target = $('.nav-tabs .active').attr('href');

    // Definir o tipo de tabela e o nome da coluna com base no ID da aba ativa
    var tipoTabela = '';
    var coluna = '';
    switch (target) {
        case '#restringir-paises':
            tipoTabela = 'paises_permitidos';
            coluna = 'pais'; // Nome da coluna correspondente
            break;
		case '#bloqueio-asns':
            tipoTabela = 'asns_bloqueados';
            coluna = 'asn'; // Nome da coluna correspondente
            break;
        case '#bloqueio-ips':
            tipoTabela = 'ips_bloqueados';
            coluna = 'ip'; // Nome da coluna correspondente
            break;
      	case '#bloqueio-isps':
            tipoTabela = 'isps_bloqueados';
            coluna = 'isp';
            break;
		case '#bloqueio-hostnames':
            tipoTabela = 'hostnames_bloqueados';
            coluna = 'hostname';
            break;
		case '#bloqueio-useragents':
            tipoTabela = 'useragents_bloqueados';
            coluna = 'useragent';
            break;
		case '#bloqueio-palavras':
            tipoTabela = 'palavras_bloqueadas';
            coluna = 'palavra';
            break;
    }

    // Chamar a função para remover os itens selecionados com o tipo de tabela correspondente
    removerItensSelecionados(tipoTabela, coluna);
});

$('#delAllItens').click(function() {
    // Obter o ID da aba ativa
    var target = $('.nav-tabs .active').attr('href');

    // Definir o tipo de tabela e a coluna com base no ID da aba ativa
    var tipoTabela = '';
    var coluna = '';
    switch (target) {
        case '#restringir-paises':
            tipoTabela = 'paises_permitidos';
            coluna = 'pais';
            break;
		case '#bloqueio-asns':
            tipoTabela = 'asns_bloqueados';
            coluna = 'asn';
         break;
        case '#bloqueio-ips':
            tipoTabela = 'ips_bloqueados';
            coluna = 'ip';
            break;
		case '#bloqueio-isps':
            tipoTabela = 'isps_bloqueados';
            coluna = 'isp';
            break;
		case '#bloqueio-hostnames':
            tipoTabela = 'hostnames_bloqueados';
            coluna = 'hostname';
            break;
		case '#bloqueio-useragents':
            tipoTabela = 'useragents_bloqueados';
            coluna = 'useragent';
            break;
		case '#bloqueio-palavras':
            tipoTabela = 'palavras_bloqueadas';
            coluna = 'palavra';
            break;
    }

    // Chamar a função para remover todos os itens com o tipo de tabela correspondente
    removerTodosOsItens(tipoTabela, coluna);
});


$("#buscarItem").on("input", function() {
    var termoBusca = $(this).val().trim();
    var target = $('.nav-tabs .active').attr('href');
    var tipoTabela, coluna;

    switch (target) {
        case '#restringir-paises':
            tipoTabela = 'paises_permitidos';
            coluna = 'pais';
            break;
		 case '#bloqueio-asns':
            tipoTabela = 'asns_bloqueados';
            coluna = 'asn';
            break;
        case '#bloqueio-ips':
            tipoTabela = 'ips_bloqueados';
            coluna = 'ip';
            break;
		case '#bloqueio-isps':
            tipoTabela = 'isps_bloqueados';
            coluna = 'isp';
            break;
		case '#bloqueio-hostnames':
            tipoTabela = 'hostnames_bloqueados';
            coluna = 'hostname';
            break;
		case '#bloqueio-useragents':
            tipoTabela = 'useragents_bloqueados';
            coluna = 'useragent';
            break;
		case '#bloqueio-palavras':
            tipoTabela = 'palavras_bloqueadas';
            coluna = 'palavra';
            break;
    }

    // Verifique se o termo de busca não está vazio
    if (termoBusca !== '') {
        // Envie uma solicitação AJAX para buscar os itens correspondentes ao termo de busca
        $.ajax({
            url: 'api.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'buscarItens',
                termoBusca: termoBusca,
                tipoTabela: tipoTabela,
                coluna: coluna
            },
            success: function(response) {
                if (response.success) {
                    // Atualize a tabela com os itens retornados
                    var itens = response.itens;
                    atualizarTabelaComResultados(itens, coluna); // Atualiza a tabela com os itens filtrados
                } else {
                    console.error('Erro ao buscar itens:', response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error('Erro ao buscar itens:', error);
            }
        });
    } else {
        // Se o termo de busca estiver vazio, exiba toda a tabela novamente
        atualizarTabelaItens(coluna);
    }
});

function atualizarTabelaComResultados(itens, coluna) {
    // Limpar o conteúdo da tabela
    $('#itensCadastrados thead').empty();
    $('#itensCadastrados tbody').empty();

    // Definir o texto do cabeçalho com base na coluna
    var cabecalhoTexto;
    if (coluna === 'pais') {
        cabecalhoTexto = 'Pais';
    } else if (coluna === 'asn') {
        cabecalhoTexto = 'ASN';
    } else if (coluna === 'ip') {
        cabecalhoTexto = 'IP';
    } else if (coluna === 'isp') {
        cabecalhoTexto = 'ISP';
	} else if (coluna === 'hostname') {
        cabecalhoTexto = 'Hostname';
    } else if (coluna === 'useragent') {
        cabecalhoTexto = 'Useragent';
    } else if (coluna === 'palavra') {
        cabecalhoTexto = 'Palavra';
    }	

    // Adicionar os cabeçalhos à tabela
    $('#itensCadastrados thead').append(`
        <tr>
            <th scope="col">ID</th>
            <th scope="col">${cabecalhoTexto}</th> <!-- Usar o nome da coluna dinamicamente -->
        </tr>
    `);

    // Adicionar os itens retornados à tabela
    itens.forEach(function(item) {
        $('#itensCadastrados tbody').append(`
            <tr>
                <th scope="row"><input type="checkbox" class="itemCheckbox" value="${item.id}">&nbsp;${item.id}</th>
                <td>${item[coluna]}</td>
                <!-- Adicione outras colunas conforme necessário -->
            </tr>
        `);
    });

    // Atualizar os botões de navegação
    atualizarBotoesNavegacaoItens();
}


// Colorir linha selecionada 

$('#numerosCadastrados').add('#itensCadastrados').on('change', 'input[type="checkbox"]', function() {
        // Se o checkbox estiver marcado, adicione a classe à linha
        if ($(this).is(':checked')) {
            $(this).closest('tr').addClass('table-danger');
        } else {
            // Se o checkbox estiver desmarcado, remova a classe da linha
            $(this).closest('tr').removeClass('table-danger');
        }
    });

// Atualiza o valor da configuração quando ativa ou desativa o switch
$("#config .form-switch input").change(function() {
    var id = $(this).attr("id");
    
    // Checar se o input é um checkbox
    var value = $(this).prop("type") === "checkbox" ? ($(this).prop("checked") ? "true" : "false") : $(this).val();

    atualizarConfiguracao(id, value);
});

// Atualiza o valor da configuração quando um input de texto perde o foco
$("#config .form-control").blur(function() {
    var id = $(this).attr("id");
    var value = $(this).val();
    atualizarConfiguracao(id, value);
});
	
	
 $('#restringir_numeros').on('change', function() {
        if ($(this).is(':checked')) {
            $('#get_id').prop('disabled', false); // Habilitar o input 'get_id'
        } else {
            $('#get_id').prop('disabled', true);  // Desabilitar o input 'get_id'
        }
    });

    // Detectar mudança no switch 'restringir_emails'
    $('#restringir_emails').on('change', function() {
        if ($(this).is(':checked')) {
            $('#get_mid').prop('disabled', false); // Habilitar o input 'get_mid'
        } else {
            $('#get_mid').prop('disabled', true);  // Desabilitar o input 'get_mid'
        }
    });

$("#maxmind_api").click(function() {
    var isChecked = $(this).prop("checked");
    // Desabilitar o switch geoip_api se maxmind_api estiver ligado
    $("#geoip_api").prop("checked", !isChecked);
    // Habilitar ou desabilitar o campo geoip_apikey de acordo com o estado de maxmind_api
    $("#geoip_apikey").prop("disabled", isChecked);
    // Atualizar a configuração na API
    atualizarConfiguracao("maxmind_api", isChecked.toString());
    // Se maxmind_api estiver ligado, desativar geoip_apikey e ativar maxmind_api na API
    if (isChecked) {
        atualizarConfiguracao("geoip_api", "false");
    } else {
        // Se maxmind_api estiver desligado, ativar geoip_api e desativar maxmind_api na API
        atualizarConfiguracao("geoip_api", "true");
    }
});


 $("#geoip_api").click(function() {
    var isChecked = $(this).prop("checked");
    // Desativar o switch maxmind_api se geoip_api estiver ligado
    $("#maxmind_api").prop("checked", !isChecked);
    // Habilitar ou desabilitar o campo geoip_apikey de acordo com o estado de geoip_api
    $("#geoip_apikey").prop("disabled", !isChecked);
    // Atualizar a configuração na API
    atualizarConfiguracao("geoip_api", isChecked.toString());
    // Se geoip_api estiver ligado, desativar maxmind_api e ativar geoip_api na API
    if (isChecked) {
        atualizarConfiguracao("maxmind_api", "false");
    } else {
        // Se geoip_api estiver desligado, ativar maxmind_api e desativar geoip_api na API
        atualizarConfiguracao("maxmind_api", "true");
    }
});



  // Evento de mudança do switch geoip_api
  $("#geoip_api").change(function() {
    $("#geoip_apikey").prop("disabled", !$(this).prop("checked"));
  });

$("#redir_mobile_url").click(function() {
        var isChecked = $(this).prop("checked");
        // Habilita o input de URL e desabilita o select de erro se o switch de URL estiver ligado
        $("#url_mobile").prop("disabled", !isChecked);
	    $("#redir_mobile_wurl").prop("checked", false);
		$("#wurl_mobile").prop("disabled", true);
        $("#redir_mobile_erro").prop("checked", false);
        $("#tipo_erro_mobile").prop("disabled", true);
        
        // Atualiza a configuração para URL mobile
        // atualizarConfiguracao("redir_mobile_url", isChecked.toString()); - talvez nao precise pq a pagina ja detecta, envia enviar so o false
        // Atualiza a configuração para erro mobile como false, pois o URL está ativado
        atualizarConfiguracao("redir_mobile_erro", "false");
		atualizarConfiguracao("redir_mobile_wurl", "false");
    });

  // Lidar com o switch de WURL Mobile
    $("#redir_mobile_wurl").click(function() {
        var isChecked = $(this).prop("checked");
        // Habilita o select de WURL e desabilita o input de URL se o switch de ERRO estiver ligado
		$("#wurl_mobile").prop("disabled", !isChecked);
		$("#redir_mobile_url").prop("checked", false);
		
        $("#url_mobile").prop("disabled", true);
		$("#redir_mobile_erro").prop("checked", false);
        $("#tipo_erro_mobile").prop("disabled", true);

        // Atualiza a configuração para ERRO mobile
        // atualizarConfiguracao("redir_mobile_erro", isChecked.toString());
        // Atualiza a configuração para URL mobile como false, pois o ERRO está ativado
        atualizarConfiguracao("redir_mobile_url", "false");
		atualizarConfiguracao("redir_mobile_erro", "false");
    });
	
    // Lidar com o switch de ERRO Mobile
 $("#redir_mobile_erro").click(function() {
        var isChecked = $(this).prop("checked");
        // Habilita o select de erro e desabilita o input de URL se o switch de ERRO estiver ligado
        $("#tipo_erro_mobile").prop("disabled", !isChecked);
        $("#redir_mobile_url").prop("checked", false);
		
	    $("#redir_mobile_wurl").prop("checked", false);
        $("#url_mobile").prop("disabled", true);
        $("#wurl_mobile").prop("disabled", true);

        // Atualiza a configuração para ERRO mobile
        // atualizarConfiguracao("redir_mobile_erro", isChecked.toString());
        // Atualiza a configuração para URL mobile como false, pois o ERRO está ativado
        atualizarConfiguracao("redir_mobile_url", "false");
	    atualizarConfiguracao("redir_mobile_wurl", "false");
    });


// Lidar com o switch de URL Desktop
$("#redir_desktop_url").click(function() {
    var isChecked = $(this).prop("checked");
    // Habilita o input de URL e desabilita o select de erro se o switch de URL estiver ligado
    $("#url_desktop").prop("disabled", !isChecked);
    $("#redir_desktop_erro").prop("checked", false);
    $("#tipo_erro_desktop").prop("disabled", true);
	$("#redir_desktop_wurl").prop("checked", false);
    $("#wurl_desktop").prop("disabled", true);

    // Atualiza a configuração para erro desktop como false, pois o URL está ativado
    atualizarConfiguracao("redir_desktop_erro", "false");
	atualizarConfiguracao("redir_desktop_wurl", "false");

});

$("#redir_desktop_wurl").click(function() {
    var isChecked = $(this).prop("checked");
    // Habilita o input de URL e desabilita o select de erro se o switch de URL estiver ligado
	$("#wurl_desktop").prop("disabled", false);

    $("#redir_desktop_url").prop("checked", false);
	$("#url_desktop").prop("disabled", true);
	
    $("#redir_desktop_erro").prop("checked", false);
	$("#tipo_erro_desktop").prop("disabled", true);
  

    // Atualiza a configuração para erro desktop como false, pois o URL está ativado
    atualizarConfiguracao("redir_desktop_erro", "false");
	atualizarConfiguracao("redir_desktop_url", "false");

});

// Lidar com o switch de ERRO Desktop
$("#redir_desktop_erro").click(function() {
    var isChecked = $(this).prop("checked");
    // Habilita o select de erro e desabilita o input de URL se o switch de ERRO estiver ligado
    $("#tipo_erro_desktop").prop("disabled", !isChecked);
    $("#redir_desktop_url").prop("checked", false);
    $("#redir_desktop_wurl").prop("checked", false);
    $("#url_desktop").prop("disabled", true);
    $("#wurl_desktop").prop("disabled", true);

    // Atualiza a configuração para URL desktop como false, pois o ERRO está ativado
    atualizarConfiguracao("redir_desktop_url", "false");
	atualizarConfiguracao("redir_desktop_wurl", "false");

});

$("#redir_bloqueados_url").click(function() {
    var isChecked = $(this).prop("checked");
    // Habilita o input de URL e desabilita o select de erro se o switch de URL estiver ligado
    $("#url_bloqueados").prop("disabled", !isChecked);

    $("#redir_bloqueados_wurl").prop("checked", false);
    $("#redir_bloqueados_erro").prop("checked", false);
    $("#tipo_erro_bloqueados").prop("disabled", true);
    $("#wurl_bloqueados").prop("disabled", true);

    // Atualiza a configuração para erro bloqueados como false, pois o URL está ativado
    atualizarConfiguracao("redir_bloqueados_erro", "false");
	atualizarConfiguracao("redir_bloqueados_wurl", "false");
});

$("#redir_bloqueados_wurl").click(function() {
    var isChecked = $(this).prop("checked");
    // Habilita o input de URL e desabilita o select de erro se o switch de URL estiver ligado
	$("#wurl_bloqueados").prop("disabled", !isChecked);

    $("#redir_bloqueados_url").prop("checked", false);
    $("#redir_bloqueados_erro").prop("checked", false);
	$("#url_bloqueados").prop("disabled", true);
    $("#tipo_erro_bloqueados").prop("disabled", true);
    
    // Atualiza a configuração para erro bloqueados como false, pois o URL está ativado
    atualizarConfiguracao("redir_bloqueados_erro", "false");
	atualizarConfiguracao("redir_bloqueados_url", "false");
});

// Lidar com o switch de ERRO bloqueados
$("#redir_bloqueados_erro").click(function() {
    var isChecked = $(this).prop("checked");
    // Habilita o select de erro e desabilita o input de URL se o switch de ERRO estiver ligado
    $("#tipo_erro_bloqueados").prop("disabled", !isChecked);
    $("#redir_bloqueados_url").prop("checked", false);
	$("#redir_bloqueados_wurl").prop("checked", false);
    $("#url_bloqueados").prop("disabled", true);
    $("#wurl_bloqueados").prop("disabled", true);

    // Atualiza a configuração para URL bloqueados como false, pois o ERRO está ativado
    atualizarConfiguracao("redir_bloqueados_url", "false");
	atualizarConfiguracao("redir_bloqueados_wurl", "false");
});


  // Evento de clique nos links do sidebar
  
  $(".nav-link").click(function() {
	 // event.preventDefault(); - SE NAO QUISER QUE FOQUE NA TABELA AO CLICAR NO NAVLINK DESCOMENTE
	 
	

    var target = $(this).attr("href");
    if (target === "#configuracoes" || target === "#config") {
      $("#dashboard, #itensCad, #numsCad, #emailsCad, #tab-default").hide();
	  $("#config").addClass("show active"); 
	  $("#configuracoes").show();

    } 
	else if (target === "#dashboard") {
		listarAcessos("acessos-gerais");
		listarAcessos("acessos-permitidos");
		listarAcessos("acessos-bloqueados");
		atualizarCtdAcessos();
      $("#configuracoes, #itensCad, #numsCad, #emailsCad, #tab-default").hide();
	  $("#acessos-gerais").addClass("show active"); 
      $("#dashboard").show();

    } 
	else if (target === "#numeros-celular") {
	  $("#itensCad, #tab-default, #emailsCad").hide();
	   listarNumeros();
      $("#numsCad").show();
    } 
	else if (target === "#emails") {
	  $("#itensCad, #tab-default, #numsCad").hide();
	  $("#tab-default").hide();
	   listarEmails();
      $("#emailsCad").show();
    }
	else if (target === "#restringir-paises") {
		$("#numsCad, #emailsCad, #tab-default").hide();
		listarItens('paises_permitidos', 'pais');
		$("#itensCad").show(); 
    } else if (target === "#bloqueio-asns") {
		$("#numsCad, #emailsCad, #itensCad").hide();
		listarItens('asns_bloqueados', 'asn');
		$("#itensCad").show();
	}
	else if (target === "#bloqueio-ips") {
		$("#numsCad, #emailsCad, #itensCad").hide();
		listarItens('ips_bloqueados', 'ip');
		$("#itensCad").show();
	}
	
	else if (target === "#bloqueio-isps") {
		$("#numsCad, #emailsCad, #itensCad").hide();
		listarItens('isps_bloqueados', 'isp');
		$("#itensCad").show();
	}
	else if (target === "#bloqueio-hostnames") {
		$("#numsCad, #emailsCad, #itensCad").hide();
		listarItens('hostnames_bloqueados', 'hostname');
		$("#itensCad").show();
	}
	
	else if (target === "#bloqueio-useragents") {
		$("#numsCad, #emailsCad, #itensCad").hide();
		listarItens('useragents_bloqueados', 'useragent');
		$("#itensCad").show();
	}
	
	else if (target === "#bloqueio-palavras") {
		$("#numsCad, #emailsCad, #itensCad").hide();
		listarItens('palavras_bloqueadas', 'palavra');
		$("#itensCad").show();
	}
	
    $(".nav-link").removeClass("active");
    $(this).addClass("active");
  });

  // Evento de clique nas abas das configurações
  $(".nav-tabs .nav-link").click(function() {
    var target = $(this).attr("href");
    $(".tab-pane").removeClass("show active");
    $(target).addClass("show active");
  });

 // Evento de entrada de texto no textarea dos numeros - atualizada 25/09/2024
$("#numeros-textarea").on("input", function() {
    // Capturar o valor atual do textarea
    let texto = $(this).val();
    
    // Remover espaços no início e no fim de cada linha, sem eliminar as quebras de linha
    texto = texto.split("\n").map(function(linha) {
        return linha.trim(); // Remove espaços no início e no fim de cada linha
    }).join("\n");

    // Atualizar o conteúdo do textarea
    $(this).val(texto);

    // Atualizar contador de números e exibir ou ocultar conforme necessário
    const linhas = texto.split("\n").filter(Boolean).length;
    if (linhas > 0) {
        $('#impNumeros').hide();
        $("#contadorNumeros").show();
        $("#cadastrarNumeros").show();
        attContNum();
    } else {
        $('#impNumeros').hide();
        $("#contadorNumeros").hide();
        $("#cadastrarNumeros").hide();
    }
});


// Evento de entrada de texto no textarea dos emails
$("#emails-textarea").on("input", function() {
    // Capturar o valor atual do textarea
    let texto = $(this).val();
    
    // Remover espaços no início e no fim de cada linha, sem eliminar as quebras de linha
    texto = texto.split("\n").map(function(linha) {
        return linha.trim(); // Remove espaços no início e no fim de cada linha
    }).join("\n");

    // Atualizar o conteúdo do textarea
    $(this).val(texto);

    // Atualizar contador de emails e exibir ou ocultar conforme necessário
    const linhas = texto.split("\n").filter(Boolean).length;
    if (linhas > 0) {
        $('#impEmails').hide();
        $("#contadorEmails").show();
        $("#cadastrarEmails").show();
        attContMail();
    } else {
        $('#impEmails').hide();
        $("#contadorEmails").hide();
        $("#cadastrarEmails").hide();
    }
});

var ultimaAba = ""; // Variável global para armazenar o último ID de aba acessado

// Evento quando uma aba é clicada
$('.nav-link.custom-tab').on('click', function() {
    var href = $(this).attr('href'); // Obtém o href da aba clicada
    if (href.startsWith('#bloqueio-')) { // Verifica se o href começa com 'bloqueio-'
        ultimaAba = href.substring(1); // Armazena o último ID de aba acessado
		$('#tab-textarea').val('');
		$('#impArquivoTab').hide();
        $("#contadorTab").hide();
        $("#bloquearTab").hide();
		
    }
});


$("#tab-textarea").on("input", function() {
    // Remover espaços em branco no início e no fim de cada linha
    let texto = $(this).val().replace(/^\s+|\s+$/g, '');
    // Remover linhas vazias
    texto = texto.replace(/^\s*[\r\n]/gm, "");

    // Atualizar o conteúdo do textarea
    $(this).val(texto);

    // Atualizar contador de números e exibir ou ocultar conforme necessário
    const linhas = texto.split("\n").filter(Boolean).length;
    if (linhas > 0) {
        $('#impArquivoTab').hide();
        $("#contadorTab").show();
        $("#bloquearTab").show();
        if (ultimaAba.startsWith('bloqueio-')) { // Verifica se o ID da aba começa com 'bloqueio-'
            attContTab(ultimaAba, linhas); // Chama a função attContTab apenas se a aba for de bloqueio
        }
    } else {
        $('#impArquivoTab').hide();
        $("#contadorTab").hide();
        $("#bloquearTab").hide();
    }
});

  // Função para atualizar o contador de números
function attContNum() {
    const linhas = $("#numeros-textarea").val().split("\n").filter(Boolean).length;
    const buttonText = (linhas === 1) ? 'Cadastrar 1 número' : 'Cadastrar ' + linhas.toLocaleString() + ' números';
    $("#cadastrarNumeros").text(buttonText);
}


  // Função para atualizar o contador de emails
function attContMail() {
    const linhas = $("#emails-textarea").val().split("\n").filter(Boolean).length;
    const buttonText = (linhas === 1) ? 'Cadastrar 1 email' : 'Cadastrar ' + linhas.toLocaleString() + ' emails';
    $("#cadastrarEmails").text(buttonText);
}

// Função para atualizar o texto do botão com base na aba atual
function attContTab(aba, linhas) {
    switch (aba) {
		 case "bloqueio-asns":
            const buttonTextASNS = (linhas === 1) ? 'Bloquear 1 ASN' : 'Bloquear ' + linhas.toLocaleString() + 'ASN`s';
            $("#bloquearTab").text(buttonTextASNS);
            break;
        case "bloqueio-ips":
            const buttonTextIPS = (linhas === 1) ? 'Bloquear 1 IP' : 'Bloquear ' + linhas.toLocaleString() + ' IP`s';
            $("#bloquearTab").text(buttonTextIPS);
            break;
        case "bloqueio-isps":
            const buttonTextISPS = (linhas === 1) ? 'Bloquear 1 ISP' : 'Bloquear ' + linhas.toLocaleString() + ' ISPs';
            $("#bloquearTab").text(buttonTextISPS);
            break;
        case "bloqueio-hostnames":
            const buttonTextHostnames = (linhas === 1) ? 'Bloquear 1 Hostname' : 'Bloquear ' + linhas.toLocaleString() + ' Hostnames';
            $("#bloquearTab").text(buttonTextHostnames);
            break;
		case "bloqueio-useragents":
            const buttonTextUseragents = (linhas === 1) ? 'Bloquear 1 Useragent' : 'Bloquear ' + linhas.toLocaleString() + ' Useragents';
            $("#bloquearTab").text(buttonTextUseragents);
            break;
		case "bloqueio-palavras":
            const buttonTextPalavras = (linhas === 1) ? 'Bloquear 1 Palavra' : 'Bloquear ' + linhas.toLocaleString() + ' Palavras';
            $("#bloquearTab").text(buttonTextPalavras);
            break;
        default:
            break;
    }
}


function handleHashChange(hash) {
    // Esconder todas as seções
    $("#dashboard").hide();
    $("#configuracoes").hide();
    $("#itensCad").hide();
    $("#numsCad").hide();
    $("#tab-default").hide();

    // Remover 'active' de todos os links e esconder conteúdo das abas
    $(".nav-link").removeClass("active");
    $(".tab-pane").removeClass("show active");

    // Verificação inicial para hashes que usam o auto-atualizador
    if (hash === "#dashboard" || hash === "#acessos-gerais" || hash === "#acessos-permitidos" || hash === "#acessos-bloqueados") {
		if (verificarAutoAtualizador()) {
            obterIntervalo(function(intervalo) {
                if (intervalo) {
                    iniciarAutoAtualizacao(intervalo);
                } else {
                    console.error('Intervalo não pôde ser obtido');
                }
            });
        }

        if (hash === "#dashboard") {
            listarAcessos("acessos-gerais");
            listarAcessos("acessos-permitidos");
            listarAcessos("acessos-bloqueados");
            atualizarCtdAcessos();
            $("#dashboard").show();
            $("a[href='#dashboard'], a[href='#acessos-gerais']").addClass("active");
            $("#acessos-gerais").addClass("show active");
        } else if (hash === "#acessos-gerais") {
            listarAcessos("acessos-gerais");
            listarAcessos("acessos-permitidos");
            listarAcessos("acessos-bloqueados");
            atualizarCtdAcessos();
            $("#dashboard").show();
            $("a[href='#dashboard'], a[href='#acessos-gerais']").addClass("active");
            $("#acessos-gerais").addClass("show active");
        } else if (hash === "#acessos-permitidos") {
            listarAcessos("acessos-gerais");
            listarAcessos("acessos-permitidos");
            listarAcessos("acessos-bloqueados");
            atualizarCtdAcessos();
            $("#dashboard").show();
            $("a[href='#dashboard'], a[href='#acessos-permitidos']").addClass("active");
            $("#acessos-permitidos").addClass("show active");
        } else if (hash === "#acessos-bloqueados") {
            listarAcessos("acessos-gerais");
            listarAcessos("acessos-permitidos");
            listarAcessos("acessos-bloqueados");
            atualizarCtdAcessos();
            $("#dashboard").show();
            $("a[href='#dashboard'], a[href='#acessos-bloqueados']").addClass("active");
            $("#acessos-bloqueados").addClass("show active");
        }
    } else {
        // Parar o auto-atualizador se estiver ativo
        if (verificarAutoAtualizador()) { 
            pararAutoAtualizador(); 
        }

        // Lógica para outros hashes
        if (hash === "#configuracoes" || hash === "#config") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#config']").addClass("active");
            $("#config").addClass("show active");
        } else if (hash === "#numeros-celular") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#numeros-celular']").addClass("active");
            $("#numeros-celular").addClass("show active");
            listarNumeros();
            $("#numsCad").show();
        } else if (hash === "#emails") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#emails']").addClass("active");
            $("#emails").addClass("show active");
            listarEmails();
            $("#emailsCad").show();
        }		
		else if (hash === "#restringir-paises") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#restringir-paises']").addClass("active");
            $("#restringir-paises").addClass("show active");
            listarItens('paises_permitidos', 'pais');
            $("#itensCad").show();
        } else if (hash === "#bloqueio-asns") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#bloqueio-asns']").addClass("active");
            $("#bloqueio-asns").addClass("show active");
            listarItens('asns_bloqueados', 'asn');
            var nomeAba = $("a[href='#bloqueio-asns']").text();
            atualizarCardPadrao(nomeAba);
            ultimaAba = "bloqueio-asns";
            $("#itensCad").show();
        } else if (hash === "#bloqueio-ips") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#bloqueio-ips']").addClass("active");
            $("#bloqueio-ips").addClass("show active");
            listarItens('ips_bloqueados', 'ip');
            var nomeAba = $("a[href='#bloqueio-ips']").text();
            atualizarCardPadrao(nomeAba);
            ultimaAba = "bloqueio-ips";
            $("#itensCad").show();
        } else if (hash === "#bloqueio-isps") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#bloqueio-isps']").addClass("active");
            $("#bloqueio-isps").addClass("show active");
            listarItens('isps_bloqueados', 'isp');
            var nomeAba = $("a[href='#bloqueio-isps']").text();
            atualizarCardPadrao(nomeAba);
            ultimaAba = "bloqueio-isps";
            $("#itensCad").show();
        } else if (hash === "#bloqueio-hostnames") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#bloqueio-hostnames']").addClass("active");
            $("#bloqueio-hostnames").addClass("show active");
            listarItens('hostnames_bloqueados', 'hostname');
            var nomeAba = $("a[href='#bloqueio-hostnames']").text();
            atualizarCardPadrao(nomeAba);
            ultimaAba = "bloqueio-hostnames";
            $("#itensCad").show();
        } else if (hash === "#bloqueio-useragents") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#bloqueio-useragents']").addClass("active");
            $("#bloqueio-useragents").addClass("show active");
            listarItens('useragents_bloqueados', 'useragent');
            var nomeAba = $("a[href='#bloqueio-useragents']").text();
            atualizarCardPadrao(nomeAba);
            ultimaAba = "bloqueio-useragents";
            $("#itensCad").show();
        } else if (hash === "#bloqueio-palavras") {
            $("#configuracoes").show();
            $("a[href='#configuracoes'], a[href='#bloqueio-palavras']").addClass("active");
            $("#bloqueio-palavras").addClass("show active");
            listarItens('palavras_bloqueadas', 'palavra');
            var nomeAba = $("a[href='#bloqueio-palavras']").text();
            atualizarCardPadrao(nomeAba);
            ultimaAba = "bloqueio-palavras";
            $("#itensCad").show();
        }
    }
}


  // Carregar as configurações ao carregar a página
  carregarConfiguracoes();
  
  listarAcessos("acessos-gerais");
  listarAcessos("acessos-permitidos");
  listarAcessos("acessos-bloqueados");
  
  if (window.location.hash) {
        handleHashChange(window.location.hash);
    } else {
        handleHashChange("#dashboard");
    }
    $(window).on('hashchange', function() {
        handleHashChange(window.location.hash);
    });
});

</script>



</body>
</html>
