<?php
if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Este arquivo só pode ser acessado via solicitações AJAX.']);
    exit;
}

require_once 'src/_condb.php';

function atualizarConfiguracao($campo, $valor) {
    $conexao = conDb(); 
    try {
        $stmt = $conexao->prepare("UPDATE configuracoes SET $campo = :valor");
        $stmt->bindParam(':valor', $valor);
        $stmt->execute();
        return true; 
    } catch (PDOException $e) {
        return false;
    }
}

function carregarConfiguracoes() {
    $conexao = conDb(); 
    try {
        $stmt = $conexao->query("SELECT * FROM configuracoes");
        $configuracoes = $stmt->fetch(PDO::FETCH_ASSOC);
        echo json_encode($configuracoes);
    } catch (PDOException $e) {
        echo "Erro ao carregar configurações: " . $e->getMessage();
    }
}


// Função para adicionar números ao banco de dados
function adicionarNumeros($numeros) {
    $conexao = conNum(); // Conectar ao banco de dados

    // Preparar a instrução SQL para inserção
    $stmt = $conexao->prepare("INSERT INTO numeros (numero_comcod, numero_semcod, nome, col4, col5, col6) VALUES (?, ?, ?, ?, ?, ?)");

    // Iterar sobre cada número no array
    foreach ($numeros as $linha) {
        // Dividir a linha em partes usando o separador identificado
        $partes = explode(";", $linha);

        // Extrair os valores para as colunas do banco de dados
        $numero_comcod = $partes[0];
        $numero_semcod = (isset($partes[1]) && strlen($partes[1]) === 9) ? $partes[1] : "Na";
        $nome = (isset($partes[2])) ? $partes[2] : "Na";
        $col4 = (isset($partes[3])) ? $partes[3] : "Na";
        $col5 = (isset($partes[4])) ? $partes[4] : "Na";
        $col6 = (isset($partes[5])) ? $partes[5] : "Na";

        // Executar a instrução preparada, passando os valores como parâmetros
        $stmt->execute([$numero_comcod, $numero_semcod, $nome, $col4, $col5, $col6]);
    }
}



// Função para detectar o separador utilizado na lista de números
function detectarSeparador($numeros) {
    // Array de possíveis separadores
    $separadores = array(';', ':', '|');

    // Expressão regular para identificar o padrão de separação
    $padrao = '/[' . implode('', $separadores) . ']/';

    // Usar a expressão regular para encontrar o padrão de separação na lista de números
    preg_match($padrao, $numeros, $matches);

    // Se um padrão de separação for encontrado, retornar o primeiro caractere correspondente
    if (!empty($matches)) {
        return $matches[0];
    }

    // Se nenhum padrão de separação for encontrado, retornar o padrão (ponto-e-vírgula)
    return ';';
}
function listarNumeros() {
    $conexao = conNum(); // Conectar ao banco de dados

    try {
        // Preparar a consulta SQL para selecionar todos os números
        $stmt = $conexao->query("SELECT * FROM numeros");
        // Obter os resultados da consulta como um array associativo
        $numeros = $stmt->fetchAll(PDO::FETCH_ASSOC);
        // Retornar os números como JSON
        echo json_encode($numeros);
    } catch (PDOException $e) {
        // Em caso de erro, imprimir mensagem de erro
        echo json_encode(["success" => false, "message" => "Erro ao listar números: " . $e->getMessage()]);
    }
}


function listarEmails() {
    $conexao = conMail(); // Conectar ao banco de dados

    try {
        // Preparar a consulta SQL para selecionar todos os números
        $stmt = $conexao->query("SELECT * FROM emails");
        // Obter os resultados da consulta como um array associativo
        $emails = $stmt->fetchAll(PDO::FETCH_ASSOC);
        // Retornar os números como JSON
        echo json_encode($emails);
    } catch (PDOException $e) {
        // Em caso de erro, imprimir mensagem de erro
        echo json_encode(["success" => false, "message" => "Erro ao listar emails: " . $e->getMessage()]);
	}
}
   
// Variável global para armazenar o total de linhas a serem importadas
$totalLinhas= 0;

function importarNumeros($dados) {
    $conexao = conNum(); // Conectar ao banco de dados

    // Dividir os dados em lotes menores (por exemplo, de 1000 em 1000 linhas)
    $linhas = explode("\n", $dados);
    $batchSize = 1000;
    $totalLinhas = count($linhas); // Armazenar o número total de linhas a serem importadas

    for ($i = 0; $i < $totalLinhas; $i += $batchSize) {
        $batch = array_slice($linhas, $i, $batchSize);

        // Preparar a instrução SQL para inserção
        $stmt = $conexao->prepare("INSERT INTO numeros (numero_comcod, numero_semcod, nome, col4, col5, col6) VALUES (?, ?, ?, ?, ?, ?)");

        // Iterar sobre cada linha do lote atual
        foreach ($batch as $linha) {
            // Dividir a linha em partes usando o separador identificado
            $partes = explode(";", $linha);

            // Extrair os valores para as colunas do banco de dados
            $numero_comcod = $partes[0];
            $numero_semcod = (isset($partes[1]) && strlen($partes[1]) === 9) ? $partes[1] : "Na";
            $nome = (isset($partes[2])) ? $partes[2] : "Na";
            $col4 = (isset($partes[3])) ? $partes[3] : "Na";
            $col5 = (isset($partes[4])) ? $partes[4] : "Na";
            $col6 = (isset($partes[5])) ? $partes[5] : "Na";

            // Executar a instrução preparada, passando os valores como parâmetros
            $stmt->execute([$numero_comcod, $numero_semcod, $nome, $col4, $col5, $col6]);
        }
    }

    // Fechar a conexão com o banco de dados
    $conexao = null;

    // Retornar uma resposta de sucesso após a conclusão da importação
    echo json_encode(["success" => true, "message" => "Dados importados com sucesso."]);
}

function gerarMailHash($email) {
    $hash = hash('sha256', $email);
    return substr($hash, 0, 32);
}


function importarEmails($dados) {
    $conexao = conMail(); // Conectar ao banco de dados
    $key = '5c5243c9585690b7930029b5df0fb22f';  // Troque por uma chave segura
    $linhas = explode("\n", $dados);
    $batchSize = 1000;
    $totalLinhas = count($linhas); // Armazenar o número total de linhas a serem importadas

    for ($i = 0; $i < $totalLinhas; $i += $batchSize) {
        $batch = array_slice($linhas, $i, $batchSize);

        // Preparar a instrução SQL para inserção
        $stmt = $conexao->prepare("INSERT INTO emails (email, hash, nome, col4, col5, col6) VALUES (?, ?, ?, ?, ?, ?)");

        // Iterar sobre cada linha do lote atual
        foreach ($batch as $linha) {
            // Dividir a linha em partes usando o separador identificado
            $partes = explode(";", $linha);

            // Extrair os valores para as colunas do banco de dados
            $email = $partes[0];
            
            // Gerar o hash do email usando a função gerarMailHash
            $hash = gerarMailHash($email, $key);

            $nome = (isset($partes[1])) ? $partes[1] : "Na";
            $col4 = (isset($partes[2])) ? $partes[2] : "Na";
            $col5 = (isset($partes[3])) ? $partes[3] : "Na";
            $col6 = (isset($partes[4])) ? $partes[4] : "Na";

            // Executar a instrução preparada, passando os valores como parâmetros
            $stmt->execute([$email, $hash, $nome, $col4, $col5, $col6]);
        }
    }

    // Fechar a conexão com o banco de dados
    $conexao = null;

    // Retornar uma resposta de sucesso após a conclusão da importação
    echo json_encode(["success" => true, "message" => "Dados importados com sucesso."]);
}

function adicionarEmails($emails) {
    $conexao = conMail(); // Conectar ao banco de dados
    $key = '5c5243c9585690b7930029b5df0fb22f';  // Chave segura para gerar o hash

    // Preparar a instrução SQL para inserção
    $stmt = $conexao->prepare("INSERT INTO emails (email, hash, nome, col4, col5, col6) VALUES (?, ?, ?, ?, ?, ?)");

    // Iterar sobre cada email no array
    foreach ($emails as $linha) {
        // Dividir a linha em partes usando o separador identificado
        $partes = explode(";", $linha);

        // Extrair os valores para as colunas do banco de dados
        $email = $partes[0];
        $hash = gerarMailHash($email, $key); // Gerar o hash para o email
        $nome = (isset($partes[1])) ? $partes[1] : "Na";
        $col4 = (isset($partes[2])) ? $partes[2] : "Na";
        $col5 = (isset($partes[3])) ? $partes[3] : "Na";
        $col6 = (isset($partes[4])) ? $partes[4] : "Na";

        // Executar a instrução preparada, passando os valores como parâmetros
        $stmt->execute([$email, $hash, $nome, $col4, $col5, $col6]);
    }

    // Fechar a conexão com o banco de dados
    $conexao = null;
}


// Função para adicionar itens a uma tabela específica
function adicionarItem($tabela, $coluna, $itens) {
    $conexao = conBlq(); // Conectar ao banco de dados

    // Preparar a instrução SQL para inserção
    $stmt = $conexao->prepare("INSERT INTO $tabela ($coluna) VALUES (?)");

    // Iterar sobre cada item
    foreach ($itens as $item) {
        // Executar a instrução preparada, passando o item como parâmetro
        $stmt->execute([$item]);
    }
}


function listarItens($tabela, $coluna) {
    $conexao = conBlq(); // Conectar ao banco de dados

    try {
        // Preparar a consulta SQL para selecionar todos os itens com base na tabela e na coluna
        $stmt = $conexao->prepare("SELECT * FROM $tabela");
        $stmt->execute();
        // Obter os resultados da consulta como um array associativo
        $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);
        // Retornar os itens como JSON
        echo json_encode(["success" => true, "itens" => $itens, "coluna" => $coluna]);
    } catch (PDOException $e) {
        // Em caso de erro, imprimir mensagem de erro
        echo json_encode(["success" => false, "message" => "Erro ao listar itens: " . $e->getMessage()]);
    }
}

function removerItensSelecionados($tipoTabela, $ids) {
    $conexao = conBlq(); // Conectar ao banco de dados

    try {
        // Preparar a consulta SQL para remover os itens com base no tipo de tabela e IDs
        $stmt = $conexao->prepare("DELETE FROM $tipoTabela WHERE id IN (" . implode(',', array_fill(0, count($ids), '?')) . ")");
        
        // Executar a consulta, passando os IDs como parâmetros
        $stmt->execute($ids);

        // Retornar uma mensagem de sucesso
        return ["success" => true, "message" => "Itens removidos com sucesso."];
    } catch (PDOException $e) {
        // Em caso de erro, retornar uma mensagem de erro
        return ["success" => false, "message" => "Erro ao remover itens: " . $e->getMessage()];
    }
}

function removerTodosOsItens($tipoTabela) {
    // Lógica para remover todos os itens da tabela especificada
    // Certifique-se de implementar essa lógica de acordo com a estrutura do seu banco de dados
    // Exemplo:
    $conexao = conBlq();

    try {
        $stmt = $conexao->prepare("DELETE FROM $tipoTabela");
        $stmt->execute();

        echo json_encode(["success" => true, "message" => "Todos os itens da tabela $tipoTabela foram removidos com sucesso."]);
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => "Erro ao remover itens da tabela $tipoTabela: " . $e->getMessage()]);
    }
}
function buscarNumeros($termoBusca) {
    // Conectar ao banco de dados
    $conexao = conNum(); // Implemente a função conDb() conforme necessário

    // Preparar a consulta SQL para buscar numeros com base no termo de busca e na coluna especificada
    $sql = "SELECT * FROM numeros WHERE ";
    $colunas = ['numero_comcod', 'numero_semcod', 'nome', 'col4', 'col5', 'col6'];
	 
	 // Adicionar cada coluna à condição WHERE
    foreach ($colunas as $coluna) {
        $sql .= "$coluna LIKE '%$termoBusca%' OR ";
    }

    // Remover o último "OR" da condição WHERE
    $sql = rtrim($sql, 'OR ');
	
    try {
        // Executar a consulta SQL
        $resultado = $conexao->query($sql);

        // Verificar se há resultados
        if ($resultado !== false) {
            // Array para armazenar os resultados da busca
            $numeros = $resultado->fetchAll(PDO::FETCH_ASSOC);

            // Responder com os numeros encontrados
            echo json_encode(array("success" => true, "numeros" => $numeros));
        } else {
            // Se não houver numero correspondentes, responder com uma mensagem de erro
            echo json_encode(array("success" => false, "message" => "Nenhum numero encontrado."));
        }
    } catch (Exception $e) {
        // Se ocorrer uma exceção, responder com uma mensagem de erro
        echo json_encode(array("success" => false, "message" => "Erro ao buscar numeros: " . $e->getMessage()));
    }

    // Fechar a conexão com o banco de dados
    $conexao = null;
}

function buscarEmails($termoBusca) {
    // Conectar ao banco de dados
    $conexao = conMail(); // Implemente a função conDb() conforme necessário

    // Preparar a consulta SQL para buscar emails com base no termo de busca e na coluna especificada
    $sql = "SELECT * FROM emails WHERE ";
    $colunas = ['email', 'hash', 'nome', 'col4', 'col5', 'col6'];
	 
	 // Adicionar cada coluna à condição WHERE
    foreach ($colunas as $coluna) {
        $sql .= "$coluna LIKE '%$termoBusca%' OR ";
    }

    // Remover o último "OR" da condição WHERE
    $sql = rtrim($sql, 'OR ');
	
    try {
        // Executar a consulta SQL
        $resultado = $conexao->query($sql);

        // Verificar se há resultados
        if ($resultado !== false) {
            // Array para armazenar os resultados da busca
            $emails = $resultado->fetchAll(PDO::FETCH_ASSOC);

            // Responder com os emails encontrados
            echo json_encode(array("success" => true, "emails" => $emails));
        } else {
            // Se não houver numero correspondentes, responder com uma mensagem de erro
            echo json_encode(array("success" => false, "message" => "Nenhum numero encontrado."));
        }
    } catch (Exception $e) {
        // Se ocorrer uma exceção, responder com uma mensagem de erro
        echo json_encode(array("success" => false, "message" => "Erro ao buscar emails: " . $e->getMessage()));
    }

    // Fechar a conexão com o banco de dados
    $conexao = null;
}


// Função para buscar itens no banco de dados com base no termo de busca, tipo de tabela e coluna
function buscarItens($termoBusca, $tipoTabela, $coluna) {
    // Conectar ao banco de dados
    $conexao = conBlq(); // Implemente a função conDb() conforme necessário

    // Preparar a consulta SQL para buscar itens com base no termo de busca e na coluna especificada
    $sql = "SELECT * FROM $tipoTabela WHERE $coluna LIKE '%$termoBusca%'";

    try {
        // Executar a consulta SQL
        $resultado = $conexao->query($sql);

        // Verificar se há resultados
        if ($resultado !== false) {
            // Array para armazenar os resultados da busca
            $itens = $resultado->fetchAll(PDO::FETCH_ASSOC);

            // Responder com os itens encontrados
            echo json_encode(array("success" => true, "itens" => $itens));
        } else {
            // Se não houver itens correspondentes, responder com uma mensagem de erro
            echo json_encode(array("success" => false, "message" => "Nenhum item encontrado."));
        }
    } catch (Exception $e) {
        // Se ocorrer uma exceção, responder com uma mensagem de erro
        echo json_encode(array("success" => false, "message" => "Erro ao buscar itens: " . $e->getMessage()));
    }

    // Fechar a conexão com o banco de dados
    $conexao = null;
}

function obterPaisesPorRegiao($regiao) {
    $db = conBlq(); 
    $countries = [];
    $stmt = $db->prepare('SELECT pais FROM paises WHERE regiao = :regiao');
    $stmt->bindValue(':regiao', $regiao, PDO::PARAM_STR);   
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $countries[] = $row['pais'];
    }
    return $countries;
}


// Verificar se a ação é para atualizar as configurações no banco de dados
if (isset($_POST['action'])) {
    switch ($_POST['action']) {
		
        case 'atualizarConfiguracoes':
            // Verificar se foi enviada uma configuração
            if (isset($_POST['config']) && isset($_POST['valor'])) {
                // Obter o campo e o valor da configuração enviada
                $config = $_POST['config'];
                $valor = $_POST['valor'];
                // Atualizar a configuração no banco de dados
                if (atualizarConfiguracao($config, $valor)) {
                    echo json_encode(["success" => true, "message" => "Configuração atualizada com sucesso!"]);
                } else {
                    echo json_encode(["success" => false, "message" => "Erro ao atualizar configuração."]);
                }
            } else {
                echo json_encode(["success" => false, "message" => "Nenhuma configuração enviada."]);
            }
            break;

        case 'carregarConfiguracoes':
            // Se a ação for para carregar as configurações do banco de dados
            carregarConfiguracoes();
            break;


        case 'adicionarNumeros':
            // Se a ação for para adicionar números ao banco de dados
            if (isset($_POST['numeros'])) {
                // Obter os números enviados
                $numeros = $_POST['numeros'];
                // Adicionar os números ao banco de dados
                if (adicionarNumeros($numeros)) {
                    echo json_encode(["success" => true, "message" => "Números adicionados com sucesso!"]);
                } else {
                    echo json_encode(["success" => false, "message" => "Erro ao adicionar números."]);
                }
            } else {
                echo json_encode(["success" => false, "message" => "Nenhum número enviado."]);
            }
            break;

  
        case 'listarNumeros':
            // Se a ação for para listar os números do banco de dados
            listarNumeros();
            break;

        case 'listarEmails':
            // Se a ação for para listar os números do banco de dados
            listarEmails();
            break;
			
        case 'removerNumSelecionados':
            if (isset($_POST['ids'])) {
                $ids = $_POST['ids'];
                $conexao = conNum();
                $stmt = $conexao->prepare("DELETE FROM numeros WHERE id IN (" . implode(',', array_fill(0, count($ids), '?')) . ")");
                // Passar os IDs como parâmetros
                $stmt->execute($ids);
                echo json_encode(["success" => true, "message" => "Itens selecionados removidos com sucesso."]);
            } else {
                echo json_encode(["success" => false, "message" => "Nenhum ID enviado."]);
            }
            break;

        case 'removerTodosOsNumeros':
            $conexao = conNum();
            $stmt = $conexao->prepare("DELETE FROM numeros");
            $stmt->execute();
            echo json_encode(["success" => true, "message" => "Todos os números foram removidos com sucesso."]);
            break;

        case 'importarNumeros':
            if (isset($_POST['dados'])) {
                $dados = $_POST['dados'];
                
                // Inserir os dados diretamente no banco de dados
                importarNumeros($dados);

                echo json_encode(["success" => true, "message" => "Dados importados com sucesso."]);
            } else {
                echo json_encode(["success" => false, "message" => "Dados ausentes."]);
            }
            break;
case 'buscarNumeros':
    $termoBusca = isset($_POST['termoBusca']) ? $_POST['termoBusca'] : '';

    // Verificar se o termo de busca não está vazio
    if (!empty($termoBusca)) {
        // Chamar a função buscarNumeros com o termo de busca especificado
        buscarNumeros($termoBusca);
    } else {
        // Retornar uma resposta de erro se o termo de busca estiver vazio
        echo json_encode(["success" => false, "message" => "Termo de busca vazio."]);
    }
    break;
	 case 'adicionarEmails':
            // Se a ação for para adicionar emails ao banco de dados
            if (isset($_POST['emails'])) {
                // Obter os emails enviados
                $emails = $_POST['emails'];
                // Adicionar os emails ao banco de dados
                if (adicionarEmails($emails)) {
                    echo json_encode(["success" => true, "message" => "Emails adicionados com sucesso!"]);
                } else {
                    echo json_encode(["success" => false, "message" => "Erro ao adicionar emails."]);
                }
            } else {
                echo json_encode(["success" => false, "message" => "Nenhum email enviado."]);
            }
            break;
	        case 'importarEmails':
            if (isset($_POST['dados'])) {
                $dados = $_POST['dados'];
                
                // Inserir os dados diretamente no banco de dados
                importarEmails($dados);

                echo json_encode(["success" => true, "message" => "Dados importados com sucesso."]);
            } else {
                echo json_encode(["success" => false, "message" => "Dados ausentes."]);
            }
            break;
	  case 'removerMailSelecionados':
            if (isset($_POST['ids'])) {
                $ids = $_POST['ids'];
                $conexao = conMail();
                $stmt = $conexao->prepare("DELETE FROM emails WHERE id IN (" . implode(',', array_fill(0, count($ids), '?')) . ")");
                // Passar os IDs como parâmetros
                $stmt->execute($ids);
                echo json_encode(["success" => true, "message" => "Itens selecionados removidos com sucesso."]);
            } else {
                echo json_encode(["success" => false, "message" => "Nenhum ID enviado."]);
            }
            break;
			 case 'removerTodosOsMails':
            $conexao = conMail();
            $stmt = $conexao->prepare("DELETE FROM emails");
            $stmt->execute();
            echo json_encode(["success" => true, "message" => "Todos os números foram removidos com sucesso."]);
            break;
	case 'buscarEmails':
    $termoBusca = isset($_POST['termoBusca']) ? $_POST['termoBusca'] : '';

    // Verificar se o termo de busca não está vazio
    if (!empty($termoBusca)) {
        // Chamar a função buscarEmails com o termo de busca especificado
        buscarEmails($termoBusca);
    } else {
        // Retornar uma resposta de erro se o termo de busca estiver vazio
        echo json_encode(["success" => false, "message" => "Termo de busca vazio."]);
    }
    break;
	case 'adicionarItem':
    $tabela = isset($_POST['tabela']) ? $_POST['tabela'] : null;
    $coluna = isset($_POST['coluna']) ? $_POST['coluna'] : null;
    $itens = isset($_POST['itens']) ? $_POST['itens'] : null;
    if ($tabela && $coluna && $itens) {
        adicionarItem($tabela, $coluna, $itens);
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => 'Parâmetros insuficientes para adicionar itens.']);
    }
    break;


case 'listarItens':
    $tabela = isset($_POST['tabela']) ? $_POST['tabela'] : '';
    $coluna = isset($_POST['coluna']) ? $_POST['coluna'] : '';

    // Executar a função listarItens com a tabela e a coluna especificadas
    if (!empty($tabela) && !empty($coluna)) {
        listarItens($tabela, $coluna);
    } else {
        // Retornar uma resposta de erro se a tabela ou a coluna estiverem vazias
        echo json_encode(["success" => false, "message" => "Tabela ou coluna não especificada."]);
    }
    break;

case 'removerItensSelecionados':
    $tipoTabela = isset($_POST['tipoTabela']) ? $_POST['tipoTabela'] : '';
    $ids = isset($_POST['ids']) ? $_POST['ids'] : [];

    // Executar a função para remover os itens selecionados
    if (!empty($tipoTabela) && !empty($ids)) {
        $resultado = removerItensSelecionados($tipoTabela, $ids);
        echo json_encode($resultado);
    } else {
        // Se os parâmetros estiverem ausentes, retornar uma mensagem de erro
        echo json_encode(["success" => false, "message" => "Parâmetros ausentes para remover itens selecionados."]);
    }
    break;
 case 'removerTodosOsItens':
        $tipoTabela = isset($_POST['tipoTabela']) ? $_POST['tipoTabela'] : '';

        if (!empty($tipoTabela)) {
            removerTodosOsItens($tipoTabela);
        } else {
            echo json_encode(["success" => false, "message" => "Tipo de tabela não especificado."]);
        }
        break;

case 'buscarItens':

	$termoBusca = $_POST['termoBusca'];
    $tipoTabela = $_POST['tipoTabela'];
    $coluna = $_POST['coluna'];

    // Chamar a função buscarItens() com os parâmetros recebidos
    buscarItens($termoBusca, $tipoTabela, $coluna);
	break;
	
	case 'obterPaisesPorRegiao':
            if (isset($_POST['region'])) {
                $region = $_POST['region'];
                $paises = obterPaisesPorRegiao($region);
                echo json_encode($paises);
            } else {
                echo json_encode(['error' => 'Região não fornecida']);
            }
            break;
			
        default:
            // Se a ação especificada não for reconhecida
            if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
                echo json_encode(["success" => false, "message" => "Ação desconhecida."]);
            } else {
                echo json_encode(["success" => false, "message" => "Este arquivo só pode ser acessado via solicitações AJAX."]);
            }
            break;
    }
} else {
    // Se nenhuma ação foi especificada
    if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
        echo json_encode(["success" => false, "message" => "Nenhuma ação especificada."]);
    } else {
        echo json_encode(["success" => false, "message" => "Este arquivo só pode ser acessado via solicitações AJAX."]);
    }
}

?>
