


<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width">
        <title>Liquiloan | Capacitando Futuros Financeiros: Apresentando Serviços Abrangentes de Estratégia e Planejamento Financeiro Liquiloan</title>
        <link href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Viaoda+Libre&display=swap" rel="stylesheet">
        
        <meta property="og:title" content="Liquiloan | Capacitando Futuros Financeiros: Apresentando Serviços Abrangentes de Estratégia e Planejamento Financeiro Liquiloan" />
        <meta property="og:image" content="665e086661fb5-7084856-portrait.jpeg"/>
        
        <meta property="og:description" content="A Liquiloan é uma fornecedora líder de serviços abrangentes de planejamento e estratégia financeira..">
        <meta name="description" content="A Liquiloan é uma fornecedora líder de serviços abrangentes de planejamento e estratégia financeira..">
        <meta name="twitter:title" content="Liquiloan | Capacitando Futuros Financeiros: Apresentando Serviços Abrangentes de Estratégia e Planejamento Financeiro Liquiloan">
        <meta name="twitter:image:src" content="665e086661fb5-7084856-portrait.jpeg"/>

        <link rel="stylesheet" href="main/style/bootstrap.css">
        <link rel="stylesheet" href="main/style/bootstrap-icons.css">
        <link rel="stylesheet" href="main/style/jquery.fancybox.css">
        <link rel="stylesheet" href="main/style/animate.min.css">
        <script src="main/jscript/jquery-3.7.1.min.js"></script>
        <script src="main/jscript/wow.min.js"> </script>

        
        
        <link rel="shortcut icon" href="brandLogo.svg" type="image/x-icon">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        
        <style>


            body{
                direction: ltr;
                font-family: 'Roboto Condensed', sans-serif !important;
                font-size: 17px;
                margin: 0;
                padding: 0px;
                color: #727272;
                background-color: #3B0944;
                position: relative;
            }

            a {
                text-decoration: none;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
                margin-top: 0;
                margin-bottom: 0;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
            color: #081828;
            }

            ul {
                padding-left: 0;
                margin-top: 0;
                margin-bottom: 0;
                list-style: none;
                padding-inline-start: 0;
            }

            img {
                display: block;
            }

            .no-scroll {
            overflow-y: hidden;
            }

            .link {
                text-decoration: none;
            }

            .link:hover,
            .link:focus {
                color: inherit;
                cursor: pointer;
            }

            .title {
                font-size: 30px;
                color: var(--text-sec-color);
                font-weight: 700;
                line-height: 1.2;
                text-align: center;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                .title {
                    font-size: 45px;
                }
            }

            .sub-title {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                .sub-title {
                    font-size: 18px;
                }
            }

            .main-btn {
                font-size: 16px;
                line-height: 1.5;
                font-weight: 600;
                padding: 12px;
                --bs-bg-opacity: 1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-sec-color);
                display: block;
                text-align: center;
                border: none;
            }

            .main-btn:hover,
            .main-btn:focus {
                --bs-bg-opacity: 0.8;
                color: var(--text-sec-color);
            }

            :root {
              --brand-color: #009500;
              --brand-color-rgb: 0;
              --text-color: rgb(149, 156, 177);
              --text-sec-color: #ffffff;
            }
           
            header .container-sp,
            section .container-sp,
            footer .container-sp {
                padding-left: 12px;
                padding-right: 12px;
                margin-left: auto;
                margin-right: auto;
                max-width: 1200px !important;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                section .container-sp {
                    padding-left: 15px;
                    padding-right: 15px;
                }
            }

            @media screen and (min-width: 992px) {
                section .container-sp {
                    padding-left: 19px;
                    padding-right: 19px;
                }
            }

            .header-sp {
                position: absolute;
                z-index: 10;
                width: 100%;
                background-color: transparent;
            }

            .nav-inner-sp {
                display: flex;
                align-items: center;
                justify-content: space-between;
                gap: 30px;
            }

            @media screen and (min-width: 992px) {
                .nav-inner-sp {
                    padding: 0 15px;
                }
            }

            .logo-link-sp {
                color: #ffffff;
                display: flex;
                align-items: center;
                gap: 10px;
                font-size: 24px;
                line-height: 1.1;
                padding: 2rem 0;
            }

            @media screen and (min-width: 576px) {
                .logo-link-sp {
                    font-size: 30px;
                }
            }

            @media screen and (min-width: 992px) {
                .logo-link-sp {
                    font-size: 32px;
                }
            }

            .logo-link-sp:hover {
                color: #ffffff;
            }

            .logo-link-sp__img {
                height: 24px;
            }

            @media screen and (min-width: 576px) {
                .logo-link-sp__img {
                    height: 30px;
                }
            }

            @media screen and (min-width: 992px) {
                .logo-link-sp__img {
                    height: 34px;
                }
            }

            .menu-btn-sp {
                padding: 6px 12px;
                width: 30px;
                height: 30px;
                position: relative;
                z-index:2;
                overflow: hidden;
                border: none;
                background-color: transparent;
            }

            @media screen and (min-width: 992px) {
                .menu-btn-sp {
                    display: none;
                }
            }

            .menu-btn-sp span {
                width: 30px;
                height: 2px;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background-color: #ffffff;
                transition: all 0.5s;
            }

            .menu-btn-sp span:nth-of-type(2) {
                top: calc(50% - 5px);
            }
            .menu-btn-sp span:nth-of-type(3) {
                top: calc(50% + 5px);
            }
          
            .menu-btn-sp.active span:nth-of-type(1) {
                display: none;
            }

            .menu-btn-sp.active span:nth-of-type(2) {
                top: 50%;
                transform: translate(-50%, 0%) rotate(45deg);  
            }

            .menu-btn-sp.active span:nth-of-type(3) {
                top: 50%;
                transform: translate(-50%, 0%) rotate(-45deg); 
            }

            .span-btn {
                width: 30px;
                height: 2px;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background-color: white;
                transition: all 0.5s;
            }

            .menu-btn span:nth-of-type(2) {
                top: calc(50% - 10px);
            }

            .menu-btn span:nth-of-type(3) {
                top: calc(50% + 10px);
            }

            .menu-btn.active span:nth-of-type(1) {
                display: none;
            }

            .menu-btn.active span:nth-of-type(2) {
                top: 50%;
                background-color:  white;
                transform: translate(-50%, 0%) rotate(45deg);
            }

            .menu-btn.active span:nth-of-type(3) {
                top: 50%;
                background-color:  white;
                transform: translate(-50%, 0%) rotate(-45deg);
            }
 
            .mob-menu-sp {
                display: none;
                position: absolute;
                top: 88px !important;
                width: 60%;
                --bs-bg-opacity: 0.95;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                z-index: 9;
                box-shadow: 0px 15px 20px 0px rgba(0, 0, 0, 0.1);
                padding: 10px 20px;
                max-height: 350px;
                overflow-y: scroll;
                border-radius: 6px;
                transform: translateX(-100%);
	            transition: transform 0.5s; 
            }

            .mob-menu-sp.active {
                display: block;
                transform: translateX(0);
            }

            .mob-menu-sp li {
                list-style-type: none;
            }

            .mob-nav-bar-sp {
                display: flex;
                flex-direction: column;
                padding-left: 0;
                list-style: none;
            }

            .mob-nav-bar-sp__list a {
                padding: 12px 16px !important;
                color: #ffffff;
                display: block;
            }
            .mob-nav-bar-sp__item {
                position: relative;
            } 

            @media screen and (min-width: 992px) {
                .menu-btn-sp {
                    display: none;
                }
            }

            .is-hidden {
                display: none;
            }

            @media screen and (max-width: 991px) {
                .nav-bar-sp {
                    display: none;
                }
            }

            .nav-bar-sp__list {
                display: flex;
                gap: 47px;
                padding: 35px 0;
            }

            .nav-bar-sp__link {
                color: #ffffff;
                text-align: center;
            }

            .nav-bar-sp__link:hover,
            .header-sp.active .nav-bar-sp__link:hover {
                color: var(--text-color);
            } 

            .header-sp.active {
                --bs-bg-opacity: 0.2;
                background-color: rgba(var(--brand-color-rgb), var(--bs-bg-opacity)) !important;
                position: fixed;
                backdrop-filter: blur(5px);
                box-shadow: inset 0 -1px 0 0 rgba(0, 0, 0, 0.1);
            }

            .header-sp.active .nav-bar-sp__list {
                padding: 24px 0;
            }

            .hero-area-sp {
                position: relative;
                background-image: linear-gradient(to right, rgba(47, 48, 58, 0.4), rgba(47, 48, 58, 0.4)), url("album/depictions_header_665e085f0656e6.97491084.jpg");
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                background-color: #081828;
                z-index: 0;
                padding-top: 210px;
                padding-bottom: 200px;
                overflow: hidden;
            }

            .hero-bg-el-1 {
                position: absolute;
                right: 0;
                top: 0;
            }

            .hero-bg-el-2 {
                position: absolute;
                left: 0;
                bottom: 0;
            }

            .hero-inner-sp {
                margin-right: auto;
                margin-left: auto;
                text-align: center;
                position: relative;
                z-index: 5;
            }

            @media screen and (min-width: 575px) {
                .hero-inner-sp {
                    max-width: 80%;
                }
            }

            @media screen and (min-width: 992px) {
                .hero-inner-sp {
                    max-width: 60%;
                }
            }

            .welcome-title-sp {
                text-align: center;
                font-size: 20px;
                line-height: 1.625;
                margin-bottom: 48px;
                color: var(--text-sec-color);
                font-weight: 500;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 575px) {
                .welcome-title-sp {
                    font-size: 22px;
                }
            }

            @media screen and (min-width: 992px) {
                .welcome-title-sp {
                    font-size: 24px;
                }
            }

            .welcome-btn-sp {
                padding: 16px 32px;
                background-color: var(--brand-color);
                color: var(--text-sec-color);
                font-size: 14px;
                line-height: 1.5;
                font-weight: 600;
                border-radius: 6px;
                transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
                transition-duration: 300ms;
                visibility: visible;
                animation-delay: 0.4s;
            }

            @media screen and (min-width: 575px) {
                .welcome-btn-sp {
                    font-size: 16px;
                }
            }

            .welcome-btn-sp:hover,
            .welcome-btn-sp:focus {
                background-color: #009500cc;
                color: var(--text-sec-color);
            }

            .features-sp {
                padding-top: 80px;
                padding-bottom: 30px;
                --bs-bg-opacity: 0.1;
                background-color: rgba(var(--brand-color-rgb), var(--bs-bg-opacity));
            }

            @media screen and (min-width: 575px) {
                .features-sp {
                padding-top: 80px;
                padding-bottom: 50px;
                }
            }

            .features-sp-title {
                margin-bottom: 30px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .marg {
                margin-bottom: 80px;
                text-align: center;
                visibility: visible;
                animation-delay: 0.2s;
            }
            
            .features-sp-list {
                display: flex;
                flex-direction: column;
                gap: 40px;
                margin-bottom: 40px;
            }

            @media screen and (min-width: 575px) {
                .features-sp-list {
                    display: flex;
                    flex-direction: row;
                    flex-wrap: wrap;
                    gap: 40px;
                    margin-bottom: 40px;
                }
            }

            .features-sp-it {
                display: flex;
                width: 100%;
                gap: 20px;
                padding: 0 10px;
                visibility: visible;
                animation-delay: 0.15s;
            }

            @media screen and (min-width: 575px) {
                .features-sp-it {
                    display: flex;
                    flex-basis: calc(100% / 2 - 20px);
                    gap: 20px;
                    padding: 0;
                }
            }

            .features-sp-ic__wr {
                width: 70px;
                height: 70px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 15px;
                color: var(--brand-color);
            }
            
            .features-sp-item__text {
                color: var(--text-color);
            }

            .conclusion {
                margin-top: 50px;
                text-align: center;
                border-top: solid 1px;
                border-bottom: solid 1px;
                border-color: #ffffff1a;
                padding: 20px;
            }

            .main-sp {
                padding: 100px 0;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
            }

            @media screen and (min-width: 575px) {
                .main-sp {
                    padding: 60px 0;
                }
            }

            .main-sp-img {
                width: 100%;
                border-radius: 6px;
            }

            .main-sp-img-wraper {
                width: 80%;
                margin-right: auto;
                margin-left: auto;
                margin-bottom: 40px;
                border-radius: 6px;
                --bs-shadow-opacity-4: 0.4;
                --bs-shadow-opacity-3: 0.3;
                --bs-shadow-opacity-2: 0.2;
                --bs-shadow-opacity-1: 0.1;
                --bs-shadow-opacity-5: 0.05;
                box-shadow: rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-4)) -5px 5px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-3)) -10px 10px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-2)) -15px 15px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-1)) -20px 20px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-5)) -25px 25px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .main-sp-text {
                margin-top: 32px;
                color: var(--text-color);
                font-size: 15px;
            }

            @media screen and (min-width: 575px) and (max-width: 991px) {
                .main-sp-text {
                    font-size: 16px;
                    padding: 0 15px;
                }
            }

            .main-sp-text h5 {
                color: var(--text-color);
                text-align: center;
            }

            .main-sp-text ul {
                margin-bottom: 16px;
                padding-left: 30px;
                list-style: circle;
                padding-inline-start: 35px;
            }

            .main-sp-price-wrap {
                text-align: center;
            }

            .main-sp-price {
                font-size: 20px;
                display: inline-block;
                padding: 12px 48px;
                margin-top: 32px;
                box-shadow: rgba(0, 0, 0, 0.2) 0px 20px 30px;
            }

            @media screen and (min-width: 575px) {
                .main-sp-price {
                    font-size: 24px;
                }
            }

            .video-sp {
                padding: 120px 0;
                position: relative;
            }

            @media screen and (min-width: 575px) {
                .video-sp {
                    padding: 60px 0;
                }
            }

            .video-bg {
                position: absolute;
                bottom: 0;
                left: 0;
                max-width: 100%;
            }

            .inner-content-sp {
                text-align: center;
            }

            .video-title-wraper-sp {
                margin-bottom: 80px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .intro-video-play-sp {
                position: relative;
                border-radius: 6px;
                max-width: 770px;
                margin-left: auto;
                margin-right: auto;
                visibility: visible;
                animation-delay: 0.2s;
            }
                .intro-video-play-sp video {
                    height: 350px;
                }
                @media (max-width: 680px) {
                    .intro-video-play-sp video {
                    height: 150px;
                }
                }
            .intro-video-sp__img {
                width: 100%;
                height: auto;
                border-radius: 6px;

            }

            .play-thumb-sp {
                position: absolute;
                right: 0;
                top: 0;
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
                height: 100%;
            }

            .play-btn-sp {
                --bs-bg-opacity: 0.75;
                background-color: rgb(255 255 255 / var(--bs-bg-opacity));
                border-radius: 50%;
                text-align: center;
                width: 70px;
                height: 70px;
                border: none;
            }

            .play-btn-sp:hover, 
            .play-btn-sp:focus {
                --bs-bg-opacity: 1;
                background-color: rgb(255 255 255 / var(--bs-bg-opacity));
            }

            .bi-play-fill {
                font-size: 26px;
                line-height: 1;
                color: var(--brand-color); 
            }

            .backdrop {
                position: fixed;
                top: 0;
                left: 0;
                z-index: 11;
                width: 100vw;
                height: 100vh;
                background-color: rgba(0, 0, 0, 0.95);
                transition: opacity 250ms cubic-bezier(0.4, 0, 0.2, 1), visibility 250ms cubic-bezier(0.4, 0, 0.2, 1);
            }

            .backdrop.is-hidden {
                opacity: 0;
                pointer-events: none;
                visibility: hidden;
            }

            .modal-btn {
                position: absolute;
                top: 8px;
                right: 8px;
                display: flex;
                justify-content: center;
                align-items: center;
                padding: 0;
                background-color: transparent;
                border: 1px solid rgba(0, 0, 0, 0.1);
                transition: fill 250ms cubic-bezier(0.4, 0, 0.2, 1);
            }

            .modal-btn:hover svg,
            .modal-btn:focus svg {
                transform: scale(1.1);
                cursor: pointer;
            }

            .modal-btn svg {
                fill:#ffffff;
            }

            .video-wraper {
                width: 90vw;
                height: auto;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
            }

            @media screen and (min-width: 992px) {
                .video-wraper {
                    max-width: 70%;
                }
            }

            .video-wraper video {
                width: 100%;
            }

            .partners {
                padding: 64px 0;
            }

            @media screen and (min-width: 576px) {
                .partners {
                    padding: 64px;
                }
            }
            @media screen and (min-width: 992px) {
                .partners {
                    padding: 64px;
                }
            }

            .partners-wraper {
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 60px 20px;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 576px) {
                .partners-wraper {
                    padding: 60px 40px;
                }
            }

            @media screen and (min-width: 992px) {
                .partners-wraper {
                    padding: 60px 50px;
                }
            }

            .partners-list {
                display: flex;
                flex-direction: column-reverse;
                justify-content: center;
                align-items: center;
            }

            @media screen and (min-width: 576px) {
                .partners-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                    gap: 20px;
                }
            }

            @media screen and (min-width: 992px) {
                .partners-list {
                    flex-wrap: nowrap;
                }
            }

            .partners-item {
                flex-basis: calc(100% / 5 - 30px);
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .partners-link {
                height: 150px;
                cursor: auto;
                display: block;
                width: 100%;
                padding: 15px 0;
            }

            .partners-link img {
                object-fit: contain;
                margin-left: auto;
                margin-right: auto;
            }

            .greyscale {
                --bs-grayscale: grayscale(100%);
                filter: var(--bs-grayscale);
            }

            .greyscale:hover,
            .greyscale:focus {
                --bs-grayscale: grayscale(0%);
            }

            .comments-sp {
                position: relative;
                padding-bottom: 50px;
                padding-top: 80px;
                --bs-bg-opacity: 0.03;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
            }

            @media screen and (min-width: 576px) {
                .comments-sp {
                    padding-bottom: 80px;
                    padding-top: 120px;
                }
            }

            .comments-sp-header {
                visibility: visible;
                animation-delay: 0.2s;
            }
            .comments-sp-header__text {
                margin-top: 16px;
                margin-bottom: 60px;
                text-align: center;
            }

            .comments-sp-wraper {
                visibility: visible;
                animation-delay: 0.4s;
            }

            .comments-sp-list {
                display: flex;
                flex-direction: column-reverse;
                gap: 32px;
                justify-content: center;
            }

            @media screen and (min-width: 576px) {
                .comments-sp-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                }
            }

            @media screen and (min-width: 992px) {
                .comments-sp-list {
                    flex-wrap: nowrap;
                }
            }

            .comments-sp-item {
                width: 100%;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 16px;
                display: flex;
            }

            @media screen and (min-width: 576px) {
                .comments-sp-item {
                    flex-basis: calc(100% / 2 - 16px);
                    padding: 32px;
                }
            }

            @media screen and (min-width: 992px) {
                .comments-sp-item {
                    flex-basis: calc(100% / 3 - 16px);
                }
            }

            .comments-sp-item-stars {
                display: flex;
                align-items: center;
                padding-bottom: 20px;
            }
            
            .comments-star {
                margin-right: 4px;
                fill: #fbb040;
            }

            .comments-sp-text {
                color: var(--text-sec-color);
                font-size: 16px;
                line-height: 26px;
                margin-bottom: 0;
            }

            .comments-sp-author {
                display: flex;
                justify-content: flex-start;
                align-items: center;
                gap: 16px;
                border-color: #ffffff1a;
            }

            .comments-sp-avatar {
                display: block;
                border-radius: 50;
                width: 50px;
                height: 50px;
            }

            .comments-sp-name {
                font-size: 18px;
                color: var(--text-sec-color);
                line-height: 28px;
                font-weight: 600;
                margin-bottom: 4px;
            }

            .comments-sp-position {
                color: var(--text-color);
                font-size: 14px;
                margin-bottom: 0;
            }

            .comments-dec1 {
                position: absolute;
                top: 20px;
                right: 0;
                z-index: -1;
            }

            .comments-dec2 {
                position: absolute;
                bottom: 20px;
                left: 0;
                z-index: -1;
            }

            .tarifs-sp {
                position: relative;
                padding-top: 120px;
                padding-bottom: 80px;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp {
                    padding-top: 80px;
                    padding-bottom: 50px;
                }
            }

            .tarifs-sp-list {
                display: flex;
                flex-direction: column-reverse;
                gap: 16px;
                visibility: visible;
                animation-delay: 0.2s;
                justify-content: center;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                    gap: 32px;
                }
            }

            @media screen and (min-width: 992px) {
                .tarifs-sp-list {
                    flex-wrap: nowrap;
                    gap: 32px;
                }
            }

            .tarifs-sp-item {
                position: relative;
                width: 100%;
                padding: 40px 32px;
                border-radius: 6px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                display: flex;
                flex-direction: column;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp-item {
                    flex-basis: calc(100% / 2 - 16px);
                }
            }

            @media screen and (min-width: 992px) {
                .tarifs-sp-item {
                    flex-basis: calc(100% / 3 - 16px);
                }
            }

            .tarifs-sp-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .tarifs-sp-price {
                font-size: 20px;
                line-height: 1.2;
                font-weight: 700;
                color: var(--text-sec-color);
            }

            .tarifs-sp-price span {
                color: var(--text-color);
                text-transform: lowercase;
            }

            .tarifs-sp-title {
                font-size: 20px;
                line-height: 1.4;
                font-weight: 700;
                color: var(--text-sec-color);
                text-align: end;
            }

            .tarifs-sp-middle {
                padding-bottom: 32px;
                margin: 32px 0;
                border-bottom: solid 1px;
                border-color: #ffffff1a;
            }

            .tarifs-sp-link {
                font-size: 16px;
                line-height: 1.5;
                font-weight: 600;
                padding: 12px;
                --bs-bg-opacity: 1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-sec-color);
                display: block;
                text-align: center;
            }

            .tarifs-sp-link:hover,
            .tarifs-sp-link:focus {
                --bs-bg-opacity: 0.8;
                color: var(--text-sec-color);
            }

            .tarifs-sp-details-list {
                display: flex;
                flex-direction: column;
                gap: 12px;
            }

            .tarifs-sp-details-item {
                display: flex;
                align-items: center;
            }

            .tarifs-sp-details-item p {
                margin-bottom: 0;
                color: var(--text-color);
                font-size: 16px;
            }

            .tarifs-sp-details-item .prev-details {
                text-align: center;
                color: #ffffff;
                margin-left: 20px;
            }

            .tarifs-sp-details-on {
                position: relative;
                border-radius: 50%;
                min-width: 18px;
                height: 18px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                margin-right: 12px;
            }

            .tarifs-sp-details-on i {
                position: absolute;
                font-size: 18px;
                --bs-text-opacity: 1;
                color: rgb(var(--brand-color-rgb) / var(--bs-text-opacity));
                text-align: center;
                line-height: 0.7;
            }

            .tarifs-sp-item-dec {
                position: absolute;
                right: 0;
                bottom: 0;
                z-index: -1;
            }

            .tarifs-sp-dec {
                position: absolute;
                left: 0;
                bottom: 0;
                z-index: -1;
            }

            .forms {
                padding-top: 120px;
                padding-bottom: 80px;
            }

            @media screen and (min-width: 576px) {
                .forms {
                    padding-top: 80px;
                    padding-bottom: 50px;
                }
            }

            .forms .container-sp {
                display: flex;
                flex-direction: column;
                gap: 32px;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 992px) {
                .forms .container-sp {
                    flex-direction: row;
                }
            }

            .form-sp-wrap {
                width: 100%;
                padding: 44px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
            }

            @media screen and (min-width: 576px) {
                .form-sp-wrap {
                    width: 100%;
                    max-width: 688px;
                    padding: 55px;
                    margin-left: auto;
                    margin-right: auto;
                }
            }

            @media screen and (min-width: 992px) {
                .form-sp-wrap {
                    max-width: 66.66%;
                }
            }

            .form-sp {
                display: flex;
                flex-direction: column;
                margin-top: 48px;
            }

            .input-f51389365,
            .textarea-f51389365 {
                display: block;
                padding: 12px 24px;
                box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
                border: solid 1px transparent;
                outline: 2px solid transparent;
                outline-offset: 2px;
                --bs-bg-opacity: 0.05;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
                margin-bottom: 32px;
            }

            .input-f51389365::placeholder,
            .textarea-f51389365::placeholder {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
            }

            .textarea-f51389365 {
                display: block;
                height: 132pxpx;
                padding-top: 15px;
            }

            .input-f51389365:focus,
            .textarea-f51389365:focus {
                border-color: var(--brand-color);
                outline: none;
            }

            .form-sp label {
                color: var(--text-sec-color);
                font-size: 14px;
                line-height: 1.43;
                font-weight: 500;
                margin-bottom: 12px;
            }

            .form-sp-btn {
                padding-left: 36px;
                padding-right: 36px;
                border: none;
            }

            .form .form-sp-check-label,
            .form-sp-check-label a {
                font-size: 14px;
            }
            
            .form-sp-check-label a {
                color: var(--text-sec-color);
                font-weight: 500;
            }

            @media screen and (min-width: 375px) {
                .form-check-label a {
                    font-weight: 700;
                }
            }

            .form-sp-check-input {
                margin-top: 0;
            }

            .form-sp-check-input {
                margin-right: 15px;
            }

            .form-sp-check-label a {
                color: var(--brand-color);
            }

            .signup-sp {
                position: relative;
                width: 100%;
                padding: 60px 44px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                overflow: hidden;
            }

            @media screen and (min-width: 576px) {
                .signup-sp {
                    width: 100%;
                    max-width: 688px;
                    padding: 60px 44px;
                    margin-left: auto;
                    margin-right: auto;
                }
            }

            @media screen and (min-width: 992px) {
                .signup-sp {
                    max-width: 33.33%;
                }
            }

            .signup-only {
                max-width: 100%;
            }

            @media screen and (min-width: 576px) {
                .signup-only {
                    width: 80%;
                max-width: 500px;
                }
            }

            @media screen and (min-width: 992px) {
                .signup-only {
                max-width: 60%;
                }
            }

            .signup-sp__text {
                font-size: 20px;
                line-height: 1.25;
                color: var(--text-sec-color);
                padding-bottom: 44px;
                margin-bottom: 44px;
                border-bottom: solid 1px;
                border-color: #ffffff33;
            }

            @media screen and (min-width: 576px) {
                .signup-sp__text {
                    font-size: 24px;
                    padding-bottom: 55px;
                    margin-bottom: 55px;
                }
            }

            .signup-sp__form {
                display: flex;
                flex-direction: column;
                width: 100%;
            }

            .signup-sp__mail {
                padding: 12px 24px;
                border: none;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
                border: solid 1px #ffffff1a;
                border-radius: 6px;
                margin-bottom: 30px;
            }

            .signup-sp__mail::placeholder {
                color: var(--text-color);
            }

            .singup-sp__submit {
                padding: 12px 24px;
                width: 100%;
            }

            .signup-sp-dec1 {
                position: absolute;
                top: 0;
                left: 0;
                z-index: -1;
            }

            .signup-sp-dec2 {
                position: absolute;
                bottom: 0;
                right: 0;
                z-index: -1;
            }

            .footer-sp {
                position: relative;
                padding-top: 100px;
                padding-bottom: 60px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                visibility: visible;
                animation-delay: 0.2s;
            }

            .ftop-sp {
                display: flex;
                flex-direction: column;
                gap: 80px;
                justify-content: space-between;
            }

            @media screen and (min-width: 576px) {
                .ftop-sp {
                    flex-direction: row;
                    flex-wrap: wrap;
                    gap: 80px;
                }
            }

            @media screen and (min-width: 992px) {
                .ftop-sp {
                    flex-wrap: nowrap;
                    gap: 20px;
                }
            }

            .footer-sp-item .logo-link-sp {
                height: 28px;
            }

            .footer-sp-item {
                max-width: 100%;
            }

            @media screen and (min-width: 576px) {
                .footer-sp-item {
                    padding-left: 20px;
                    flex: 1;
                }
            }

            .footer-sp__text {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
                margin-top: 20px;
            }

            .footer-sp-title {
                font-size: 20px;
                line-height: 1.4;
                font-weight: 700;
                color: var(--text-sec-color);
                margin-bottom: 30px;
                margin-top: 25px;
            }

            .footer-sp-contacts__item {
                display: flex;
                gap: 15px;
            }

            .footer-sp-contacts__item:hover a,
            .footer-sp-contacts__item:focus a {
                color: var(--text-color);
            }

            .footer-contact {
                margin: 0;
            }

            .fbottom-pol {
                padding-top: 80px;
            }

            .fbottom-pol a {
                display: block;
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
                margin-bottom: 20px;
            }

            .footer-sp-dec1 {
                position: absolute;
                left: 0;
                bottom: 0;
                z-index: -1;
            }

            .footer-sp-dec2 {
                position: absolute;
                right: 0;
                top: 56px;
                z-index: -1;
            }

            .back-to-top {
                display: flex;
                justify-content: center;
                align-items: center;
                position: fixed;
                border: transparent;
                border-radius: 6px;
                background-color: var(--brand-color);
                cursor: pointer;
                z-index: 9999;
                font-size: 40px;
                right: 30px;
                bottom: 30px;
                border-radius: 5px;
                height: 40px;
                width: 40px;
                line-height: 25px;
                text-align: center;
                color: #ffffff;
                visibility: hidden;
            }

            .back-to-top i,
            .back-to-top i {
                font-size: 24px;
            }

            .back-to-top:hover i,
            .back-to-top:focus i {
                color: #ffffff;
            }

            .back-to-top.active {
                visibility: visible;
            }

            .visually-hidden {
                position: absolute;
                white-space: nowrap;
                width: 1px;
                height: 1px;
                overflow: hidden;
                border: 0;
                padding: 0;
                clip: rect(0 0 0 0);
                clip-path: inset(50%);
                margin: -1px;
            }

            .content-block h1,
            .content-block h2, 
            .content-block h3,
            .content-block h4 {
                color: var(--text-sec-color) !important;
            }

            @media (max-width: 767px){
                .comments-sp-list {
                    flex-direction: column !important;
                }
                .tarifs-sp-list {
                    flex-direction: column !important;
                }
        }

        @media (max-width: 1200px){

.pro-text {
 width: 80% !important;
 margin: auto;
}
 
.our-bnft-decpic img {
     width: 680px;
}


}


@media (max-width: 992px) {

 .pro-bg {
     background-size: cover !important;
 }

 .our-bnft-list {
     flex-wrap: wrap !important;
 }

 .our-bnft-item {
     width: 47% !important;
 }

 .our-bnft-title {
     padding: 25px 30px;
     width: fit-content;
     background-color: rgb(0 0 0 / 70%);
     border-radius: 15px;
 }

 .our-bnft-decpic {
     top: -60px;
 }

 .our-bnft-decpic img {
     height: 430px;
 }

 .serv-item {
     width: 45% !important;
     margin: 0 !important;
 }

 .serv-list {
     position: relative;
 }

 .packages {
     justify-content: space-around !important;
     flex-wrap: wrap;
     gap: 25px;
 }

 .tarif-pack {
     width: 45%;
 }

 .footer-head-nav a {
     font-size: 16px;
 }

 .stat-rand-item h4 {
     font-size: 14px;
 }

 .stat-rand-item {
     padding: 15px 10px;
 }

 .stat-rand-list {
     gap: 15px;
     margin-bottom: 120px;
 }

 .ques-form {
     align-items: center;
 }

 .footer-liner-block {
     flex-direction: column !important;
 }

.home-article-price {
 display: flex;
 width: fit-content;
}


.form-md-content {
 width: 80%;
}



}


@media (max-width: 767px) {

.hdr-logo-name {
 font-size: 16px;
}

.hdr-block {
 flex-direction: column !important;
}

.hdr-nav-link {
 font-size: 14px;
}

.hdr-main-title {
 font-size: 22px;
 margin-bottom: 20px;
}

.our-bnft-decpic img {
 height: 360px;
 width: 490px;
}

.our-bnft-decpic img {
 font-size: 20px;
}

.our-bnft-item {
 padding: 10px;
}

.home-article-img {
 float: none;
 width: 100%;
 margin-right: 0 ;
 margin-left: 0 ;
}

.packages {
 flex-direction: column;
}

.tarif-pack {
 width: 100%;
}

.ques-form {
 flex-direction: column;
}

.footer-conts-list {
 flex-direction: column;
}

.ques-block {
 width: 100%;
}

.stat-rand-block {
 width: 100%;
}

.footer-conts-item {
 width: 100%;
}

.form-half {
 width: 100%;
}

.footer-head-nav a {
 font-size: 14px;
}




}


@media(max-width: 576px){

 .hdr-nav-list {
     display: flex;
     flex-wrap: wrap;
     justify-content: center;
 }

 .our-bnft-decpic {
 top: -30px;
} 

.our-bnft-decpic img {
 height: 270px;
 width: 290px;
} 

.our-bnft-list {
 flex-direction: column;
}

.our-bnft-item {
 width: 100% !important;
}

.serv-img {
 display: none;
}

.serv-title-block {
 width: 100%;
}

.serv-list {
 flex-direction: column;
}

.serv-item {
 width: 100% !important;
}

.footer-head-nav {
 flex-direction: column;
 align-items: center;
}

}

             
        </style>
       
        
    </head>

    <body>
     
        <header class="header-sp header__T95SP__style">
            <div class="container-sp">
                <div class="nav-inner-sp flex-row-reverse">
                    <a class="logo-link-sp link" href="./">
                        <img class="logo-link-sp__img" src="brandLogo.svg" width="37px" alt="">Liquiloan
                    </a>
                    <button class="menu-btn-sp" type="button">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>

                    <div class="mob-menu-sp" id="mobile-menu" data-menu>
                        <nav class="mob-nav-bar-sp">
                            <ul class="mob-nav-bar-sp__list list">
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./">Página inicial</a>
                                </li>
                                
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./#comments">Comentários</a>
                                </li>
                                
                                
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./#tariffs">As nossas tarifas</a>
                                </li>
                                
                                
                            </ul>
                        </nav>
                    </div>

                    <nav class="nav-bar-sp">
                        <ul class="nav-bar-sp__list list">
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./">Página inicial</a>
                            </li>
                            
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./#comments">Comentários</a>
                            </li>
                            
                            
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./#tariffs">As nossas tarifas</a>
                            </li>
                            
                            
                        </ul>
                    </nav>
                </div>
            </div>
        </header>

       <section class="hero-area-sp btn--IudN6--style">
            <svg class="hero-bg-el-1" width="450" height="556" viewBox="0 0 450 556" fill="none" xmlns="http://www.w3.org/2000/svg">
            <circle cx="277" cy="63" r="225" fill="url(#paint0_linear_25:217)"></circle>
            <circle cx="17.9997" cy="182" r="18" fill="url(#paint1_radial_25:217)"></circle>
            <circle cx="76.9997" cy="288" r="34" fill="url(#paint2_radial_25:217)"></circle>
            <circle cx="325.486" cy="302.87" r="180" transform="rotate(-37.6852 325.486 302.87)" fill="url(#paint3_linear_25:217)"></circle>
            <circle opacity="0.8" cx="184.521" cy="315.521" r="132.862" transform="rotate(114.874 184.521 315.521)" stroke="url(#paint4_linear_25:217)"></circle>
            <circle opacity="0.8" cx="356" cy="290" r="179.5" transform="rotate(-30 356 290)" stroke="url(#paint5_linear_25:217)"></circle>
            <circle opacity="0.8" cx="191.659" cy="302.659" r="133.362" transform="rotate(133.319 191.659 302.659)" fill="url(#paint6_linear_25:217)"></circle>
            <defs>
            <linearGradient id="paint0_linear_25:217" x1="-54.5003" y1="-178" x2="222" y2="288" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            <radialGradient id="paint1_radial_25:217" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(17.9997 182) rotate(90) scale(18)">
            <stop offset="0.145833" stop-color="#009500" stop-opacity="0"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0.08"></stop>
            </radialGradient>
            <radialGradient id="paint2_radial_25:217" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(76.9997 288) rotate(90) scale(34)">
            <stop offset="0.145833" stop-color="#009500" stop-opacity="0"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0.08"></stop>
            </radialGradient>
            <linearGradient id="paint3_linear_25:217" x1="226.775" y1="-66.1548" x2="292.157" y2="351.421" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint4_linear_25:217" x1="184.521" y1="182.159" x2="184.521" y2="448.882" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint5_linear_25:217" x1="356" y1="110" x2="356" y2="470" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint6_linear_25:217" x1="118.524" y1="29.2497" x2="166.965" y2="338.63" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            </defs>
            </svg>
            <svg class="hero-bg-el-2" width="364" height="201" viewBox="0 0 364 201" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5.88928 72.3303C33.6599 66.4798 101.397 64.9086 150.178 105.427C211.155 156.076 229.59 162.093 264.333 166.607C299.076 171.12 337.718 183.657 362.889 212.24" stroke="url(#paint0_linear_25:218)"></path>
                <path d="M-22.1107 72.3303C5.65989 66.4798 73.3965 64.9086 122.178 105.427C183.155 156.076 201.59 162.093 236.333 166.607C271.076 171.12 309.718 183.657 334.889 212.24" stroke="url(#paint1_linear_25:218)"></path>
                <path d="M-53.1107 72.3303C-25.3401 66.4798 42.3965 64.9086 91.1783 105.427C152.155 156.076 170.59 162.093 205.333 166.607C240.076 171.12 278.718 183.657 303.889 212.24" stroke="url(#paint2_linear_25:218)"></path>
                <path d="M-98.1618 65.0889C-68.1416 60.0601 4.73364 60.4882 56.0734 102.431C120.248 154.86 139.905 161.419 177.137 166.956C214.37 172.493 255.575 186.165 281.856 215.481" stroke="url(#paint3_linear_25:218)"></path>
                <circle opacity="0.8" cx="214.505" cy="60.5054" r="49.7205" transform="rotate(-13.421 214.505 60.5054)" stroke="url(#paint4_linear_25:218)"></circle>
                <circle cx="220" cy="63" r="43" fill="url(#paint5_radial_25:218)"></circle>
                <defs>
                <linearGradient id="paint0_linear_25:218" x1="184.389" y1="69.2405" x2="184.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint1_linear_25:218" x1="156.389" y1="69.2405" x2="156.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint2_linear_25:218" x1="125.389" y1="69.2405" x2="125.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint3_linear_25:218" x1="93.8507" y1="67.2674" x2="89.9278" y2="210.214" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint4_linear_25:218" x1="214.505" y1="10.2849" x2="212.684" y2="99.5816" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500"></stop>
                <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                </linearGradient>
                <radialGradient id="paint5_radial_25:218" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(220 63) rotate(90) scale(43)">
                <stop offset="0.145833" stop-color="white" stop-opacity="0"></stop>
                <stop offset="1" stop-color="white" stop-opacity="0.08"></stop>
                </radialGradient>
                </defs>
                </svg>
            <div class="container-sp">
                <div class="hero-inner-sp">
                    <h2 class="welcome-title-sp">Bem-vindo ao Liquiloan! A nossa experiência e especialização são a sua chave para o sucesso financeiro. Trabalhamos para garantir que os seus fundos tragam o máximo retorno.</h2>
                    
                </div>
            </div>
       </section>
       


       <section class="features-sp">
        <div class="container-sp">
                <h2 class="features-sp-title title">As nossas vantagens</h2>
                <p class="sub-title marg">Somos especializados na prestação de serviços financeiros, apoiando a estabilidade e o crescimento dos seus ativos.</p>
            <div>
                <ul class="features-sp-list">
                    <li class="features-sp-it flex-column"> 
                        <div class="features-sp-ic__wr">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor" class="bi bi-box-fill features-sp-ic" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M15.528 2.973a.75.75 0 0 1 .472.696v8.662a.75.75 0 0 1-.472.696l-7.25 2.9a.75.75 0 0 1-.557 0l-7.25-2.9A.75.75 0 0 1 0 12.331V3.669a.75.75 0 0 1 .471-.696L7.443.184l.004-.001.274-.11a.75.75 0 0 1 .558 0l.274.11.004.001 6.971 2.789Zm-1.374.527L8 5.962 1.846 3.5 1 3.839v.4l6.5 2.6v7.922l.5.2.5-.2V6.84l6.5-2.6v-.4l-.846-.339Z"/>
                              </svg>
                        </div>
                        <p class="features-sp-item__text">Consultoria Personalizada Oferecemos soluções financeiras ajustadas especificamente às suas necessidades e objetivos.</p>
                    </li>
                    <li class="features-sp-it flex-column"> 
                        <div class="features-sp-ic__wr">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor" class="bi bi-columns-gap features-sp-ic" viewBox="0 0 16 16">
                                <path d="M6 1v3H1V1h5zM1 0a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1V1a1 1 0 0 0-1-1H1zm14 12v3h-5v-3h5zm-5-1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1h-5zM6 8v7H1V8h5zM1 7a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H1zm14-6v7h-5V1h5zm-5-1a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1V1a1 1 0 0 0-1-1h-5z"/>
                              </svg>
                        </div>
                        <p class="features-sp-item__text">Análise de Mercado Utilizamos ferramentas de análise modernas para fornecer informações precisas sobre o mercado financeiro.</p>
                    </li>
                    <li class="features-sp-it flex-column"> 
                        <div class="features-sp-ic__wr">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor" class="bi bi-briefcase-fill features-sp-ic" viewBox="0 0 16 16">
                                <path d="M6.5 1A1.5 1.5 0 0 0 5 2.5V3H1.5A1.5 1.5 0 0 0 0 4.5v1.384l7.614 2.03a1.5 1.5 0 0 0 .772 0L16 5.884V4.5A1.5 1.5 0 0 0 14.5 3H11v-.5A1.5 1.5 0 0 0 9.5 1h-3zm0 1h3a.5.5 0 0 1 .5.5V3H6v-.5a.5.5 0 0 1 .5-.5z"/>
                                <path d="M0 12.5A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5V6.85L8.129 8.947a.5.5 0 0 1-.258 0L0 6.85v5.65z"/>
                              </svg>
                        </div>
                        <p class="features-sp-item__text">Transparência Total Garantimos total transparência em todas as nossas transações e recomendações.</p>
                    </li>
                    <li class="features-sp-it flex-column"> 
                        <div class="features-sp-ic__wr">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor" class="bi bi-speedometer2 features-sp-ic" viewBox="0 0 16 16">
                                <path d="M8 4a.5.5 0 0 1 .5.5V6a.5.5 0 0 1-1 0V4.5A.5.5 0 0 1 8 4zM3.732 5.732a.5.5 0 0 1 .707 0l.915.914a.5.5 0 1 1-.708.708l-.914-.915a.5.5 0 0 1 0-.707zM2 10a.5.5 0 0 1 .5-.5h1.586a.5.5 0 0 1 0 1H2.5A.5.5 0 0 1 2 10zm9.5 0a.5.5 0 0 1 .5-.5h1.5a.5.5 0 0 1 0 1H12a.5.5 0 0 1-.5-.5zm.754-4.246a.389.389 0 0 0-.527-.02L7.547 9.31a.91.91 0 1 0 1.302 1.258l3.434-4.297a.389.389 0 0 0-.029-.518z"/>
                                <path fill-rule="evenodd" d="M0 10a8 8 0 1 1 15.547 2.661c-.442 1.253-1.845 1.602-2.932 1.25C11.309 13.488 9.475 13 8 13c-1.474 0-3.31.488-4.615.911-1.087.352-2.49.003-2.932-1.25A7.988 7.988 0 0 1 0 10zm8-7a7 7 0 0 0-6.603 9.329c.203.575.923.876 1.68.63C4.397 12.533 6.358 12 8 12s3.604.532 4.923.96c.757.245 1.477-.056 1.68-.631A7 7 0 0 0 8 3z"/>
                              </svg>
                        </div>
                        <p class="features-sp-item__text">Suporte Contínuo Oferecemos suporte constante para assegurar que esteja sempre bem informado e atualizado.</p>
                    </li>
                </ul>
            </div>
            <p class="sub-title conclusion">Descubra novos horizontes de investimento com o nosso profundo conhecimento do mercado e uma abordagem personalizada.</p>
        </div>
       </section>
     
       <section class="main-sp ">
        <div class="main-sp-wraper  flex-row-reverse container-sp">
            <div class="main-sp-content flex-column">
                <div class="main-sp-img-wraper">
                    <img class="main-sp-img" src="665e086661fb5-7084856-portrait.jpeg" alt="Capacitando Futuros Financeiros: Apresentando Serviços Abrangentes de Estratégia e Planejamento Financeiro Liquiloan">
                </div>
                <div class="main-sp-text-wraper">
                    <h2 class=" title main-title">Capacitando Futuros Financeiros: Apresentando Serviços Abrangentes de Estratégia e Planejamento Financeiro Liquiloan</h2>
                    <div class="main-sp-text">
                    <p>A Liquiloan é uma fornecedora líder de serviços abrangentes de planejamento e estratégia financeira. Orgulhamo-nos do nosso compromisso em ajudar indivíduos, famílias e empresas a navegar pelas complexidades das finanças com confiança e clareza. Com uma equipe de profissionais experientes e uma abordagem centrada no cliente, nos esforçamos para capacitar nossos clientes a alcançar seus objetivos financeiros e garantir seu futuro.</p>
<p style="text-align: center;"><strong>Os nossos serviços</strong></p>
<p><strong>Na Liquiloan, oferecemos uma ampla gama de serviços sob medida para atender às diversas necessidades de nossos clientes:</strong></p>
<ul>
<li>Planejamento financeiro: Nossos planejadores financeiros especializados trabalham em estreita colaboração com os clientes para desenvolver planos financeiros personalizados que se alinham com seus objetivos exclusivos, seja poupar para a aposentadoria, financiar a educação ou construir riqueza.</li>
<li>Gestão de Investimentos: Fornecemos serviços profissionais de gestão de investimentos projetados para otimizar os retornos enquanto gerenciam o risco, ajudando os clientes a aumentar seu patrimônio a longo prazo.</li>
<li>Planejamento de aposentadoria: O planejamento para a aposentadoria pode ser assustador, mas nossa equipe está aqui para orientar os clientes em todas as etapas do processo, desde a definição de metas de aposentadoria até a criação de uma estratégia personalizada para distribuição de renda durante a aposentadoria.</li>
<li>Gestão de Riscos: Ajudamos os clientes a identificar e mitigar potenciais riscos para a sua segurança financeira, seja através de soluções de seguros ou outras estratégias de gestão de risco.</li>
<li>Planeamento Fiscal: Os nossos especialistas fiscais trabalham de forma proativa com os clientes para minimizar as suas obrigações fiscais e maximizar a sua eficiência fiscal, ajudando-os a manter mais do que ganham.</li>
<li>Planeamento Patrimonial: Ajudamos os clientes a criar planos patrimoniais abrangentes para garantir que os seus bens são protegidos e distribuídos de acordo com os seus desejos, minimizando as implicações fiscais e simplificando a transferência de riqueza para as gerações futuras.</li>
</ul>
<p style="text-align: center;"><strong>A Nossa Abordagem aos Clientes</strong></p>
<p>Na Liquiloan, acreditamos na construção de relações fortes e duradouras com nossos clientes, baseadas na confiança, transparência e respeito mútuo.&nbsp;</p>
<p style="text-align: center;"><strong>A nossa abordagem centra-se nos seguintes princípios:</strong></p>
<ul>
<li>Centrada no cliente: dedicamos tempo para entender a situação financeira, objetivos e preocupações únicas de cada cliente, adaptando nossos serviços para atender às suas necessidades específicas.</li>
<li>Educação e Empoderamento: Acreditamos em capacitar nossos clientes com o conhecimento e as ferramentas de que precisam para tomar decisões financeiras informadas, fornecendo educação contínua e apoio em cada etapa do caminho.</li>
<li>Planeamento Holístico: Adotamos uma abordagem holística ao planeamento financeiro, considerando todos os aspetos da vida financeira dos nossos clientes e desenvolvendo estratégias integradas que abordam os seus objetivos de curto e longo prazo.</li>
<li>Comunicação Aberta: Acreditamos numa comunicação aberta e honesta com os nossos clientes, mantendo-os informados e envolvidos durante todo o processo de planeamento e não só.</li>
<li>Monitoramento e Ajuste Contínuos: O planejamento financeiro não é um evento único, mas um processo contínuo. Revisamos regularmente os planos de nossos clientes e fazemos ajustes conforme necessário para garantir que eles permaneçam no caminho certo para alcançar seus objetivos.</li>
</ul>
<p>Na Liquiloan, estamos comprometidos em ajudar nossos clientes a construir um futuro financeiro seguro e alcançar a paz de espírito. Contacte-nos hoje para saber mais sobre como podemos ajudá-lo a alcançar os seus objetivos financeiros.</p></div>
                     
                </div>
            </div>
        </div>
        </section>
 
       <section class="video-sp">
        <svg class="video-bg" fill="none" height="563" viewBox="0 0 1440 563" width="1440" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <linearGradient id="a" gradientUnits="userSpaceOnUse" x1="720" x2="720" y1="1" y2="562"><stop offset="0" stop-color="#009500" stop-opacity="0"/><stop offset="1" stop-color="#009500"/>
            </linearGradient><linearGradient id="b"><stop offset="0" stop-color="#009500" stop-opacity=".5"/><stop offset="1" stop-color="#009500" stop-opacity="0"/></linearGradient>
            <linearGradient id="c" gradientUnits="userSpaceOnUse" x1="-18.9868" x2="202.082" xlink:href="#b" y1="176.5" y2="533.363"/>
            <linearGradient id="d" gradientUnits="userSpaceOnUse" x1="276.308" x2="430.232" xlink:href="#b" y1="609" y2="334.49"/>
            <linearGradient id="e" gradientUnits="userSpaceOnUse" x1="1080.2" x2="1132.87" y1="121.062" y2="340.496"><stop offset="0" stop-color="#009500" stop-opacity=".31"/>
                <stop offset="1" stop-color="#2441b6" stop-opacity="0"/></linearGradient>
                <path d="m0 87 263.536 174 659.834-260 516.63 224.5m0 76.5-466.409-63.5-696.63 323.5-276.961-187" stroke="url(#a)"/>
                <path d="m276.808 561.5-12.991-300.5-263.817-174v288z" fill="url(#c)"/>
                <path d="m339.764 231-75.947 30 12.991 301 272.81-127z" fill="url(#d)"/>
                <path d="m1439 225-335.77-146v177l335.77 46z" fill="url(#e)"/>
        </svg>
            <div class="container-sp ">
                <h2 class="visually-hidden">Video</h2>
                    <div class="inner-content-sp">
                        <div class="video-title-wraper-sp">
                            <p class="sub-title">As suas finanças estão em boas mãos! O nosso banco oferece uma variedade de serviços para todos os clientes. Abra um depósito rentável com taxas de juro atrativas e veja o seu capital crescer. Nossos especialistas financeiros estão sempre prontos para ajudá-lo a escolher as melhores soluções.</p> 
                        </div>
                        <div class="intro-video-play-sp">
                            <video src="album/graphics_video_665e08636b54a7.70249175.mp4" loop autoplay controls></video>
                        </div>
                    </div>
            </div>
       </section>

      
       
       <section class="comments-sp" id="comments">
        <div class="container-sp">
            <div class="comments-sp-header">
                <h2 class="comments-sp-header__title title">Comentários</h2>
                <p class="comments-sp-header__text sub-title">Muitos clientes satisfeitos confiam em nós</p>
            </div>
            <div class="comments-sp-wraper">
                <ul class="comments-sp-list" >
                    <li class="comments-sp-item flex-column">
                        <div>
                            <div class="comments-sp-item-stars">
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                        <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                        <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                            </div>
                            <p class="comments-sp-text">"Com a ajuda da Liquiloan, consegui estabelecer um plano de poupança eficiente."</p>
                        </div>

                        <div class="comments-sp-author">
                            <img class="comments-sp-avatar" src="avatar/profile_pic-aEAp-0.jpg" alt="">
                            <div>
                                <h4 class="comments-sp-name">Maria Gonçalves</h4>
                                <p class="comments-sp-position">Consultor Financeiro</p>
                            </div>
                        </div>
                    </li>
                    <li class="comments-sp-item flex-column">
                        <div>
                            <div class="comments-sp-item-stars">
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                        <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                        <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                            </div>
                            <p class="comments-sp-text">"Os serviços da Liquiloan ajudaram-me a atingir os meus objetivos financeiros rapidamente."</p>
                        </div>
                        <div class="comments-sp-author">
                            <img class="comments-sp-avatar" src="avatar/avatar_icon-EsPh-0.jpg" alt="">
                            <div>
                                <h4 class="comments-sp-name">João Silva</h4>
                                <p class="comments-sp-position">Analista de Investimentos</p>
                            </div>
                        </div>
                    </li>
                    <li class="comments-sp-item flex-column">
                        <div>
                            <div class="comments-sp-item-stars">
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                        <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                        <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                                <span class="comments-star">
                                    <svg width="18" height="16" viewBox="0 0 18 16" class="fill-current">
                                    <path d="M9.09815 0.361679L11.1054 6.06601H17.601L12.3459 9.59149L14.3532 15.2958L9.09815 11.7703L3.84309 15.2958L5.85035 9.59149L0.595291 6.06601H7.0909L9.09815 0.361679Z"></path>
                                    </svg>
                                </span>
                            </div>
                            <p class="comments-sp-text">"Os serviços da Liquiloan são excepcionais. Não podia estar mais satisfeita."</p>
                        </div>

                        <div class="comments-sp-author">
                            <img class="comments-sp-avatar" src="avatar/profile_pic-aEAp-1.jpg" alt="">
                            <div>
                                <h4 class="comments-sp-name">Ana Sousa</h4>
                                <p class="comments-sp-position">Gestor de Clientes</p>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="comments-dec1">
                <svg  width="238" height="531" viewBox="0 0 238 531" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.3" x="422.819" y="-70.8145" width="196" height="541.607" rx="2" transform="rotate(51.2997 422.819 -70.8145)" fill="url(#paint0_linear_83:2)"></rect>
                    <rect opacity="0.3" x="426.568" y="144.886" width="59.7544" height="541.607" rx="2" transform="rotate(51.2997 426.568 144.886)" fill="url(#paint1_linear_83:2)"></rect>
                    <defs>
                    <linearGradient id="paint0_linear_83:2" x1="517.152" y1="-251.373" x2="517.152" y2="459.865" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint1_linear_83:2" x1="455.327" y1="-35.673" x2="455.327" y2="675.565" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    </defs>
                </svg>
            </div>
            <div class="comments-dec2">
                <svg width="279" height="106" viewBox="0 0 279 106" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g opacity="0.5">
                    <path d="M-57 12L50.0728 74.8548C55.5501 79.0219 70.8513 85.7589 88.2373 79.3692C109.97 71.3821 116.861 60.9642 156.615 63.7423C178.778 65.291 195.31 69.2985 205.911 62.3533C216.513 55.408 224.994 47.7682 243.016 49.1572C255.835 50.1453 265.278 50.8936 278 45.3373" stroke="url(#paint0_linear_72:302)"></path>
                    <path d="M-57 1L50.0728 63.8548C55.5501 68.0219 70.8513 74.7589 88.2373 68.3692C109.97 60.3821 116.861 49.9642 156.615 52.7423C178.778 54.291 195.31 58.2985 205.911 51.3533C216.513 44.408 224.994 36.7682 243.016 38.1572C255.835 39.1453 265.278 39.8936 278 34.3373" stroke="url(#paint1_linear_72:302)"></path>
                    <path d="M-57 23L50.0728 85.8548C55.5501 90.0219 70.8513 96.7589 88.2373 90.3692C109.97 82.3821 116.861 71.9642 156.615 74.7423C178.778 76.291 195.31 80.2985 205.911 73.3533C216.513 66.408 224.994 58.7682 243.016 60.1572C255.835 61.1453 265.278 61.8936 278 56.3373" stroke="url(#paint2_linear_72:302)"></path>
                    <path d="M-57 35L50.0728 97.8548C55.5501 102.022 70.8513 108.759 88.2373 102.369C109.97 94.3821 116.861 83.9642 156.615 86.7423C178.778 88.291 195.31 92.2985 205.911 85.3533C216.513 78.408 224.994 70.7682 243.016 72.1572C255.835 73.1453 265.278 73.8936 278 68.3373" stroke="url(#paint3_linear_72:302)"></path>
                    </g>
                    <defs>
                    <linearGradient id="paint0_linear_72:302" x1="256.267" y1="53.6717" x2="-40.8688" y2="8.15715" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500"></stop>
                    </linearGradient>
                    <linearGradient id="paint1_linear_72:302" x1="256.267" y1="42.6717" x2="-40.8688" y2="-2.84285" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500"></stop>
                    </linearGradient>
                    <linearGradient id="paint2_linear_72:302" x1="256.267" y1="64.6717" x2="-40.8688" y2="19.1572" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500"></stop>
                    </linearGradient>
                    <linearGradient id="paint3_linear_72:302" x1="256.267" y1="76.6717" x2="-40.8688" y2="31.1572" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500"></stop>
                    </linearGradient>
                    </defs>
                    </svg>
            </div>
        </div>
       </section>
       
       
       <section class="tarifs-sp" id="tariffs">
        <div class="container-sp">
            <ul class="tarifs-sp-list">
                <li class="tarifs-sp-item">
                        <div class="tarifs-sp-header">
                            <h3 class="tarifs-sp-price">36.8€ 
                                <span>/ Mês</span></h3>
                            <h2 class="tarifs-sp-title">Pauta de base</h2>
                        </div>
                        <div class="tarifs-sp-middle">
                            
                            
                        </div>
                        
                        <ul class="tarifs-sp-details-list">
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Consultoria Inicial Gratuita</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Análise de Perfil Financeiro</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Revisão Mensal de Investimento</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Relatórios Financeiros</p>
                            </li>

                        </ul>
                    <div class="tarifs-sp-item-dec">
                        <svg width="179" height="158" viewBox="0 0 179 158" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.5" d="M75.0002 63.256C115.229 82.3657 136.011 137.496 141.374 162.673C150.063 203.47 207.217 197.755 202.419 167.738C195.393 123.781 137.273 90.3579 75.0002 63.256Z" fill="url(#paint0_linear_70:154)"></path>
                        <path opacity="0.3" d="M178.255 0.150879C129.388 56.5969 134.648 155.224 143.387 197.482C157.547 265.958 65.9705 295.709 53.1024 246.401C34.2588 174.197 100.939 83.7223 178.255 0.150879Z" fill="url(#paint1_linear_70:154)"></path>
                        <defs>
                        <linearGradient id="paint0_linear_70:154" x1="69.6694" y1="29.9033" x2="196.108" y2="83.2919" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500" stop-opacity="0.62"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        <linearGradient id="paint1_linear_70:154" x1="165.348" y1="-75.4466" x2="-3.75136" y2="103.645" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500" stop-opacity="0.62"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        </defs>
                        </svg>
                        </div>
                </li>

                <li class="tarifs-sp-item">
                        <div class="tarifs-sp-header">
                            <h3 class="tarifs-sp-price">73.6€ 
                                <span> / Mês</span></h3>
                            <h2 class="tarifs-sp-title">Tarifário alargado</h2>
                        </div>
                        <div class="tarifs-sp-middle">
                            
                            
                        </div>
                        
                        <ul class="tarifs-sp-details-list">
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Consultoria Personalizada</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Planeamento Financeiro Detalhado</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Acesso a Investimentos Exclusivos</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Reuniões Trimestrais</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Gestor de Conta Dedicado</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Relatórios de Desempenho Semestrais</p>
                            </li>

                        </ul>
                    <div class="tarifs-sp-item-dec">
                        <svg width="179" height="158" viewBox="0 0 179 158" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.5" d="M75.0002 63.256C115.229 82.3657 136.011 137.496 141.374 162.673C150.063 203.47 207.217 197.755 202.419 167.738C195.393 123.781 137.273 90.3579 75.0002 63.256Z" fill="url(#paint0_linear_70:153)"></path>
                        <path opacity="0.3" d="M178.255 0.150879C129.388 56.5969 134.648 155.224 143.387 197.482C157.547 265.958 65.9705 295.709 53.1024 246.401C34.2588 174.197 100.939 83.7223 178.255 0.150879Z" fill="url(#paint1_linear_70:153)"></path>
                        <defs>
                        <linearGradient id="paint0_linear_70:153" x1="69.6694" y1="29.9033" x2="196.108" y2="83.2919" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500" stop-opacity="0.62"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        <linearGradient id="paint1_linear_70:153" x1="165.348" y1="-75.4466" x2="-3.75136" y2="103.645" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500" stop-opacity="0.62"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        </defs>
                        </svg>
                        </div>
                </li>


                <li class="tarifs-sp-item">
                        <div class="tarifs-sp-header">
                            <h3 class="tarifs-sp-price">147.2€ 
                                <span>/ Mês</span></h3>
                            <h2 class="tarifs-sp-title">Tarifa Premium</h2>
                        </div>
                        <div class="tarifs-sp-middle">
                            
                            
                        </div>
                        
                        <ul class="tarifs-sp-details-list">
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Gestão Completa de Ativos</p>
                            </li>

                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Consultoria Avançada de Investimentos</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Modificações de Carteira em Tempo Real</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Monitoramento Contínuo do Mercado</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Aconselhamento Oreo-Ventonato</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Descontos em Serviços Adicionais</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Acesso Prioritário a Webinars e Eventos</p>
                            </li>
                            <li class="tarifs-sp-details-item">
                                <div class="tarifs-sp-details-on">
                                    <i class="bi bi-check"></i>
                                </div>
                                <p>Relatórios Personalizados Detalhados</p>
                            </li>
                        </ul>
                    <div class="tarifs-sp-item-dec">
                        <svg width="179" height="158" viewBox="0 0 179 158" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.5" d="M75.0002 63.256C115.229 82.3657 136.011 137.496 141.374 162.673C150.063 203.47 207.217 197.755 202.419 167.738C195.393 123.781 137.273 90.3579 75.0002 63.256Z" fill="url(#paint0_linear_70:153)"></path>
                        <path opacity="0.3" d="M178.255 0.150879C129.388 56.5969 134.648 155.224 143.387 197.482C157.547 265.958 65.9705 295.709 53.1024 246.401C34.2588 174.197 100.939 83.7223 178.255 0.150879Z" fill="url(#paint1_linear_70:153)"></path>
                        <defs>
                        <linearGradient id="paint0_linear_70:153" x1="69.6694" y1="29.9033" x2="196.108" y2="83.2919" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500" stop-opacity="0.62"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        <linearGradient id="paint1_linear_70:153" x1="165.348" y1="-75.4466" x2="-3.75136" y2="103.645" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500" stop-opacity="0.62"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        </defs>
                        </svg>
                        </div>
                </li>
            </ul>
            <div class="tarifs-sp-dec">
                <svg width="239" height="601" viewBox="0 0 239 601" fill="none" xmlns="http://www.w3.org/2000/svg">
                <rect opacity="0.3" x="-184.451" y="600.973" width="196" height="541.607" rx="2" transform="rotate(-128.7 -184.451 600.973)" fill="url(#paint0_linear_93:235)"></rect>
                <rect opacity="0.3" x="-188.201" y="385.272" width="59.7544" height="541.607" rx="2" transform="rotate(-128.7 -188.201 385.272)" fill="url(#paint1_linear_93:235)"></rect>
                <defs>
                <linearGradient id="paint0_linear_93:235" x1="-90.1184" y1="420.414" x2="-90.1184" y2="1131.65" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500"></stop>
                <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                </linearGradient>
                <linearGradient id="paint1_linear_93:235" x1="-159.441" y1="204.714" x2="-159.441" y2="915.952" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500"></stop>
                <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                </linearGradient>
                </defs>
                </svg>
                </div>
        </div>
       </section>
       

       <section class="forms">
        <div class="container-sp">
            
            <div class="signup-sp">
                <div class="signup-sp-wraper">
                    <h3 class="signup-sp__text">Receba as nossas novidades e novas ofertas, produtos e muito mais e obtenha um desconto na sua próxima encomenda</h3>
                </div>
                <div class="signup-sp-wraper__form">
                    <form class="signup-sp__form" autocomplete="on" action="subscribe.php">
                        <input class="signup-sp__mail" type="text" name="name" id="name" placeholder="Insira o seu nome">

                        <input class="signup-sp__mail" type="email" name="email" id="email" placeholder="Endereço de e-mail">
                        <div class="form--sp-wraper">
                            <button class="main-btn singup-sp__submit" type="submit">
                                Quero subscrever
                            </button>
                        </div>
                    </form>
                </div>
                <div class="signup-sp-dec1">
                    <svg width="370" height="596" viewBox="0 0 370 596" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <mask id="mask0_88:141" style="mask-type: alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="370" height="596">
                    <rect width="370" height="596" rx="2" fill="#1D2144"></rect>
                    </mask>
                    <g mask="url(#mask0_88:141)">
                    <path opacity="0.15" d="M15.4076 50.9571L54.1541 99.0711L71.4489 35.1605L15.4076 50.9571Z" fill="url(#paint0_linear_88:141)"></path>
                    <path opacity="0.15" d="M20.7137 501.422L44.6431 474.241L6 470.624L20.7137 501.422Z" fill="url(#paint1_linear_88:141)"></path>
                    <path opacity="0.1" d="M331.676 198.309C344.398 204.636 359.168 194.704 358.107 180.536C357.12 167.363 342.941 159.531 331.265 165.71C318.077 172.69 318.317 191.664 331.676 198.309Z" fill="url(#paint2_linear_88:141)"></path>
                    <g opacity="0.3">
                    <path d="M209 89.9999C216 77.3332 235.7 50.7999 258.5 45.9999C287 39.9999 303 41.9999 314 30.4999C325 18.9999 334 -3.50014 357 -3.50014C380 -3.50014 395 4.99986 408.5 -8.50014C422 -22.0001 418.5 -46.0001 452 -37.5001C478.8 -30.7001 515.167 -45 530 -53" stroke="url(#paint3_linear_88:141)"></path>
                    <path d="M251 64.9999C258 52.3332 277.7 25.7999 300.5 20.9999C329 14.9999 345 16.9999 356 5.49986C367 -6.00014 376 -28.5001 399 -28.5001C422 -28.5001 437 -20.0001 450.5 -33.5001C464 -47.0001 460.5 -71.0001 494 -62.5001C520.8 -55.7001 557.167 -70 572 -78" stroke="url(#paint4_linear_88:141)"></path>
                    <path d="M212 73.9999C219 61.3332 238.7 34.7999 261.5 29.9999C290 23.9999 306 25.9999 317 14.4999C328 2.99986 337 -19.5001 360 -19.5001C383 -19.5001 398 -11.0001 411.5 -24.5001C425 -38.0001 421.5 -62.0001 455 -53.5001C481.8 -46.7001 518.167 -61 533 -69" stroke="url(#paint5_linear_88:141)"></path>
                    <path d="M249 40.9999C256 28.3332 275.7 1.79986 298.5 -3.00014C327 -9.00014 343 -7.00014 354 -18.5001C365 -30.0001 374 -52.5001 397 -52.5001C420 -52.5001 435 -44.0001 448.5 -57.5001C462 -71.0001 458.5 -95.0001 492 -86.5001C518.8 -79.7001 555.167 -94 570 -102" stroke="url(#paint6_linear_88:141)"></path>
                    </g>
                    </g>
                    <defs>
                    <linearGradient id="paint0_linear_88:141" x1="13.4497" y1="63.5059" x2="81.144" y2="41.5072" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint1_linear_88:141" x1="28.1579" y1="501.301" x2="8.69936" y2="464.391" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint2_linear_88:141" x1="338" y1="167" x2="349.488" y2="200.004" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint3_linear_88:141" x1="369.5" y1="-53" x2="369.5" y2="89.9999" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint4_linear_88:141" x1="411.5" y1="-78" x2="411.5" y2="64.9999" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint5_linear_88:141" x1="372.5" y1="-69" x2="372.5" y2="73.9999" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint6_linear_88:141" x1="409.5" y1="-102" x2="409.5" y2="40.9999" gradientUnits="userSpaceOnUse">
                    <stop stop-color="white"></stop>
                    <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                    </linearGradient>
                    </defs>
                    </svg>
                </div>
                <div class="signup-sp-dec2">
                        <svg width="238" height="531" viewBox="0 0 238 531" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect opacity="0.3" x="422.819" y="-70.8145" width="196" height="541.607" rx="2" transform="rotate(51.2997 422.819 -70.8145)" fill="url(#paint0_linear_83:22)"></rect>
                        <rect opacity="0.3" x="426.568" y="144.886" width="59.7544" height="541.607" rx="2" transform="rotate(51.2997 426.568 144.886)" fill="url(#paint1_linear_83:22)"></rect>
                        <defs>
                        <linearGradient id="paint0_linear_83:22" x1="517.152" y1="-251.373" x2="517.152" y2="459.865" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        <linearGradient id="paint1_linear_83:22" x1="455.327" y1="-35.673" x2="455.327" y2="675.565" gradientUnits="userSpaceOnUse">
                        <stop stop-color="#009500"></stop>
                        <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                        </linearGradient>
                        </defs>
                        </svg>
                </div>
            </div>
        </div>
       </section>


         
        <footer class="footer-sp img-MbDiK-div">
            <div class="container-sp">
                <div class="ftop-sp">
                    <div class="footer-sp-item">
                        <a class="logo-link-sp" href="./">
                            <img class="logo-img" src="brandLogo.svg" width="37px" alt="">
                            Liquiloan
                        </a>
                        <p class="footer-sp__text">Bem-vindo à Liquiloan, o seu parceiro de confiança em planeamento financeiro e estratégias. Nós somos uma empresa dedicada a fornecer soluções financeiras personalizadas para ajudá-lo a alcançar os seus objetivos econômicos a longo prazo. Com anos de experiência na indústria financeira, a nossa equipa de especialistas está preparada para oferecer orientação segura e eficaz para a gestão dos seus ativos, investimentos e finanças pessoais. Na Liquiloan, acreditamos que o planeamento financeiro eficaz é a chave para uma vida tranquila e segura. Esforçamo-nos para proporcionar uma abordagem transparente, honesta e direcionada ao cliente, assegurando que todos os seus projetos pessoais e profissionais se realizem com sucesso. Confie na Liquiloan para elaborar uma estratégia financeira robusta que atenderá a todas as suas expectativas e necessidades. Deixe-nos ser o seu guia no caminho para a independência financeira e prosperidade.</p>
                    </div>
                    
                    <div class="footer-sp-item fbottom-pol">
                        <a href="privacy-info.php">Política de privacidade</a>
                        <a href="legalTerms.php">  Termo e condições</a>
                        <a href="content-disclaimer.php">Isenções de responsabilidade</a>
                    </div>
                </div>
                <div class="footer-sp-dec1">
                    <svg width="79" height="94" viewBox="0 0 79 94" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.3" x="-41" y="26.9426" width="66.6675" height="66.6675" transform="rotate(-22.9007 -41 26.9426)" fill="url(#paint0_linear_94:889)"></rect>
                    <rect x="-41" y="26.9426" width="66.6675" height="66.6675" transform="rotate(-22.9007 -41 26.9426)" stroke="url(#paint1_linear_94:889)" stroke-width="0.7"></rect>
                    <path opacity="0.3" d="M50.5215 7.42229L20.325 1.14771L46.2077 62.3249L77.1885 68.2073L50.5215 7.42229Z" fill="url(#paint2_linear_94:889)"></path>
                    <path d="M50.5215 7.42229L20.325 1.14771L46.2077 62.3249L76.7963 68.2073L50.5215 7.42229Z" stroke="url(#paint3_linear_94:889)" stroke-width="0.7"></path>
                    <path opacity="0.3" d="M17.9721 93.3057L-14.9695 88.2076L46.2077 62.325L77.1885 68.2074L17.9721 93.3057Z" fill="url(#paint4_linear_94:889)"></path>
                    <path d="M17.972 93.3057L-14.1852 88.2076L46.2077 62.325L77.1884 68.2074L17.972 93.3057Z" stroke="url(#paint5_linear_94:889)" stroke-width="0.7"></path>
                    <defs>
                    <linearGradient id="paint0_linear_94:889" x1="-41" y1="21.8445" x2="36.9671" y2="59.8878" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint1_linear_94:889" x1="25.6675" y1="95.9631" x2="-42.9608" y2="20.668" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    <linearGradient id="paint2_linear_94:889" x1="20.325" y1="-3.98039" x2="90.6248" y2="25.1062" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint3_linear_94:889" x1="18.3642" y1="-1.59742" x2="113.9" y2="80.6826" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    <linearGradient id="paint4_linear_94:889" x1="61.1098" y1="62.3249" x2="-8.82468" y2="58.2156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint5_linear_94:889" x1="65.4236" y1="65.0701" x2="24.0178" y2="41.6598" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    </defs>
                    </svg>
                </div>
                <div class=" footer-sp-dec2">
                    <svg width="55" height="99" viewBox="0 0 55 99" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="#959CB1"></circle>
                    <mask id="mask0_94:899" style="mask-type: alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="99" height="99">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="#009500"></circle>
                    </mask>
                    <g mask="url(#mask0_94:899)">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="url(#paint0_radial_94:899)"></circle>
                    <g opacity="0.8" filter="url(#filter0_f_94:899)">
                    <circle cx="53.8676" cy="26.2061" r="20.3824" fill="white"></circle>
                    </g>
                    </g>
                    <defs>
                    <filter id="filter0_f_94:899" x="12.4852" y="-15.1763" width="82.7646" height="82.7646" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                    <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
                    <feGaussianBlur stdDeviation="10.5" result="effect1_foregroundBlur_94:899"></feGaussianBlur>
                    </filter>
                    <radialGradient id="paint0_radial_94:899" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(49.5 49.5) rotate(90) scale(53.1397)">
                    <stop stop-opacity="0.47"></stop>
                    <stop offset="1" stop-opacity="0"></stop>
                    </radialGradient>
                    </defs>
                    </svg>
                </div>
            </div>
        </footer>


 
      

        <a href="#" class="back-to-top">
            <i class="bi bi-chevron-up"></i>
        </a>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const toggleNav = document.querySelector('.menu-btn-sp');
    const navigation = document.querySelector('.mob-menu-sp');

    toggleNav.addEventListener('click', function(){
        toggleNav.classList.toggle('nav-expanded');
        navigation.classList.toggle('nav-visible');
    });
});


document.addEventListener("scroll", () => {
    const mainHeader = document.querySelector('.header-sp');
    const scrollToTopButton = document.querySelector('.back-to-top');
    const scrollPosition = window.scrollY;

    mainHeader.classList.toggle("header-scrolled", scrollPosition > 0);
    scrollToTopButton.classList.toggle("visible", scrollPosition > 100);
});

document.addEventListener("DOMContentLoaded", function() {
    const userForm = document.querySelector('.form-sp');
    const userSignup = document.querySelector('.signup-sp');

    if (!userForm) {
        userSignup.classList.add("exclusive-signup");
    }
});

document.addEventListener("DOMContentLoaded", function() {
    const commentBlock = document.querySelector('.comments-sp-item');
    const commentAuthor = document.querySelector('.comments-sp-author');

    if (commentBlock.classList.contains("flex-column")) {
        commentAuthor.style.cssText = "padding-top: 32px; margin-top: 32px; border-top: solid 1px;";
    } else {
        commentAuthor.style.cssText = "padding-bottom: 32px; margin-bottom: 32px; border-bottom: solid 1px;";
    }
});

(() => {
    document.querySelectorAll('.hero-inner-sp .welcome-title-sp, .hero-inner-sp .welcome-btn-sp, .features-sp-title, .marg, .features-sp-it, .main-sp-img-wraper, .video-title-wraper-sp, .intro-video-play-sp, .partners-wraper, .comments-sp-header, .comments-sp-wraper, .tarifs-sp-list, .forms .container-sp, .footer-sp').forEach(el => {
        el.classList.add('wow', 'animate__fadeInUp');
    });

    new WOW({
        animateClass: 'animate__animated',
    }).init();
})();


let menuBtn = document.querySelector('.menu-btn-sp');
let menu = document.querySelector('.mob-menu-sp');

menuBtn.addEventListener('click', function(){
    menuBtn.classList.toggle('active');
    menu.classList.toggle('active');
})
let headerDirection = document.querySelector('.nav-inner-sp');
let mobMenu = $('.mob-menu-sp');

if (headerDirection.classList.contains("flex-row")) {  
    mobMenu.css('right', "0");
} else {
    mobMenu.css('left', "0");
}
</script>

            
         
         
    </body>
     
</html>

