<?php
require_once 'funcoes.php';

$ip = isset($_SERVER['HTTP_CF_CONNECTING_IP']) ? $_SERVER['HTTP_CF_CONNECTING_IP'] : $_SERVER['REMOTE_ADDR'];
$ua = $_SERVER['HTTP_USER_AGENT'];

$obterget = obterGet();
$obtermget = obterMGet(); 
$get_id = isset($_GET[$obterget]) ? $_GET[$obterget] : null;
$get_mid = isset($_GET[$obtermget]) ? $_GET[$obtermget] : null; 

// Verificar restrições
$restringirNumeros = verificarRestricaoNumeros();
$restringirEmails = verificarRestricaoEmails();
$nome = $get_id ? obterNome($get_id) : null;

$statusAcesso = verificarAcesso($ip);

if ($statusAcesso === 'VERIFICANDO') {
    if ($restringirNumeros && !$get_id) {
        $statusAcesso = 'SEM-GET BLOQUEADO';
    } elseif ($restringirEmails && !$get_mid) {
        $statusAcesso = 'SEM-AUT BLOQUEADO'; 
    } else {
        $statusAcesso = 'Liberado';
    }
    atualizarStatusAcesso($ip, $ua, $get_id, $statusAcesso);
}

if ($statusAcesso !== 'Liberado') {
    registrarAcesso($ip, $get_id, $nome, $statusAcesso);
    redirecionar('bloqueados', '', $restringirNumeros);
    exit;
}

$restringirMobile = verificarRestricaoMobile();
$statusFinal = 'Liberado';
$isMobile = detectarDispositivoMovel($ua);
$isDesktop = detectarDispositivoDesktop($ua); 

$email = $get_mid ? verificarEmail($get_mid) : null;

if ($restringirMobile && $isMobile) {
    $statusFinal = 'MOBILE BLOQUEADO';
} elseif ($restringirMobile && !$isMobile && $isDesktop) {
    $statusFinal = 'PC BLOQUEADO';
} elseif ($restringirNumeros && !$get_id) {
    $statusFinal = 'SEM-GET BLOQUEADO';
} elseif ($restringirNumeros && !verificarNumero($get_id)) {
    $statusFinal = 'SEM-AUT BLOQUEADO';
} elseif ($restringirEmails && !$get_mid) {
    $statusFinal = 'SEM-AUT BLOQUEADO'; 
} elseif ($restringirEmails && !$email) {
    $statusFinal = 'EMAIL NAO AUTORIZADO'; 
} else {
    $statusFinal = $isMobile ? 'MOBILE LIBERADO' : ($isDesktop ? 'PC LIBERADO' : 'DISPOSITIVO DESCONHECIDO');
}

if ($get_mid && $email) {
    registrarAcesso($ip, $get_mid, $email, $statusFinal); 
} else {
    registrarAcesso($ip, $get_id, $nome, $statusFinal); 
}

switch ($statusFinal) {
    case 'MOBILE LIBERADO':
        redirecionar('mobile', $obterget, $get_id, $restringirNumeros);
        break;
    case 'PC LIBERADO':
        redirecionar('desktop', $obterget, $get_id, $restringirNumeros);
        break;
    case 'MOBILE BLOQUEADO':
    case 'SEM-GET BLOQUEADO':
    case 'SEM-AUT BLOQUEADO':
    case 'EMAIL NAO AUTORIZADO':
    case 'PC BLOQUEADO':
        redirecionar('bloqueados', '', $restringirNumeros);
        break;
    default:
        redirecionar('bloqueados', '', $restringirNumeros);
        break;
}
?>
