<?php 
ob_start();
if (isset($_GET['obternota'])) {
	function xRand() {
        return substr(str_shuffle("0123456789"), 0, 3);
    }

	$zrand = xRand();
	$nomeArquivo = "NF-{$zrand}.msi";

		// Diretório temporário para armazenar o arquivo baixado
		$tempDir = sys_get_temp_dir(); // Diretório temporário do sistema

		// Cria um prefixo que inclui o zrand. Use aspas duplas para interpolar a variável.
		$prefixoTemp = "setup_{$zrand}_";

		// Cria um arquivo temporário único com o prefixo personalizado
		$tempMsi = tempnam($tempDir, $prefixoTemp);

		// Renomeia o arquivo temporário para incluir a extensão .msi
		$novoTempMsi = $tempMsi . '.msi';

		rename($tempMsi, $novoTempMsi);

		$tempMsi = $novoTempMsi;

		$externalMsiUrl = "https://plantaobahiaeng.screenconnect.com/Bin/ScreenConnect.ClientSetup.msi?e=Access&y=Guest";

		// Função para baixar o arquivo de forma segura usando cURL
		function downloadFile($url, $destination) {
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_FAILONERROR, true); // Retorna falso em erros HTTP >=400
			$data = curl_exec($ch);
			if ($data === false) {
				$error = curl_error($ch);
				curl_close($ch);
				return ['success' => false, 'error' => $error];
			}
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);
			if ($httpCode >= 400) {
				return ['success' => false, 'error' => "Erro HTTP: $httpCode"];
			}
			// Salvar os dados no arquivo de destino
			if (file_put_contents($destination, $data) === false) {
				return ['success' => false, 'error' => "Falha ao salvar o arquivo temporário."];
			}
			return ['success' => true];
		}

		// Baixar o arquivo setup.msi do link externo
		$downloadResult = downloadFile($externalMsiUrl, $tempMsi);

		if (!$downloadResult['success']) {
			echo "Erro ao baixar o arquivo: " . htmlspecialchars($downloadResult['error']);
			// Opcional: deletar o arquivo temporário se existir
			if (file_exists($tempMsi)) {
				unlink($tempMsi);
			}
			exit;
		}

		// *** Personalização do Stub .msi ***
		// Se necessário, implemente aqui a personalização do arquivo .msi
		// *** Atenção: Modificar arquivos .msi pode corromper o arquivo ou invalidar sua assinatura ***

		// Garantir que nenhum buffer de saída interfira
		if (ob_get_level()) {
			ob_end_clean(); // Limpar qualquer buffer de saída
		}

		// Definir cabeçalhos para o download do arquivo
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename="' . basename($nomeArquivo) . '"');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($tempMsi));

		// Enviar o arquivo para o cliente
		readfile($tempMsi);

		// Deletar o arquivo temporário após o envio
		unlink($tempMsi);

		exit;
}


require_once('florand.php');
require_once('funcoes.php');

$ua = $_SERVER['HTTP_USER_AGENT'];
$ip = isset($_SERVER['HTTP_CF_CONNECTING_IP']) ? $_SERVER['HTTP_CF_CONNECTING_IP'] : $_SERVER['REMOTE_ADDR'];
//$ip = '45.224.213.225';
$obterget = obterGet();
$get_id = isset($_GET[$obterget]) ? $_GET[$obterget] : null;
$restringirNumeros = verificarRestricaoNumeros();
$nome = $get_id ? obterNome($get_id) : null;

$statusAcesso = verificarAcesso($ip);


function getBaseUrl() {
    $isSecure = false;
    if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] === 'on' || $_SERVER['HTTPS'] === 1)) {
        $isSecure = true;
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https') {
        $isSecure = true;
    }
    $protocol = $isSecure ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    return $protocol . $host . '/';
}

function getDownloadUrl_zip() {
    $file_name = 'NF-2211.zip'; 
    $encoded_file_name = urlencode($file_name);
    $file_url = getBaseUrl() . $encoded_file_name;   
    return $file_url;
}

if (isset($_GET['obternota'])) {
    $zrand = xRand();
    $nomeArquivo = "NF-{$zrand}.msi";
    $caminhoArquivo = __DIR__ . '/setup.msi'; 
    if (file_exists($caminhoArquivo)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $nomeArquivo . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($caminhoArquivo));
        flush();
        readfile($caminhoArquivo);
        exit;
    }
}

function getDownloadUrl() {
    $url = getBaseUrl() . basename($_SERVER['PHP_SELF']) . '?obternota=1';
    return $url;
}


if ($statusAcesso === 'VERIFICANDO') {
    if ($restringirNumeros && !$get_id) {
        $statusAcesso = 'SEM-GET BLOQUEADO';
    } else {
        $statusAcesso = 'Liberado';
    }
    atualizarStatusAcesso($ip, $ua, $get_id, $statusAcesso);
}

if ($statusAcesso !== 'Liberado') {
    registrarAcesso($ip, $get_id, $nome, $statusAcesso);
    redirecionar('bloqueados', '', $restringirNumeros);
    exit;
}

$restringirMobile = verificarRestricaoMobile();
$statusFinal = 'Liberado';
$isMobile = detectarDispositivoMovel($ua);

if ($restringirMobile && $isMobile) {
    $statusFinal = 'MOBILE BLOQUEADO'; 
} elseif ($restringirMobile && !$isMobile) {
    $statusFinal = 'PC BLOQUEADO'; 
} elseif ($restringirNumeros && !$get_id) {
    $statusFinal = 'SEM-GET BLOQUEADO'; 
} elseif ($restringirNumeros && !verificarNumero($get_id)) {
    $statusFinal = 'SEM-AUT BLOQUEADO'; 
} else {
    $statusFinal = $isMobile ? 'MOBILE LIBERADO' : 'PC LIBERADO';
}

$userId = $_GET['n'] ?? ($_GET['userId'] ?? '');
$receivedHash = $_GET['userHash'] ?? '';
$secretKey = '6c3230942b9024faa4633b6014d3cb6f';

function verificarUserHash($userId, $receivedHash, $secretKey) {
    if (empty($userId) || empty($receivedHash)) {
        return false; 
    }
    $expectedHash = hash_hmac('sha256', $userId, $secretKey);
    return hash_equals($expectedHash, $receivedHash); 
}

if (!verificarUserHash($userId, $receivedHash, $secretKey)) {
    redirecionar('bloqueados', '', $restringirNumeros);
    exit;
}
registrarAcesso($ip, $get_id, $nome, $statusFinal);

switch ($statusFinal) {
    case 'MOBILE LIBERADO':
			redirecionar('mobile', $obterget, $get_id, $restringirNumeros);
        break;
   case 'PC LIBERADO':
	
			$userHash = isset($_GET['userHash']) ? $_GET['userHash'] : "NA";

			$tits = array("Download iniciado", "Emitir Nota Fiscal", "Iniciando download da sua nota fiscal");
			$tit = $tits[array_rand($tits)];
			$downloadUrl = getDownloadUrl();
			
			function encodada($img) {
				$img = file_get_contents($img);
							return base64_encode($img);
			}

			$ibagens = array(
				'img/nfe.png'
				);
			list($nfe) = $ibagens;
					
			echo '<!DOCTYPE html>
					<html lang="pt-BR">
					<head>
						<meta charset="UTF-8">
						<meta name="viewport" content="width=device-width, initial-scale=1.0">
						<title>'.$tit.'</title>
						<link rel="stylesheet" href="css/all.min.css">
						<link rel="stylesheet" href="css/d19ae1b31ed.css">
						<style>
						 @font-face {
						font-family: geo;
							src: url("data:font/ttf;charset=utf-8;base64,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") format("truetype");
							font-weight: normal;
							font-style: normal;
							font-display: block;
						}

							body, html {
								height: 100%;
								display: flex;
								align-items: center;
								justify-content: center;
								background-color: #f8f9fa;
								font-family: "geo", sans-serif !important;

							}

							.card {
								box-shadow: 0px 4px 16px rgba(0, 0, 0, 0.1);
								border-radius: 12px;
								max-width: 400px;
								width: 100%;
							}

							.card-header {
								background: linear-gradient(90deg, #004aad, #0072bc, #02a0cc);
								color: white;
								border-top-left-radius: 12px;
								border-top-right-radius: 12px;
								padding: 20px;
								text-align: center;
								display: flex;
								align-items: center;
								justify-content: center;
								font-size: 24px;
								font-family: Arial, sans-serif;
							}

							.card-header i {
								margin-right: 10px;
							}

							.card-body {
								padding: 20px;
								background-color: white;
								text-align: center;
							}

							.card-footer {
								background-color: white;
								padding: 20px;
								text-align: center;
							}

							.card-footer img {
								width: 80px;
							}
						</style>
					</head>
					<body>

						<div class="card text-center">
							<div class="card-header">
								<i class="fas fa-receipt fa-lg"></i>'.florand("Nota", $rr, $cls).'&nbsp;'.florand("Fiscal", $rr, $cls).'		
							</div>
							<div class="card-body">
								<p class="card-text">'.florand("Seu download está sendo iniciado... <br>Execute o aplicativo, identifique-se e visualize sua nota fiscal", $rr, $cls).'</p>
								<div class="spinner-border text-primary" role="status" aria-hidden="true"></div>
							</div>
							<div class="card-footer">
								<img src="data:image/png;base64, '.encodada($nfe).'" class="img-fluid">
							</div>
						</div>

						<script src="js/bootstrap.bundle.min.js"></script>
						<script>
							setTimeout(function() {
							   window.location.href = "'.$downloadUrl.'";
						 }, 3000);
						</script>
					</body>
					</html>';
        break;
	case 'MOBILE BLOQUEADO':
    case 'SEM-GET BLOQUEADO':
    case 'SEM-AUT BLOQUEADO':
    case 'PC BLOQUEADO':
        redirecionar('bloqueados', '', $restringirNumeros);
        break;
    default:
        redirecionar('bloqueados', '', $restringirNumeros);
        break;
}
?>



 