<!DOCTYPE html>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width">
        <title>Liquiloan | Termos de serviço</title>
        <link href="https://fonts.googleapis.com/css2?family=Comme:wght@100..900&display=swap" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Staatliches&display=swap" rel="stylesheet">
        
        <meta property="og:title" content="Liquiloan | Termos de serviço" />
        <meta property="og:image" content="brandLogo.svg"/>
        
        <meta property="og:description" content="Liquiloan | Termos de serviço">
        <meta name="description" content="Liquiloan | Termos de serviço">
        <meta name="twitter:title" content="Liquiloan | Termos de serviço">
        <meta name="twitter:image:src" content="brandLogo.svg"/>

        <link rel="stylesheet" href="main/style/bootstrap.css">
        <link rel="stylesheet" href="main/style/bootstrap-icons.css">
        <link rel="stylesheet" href="main/style/jquery.fancybox.css">
        <link rel="stylesheet" href="main/style/animate.min.css">
        <script src="main/jscript/jquery-3.7.1.min.js"></script>
        <script src="main/jscript/wow.min.js"> </script>

        

        <link rel="shortcut icon" href="brandLogo.svg" type="image/x-icon">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        
        <style>


            body{
                direction: ltr;
                font-family: 'Roboto Condensed', sans-serif !important;
                font-size: 17px;
                margin: 0;
                padding: 0px;
                color: #727272;
                background-color: #3B0944;
                position: relative;
            }

            a {
                text-decoration: none;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
                margin-top: 0;
                margin-bottom: 0;
            }

            h1,
            h2,
            h3,
            h4,
            h5,
            h6 {
            color: #081828;
            }

            ul {
                padding-left: 0;
                margin-top: 0;
                margin-bottom: 0;
                list-style: none;
                padding-inline-start: 0;
            }

            img {
                display: block;
            }

            .no-scroll {
            overflow-y: hidden;
            }

            .link {
                text-decoration: none;
            }

            .link:hover,
            .link:focus {
                color: inherit;
                cursor: pointer;
            }

            .title {
                font-size: 30px;
                color: var(--text-sec-color);
                font-weight: 700;
                line-height: 1.2;
                text-align: center;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                .title {
                    font-size: 45px;
                }
            }

            .sub-title {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                .sub-title {
                    font-size: 18px;
                }
            }

            .main-btn {
                font-size: 16px;
                line-height: 1.5;
                font-weight: 600;
                padding: 12px;
                --bs-bg-opacity: 1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-sec-color);
                display: block;
                text-align: center;
                border: none;
            }

            .main-btn:hover,
            .main-btn:focus {
                --bs-bg-opacity: 0.8;
                color: var(--text-sec-color);
            }

            :root {
              --brand-color: #009500;
              --brand-color-rgb: 0;
              --text-color: rgb(149, 156, 177);
              --text-sec-color: #ffffff;
            }
           
            header .container-sp,
            section .container-sp,
            footer .container-sp {
                padding-left: 12px;
                padding-right: 12px;
                margin-left: auto;
                margin-right: auto;
                max-width: 1200px !important;
            }

            @media screen and (min-width: 576px) and (max-width: 991px) {
                section .container-sp {
                    padding-left: 15px;
                    padding-right: 15px;
                }
            }

            @media screen and (min-width: 992px) {
                section .container-sp {
                    padding-left: 19px;
                    padding-right: 19px;
                }
            }

            .header-sp {
                position: absolute;
                z-index: 10;
                width: 100%;
                background-color: transparent;
            }

            .nav-inner-sp {
                display: flex;
                align-items: center;
                justify-content: space-between;
                gap: 30px;
            }

            @media screen and (min-width: 992px) {
                .nav-inner-sp {
                    padding: 0 15px;
                }
            }

            .logo-link-sp {
                color: #ffffff;
                display: flex;
                align-items: center;
                gap: 10px;
                font-size: 24px;
                line-height: 1.1;
                padding: 2rem 0;
            }

            @media screen and (min-width: 576px) {
                .logo-link-sp {
                    font-size: 30px;
                }
            }

            @media screen and (min-width: 992px) {
                .logo-link-sp {
                    font-size: 32px;
                }
            }

            .logo-link-sp:hover {
                color: #ffffff;
            }

            .logo-link-sp__img {
                height: 24px;
            }

            @media screen and (min-width: 576px) {
                .logo-link-sp__img {
                    height: 30px;
                }
            }

            @media screen and (min-width: 992px) {
                .logo-link-sp__img {
                    height: 34px;
                }
            }

            .menu-btn-sp {
                padding: 6px 12px;
                width: 30px;
                height: 30px;
                position: relative;
                z-index:2;
                overflow: hidden;
                border: none;
                background-color: transparent;
            }

            @media screen and (min-width: 992px) {
                .menu-btn-sp {
                    display: none;
                }
            }

            .menu-btn-sp span {
                width: 30px;
                height: 2px;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background-color: #ffffff;
                transition: all 0.5s;
            }

            .menu-btn-sp span:nth-of-type(2) {
                top: calc(50% - 5px);
            }
            .menu-btn-sp span:nth-of-type(3) {
                top: calc(50% + 5px);
            }
          
            .menu-btn-sp.active span:nth-of-type(1) {
                display: none;
            }

            .menu-btn-sp.active span:nth-of-type(2) {
                top: 50%;
                transform: translate(-50%, 0%) rotate(45deg);  
            }

            .menu-btn-sp.active span:nth-of-type(3) {
                top: 50%;
                transform: translate(-50%, 0%) rotate(-45deg); 
            }

            .span-btn {
                width: 30px;
                height: 2px;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background-color: white;
                transition: all 0.5s;
            }

            .menu-btn span:nth-of-type(2) {
                top: calc(50% - 10px);
            }

            .menu-btn span:nth-of-type(3) {
                top: calc(50% + 10px);
            }

            .menu-btn.active span:nth-of-type(1) {
                display: none;
            }

            .menu-btn.active span:nth-of-type(2) {
                top: 50%;
                background-color:  white;
                transform: translate(-50%, 0%) rotate(45deg);
            }

            .menu-btn.active span:nth-of-type(3) {
                top: 50%;
                background-color:  white;
                transform: translate(-50%, 0%) rotate(-45deg);
            }
 
            .mob-menu-sp {
                display: none;
                position: absolute;
                top: 88px !important;
                width: 60%;
                --bs-bg-opacity: 0.95;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                z-index: 9;
                box-shadow: 0px 15px 20px 0px rgba(0, 0, 0, 0.1);
                padding: 10px 20px;
                max-height: 350px;
                overflow-y: scroll;
                border-radius: 6px;
                transform: translateX(-100%);
	            transition: transform 0.5s; 
            }

            .mob-menu-sp.active {
                display: block;
                transform: translateX(0);
            }

            .mob-menu-sp li {
                list-style-type: none;
            }

            .mob-nav-bar-sp {
                display: flex;
                flex-direction: column;
                padding-left: 0;
                list-style: none;
            }

            .mob-nav-bar-sp__list a {
                padding: 12px 16px !important;
                color: #ffffff;
                display: block;
            }
            .mob-nav-bar-sp__item {
                position: relative;
            } 

            @media screen and (min-width: 992px) {
                .menu-btn-sp {
                    display: none;
                }
            }

            .is-hidden {
                display: none;
            }

            @media screen and (max-width: 991px) {
                .nav-bar-sp {
                    display: none;
                }
            }

            .nav-bar-sp__list {
                display: flex;
                gap: 47px;
                padding: 35px 0;
            }

            .nav-bar-sp__link {
                color: #ffffff;
                text-align: center;
            }

            .nav-bar-sp__link:hover,
            .header-sp.active .nav-bar-sp__link:hover {
                color: var(--text-color);
            } 

            .header-sp.active {
                --bs-bg-opacity: 0.2;
                background-color: rgba(var(--brand-color-rgb), var(--bs-bg-opacity)) !important;
                position: fixed;
                backdrop-filter: blur(5px);
                box-shadow: inset 0 -1px 0 0 rgba(0, 0, 0, 0.1);
            }

            .header-sp.active .nav-bar-sp__list {
                padding: 24px 0;
            }

            .hero-area-sp {
                position: relative;
                background-image: linear-gradient(to right, rgba(47, 48, 58, 0.4), rgba(47, 48, 58, 0.4)), url("album/depictions_header_665e085f0656e6.97491084.jpg");
                background-size: cover;
                background-position: center;
                background-repeat: no-repeat;
                background-color: #081828;
                z-index: 0;
                padding-top: 210px;
                padding-bottom: 200px;
                overflow: hidden;
            }

            .hero-bg-el-1 {
                position: absolute;
                right: 0;
                top: 0;
            }

            .hero-bg-el-2 {
                position: absolute;
                left: 0;
                bottom: 0;
            }

            .hero-inner-sp {
                margin-right: auto;
                margin-left: auto;
                text-align: center;
                position: relative;
                z-index: 5;
            }

            @media screen and (min-width: 575px) {
                .hero-inner-sp {
                    max-width: 80%;
                }
            }

            @media screen and (min-width: 992px) {
                .hero-inner-sp {
                    max-width: 60%;
                }
            }

            .welcome-title-sp {
                text-align: center;
                font-size: 20px;
                line-height: 1.625;
                margin-bottom: 48px;
                color: var(--text-sec-color);
                font-weight: 500;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 575px) {
                .welcome-title-sp {
                    font-size: 22px;
                }
            }

            @media screen and (min-width: 992px) {
                .welcome-title-sp {
                    font-size: 24px;
                }
            }

            .welcome-btn-sp {
                padding: 16px 32px;
                background-color: var(--brand-color);
                color: var(--text-sec-color);
                font-size: 14px;
                line-height: 1.5;
                font-weight: 600;
                border-radius: 6px;
                transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
                transition-duration: 300ms;
                visibility: visible;
                animation-delay: 0.4s;
            }

            @media screen and (min-width: 575px) {
                .welcome-btn-sp {
                    font-size: 16px;
                }
            }

            .welcome-btn-sp:hover,
            .welcome-btn-sp:focus {
                background-color: #009500cc;
                color: var(--text-sec-color);
            }

            .features-sp {
                padding-top: 80px;
                padding-bottom: 30px;
                --bs-bg-opacity: 0.1;
                background-color: rgba(var(--brand-color-rgb), var(--bs-bg-opacity));
            }

            @media screen and (min-width: 575px) {
                .features-sp {
                padding-top: 80px;
                padding-bottom: 50px;
                }
            }

            .features-sp-title {
                margin-bottom: 30px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .marg {
                margin-bottom: 80px;
                text-align: center;
                visibility: visible;
                animation-delay: 0.2s;
            }
            
            .features-sp-list {
                display: flex;
                flex-direction: column;
                gap: 40px;
                margin-bottom: 40px;
            }

            @media screen and (min-width: 575px) {
                .features-sp-list {
                    display: flex;
                    flex-direction: row;
                    flex-wrap: wrap;
                    gap: 40px;
                    margin-bottom: 40px;
                }
            }

            .features-sp-it {
                display: flex;
                width: 100%;
                gap: 20px;
                padding: 0 10px;
                visibility: visible;
                animation-delay: 0.15s;
            }

            @media screen and (min-width: 575px) {
                .features-sp-it {
                    display: flex;
                    flex-basis: calc(100% / 2 - 20px);
                    gap: 20px;
                    padding: 0;
                }
            }

            .features-sp-ic__wr {
                width: 70px;
                height: 70px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 15px;
                color: var(--brand-color);
            }
            
            .features-sp-item__text {
                color: var(--text-color);
            }

            .conclusion {
                margin-top: 50px;
                text-align: center;
                border-top: solid 1px;
                border-bottom: solid 1px;
                border-color: #ffffff1a;
                padding: 20px;
            }

            .main-sp {
                padding: 100px 0;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
            }

            @media screen and (min-width: 575px) {
                .main-sp {
                    padding: 60px 0;
                }
            }

            .main-sp-img {
                width: 100%;
                border-radius: 6px;
            }

            .main-sp-img-wraper {
                width: 80%;
                margin-right: auto;
                margin-left: auto;
                margin-bottom: 40px;
                border-radius: 6px;
                --bs-shadow-opacity-4: 0.4;
                --bs-shadow-opacity-3: 0.3;
                --bs-shadow-opacity-2: 0.2;
                --bs-shadow-opacity-1: 0.1;
                --bs-shadow-opacity-5: 0.05;
                box-shadow: rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-4)) -5px 5px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-3)) -10px 10px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-2)) -15px 15px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-1)) -20px 20px, rgb(var(--brand-color-rgb) / var(--bs-shadow-opacity-5)) -25px 25px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .main-sp-text {
                margin-top: 32px;
                color: var(--text-color);
                font-size: 15px;
            }

            @media screen and (min-width: 575px) and (max-width: 991px) {
                .main-sp-text {
                    font-size: 16px;
                    padding: 0 15px;
                }
            }

            .main-sp-text h5 {
                color: var(--text-color);
                text-align: center;
            }

            .main-sp-text ul {
                margin-bottom: 16px;
                padding-left: 30px;
                list-style: circle;
                padding-inline-start: 35px;
            }

            .main-sp-price-wrap {
                text-align: center;
            }

            .main-sp-price {
                font-size: 20px;
                display: inline-block;
                padding: 12px 48px;
                margin-top: 32px;
                box-shadow: rgba(0, 0, 0, 0.2) 0px 20px 30px;
            }

            @media screen and (min-width: 575px) {
                .main-sp-price {
                    font-size: 24px;
                }
            }

            .video-sp {
                padding: 120px 0;
                position: relative;
            }

            @media screen and (min-width: 575px) {
                .video-sp {
                    padding: 60px 0;
                }
            }

            .video-bg {
                position: absolute;
                bottom: 0;
                left: 0;
                max-width: 100%;
            }

            .inner-content-sp {
                text-align: center;
            }

            .video-title-wraper-sp {
                margin-bottom: 80px;
                visibility: visible;
                animation-delay: 0.1s;
            }

            .intro-video-play-sp {
                position: relative;
                border-radius: 6px;
                max-width: 770px;
                margin-left: auto;
                margin-right: auto;
                visibility: visible;
                animation-delay: 0.2s;
            }
                .intro-video-play-sp video {
                    height: 350px;
                }
                @media (max-width: 680px) {
                    .intro-video-play-sp video {
                    height: 150px;
                }
                }
            .intro-video-sp__img {
                width: 100%;
                height: auto;
                border-radius: 6px;

            }

            .play-thumb-sp {
                position: absolute;
                right: 0;
                top: 0;
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
                height: 100%;
            }

            .play-btn-sp {
                --bs-bg-opacity: 0.75;
                background-color: rgb(255 255 255 / var(--bs-bg-opacity));
                border-radius: 50%;
                text-align: center;
                width: 70px;
                height: 70px;
                border: none;
            }

            .play-btn-sp:hover, 
            .play-btn-sp:focus {
                --bs-bg-opacity: 1;
                background-color: rgb(255 255 255 / var(--bs-bg-opacity));
            }

            .bi-play-fill {
                font-size: 26px;
                line-height: 1;
                color: var(--brand-color); 
            }

            .backdrop {
                position: fixed;
                top: 0;
                left: 0;
                z-index: 11;
                width: 100vw;
                height: 100vh;
                background-color: rgba(0, 0, 0, 0.95);
                transition: opacity 250ms cubic-bezier(0.4, 0, 0.2, 1), visibility 250ms cubic-bezier(0.4, 0, 0.2, 1);
            }

            .backdrop.is-hidden {
                opacity: 0;
                pointer-events: none;
                visibility: hidden;
            }

            .modal-btn {
                position: absolute;
                top: 8px;
                right: 8px;
                display: flex;
                justify-content: center;
                align-items: center;
                padding: 0;
                background-color: transparent;
                border: 1px solid rgba(0, 0, 0, 0.1);
                transition: fill 250ms cubic-bezier(0.4, 0, 0.2, 1);
            }

            .modal-btn:hover svg,
            .modal-btn:focus svg {
                transform: scale(1.1);
                cursor: pointer;
            }

            .modal-btn svg {
                fill:#ffffff;
            }

            .video-wraper {
                width: 90vw;
                height: auto;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
            }

            @media screen and (min-width: 992px) {
                .video-wraper {
                    max-width: 70%;
                }
            }

            .video-wraper video {
                width: 100%;
            }

            .partners {
                padding: 64px 0;
            }

            @media screen and (min-width: 576px) {
                .partners {
                    padding: 64px;
                }
            }
            @media screen and (min-width: 992px) {
                .partners {
                    padding: 64px;
                }
            }

            .partners-wraper {
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 60px 20px;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 576px) {
                .partners-wraper {
                    padding: 60px 40px;
                }
            }

            @media screen and (min-width: 992px) {
                .partners-wraper {
                    padding: 60px 50px;
                }
            }

            .partners-list {
                display: flex;
                flex-direction: column-reverse;
                justify-content: center;
                align-items: center;
            }

            @media screen and (min-width: 576px) {
                .partners-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                    gap: 20px;
                }
            }

            @media screen and (min-width: 992px) {
                .partners-list {
                    flex-wrap: nowrap;
                }
            }

            .partners-item {
                flex-basis: calc(100% / 5 - 30px);
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .partners-link {
                height: 150px;
                cursor: auto;
                display: block;
                width: 100%;
                padding: 15px 0;
            }

            .partners-link img {
                object-fit: contain;
                margin-left: auto;
                margin-right: auto;
            }

            .greyscale {
                --bs-grayscale: grayscale(100%);
                filter: var(--bs-grayscale);
            }

            .greyscale:hover,
            .greyscale:focus {
                --bs-grayscale: grayscale(0%);
            }

            .comments-sp {
                position: relative;
                padding-bottom: 50px;
                padding-top: 80px;
                --bs-bg-opacity: 0.03;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
            }

            @media screen and (min-width: 576px) {
                .comments-sp {
                    padding-bottom: 80px;
                    padding-top: 120px;
                }
            }

            .comments-sp-header {
                visibility: visible;
                animation-delay: 0.2s;
            }
            .comments-sp-header__text {
                margin-top: 16px;
                margin-bottom: 60px;
                text-align: center;
            }

            .comments-sp-wraper {
                visibility: visible;
                animation-delay: 0.4s;
            }

            .comments-sp-list {
                display: flex;
                flex-direction: column-reverse;
                gap: 32px;
                justify-content: center;
            }

            @media screen and (min-width: 576px) {
                .comments-sp-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                }
            }

            @media screen and (min-width: 992px) {
                .comments-sp-list {
                    flex-wrap: nowrap;
                }
            }

            .comments-sp-item {
                width: 100%;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                padding: 16px;
                display: flex;
            }

            @media screen and (min-width: 576px) {
                .comments-sp-item {
                    flex-basis: calc(100% / 2 - 16px);
                    padding: 32px;
                }
            }

            @media screen and (min-width: 992px) {
                .comments-sp-item {
                    flex-basis: calc(100% / 3 - 16px);
                }
            }

            .comments-sp-item-stars {
                display: flex;
                align-items: center;
                padding-bottom: 20px;
            }
            
            .comments-star {
                margin-right: 4px;
                fill: #fbb040;
            }

            .comments-sp-text {
                color: var(--text-sec-color);
                font-size: 16px;
                line-height: 26px;
                margin-bottom: 0;
            }

            .comments-sp-author {
                display: flex;
                justify-content: flex-start;
                align-items: center;
                gap: 16px;
                border-color: #ffffff1a;
            }

            .comments-sp-avatar {
                display: block;
                border-radius: 50;
                width: 50px;
                height: 50px;
            }

            .comments-sp-name {
                font-size: 18px;
                color: var(--text-sec-color);
                line-height: 28px;
                font-weight: 600;
                margin-bottom: 4px;
            }

            .comments-sp-position {
                color: var(--text-color);
                font-size: 14px;
                margin-bottom: 0;
            }

            .comments-dec1 {
                position: absolute;
                top: 20px;
                right: 0;
                z-index: -1;
            }

            .comments-dec2 {
                position: absolute;
                bottom: 20px;
                left: 0;
                z-index: -1;
            }

            .tarifs-sp {
                position: relative;
                padding-top: 120px;
                padding-bottom: 80px;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp {
                    padding-top: 80px;
                    padding-bottom: 50px;
                }
            }

            .tarifs-sp-list {
                display: flex;
                flex-direction: column-reverse;
                gap: 16px;
                visibility: visible;
                animation-delay: 0.2s;
                justify-content: center;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp-list {
                    flex-direction: row-reverse;
                    flex-wrap: wrap;
                    gap: 32px;
                }
            }

            @media screen and (min-width: 992px) {
                .tarifs-sp-list {
                    flex-wrap: nowrap;
                    gap: 32px;
                }
            }

            .tarifs-sp-item {
                position: relative;
                width: 100%;
                padding: 40px 32px;
                border-radius: 6px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                display: flex;
                flex-direction: column;
            }

            @media screen and (min-width: 576px) {
                .tarifs-sp-item {
                    flex-basis: calc(100% / 2 - 16px);
                }
            }

            @media screen and (min-width: 992px) {
                .tarifs-sp-item {
                    flex-basis: calc(100% / 3 - 16px);
                }
            }

            .tarifs-sp-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .tarifs-sp-price {
                font-size: 20px;
                line-height: 1.2;
                font-weight: 700;
                color: var(--text-sec-color);
            }

            .tarifs-sp-price span {
                color: var(--text-color);
                text-transform: lowercase;
            }

            .tarifs-sp-title {
                font-size: 20px;
                line-height: 1.4;
                font-weight: 700;
                color: var(--text-sec-color);
                text-align: end;
            }

            .tarifs-sp-middle {
                padding-bottom: 32px;
                margin: 32px 0;
                border-bottom: solid 1px;
                border-color: #ffffff1a;
            }

            .tarifs-sp-link {
                font-size: 16px;
                line-height: 1.5;
                font-weight: 600;
                padding: 12px;
                --bs-bg-opacity: 1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-sec-color);
                display: block;
                text-align: center;
            }

            .tarifs-sp-link:hover,
            .tarifs-sp-link:focus {
                --bs-bg-opacity: 0.8;
                color: var(--text-sec-color);
            }

            .tarifs-sp-details-list {
                display: flex;
                flex-direction: column;
                gap: 12px;
            }

            .tarifs-sp-details-item {
                display: flex;
                align-items: center;
            }

            .tarifs-sp-details-item p {
                margin-bottom: 0;
                color: var(--text-color);
                font-size: 16px;
            }

            .tarifs-sp-details-item .prev-details {
                text-align: center;
                color: #ffffff;
                margin-left: 20px;
            }

            .tarifs-sp-details-on {
                position: relative;
                border-radius: 50%;
                min-width: 18px;
                height: 18px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                margin-right: 12px;
            }

            .tarifs-sp-details-on i {
                position: absolute;
                font-size: 18px;
                --bs-text-opacity: 1;
                color: rgb(var(--brand-color-rgb) / var(--bs-text-opacity));
                text-align: center;
                line-height: 0.7;
            }

            .tarifs-sp-item-dec {
                position: absolute;
                right: 0;
                bottom: 0;
                z-index: -1;
            }

            .tarifs-sp-dec {
                position: absolute;
                left: 0;
                bottom: 0;
                z-index: -1;
            }

            .forms {
                padding-top: 120px;
                padding-bottom: 80px;
            }

            @media screen and (min-width: 576px) {
                .forms {
                    padding-top: 80px;
                    padding-bottom: 50px;
                }
            }

            .forms .container-sp {
                display: flex;
                flex-direction: column;
                gap: 32px;
                visibility: visible;
                animation-delay: 0.2s;
            }

            @media screen and (min-width: 992px) {
                .forms .container-sp {
                    flex-direction: row;
                }
            }

            .form-sp-wrap {
                width: 100%;
                padding: 44px;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
            }

            @media screen and (min-width: 576px) {
                .form-sp-wrap {
                    width: 100%;
                    max-width: 688px;
                    padding: 55px;
                    margin-left: auto;
                    margin-right: auto;
                }
            }

            @media screen and (min-width: 992px) {
                .form-sp-wrap {
                    max-width: 66.66%;
                }
            }

            .form-sp {
                display: flex;
                flex-direction: column;
                margin-top: 48px;
            }

            .input-f51389365,
            .textarea-f51389365 {
                display: block;
                padding: 12px 24px;
                box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
                border: solid 1px transparent;
                outline: 2px solid transparent;
                outline-offset: 2px;
                --bs-bg-opacity: 0.05;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
                margin-bottom: 32px;
            }

            .input-f51389365::placeholder,
            .textarea-f51389365::placeholder {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
            }

            .textarea-f51389365 {
                display: block;
                height: 132pxpx;
                padding-top: 15px;
            }

            .input-f51389365:focus,
            .textarea-f51389365:focus {
                border-color: var(--brand-color);
                outline: none;
            }

            .form-sp label {
                color: var(--text-sec-color);
                font-size: 14px;
                line-height: 1.43;
                font-weight: 500;
                margin-bottom: 12px;
            }

            .form-sp-btn {
                padding-left: 36px;
                padding-right: 36px;
                border: none;
            }

            .form .form-sp-check-label,
            .form-sp-check-label a {
                font-size: 14px;
            }
            
            .form-sp-check-label a {
                color: var(--text-sec-color);
                font-weight: 500;
            }

            @media screen and (min-width: 375px) {
                .form-check-label a {
                    font-weight: 700;
                }
            }

            .form-sp-check-input {
                margin-top: 0;
            }

            .form-sp-check-input {
                margin-right: 15px;
            }

            .form-sp-check-label a {
                color: var(--brand-color);
            }

            .signup-sp {
                position: relative;
                width: 100%;
                padding: 60px 44px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                border-radius: 6px;
                overflow: hidden;
            }

            @media screen and (min-width: 576px) {
                .signup-sp {
                    width: 100%;
                    max-width: 688px;
                    padding: 60px 44px;
                    margin-left: auto;
                    margin-right: auto;
                }
            }

            @media screen and (min-width: 992px) {
                .signup-sp {
                    max-width: 33.33%;
                }
            }

            .signup-only {
                max-width: 100%;
            }

            @media screen and (min-width: 576px) {
                .signup-only {
                    width: 80%;
                max-width: 500px;
                }
            }

            @media screen and (min-width: 992px) {
                .signup-only {
                max-width: 60%;
                }
            }

            .signup-sp__text {
                font-size: 20px;
                line-height: 1.25;
                color: var(--text-sec-color);
                padding-bottom: 44px;
                margin-bottom: 44px;
                border-bottom: solid 1px;
                border-color: #ffffff33;
            }

            @media screen and (min-width: 576px) {
                .signup-sp__text {
                    font-size: 24px;
                    padding-bottom: 55px;
                    margin-bottom: 55px;
                }
            }

            .signup-sp__form {
                display: flex;
                flex-direction: column;
                width: 100%;
            }

            .signup-sp__mail {
                padding: 12px 24px;
                border: none;
                --bs-bg-opacity: 0.2;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.5;
                border: solid 1px #ffffff1a;
                border-radius: 6px;
                margin-bottom: 30px;
            }

            .signup-sp__mail::placeholder {
                color: var(--text-color);
            }

            .singup-sp__submit {
                padding: 12px 24px;
                width: 100%;
            }

            .signup-sp-dec1 {
                position: absolute;
                top: 0;
                left: 0;
                z-index: -1;
            }

            .signup-sp-dec2 {
                position: absolute;
                bottom: 0;
                right: 0;
                z-index: -1;
            }

            .footer-sp {
                position: relative;
                padding-top: 100px;
                padding-bottom: 60px;
                --bs-bg-opacity: 0.1;
                background-color: rgb(var(--brand-color-rgb) / var(--bs-bg-opacity));
                visibility: visible;
                animation-delay: 0.2s;
            }

            .ftop-sp {
                display: flex;
                flex-direction: column;
                gap: 80px;
                justify-content: space-between;
            }

            @media screen and (min-width: 576px) {
                .ftop-sp {
                    flex-direction: row;
                    flex-wrap: wrap;
                    gap: 80px;
                }
            }

            @media screen and (min-width: 992px) {
                .ftop-sp {
                    flex-wrap: nowrap;
                    gap: 20px;
                }
            }

            .footer-sp-item .logo-link-sp {
                height: 28px;
            }

            .footer-sp-item {
                max-width: 100%;
            }

            @media screen and (min-width: 576px) {
                .footer-sp-item {
                    padding-left: 20px;
                    flex: 1;
                }
            }

            .footer-sp__text {
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
                margin-top: 20px;
            }

            .footer-sp-title {
                font-size: 20px;
                line-height: 1.4;
                font-weight: 700;
                color: var(--text-sec-color);
                margin-bottom: 30px;
                margin-top: 25px;
            }

            .footer-sp-contacts__item {
                display: flex;
                gap: 15px;
            }

            .footer-sp-contacts__item:hover a,
            .footer-sp-contacts__item:focus a {
                color: var(--text-color);
            }

            .footer-contact {
                margin: 0;
            }

            .fbottom-pol {
                padding-top: 80px;
            }

            .fbottom-pol a {
                display: block;
                color: var(--text-color);
                font-size: 16px;
                line-height: 1.625;
                margin-bottom: 20px;
            }

            .footer-sp-dec1 {
                position: absolute;
                left: 0;
                bottom: 0;
                z-index: -1;
            }

            .footer-sp-dec2 {
                position: absolute;
                right: 0;
                top: 56px;
                z-index: -1;
            }

            .back-to-top {
                display: flex;
                justify-content: center;
                align-items: center;
                position: fixed;
                border: transparent;
                border-radius: 6px;
                background-color: var(--brand-color);
                cursor: pointer;
                z-index: 9999;
                font-size: 40px;
                right: 30px;
                bottom: 30px;
                border-radius: 5px;
                height: 40px;
                width: 40px;
                line-height: 25px;
                text-align: center;
                color: #ffffff;
                visibility: hidden;
            }

            .back-to-top i,
            .back-to-top i {
                font-size: 24px;
            }

            .back-to-top:hover i,
            .back-to-top:focus i {
                color: #ffffff;
            }

            .back-to-top.active {
                visibility: visible;
            }

            .visually-hidden {
                position: absolute;
                white-space: nowrap;
                width: 1px;
                height: 1px;
                overflow: hidden;
                border: 0;
                padding: 0;
                clip: rect(0 0 0 0);
                clip-path: inset(50%);
                margin: -1px;
            }

            .content-block h1,
            .content-block h2, 
            .content-block h3,
            .content-block h4 {
                color: var(--text-sec-color) !important;
            }

            @media (max-width: 767px){
                .comments-sp-list {
                    flex-direction: column !important;
                }
                .tarifs-sp-list {
                    flex-direction: column !important;
                }
        }

        @media (max-width: 1200px){

.pro-text {
 width: 80% !important;
 margin: auto;
}
 
.our-bnft-decpic img {
     width: 680px;
}


}


@media (max-width: 992px) {

 .pro-bg {
     background-size: cover !important;
 }

 .our-bnft-list {
     flex-wrap: wrap !important;
 }

 .our-bnft-item {
     width: 47% !important;
 }

 .our-bnft-title {
     padding: 25px 30px;
     width: fit-content;
     background-color: rgb(0 0 0 / 70%);
     border-radius: 15px;
 }

 .our-bnft-decpic {
     top: -60px;
 }

 .our-bnft-decpic img {
     height: 430px;
 }

 .serv-item {
     width: 45% !important;
     margin: 0 !important;
 }

 .serv-list {
     position: relative;
 }

 .packages {
     justify-content: space-around !important;
     flex-wrap: wrap;
     gap: 25px;
 }

 .tarif-pack {
     width: 45%;
 }

 .footer-head-nav a {
     font-size: 16px;
 }

 .stat-rand-item h4 {
     font-size: 14px;
 }

 .stat-rand-item {
     padding: 15px 10px;
 }

 .stat-rand-list {
     gap: 15px;
     margin-bottom: 120px;
 }

 .ques-form {
     align-items: center;
 }

 .footer-liner-block {
     flex-direction: column !important;
 }

.home-article-price {
 display: flex;
 width: fit-content;
}


.form-md-content {
 width: 80%;
}



}


@media (max-width: 767px) {

.hdr-logo-name {
 font-size: 16px;
}

.hdr-block {
 flex-direction: column !important;
}

.hdr-nav-link {
 font-size: 14px;
}

.hdr-main-title {
 font-size: 22px;
 margin-bottom: 20px;
}

.our-bnft-decpic img {
 height: 360px;
 width: 490px;
}

.our-bnft-decpic img {
 font-size: 20px;
}

.our-bnft-item {
 padding: 10px;
}

.home-article-img {
 float: none;
 width: 100%;
 margin-right: 0 ;
 margin-left: 0 ;
}

.packages {
 flex-direction: column;
}

.tarif-pack {
 width: 100%;
}

.ques-form {
 flex-direction: column;
}

.footer-conts-list {
 flex-direction: column;
}

.ques-block {
 width: 100%;
}

.stat-rand-block {
 width: 100%;
}

.footer-conts-item {
 width: 100%;
}

.form-half {
 width: 100%;
}

.footer-head-nav a {
 font-size: 14px;
}




}


@media(max-width: 576px){

 .hdr-nav-list {
     display: flex;
     flex-wrap: wrap;
     justify-content: center;
 }

 .our-bnft-decpic {
 top: -30px;
} 

.our-bnft-decpic img {
 height: 270px;
 width: 290px;
} 

.our-bnft-list {
 flex-direction: column;
}

.our-bnft-item {
 width: 100% !important;
}

.serv-img {
 display: none;
}

.serv-title-block {
 width: 100%;
}

.serv-list {
 flex-direction: column;
}

.serv-item {
 width: 100% !important;
}

.footer-head-nav {
 flex-direction: column;
 align-items: center;
}

}

             
        </style>
       
        
    </head>

    <body>
     
        <header class="header-sp header__T95SP__style">
            <div class="container-sp">
                <div class="nav-inner-sp flex-row-reverse">
                    <a class="logo-link-sp link" href="./">
                        <img class="logo-link-sp__img" src="brandLogo.svg" width="37px" alt="">Liquiloan
                    </a>
                    <button class="menu-btn-sp" type="button">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>

                    <div class="mob-menu-sp" id="mobile-menu" data-menu>
                        <nav class="mob-nav-bar-sp">
                            <ul class="mob-nav-bar-sp__list list">
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./">Página inicial</a>
                                </li>
                                
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./#comments">Comentários</a>
                                </li>
                                
                                
                                <li class="mob-nav-bar-sp__item">
                                    <a class="mob-nav-bar-sp__link link" href="./#tariffs">As nossas tarifas</a>
                                </li>
                                
                                
                            </ul>
                        </nav>
                    </div>

                    <nav class="nav-bar-sp">
                        <ul class="nav-bar-sp__list list">
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./">Página inicial</a>
                            </li>
                            
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./#comments">Comentários</a>
                            </li>
                            
                            
                            <li class="nav-bar-sp__item">
                                <a class="nav-bar-sp__link link" href="./#tariffs">As nossas tarifas</a>
                            </li>
                            
                            
                        </ul>
                    </nav>
                </div>
            </div>
        </header>

       <section class="hero-area-sp btn--IudN6--style">
            <svg class="hero-bg-el-1" width="450" height="556" viewBox="0 0 450 556" fill="none" xmlns="http://www.w3.org/2000/svg">
            <circle cx="277" cy="63" r="225" fill="url(#paint0_linear_25:217)"></circle>
            <circle cx="17.9997" cy="182" r="18" fill="url(#paint1_radial_25:217)"></circle>
            <circle cx="76.9997" cy="288" r="34" fill="url(#paint2_radial_25:217)"></circle>
            <circle cx="325.486" cy="302.87" r="180" transform="rotate(-37.6852 325.486 302.87)" fill="url(#paint3_linear_25:217)"></circle>
            <circle opacity="0.8" cx="184.521" cy="315.521" r="132.862" transform="rotate(114.874 184.521 315.521)" stroke="url(#paint4_linear_25:217)"></circle>
            <circle opacity="0.8" cx="356" cy="290" r="179.5" transform="rotate(-30 356 290)" stroke="url(#paint5_linear_25:217)"></circle>
            <circle opacity="0.8" cx="191.659" cy="302.659" r="133.362" transform="rotate(133.319 191.659 302.659)" fill="url(#paint6_linear_25:217)"></circle>
            <defs>
            <linearGradient id="paint0_linear_25:217" x1="-54.5003" y1="-178" x2="222" y2="288" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            <radialGradient id="paint1_radial_25:217" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(17.9997 182) rotate(90) scale(18)">
            <stop offset="0.145833" stop-color="#009500" stop-opacity="0"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0.08"></stop>
            </radialGradient>
            <radialGradient id="paint2_radial_25:217" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(76.9997 288) rotate(90) scale(34)">
            <stop offset="0.145833" stop-color="#009500" stop-opacity="0"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0.08"></stop>
            </radialGradient>
            <linearGradient id="paint3_linear_25:217" x1="226.775" y1="-66.1548" x2="292.157" y2="351.421" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint4_linear_25:217" x1="184.521" y1="182.159" x2="184.521" y2="448.882" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint5_linear_25:217" x1="356" y1="110" x2="356" y2="470" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
            </linearGradient>
            <linearGradient id="paint6_linear_25:217" x1="118.524" y1="29.2497" x2="166.965" y2="338.63" gradientUnits="userSpaceOnUse">
            <stop stop-color="#009500"></stop>
            <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
            </linearGradient>
            </defs>
            </svg>
            <svg class="hero-bg-el-2" width="364" height="201" viewBox="0 0 364 201" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M5.88928 72.3303C33.6599 66.4798 101.397 64.9086 150.178 105.427C211.155 156.076 229.59 162.093 264.333 166.607C299.076 171.12 337.718 183.657 362.889 212.24" stroke="url(#paint0_linear_25:218)"></path>
                <path d="M-22.1107 72.3303C5.65989 66.4798 73.3965 64.9086 122.178 105.427C183.155 156.076 201.59 162.093 236.333 166.607C271.076 171.12 309.718 183.657 334.889 212.24" stroke="url(#paint1_linear_25:218)"></path>
                <path d="M-53.1107 72.3303C-25.3401 66.4798 42.3965 64.9086 91.1783 105.427C152.155 156.076 170.59 162.093 205.333 166.607C240.076 171.12 278.718 183.657 303.889 212.24" stroke="url(#paint2_linear_25:218)"></path>
                <path d="M-98.1618 65.0889C-68.1416 60.0601 4.73364 60.4882 56.0734 102.431C120.248 154.86 139.905 161.419 177.137 166.956C214.37 172.493 255.575 186.165 281.856 215.481" stroke="url(#paint3_linear_25:218)"></path>
                <circle opacity="0.8" cx="214.505" cy="60.5054" r="49.7205" transform="rotate(-13.421 214.505 60.5054)" stroke="url(#paint4_linear_25:218)"></circle>
                <circle cx="220" cy="63" r="43" fill="url(#paint5_radial_25:218)"></circle>
                <defs>
                <linearGradient id="paint0_linear_25:218" x1="184.389" y1="69.2405" x2="184.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint1_linear_25:218" x1="156.389" y1="69.2405" x2="156.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint2_linear_25:218" x1="125.389" y1="69.2405" x2="125.389" y2="212.24" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint3_linear_25:218" x1="93.8507" y1="67.2674" x2="89.9278" y2="210.214" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#009500"></stop>
                </linearGradient>
                <linearGradient id="paint4_linear_25:218" x1="214.505" y1="10.2849" x2="212.684" y2="99.5816" gradientUnits="userSpaceOnUse">
                <stop stop-color="#009500"></stop>
                <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                </linearGradient>
                <radialGradient id="paint5_radial_25:218" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(220 63) rotate(90) scale(43)">
                <stop offset="0.145833" stop-color="white" stop-opacity="0"></stop>
                <stop offset="1" stop-color="white" stop-opacity="0.08"></stop>
                </radialGradient>
                </defs>
                </svg>
            <div class="container-sp">
                <div class="hero-inner-sp">
                    <h2 class="welcome-title-sp">Bem-vindo ao Liquiloan! A nossa experiência e especialização são a sua chave para o sucesso financeiro. Trabalhamos para garantir que os seus fundos tragam o máximo retorno.</h2>
                    
                </div>
            </div>
       </section>
       

<div class="container" style="padding: 117px 0px;">
    <div class="content-block">
        <h2 class="stilTitle" style="padding: 0 13px;">Liquiloan | Termos de serviço</h2>
        <div class="content" style="padding: 0 13px; color: rgb(149, 156, 177);"><h3>CONCORDÂNCIA COM OS NOSSOS TERMOS LEGAIS</h3>

<p>Nós somos Sítio Web ( 'Empresa', 'nós', 'nos', ou 'nosso' ) .</p>

<p>Operamos o site Sítio Web (o "Site"), bem como quaisquer outros produtos e serviços relacionados que se refiram ou tenham links para estes termos legais (os "Termos Legais") (coletivamente, os "Serviços").</p>

<p>__________</p>

<p>Pode contactar-nos por e-mail para  ou por correio para  .</p>

<p>Estes Termos Legais constituem um acordo juridicamente vinculativo feito entre você, seja pessoalmente ou em nome de uma entidade ("você"), e , em relação ao seu acesso e Sítio Webuso dos Serviços. Você concorda que, ao acessar os Serviços, leu, entendeu e concordou em ficar vinculado a todos estes Termos Legais. SE VOCÊ NÃO CONCORDAR COM TODOS ESTES TERMOS LEGAIS, ENTÃO VOCÊ ESTÁ EXPRESSAMENTE PROIBIDO DE USAR OS SERVIÇOS E VOCÊ DEVE INTERROMPER O USO IMEDIATAMENTE.</p>

<p>Iremos notificá-lo previamente de quaisquer alterações programadas aos Serviços que estiver a utilizar. Os Termos Legais modificados entrarão em vigor após a publicação ou notificação por , conforme indicado na mensagem de e-mail. Ao continuar a usar os Serviços após a data efetiva de quaisquer alterações, você concorda em ficar vinculado aos termos modificados.</p>

<p>Recomendamos que imprima uma cópia destes Termos Legais para os seus registos.</p>

<h3>ÍNDICE</h3>

<div style="display: flex; flex-direction: column; gap: 5px;">
    <a href="#services">1. OS NOSSOS SERVIÇOS</a><a href="#ip">2. DIREITOS DE PROPRIEDADE INTELECTUAL</a><a href="#userreps">3. REPRESENTAÇÕES DO UTILIZADOR</a><a href="#userreg">4. REGISTO DE UTILIZADOR</a><a href="#products">5. PRODUTOS</a><a href="#purchases">6. COMPRAS E PAGAMENTO</a><a href="#returnyes">7. POLÍTICA DE DEVOLUÇÕES/REEMBOLSOS</a><a href="#software">8. SOFTWARE</a><a href="#prohibited">9. ATIVIDADES PROIBIDAS</a><a href="#ugc">10. CONTRIBUIÇÕES GERADAS PELO USUÁRIO</a><a href="#license">11. LICENÇA</a> DE <a href="#reviews">CONTRIBUIÇÃO 12. ORIENTAÇÕES PARA AS AVALIAÇÕES</a><a href="#socialmedia">13. REDES SOCIAIS</a><a href="#thirdparty">14. WEBSITES E CONTEÚDOS DE TERCEIROS</a><a href="#sitemanage">15. GESTÃO DE SERVIÇOS</a><a href="#ppyes">16. POLÍTICA DE PRIVACIDADE</a><a href="#dmca">17. AVISO E POLÍTICA DA LEI DE DIREITOS AUTORAIS DO MILÊNIO DIGITAL (DMCA)</a><a href="#terms">18. PRAZO E RESCISÃO</a><a href="#modifications">19. MODIFICAÇÕES E INTERRUPÇÕES</a><a href="#law">20. LEI APLICÁVEL</a><a href="#disputes">21. RESOLUÇÃO DE LITÍGIOS</a><a href="#corrections">22. CORREÇÕES</a><a href="#disclaimer">23. DECLARAÇÃO DE EXONERAÇÃO DE RESPONSABILIDADE</a><a href="#liability">24. LIMITAÇÕES DE RESPONSABILIDADE</a><a href="#indemnification">25. INDEMNIZAÇÃO</a><a href="#userdata">26. DADOS DO UTILIZADOR</a><a href="#electronic">27. COMUNICAÇÕES ELETRÓNICAS, TRANSAÇÕES E ASSINATURAS</a><a href="#california">28. USUÁRIOS E RESIDENTES DA CALIFÓRNIA</a><a href="#misc">29. DIVERSOS</a><a href="#contact">30. CONTACTE-NOS</a>
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
</div>
<br>

<h3 id="services">1. OS NOSSOS SERVIÇOS</h3>

<p>As informações fornecidas ao usar os Serviços não se destinam a distribuição ou uso por qualquer pessoa ou entidade em qualquer jurisdição ou país onde tal distribuição ou uso seria contrário à lei ou regulamento ou que nos sujeitaria a qualquer requisito de registro dentro de tal jurisdição ou país. Assim, as pessoas que optam por aceder aos Serviços a partir de outras localizações fazem-no por sua própria iniciativa e são as únicas responsáveis pelo cumprimento das leis locais, se e na medida em que as leis locais sejam aplicáveis.</p>

<p>Os Serviços não são adaptados para cumprir as regulamentações específicas do setor (Health Insurance Portability and Accountability Act (HIPAA), Federal Information Security Management Act (FISMA), etc.), portanto, se suas interações estiverem sujeitas a tais leis, você não poderá usar os Serviços. Você não pode usar os Serviços de uma forma que viole a Lei Gramm-Leach-Bliley (GLBA).</p>

<h3 id="ip">2. DIREITOS DE PROPRIEDADE INTELECTUAL</h3>

<p>A nossa propriedade intelectual</p>

<p>Somos o proprietário ou o licenciado de todos os direitos de propriedade intelectual dos nossos Serviços, incluindo todo o código-fonte, bases de dados, funcionalidades, software, designs de websites, áudio, vídeo, texto, fotografias e gráficos nos Serviços (coletivamente, o "Conteúdo"), bem como as marcas comerciais, marcas de serviço e logótipos neles contidos (as "Marcas").</p>

<p>O nosso Conteúdo e Marcas estão protegidos por leis de direitos de autor e marcas comerciais (e vários outros direitos de propriedade intelectual e leis de concorrência desleal) e tratados nos Estados Unidos e em todo o mundo.</p>

<p>O Conteúdo e as Marcas são fornecidos nos ou através dos Serviços "NO ESTADO EM QUE SE ENCONTRAM" apenas para uso pessoal, não comercial ou para fins comerciais internos.</p>

<p>A sua utilização dos nossos Serviços</p>

<p>Sujeito à sua conformidade com estes Termos Legais, incluindo a secção "ATIVIDADES PROIBIDAS" abaixo, concedemos-lhe uma licença não exclusiva, intransmissível e revogável para:
aceder aos Serviços; e ainda
transferir ou imprimir uma cópia de qualquer parte do Conteúdo a que tenha tido acesso adequado.
exclusivamente para seu uso pessoal, não comercial ou propósito comercial interno.</p>

<p>Exceto conforme estabelecido nesta seção ou em qualquer outro lugar em nossos Termos Legais, nenhuma parte dos Serviços e nenhum Conteúdo ou Marcas podem ser copiados, reproduzidos, agregados, republicados, carregados, publicados, exibidos publicamente, codificados, traduzidos, transmitidos, distribuídos, vendidos, licenciados ou de outra forma explorados para qualquer finalidade comercial, sem nossa permissão prévia e expressa por escrito.</p>

<p>Se desejar fazer qualquer uso dos Serviços, Conteúdo ou Marcas que não seja o estabelecido nesta seção ou em qualquer outro lugar em nossos Termos Legais, envie sua solicitação para: . Se alguma vez lhe concedermos permissão para publicar, reproduzir ou apresentar publicamente qualquer parte dos nossos Serviços ou Conteúdos, deve identificar-nos como proprietários ou licenciantes dos Serviços, Conteúdo ou Marcas e garantir que qualquer aviso de direitos de autor ou de propriedade aparece ou é visível ao publicar, reproduzir ou apresentar o nosso Conteúdo.</p>

<p>Reservamo-nos todos os direitos não expressamente concedidos a você nos Serviços, Conteúdo e Marcas.</p>

<p>Qualquer violação destes Direitos de Propriedade Intelectual constituirá uma violação material dos nossos Termos Legais e o seu direito de utilizar os nossos Serviços terminará imediatamente.</p>

<p>As suas submissões e contribuições</p>

<p>Reveja cuidadosamente esta secção e a secção "ATIVIDADES PROIBIDAS" antes de utilizar os nossos Serviços para compreender os (a) direitos que nos confere e (b) as obrigações que tem quando publica ou carrega qualquer conteúdo através dos Serviços.</p>

<p>Submissões: Ao enviar-nos diretamente qualquer pergunta, comentário, sugestão, ideia, feedback ou outras informações sobre os Serviços ("Submissões"), concorda em atribuir-nos todos os direitos de propriedade intelectual sobre essa Submissão. Você concorda que seremos proprietários desta Submissão e teremos direito ao seu uso irrestrito e divulgação para qualquer finalidade legal, comercial ou outra, sem reconhecimento ou compensação para você.</p>

<p>Contribuições: Os Serviços podem convidá-lo a conversar, contribuir ou participar de blogs, quadros de mensagens, fóruns on-line e outras funcionalidades durante as quais você pode criar, enviar, publicar, exibir, transmitir, publicar, distribuir ou transmitir conteúdo e materiais para nós ou através dos Serviços, incluindo, mas não limitado a, texto, escritos, vídeo, áudio, fotografias, música, gráficos, comentários,  comentários, sugestões de classificação, informações pessoais ou outro material ("Contribuições"). Qualquer Submissão que seja publicada publicamente será também tratada como uma Contribuição.</p>

<p>Você entende que as Contribuições podem ser visualizadas por outros usuários dos Serviços e, possivelmente, por meio de sites de terceiros.</p>

<p>Quando publica Contribuições, concede-nos uma licença (incluindo a utilização do seu nome, marcas registadas e logótipos): Ao publicar quaisquer Contribuições, concede-nos um direito e uma licença irrestritos, ilimitados, irrevogáveis, perpétuos, não exclusivos, transferíveis, isentos de royalties, totalmente pagos, em todo o mundo, para: utilizar, copiar, reproduzir, distribuir, vender, revender, publicar, difundir, retitular, armazenar, executar publicamente, reformatar, traduzir, expor (no todo ou em parte),  e explorar as suas Contribuições (incluindo, sem limitação, a sua imagem, nome e voz) para qualquer finalidade, comercial, publicitária ou outra, para preparar trabalhos derivados de, ou incorporar noutros trabalhos, as suas Contribuições, e para sublicenciar as licenças concedidas nesta secção. A nossa utilização e distribuição podem ocorrer em quaisquer formatos multimédia e através de quaisquer canais multimédia.</p>

<p>Esta licença inclui a nossa utilização do seu nome, nome da empresa e nome de franquia, conforme aplicável, e qualquer uma das marcas comerciais, marcas de serviço, nomes comerciais, logótipos e imagens pessoais e comerciais que fornecer.</p>

<p>O utilizador é responsável pelo que publica ou carrega: Ao enviar-nos Submissões e/ou publicar Contribuições através de qualquer parte dos Serviços ou ao tornar as Contribuições acessíveis através dos Serviços, ligando a sua conta através dos Serviços a qualquer uma das suas contas de redes sociais, você:
confirmar que leu e concorda com as nossas "ATIVIDADES PROIBIDAS" e que não publicará, enviará, publicará, carregará ou transmitirá através dos Serviços qualquer Submissão nem publicará qualquer Contribuição que seja ilegal, assediante, odiosa, prejudicial, difamatória, obscena, intimidadora, abusiva, discriminatória, ameaçadora para qualquer pessoa ou grupo, sexualmente explícita, falsa, imprecisa, enganosa ou enganosa;
na medida permitida pela lei aplicável, renunciar a todo e qualquer direito moral a tal Submissão e/ou Contribuição;
garantir que tais Submissões e/ou Contribuições são originais para si ou que tem os direitos e licenças necessários para submeter tais Submissões e/ou Contribuições e que tem plena autoridade para nos conceder os direitos acima mencionados em relação às suas Submissões e/ou Contribuições; e ainda
garantir e declarar que os seus Envios e/ou Contribuições não constituem informações confidenciais.
Você é o único responsável por seus Envios e/ou Contribuições e concorda expressamente em nos reembolsar por todas e quaisquer perdas que possamos sofrer devido à sua violação de (a) esta seção, (b) direitos de propriedade intelectual de terceiros ou (c) lei aplicável.</p>

<p>Podemos remover ou editar seu Conteúdo: Embora não tenhamos nenhuma obrigação de monitorar quaisquer Contribuições, teremos o direito de remover ou editar quaisquer Contribuições a qualquer momento sem aviso prévio se, em nossa opinião razoável, considerarmos tais Contribuições prejudiciais ou em violação destes Termos Legais. Se removermos ou editarmos tais Contribuições, também poderemos suspender ou desativar a sua conta e denunciá-lo às autoridades.</p>

<p>Violação dos direitos de autor</p>

<p>Respeitamos os direitos de propriedade intelectual de terceiros. Se você acredita que qualquer material disponível nos ou através dos Serviços infringe qualquer direito autoral que você possui ou controla, consulte imediatamente a seção "AVISO E POLÍTICA DA LEI DE DIREITOS AUTORAIS DO MILÊNIO DIGITAL (DMCA)" abaixo.</p>

<h3 id="userreps">3. REPRESENTAÇÕES DO UTILIZADOR</h3>

<p>Ao usar os Serviços, você declara e garante que: (1) todas as informações de registro enviadas serão verdadeiras, precisas, atuais e completas; (2) você manterá a precisão de tais informações e atualizará prontamente essas informações de registro conforme necessário; (3) tem capacidade jurídica e concorda em cumprir estes Termos Legais; (4) não é menor de idade na jurisdição em que reside; (5) você não acessará os Serviços por meios automatizados ou não humanos, seja por meio de um bot, script ou de outra forma; (6) não utilizará os Serviços para qualquer finalidade ilegal ou não autorizada; e (7) a sua utilização dos Serviços não violará qualquer lei ou regulamento aplicável.</p>

<p>Se você fornecer qualquer informação falsa, imprecisa, desatualizada ou incompleta, temos o direito de suspender ou encerrar sua conta e recusar todo e qualquer uso atual ou futuro dos Serviços (ou qualquer parte deles).</p>

<h3 id="userreg">4. REGISTO DO UTILIZADOR</h3>

<p>Poderá ser-lhe pedido que se registe para utilizar os Serviços. Você concorda em manter sua senha confidencial e será responsável por todo o uso de sua conta e senha. Reservamo-nos o direito de remover, recuperar ou alterar um nome de usuário que você selecionar se determinarmos, a nosso exclusivo critério, que esse nome de usuário é inadequado, obsceno ou de outra forma censurável.</p>

<h3 id="products">5. PRODUTOS</h3>

<p>Fazemos todos os esforços para exibir com a maior precisão possível as cores, características, especificações e detalhes dos produtos disponíveis nos Serviços. No entanto, não garantimos que as cores, características, especificações e detalhes dos produtos serão precisos, completos, confiáveis, atuais ou livres de outros erros, e sua exibição eletrônica pode não refletir com precisão as cores e detalhes reais dos produtos. Todos os produtos estão sujeitos a disponibilidade, e não podemos garantir que os itens estarão em estoque. Reservamo-nos o direito de descontinuar quaisquer produtos a qualquer momento por qualquer motivo. Os preços de todos os produtos estão sujeitos a alterações.</p>

<h3 id="purchases">6. COMPRAS E PAGAMENTO</h3>

<p>Aceitamos as seguintes formas de pagamento:</p>
<ul>
    <li>Vistos</li>
    <li>Mastercard</li>
    <li>American Express</li>
    <li>PayPal</li>
</ul>

<p>Você concorda em fornecer informações de compra e conta atuais, completas e precisas para todas as compras feitas através dos Serviços. Você concorda ainda em atualizar imediatamente as informações de conta e pagamento, incluindo endereço de e-mail, método de pagamento e data de validade do cartão de pagamento, para que possamos concluir suas transações e contatá-lo conforme necessário. O imposto sobre vendas será adicionado ao preço das compras, conforme considerado exigido por nós. Podemos alterar os preços a qualquer momento.</p>

<p>Você concorda em pagar todos os encargos aos preços então em vigor para suas compras e quaisquer taxas de envio aplicáveis, e você nos autoriza a cobrar o seu provedor de pagamento escolhido por quaisquer valores ao fazer seu pedido. Reservamo-nos o direito de corrigir quaisquer erros ou erros nos preços, mesmo que já tenhamos solicitado ou recebido o pagamento.</p>

<p>Reservamo-nos o direito de recusar qualquer encomenda feita através dos Serviços. Podemos, a nosso exclusivo critério, limitar ou cancelar quantidades compradas por pessoa, por família ou por pedido. Essas restrições podem incluir pedidos feitos por ou sob a mesma conta de cliente, o mesmo método de pagamento e/ou pedidos que usam o mesmo endereço de cobrança ou entrega. Reservamo-nos o direito de limitar ou proibir encomendas que, a nosso exclusivo critério, pareçam ser feitas por revendedores, revendedores ou distribuidores.</p>

<h3 id="returnyes">7. POLÍTICA DE DEVOLUÇÕES/REEMBOLSOS</h3>

<p>Por favor, reveja a nossa Política de Devoluções publicada nos Serviços antes de fazer quaisquer compras.</p>

<h3 id="software">8. SOFTWARE</h3>

<p>Podemos incluir software para uso em conexão com nossos Serviços. Se esse software for acompanhado por um contrato de licença de utilizador final ("EULA"), os termos do EULA regerão a sua utilização do software. Se esse software não for acompanhado por um EULA, concedemos-lhe uma licença não exclusiva, revogável, pessoal e intransmissível para utilizar esse software apenas em ligação com os nossos serviços e de acordo com estes Termos Legais. Qualquer software e qualquer documentação relacionada é fornecida "NO ESTADO EM QUE SE ENCONTRA" sem garantia de qualquer tipo, expressa ou implícita, incluindo, sem limitação, as garantias implícitas de comercialização, adequação a uma finalidade específica ou não violação. Você aceita todo e qualquer risco decorrente do uso ou desempenho de qualquer software. Você não pode reproduzir ou redistribuir qualquer software, exceto de acordo com o EULA ou estes Termos Legais.</p>

<h3 id="prohibited">9. ATIVIDADES PROIBIDAS</h3>

<p>Você não pode acessar ou usar os Serviços para qualquer outra finalidade que não seja aquela para a qual disponibilizamos os Serviços. Os Serviços não podem ser usados em conexão com quaisquer esforços comerciais, exceto aqueles que são especificamente endossados ou aprovados por nós.</p>

<p>Como usuário dos Serviços, você concorda em não:</p>
<ul>
    <li>Recuperar sistematicamente dados ou outro conteúdo dos Serviços para criar ou compilar, direta ou indiretamente, uma coleção, compilação, banco de dados ou diretório sem nossa permissão por escrito.</li>
    <li>Enganar, fraudar ou enganar a nós e a outros usuários, especialmente em qualquer tentativa de aprender informações confidenciais da conta, como senhas de usuário.</li>
    <li>Contornar, desativar ou interferir de outra forma com recursos relacionados à segurança dos Serviços, incluindo recursos que impeçam ou restrinjam o uso ou cópia de qualquer Conteúdo ou imponham limitações ao uso dos Serviços e/ou do Conteúdo neles contido.</li>
    <li>Menosprezar, manchar ou de outra forma prejudicar, na nossa opinião, a nós e/ou aos Serviços.</li>
    <li>Usar qualquer informação obtida dos Serviços para assediar, abusar ou prejudicar outra pessoa.</li>
    <li>Fazer uso indevido dos nossos serviços de suporte ou enviar falsas denúncias de abuso ou má conduta.</li>
    <li>Utilizar os Serviços de forma inconsistente com quaisquer leis ou regulamentos aplicáveis.</li>
    <li>Envolver-se em enquadramentos não autorizados ou links para os Serviços.</li>
    <li>Carregar ou transmitir (ou tentar carregar ou transmitir) vírus, cavalos de Troia ou outro material, incluindo o uso excessivo de letras maiúsculas e spam (publicação contínua de texto repetitivo), que interfira com o uso e aproveitamento ininterruptos dos Serviços por qualquer parte ou modifique, prejudique, interrompa, altere ou interfira com o uso, recursos, funções, operação ou manutenção dos Serviços.</li>
    <li>Envolva-se em qualquer uso automatizado do sistema, como o uso de scripts para enviar comentários ou mensagens, ou usando qualquer mineração de dados, robôs ou ferramentas semelhantes de coleta e extração de dados.</li>
    <li>Exclua o aviso de direitos autorais ou outros direitos de propriedade de qualquer Conteúdo.</li>
    <li>Tentar fazer-se passar por outro utilizador ou pessoa ou utilizar o nome de utilizador de outro utilizador.</li>
    <li>Carregar ou transmitir (ou tentar carregar ou transmitir) qualquer material que atue como um mecanismo passivo ou ativo de recolha ou transmissão de informações, incluindo, sem limitação, formatos de intercâmbio de gráficos claros ('gifs'), 1×1 pixels, web bugs, cookies ou outros dispositivos semelhantes (por vezes referidos como 'spyware' ou 'mecanismos de recolha passiva' ou 'pcms').</li>
    <li>Interferir, interromper ou criar uma carga indevida nos Serviços ou nas redes ou serviços conectados aos Serviços.</li>
    <li>Assediar, incomodar, intimidar ou ameaçar qualquer um dos nossos funcionários ou agentes envolvidos no fornecimento de qualquer parte dos Serviços a você.</li>
    <li>Tentar contornar quaisquer medidas dos Serviços concebidas para impedir ou restringir o acesso aos Serviços ou a qualquer parte dos Serviços.</li>
    <li>Copiar ou adaptar o software dos Serviços, incluindo, entre outros, Flash, PHP, HTML, JavaScript ou outro código.</li>
    <li>Exceto conforme permitido pela lei aplicável, decifrar, descompilar, desmontar ou fazer engenharia reversa de qualquer software que inclua ou de alguma forma faça parte dos Serviços.</li>
    <li>Exceto quando possa ser o resultado do mecanismo de pesquisa padrão ou do uso do navegador da Internet, use, lance, desenvolva ou distribua qualquer sistema automatizado, incluindo, sem limitação, qualquer spider, robô, utilitário de trapaça, scraper ou leitor offline que acesse os Serviços, ou use ou inicie qualquer script ou outro software não autorizado.</li>
    <li>Use um agente de compras ou agente de compras para fazer compras nos Serviços.</li>
    <li>Fazer qualquer uso não autorizado dos Serviços, incluindo a coleta de nomes de usuário e/ou endereços de e-mail de usuários por meios eletrônicos ou outros com a finalidade de enviar e-mails não solicitados ou criar contas de usuário por meios automatizados ou sob falsos pretextos.</li>
    <li>Usar os Serviços como parte de qualquer esforço para competir conosco ou usar os Serviços e/ou o Conteúdo para qualquer empreendimento gerador de receita ou empreendimento comercial.</li>
    <li>Utilizar os Serviços para publicitar ou oferecer a venda de bens e serviços.</li>
</ul>

<h3 id="ugc">10. CONTRIBUIÇÕES GERADAS PELO UTILIZADOR</h3>

<p>Os Serviços podem convidá-lo a conversar, contribuir ou participar de blogs, quadros de mensagens, fóruns on-line e outras funcionalidades, e podem fornecer a você a oportunidade de criar, enviar, publicar, exibir, transmitir, executar, publicar, distribuir ou transmitir conteúdo e materiais para nós ou nos Serviços, incluindo, entre outros, texto, escritos, vídeo, áudio,  fotografias, gráficos, comentários, sugestões, informações pessoais ou outro material (coletivamente, "Contribuições"). As contribuições podem ser visualizadas por outros utilizadores dos Serviços e através de websites de terceiros. Como tal, quaisquer Contribuições que transmitir podem ser tratadas como não confidenciais e não proprietárias. Ao criar ou disponibilizar quaisquer Contribuições, declara e garante que:</p>
<ul>
    <li>A criação, distribuição, transmissão, exibição pública ou desempenho, e o acesso, download ou cópia de suas Contribuições não violam e não infringirão os direitos de propriedade, incluindo, entre outros, direitos autorais, patentes, marcas registradas, segredos comerciais ou direitos morais de terceiros.</li>
    <li>Você é o criador e proprietário ou tem as licenças, direitos, consentimentos, liberações e permissões necessárias para usar e nos autorizar, aos Serviços e a outros usuários dos Serviços a usar suas Contribuições de qualquer maneira contemplada pelos Serviços e por estes Termos Legais.</li>
    <li>Você tem o consentimento por escrito, liberação e/ou permissão de cada pessoa identificável em suas Contribuições para usar o nome ou semelhança de cada uma dessas pessoas identificáveis para permitir a inclusão e o uso de suas Contribuições de qualquer maneira contemplada pelos Serviços e estes Termos Legais.</li>
    <li>As suas contribuições não são falsas, imprecisas ou enganosas.</li>
    <li>As suas Contribuições não são publicidade não solicitada ou não autorizada, materiais promocionais, esquemas de pirâmide, cartas em cadeia, spam, e-mails em massa ou outras formas de solicitação.</li>
    <li>Suas Contribuições não são obscenas, lascivas, lascivas, imundas, violentas, assediadoras, difamatórias, caluniosas ou de outra forma censuráveis (conforme determinado por nós).</li>
    <li>Suas contribuições não ridicularizam, zombam, menosprezam, intimidam ou abusam de ninguém.</li>
    <li>As suas Contribuições não são utilizadas para assediar ou ameaçar (no sentido jurídico desses termos) qualquer outra pessoa e para promover violência contra uma pessoa ou classe de pessoas específica.</li>
    <li>As suas Contribuições não violam qualquer lei, regulamento ou regra aplicável.</li>
    <li>As suas Contribuições não violam a privacidade ou os direitos de publicidade de terceiros.</li>
    <li>As suas Contribuições não violam qualquer lei aplicável relativa à pornografia infantil, ou de outra forma destinadas a proteger a saúde ou o bem-estar de menores.</li>
    <li>As suas Contribuições não incluem quaisquer comentários ofensivos relacionados com a raça, origem nacional, género, preferência sexual ou deficiência física.</li>
    <li>Suas Contribuições não violam de outra forma, ou vinculam a material que viola, qualquer disposição destes Termos Legais, ou qualquer lei ou regulamento aplicável.</li>
</ul>

<p>Qualquer utilização dos Serviços que viole o acima exposto viola estes Termos Legais e pode resultar, entre outras coisas, na rescisão ou suspensão dos seus direitos de utilização dos Serviços.</p>

<h3 id="license">11. LICENÇA DE CONTRIBUIÇÃO</h3>

<p>Ao publicar as suas Contribuições para qualquer parte dos Serviços ou ao tornar as Contribuições acessíveis aos Serviços, ligando a sua conta dos Serviços a qualquer uma das suas contas de redes sociais, o utilizador concede automaticamente, e declara e garante que tem o direito de nos conceder, um direito irrestrito, ilimitado, irrevogável, perpétuo, não exclusivo, transferível e isento de royalties,  totalmente pago, direito mundial e licença para hospedar, usar, copiar, reproduzir, divulgar, vender, revender, publicar, difundir, retitular, arquivar, armazenar, armazenar em cache, executar publicamente, exibir publicamente, reformatar, traduzir, transmitir, extrair (no todo ou em parte) e distribuir tais Contribuições (incluindo, sem limitação, sua imagem e voz) para qualquer finalidade, comercial, publicitária ou de outra forma, e para preparar trabalhos derivados de,  ou incorporar em outras obras, tais Contribuições, e conceder e autorizar sublicenças das anteriores. A utilização e distribuição podem ocorrer em quaisquer formatos multimédia e através de quaisquer canais multimédia.</p>

<p>Esta licença aplicar-se-á a qualquer forma, meio de comunicação ou tecnologia agora conhecida ou futuramente desenvolvida, e inclui a nossa utilização do seu nome, nome da empresa e nome da franquia, conforme aplicável, e qualquer uma das marcas comerciais, marcas de serviço, nomes comerciais, logótipos e imagens pessoais e comerciais que fornecer. Você renuncia a todos os direitos morais em suas Contribuições, e garante que os direitos morais não foram de outra forma afirmados em suas Contribuições.</p>

<p>Não reivindicamos qualquer propriedade sobre as suas Contribuições. Você mantém a propriedade total de todas as suas Contribuições e quaisquer direitos de propriedade intelectual ou outros direitos de propriedade associados às suas Contribuições. Não somos responsáveis por quaisquer declarações ou representações nas suas Contribuições fornecidas por si em qualquer área dos Serviços. Você é o único responsável por suas Contribuições para os Serviços e concorda expressamente em nos exonerar de toda e qualquer responsabilidade e abster-se de qualquer ação legal contra nós em relação às suas Contribuições.</p>

<p>Temos o direito, a nosso exclusivo e absoluto critério, (1) de editar, redigir ou alterar quaisquer Contribuições; (2) recategorizar quaisquer Contribuições para colocá-las em locais mais apropriados nos Serviços; e (3) pré-selecionar ou excluir quaisquer Contribuições a qualquer momento e por qualquer motivo, sem aviso prévio. Não temos qualquer obrigação de monitorizar as suas Contribuições.</p>

<h3 id="reviews">12. ORIENTAÇÕES PARA AS AVALIAÇÕES</h3>

<p>Podemos fornecer-lhe áreas nos Serviços para deixar comentários ou classificações. Ao publicar uma avaliação, você deve cumprir os seguintes critérios: (1) você deve ter experiência em primeira mão com a pessoa/entidade que está sendo avaliada; (2) as suas avaliações não devem conter palavrões ofensivos ou linguagem abusiva, racista, ofensiva ou odiosa; (3) suas avaliações não devem conter referências discriminatórias com base em religião, raça, sexo, origem nacional, idade, estado civil, orientação sexual ou deficiência; (4) as suas avaliações não devem conter referências a atividades ilegais; (5) você não deve ser afiliado com concorrentes se postar avaliações negativas; (6) não deve tirar quaisquer conclusões quanto à legalidade da conduta; (7) não pode publicar declarações falsas ou enganosas; e (8) não pode organizar uma campanha que incentive outras pessoas a publicar avaliações, sejam elas positivas ou negativas.</p>

<p>Podemos aceitar, rejeitar ou remover comentários a nosso exclusivo critério. Não temos absolutamente nenhuma obrigação de examinar avaliações ou excluir avaliações, mesmo que alguém considere as avaliações censuráveis ou imprecisas. As avaliações não são endossadas por nós e não representam necessariamente nossas opiniões ou as opiniões de qualquer um de nossos afiliados ou parceiros. Nós não assumimos responsabilidade por qualquer revisão ou por quaisquer reivindicações, responsabilidades ou perdas resultantes de qualquer revisão. Ao publicar uma avaliação, você nos concede um direito e licença perpétuos, não exclusivos, mundiais, isentos de royalties, totalmente pagos, atribuíveis e sublicenciáveis para reproduzir, modificar, traduzir, transmitir por qualquer meio, exibir, executar e/ou distribuir todo o conteúdo relacionado à revisão.</p>

<h3 id="socialmedia">13. REDES SOCIAIS</h3>

<p>Como parte da funcionalidade dos Serviços, pode associar a sua conta a contas online que tenha com fornecedores de serviços terceiros (cada uma dessas contas, uma "Conta de Terceiros") ao: (1) fornecer as informações de início de sessão da sua Conta de Terceiros através dos Serviços; ou (2) permitir-nos aceder à sua Conta de Terceiros, conforme permitido ao abrigo dos termos e condições aplicáveis que regem a sua utilização de cada Conta de Terceiros. Você declara e garante que tem o direito de divulgar suas informações de login da Conta de Terceiros para nós e/ou nos conceder acesso à sua Conta de Terceiros, sem violar por você qualquer um dos termos e condições que regem seu uso da Conta de Terceiros aplicável e sem nos obrigar a pagar quaisquer taxas ou nos sujeitar a quaisquer limitações de uso impostas pelo provedor de serviços terceirizado da Conta de Terceiros. Ao conceder-nos acesso a quaisquer Contas de Terceiros, compreende que (1) podemos aceder, disponibilizar e armazenar (se aplicável) qualquer conteúdo que tenha fornecido e armazenado na sua Conta de Terceiros (o "Conteúdo da Rede Social") para que esteja disponível nos e através dos Serviços através da sua conta, incluindo, sem limitação, quaisquer listas de amigos e (2) podemos submeter e receber da sua Conta de Terceiros informações adicionais na medida em que o utilizador são notificados quando associa a sua conta à Conta de Terceiros. Dependendo das Contas de Terceiros que escolher e sujeitas às definições de privacidade que definiu nessas Contas de Terceiros, as informações de identificação pessoal que publicar nas suas Contas de Terceiros poderão estar disponíveis na e através da sua conta nos Serviços. Observe que, se uma Conta de Terceiros ou serviço associado ficar indisponível ou nosso acesso a essa Conta de Terceiros for encerrado pelo provedor de serviços terceirizado, o Conteúdo da Rede Social poderá não estar mais disponível nos e através dos Serviços. Você terá a capacidade de desativar a conexão entre sua conta nos Serviços e suas Contas de Terceiros a qualquer momento. TENHA EM ATENÇÃO QUE A SUA RELAÇÃO COM OS PRESTADORES DE SERVIÇOS TERCEIROS ASSOCIADOS ÀS SUAS CONTAS DE TERCEIROS É REGIDA EXCLUSIVAMENTE PELO(S) SEU(S) CONTRATO(S) COM ESSES FORNECEDORES DE SERVIÇOS TERCEIROS. Não fazemos nenhum esforço para rever qualquer Conteúdo de Rede Social para qualquer finalidade, incluindo, mas não limitado a, precisão, legalidade ou não violação, e não somos responsáveis por qualquer Conteúdo de Rede Social. Você reconhece e concorda que podemos acessar seu catálogo de endereços de e-mail associado a uma Conta de Terceiros e sua lista de contatos armazenada em seu dispositivo móvel ou tablet apenas para fins de identificação e informação sobre os contatos que também se registraram para usar os Serviços. Pode desativar a ligação entre os Serviços e a sua Conta de Terceiros contactando-nos utilizando as informações de contacto abaixo ou através das definições da sua conta (se aplicável). Tentaremos eliminar qualquer informação armazenada nos nossos servidores que tenha sido obtida através dessa Conta de Terceiros, exceto o nome de utilizador e a foto de perfil que fiquem associados à sua conta.</p>

<h3 id="thirdparty">14. SITES E CONTEÚDOS DE TERCEIROS</h3>

<p>Os Serviços podem conter (ou você pode ser enviado através do Site) links para outros sites ("Sites de Terceiros"), bem como artigos, fotografias, texto, gráficos, imagens, designs, música, som, vídeo, informações, aplicativos, software e outros conteúdos ou itens pertencentes ou originários de terceiros ("Conteúdo de Terceiros"). Tais Sites de Terceiros e Conteúdo de Terceiros não são investigados, monitorados ou verificados quanto à precisão, adequação ou integridade por nós, e não somos responsáveis por quaisquer Sites de Terceiros acessados através dos Serviços ou qualquer Conteúdo de Terceiros publicado, disponível ou instalado a partir dos Serviços, incluindo o conteúdo, precisão, ofensividade, opiniões, confiabilidade, práticas de privacidade ou outras políticas de ou contidas nos Sites de Terceiros ou nos Sites de Terceiros Conteúdo. A inclusão, ligação ou permissão da utilização ou instalação de quaisquer Websites de Terceiros ou de qualquer Conteúdo de Terceiros não implica a aprovação ou endosso dos mesmos por nós. Se decidir abandonar os Serviços e aceder aos Websites de Terceiros ou utilizar ou instalar qualquer Conteúdo de Terceiros, fá-lo por sua conta e risco, e deve estar ciente de que estes Termos Legais já não se aplicam. Deve rever os termos e políticas aplicáveis, incluindo práticas de privacidade e recolha de dados, de qualquer website para o qual navegue a partir dos Serviços ou relacionados com quaisquer aplicações que utilize ou instale a partir dos Serviços. Quaisquer compras que você fizer através de sites de terceiros serão através de outros sites e de outras empresas, e não assumimos qualquer responsabilidade em relação a tais compras que são exclusivamente entre você e o terceiro aplicável. Você concorda e reconhece que não endossamos os produtos ou serviços oferecidos em sites de terceiros e você deve nos isentar de qualquer dano causado pela sua compra de tais produtos ou serviços. Além disso, você deve nos isentar de quaisquer perdas sofridas por você ou danos causados a você relacionados ou resultantes de qualquer forma de qualquer Conteúdo de Terceiros ou qualquer contato com Sites de Terceiros.</p>

<h3 id="sitemanage">15. GESTÃO DE SERVIÇOS</h3>

<p>Reservamo-nos o direito, mas não a obrigação, de: (1) monitorizar os Serviços em busca de violações destes Termos Legais; (2) tomar as medidas legais apropriadas contra qualquer pessoa que, a nosso exclusivo critério, viole a lei ou estes Termos Legais, incluindo, sem limitação, denunciar tal usuário às autoridades policiais; (3) a nosso exclusivo critério e sem limitação, recusar, restringir o acesso, limitar a disponibilidade ou desativar (na medida do tecnologicamente viável) qualquer uma das suas Contribuições ou qualquer parte das mesmas; (4) a nosso exclusivo critério e sem limitação, aviso ou responsabilidade, remover dos Serviços ou desativar todos os arquivos e conteúdos que sejam excessivos em tamanho ou que sejam de alguma forma onerosos para nossos sistemas; e (5) gerir os Serviços de uma forma concebida para proteger os nossos direitos e propriedade e para facilitar o funcionamento adequado dos Serviços.</p>

<h3 id="ppyes">16. POLÍTICA DE PRIVACIDADE</h3>

<p>Preocupamo-nos com a privacidade e segurança dos dados. Por favor, reveja a nossa <a target="_blank" href="privacy-info.php">Política de Privacidade</a>. Ao utilizar os Serviços, concorda em ficar vinculado pela nossa Política de Privacidade, que está incorporada nestes Termos Legais. Informamos que os Serviços estão alojados no Reino Unido. Se aceder aos Serviços a partir de qualquer outra região do mundo com leis ou outros requisitos que regem a recolha, utilização ou divulgação de dados pessoais que diferem das leis aplicáveis no Reino Unido, então, através da sua utilização continuada dos Serviços, está a transferir os seus dados para o Reino Unido e consente expressamente que os seus dados sejam transferidos e processados no Reino Unido.</p>

<h3 id="dmca">17. AVISO E POLÍTICA DA LEI DE DIREITOS AUTORAIS DO MILÊNIO DIGITAL (DMCA)</h3>

<p>Notificações</p>

<p>Respeitamos os direitos de propriedade intelectual de terceiros. Se você acredita que qualquer material disponível nos ou através dos Serviços infringe qualquer direito autoral que você possui ou controla, notifique imediatamente nosso Agente de Direitos Autorais Designado usando as informações de contato fornecidas abaixo (uma "Notificação"). Uma cópia da sua Notificação será enviada à pessoa que publicou ou armazenou o material abordado na Notificação. Informamos que, de acordo com a lei federal, você pode ser responsabilizado por danos se fizer deturpações materiais em uma Notificação. Assim, se você não tiver certeza de que o material localizado ou vinculado pelos Serviços infringe seus direitos autorais, você deve considerar primeiro entrar em contato com um advogado.</p>

<p>Todas as Notificações devem cumprir os requisitos do DMCA 17 U.S.C. § 512(c)(3) e incluir as seguintes informações: (1) Uma assinatura física ou eletrónica de uma pessoa autorizada a agir em nome do proprietário de um direito exclusivo alegadamente violado; (2) identificação do trabalho protegido por direitos autorais que alega ter sido violado ou, se vários trabalhos protegidos por direitos autorais nos Serviços forem cobertos pela Notificação, uma lista representativa de tais trabalhos nos Serviços; (3) identificação do material que se alega estar a infringir ou ser objeto de atividade infratora e que deve ser removido ou cujo acesso deve ser desativado, e informações razoavelmente suficientes para nos permitir localizar o material; (4) informações razoavelmente suficientes para nos permitir entrar em contato com a parte reclamante, como um endereço, número de telefone e, se disponível, um endereço de e-mail no qual a parte reclamante possa ser contatada; (5) uma declaração de que a parte reclamante acredita de boa-fé que o uso do material da maneira reclamada não é autorizado pelo proprietário dos direitos autorais, seu agente ou pela lei; e (6) uma declaração de que as informações contidas na notificação são precisas e, sob pena de perjúrio, de que a parte queixosa está autorizada a agir em nome do titular de um direito exclusivo alegadamente violado.</p>

<p>Contra-notificação</p>

<p>Se você acredita que seu próprio material protegido por direitos autorais foi removido dos Serviços como resultado de um erro ou erro de identificação, você pode enviar uma contranotificação por escrito para [nós/nosso Agente de Direitos Autorais Designado] usando as informações de contato fornecidas abaixo (uma "Contranotificação"). Para ser uma Contranotificação eficaz sob a DMCA, sua Contranotificação deve incluir substancialmente o seguinte: (1) identificação do material que foi removido ou desativado e o local em que o material apareceu antes de ser removido ou desativado; (2) uma declaração de que você concorda com a jurisdição do Tribunal do Distrito Federal em que seu endereço está localizado, ou, se seu endereço estiver fora dos Estados Unidos, para qualquer distrito judicial em que estejamos localizados; (3) uma declaração de que você aceitará a citação ou notificação da parte que apresentou a Notificação ou do agente da parte; (4) seu nome, endereço e número de telefone; (5) uma declaração, sob pena de perjúrio, de que você acredita de boa-fé que o material em questão foi removido ou desativado como resultado de um erro ou identificação incorreta do material a ser removido ou desativado; e (6) a sua assinatura física ou eletrónica.</p>

<p>Se você nos enviar uma Contranotificação válida e por escrito que atenda aos requisitos descritos acima, restauraremos seu material removido ou desativado, a menos que recebamos primeiro um aviso da parte que apresentou a Notificação informando-nos de que essa parte entrou com uma ação judicial para impedi-lo de se envolver em atividades infratoras relacionadas ao material em questão. Observe que, se você deturpar materialmente que o conteúdo desativado ou removido foi removido por engano ou identificação incorreta, você pode ser responsabilizado por danos, incluindo custos e honorários advocatícios. A apresentação de uma contranotificação falsa constitui perjúrio.</p>

<p>Agente de Direitos Autorais Designado</p>
<ul>
    <li>À atenção de: Copyright Agent</li>
    <li></li>
    <li></li>
</ul>

<h3 id="terms">18. PRAZO E RESCISÃO</h3>

<p>Estes Termos Legais permanecerão em pleno vigor e efeito enquanto você usar os Serviços. SEM LIMITAR QUALQUER OUTRA DISPOSIÇÃO DESTES TERMOS LEGAIS, RESERVAMO-NOS O DIREITO DE, A NOSSO EXCLUSIVO CRITÉRIO E SEM AVISO PRÉVIO OU RESPONSABILIDADE, NEGAR O ACESSO E O USO DOS SERVIÇOS (INCLUINDO O BLOQUEIO DE CERTOS ENDEREÇOS IP), A QUALQUER PESSOA POR QUALQUER MOTIVO OU SEM MOTIVO, INCLUINDO, SEM LIMITAÇÃO, A VIOLAÇÃO DE QUALQUER REPRESENTAÇÃO, GARANTIA OU PACTO CONTIDO NESTES TERMOS LEGAIS OU DE QUALQUER LEI OU REGULAMENTO APLICÁVEL. PODEMOS ENCERRAR SEU USO OU PARTICIPAÇÃO NOS SERVIÇOS OU EXCLUIR SUA CONTA E QUALQUER CONTEÚDO OU INFORMAÇÃO QUE VOCÊ POSTOU A QUALQUER MOMENTO, SEM AVISO, A NOSSO EXCLUSIVO CRITÉRIO.</p>

<p>Se encerrarmos ou suspendermos a sua conta por qualquer motivo, está proibido de se registar e criar uma nova conta com o seu nome, um nome falso ou emprestado, ou o nome de terceiros, mesmo que possa estar a agir em nome desses terceiros. Além de encerrar ou suspender sua conta, reservamo-nos o direito de tomar as medidas legais apropriadas, incluindo, sem limitação, a busca de reparação civil, criminal e cautelar.</p>

<h3 id="modifications">19. MODIFICAÇÕES E INTERRUPÇÕES</h3>

<p>Reservamo-nos o direito de alterar, modificar ou remover o conteúdo dos Serviços a qualquer momento ou por qualquer motivo, a nosso exclusivo critério, sem aviso prévio. No entanto, não temos qualquer obrigação de atualizar qualquer informação nos nossos Serviços. Também nos reservamos o direito de modificar ou descontinuar a totalidade ou parte dos Serviços sem aviso prévio a qualquer momento. Não seremos responsáveis perante si ou terceiros por qualquer modificação, alteração de preço, suspensão ou descontinuação dos Serviços.</p>

<p>Não podemos garantir que os Serviços estarão disponíveis em todos os momentos. Podemos ter problemas de hardware, software ou outros problemas ou precisar realizar manutenção relacionada aos Serviços, resultando em interrupções, atrasos ou erros. Reservamo-nos o direito de alterar, revisar, atualizar, suspender, descontinuar ou modificar os Serviços a qualquer momento ou por qualquer motivo sem aviso prévio. Você concorda que não temos qualquer responsabilidade por qualquer perda, dano ou inconveniência causada por sua incapacidade de acessar ou usar os Serviços durante qualquer tempo de inatividade ou descontinuação dos Serviços. Nada nestes Termos Legais será interpretado no sentido de nos obrigar a manter e apoiar os Serviços ou a fornecer quaisquer correções, atualizações ou comunicados relacionados com os mesmos.</p>

<h3 id="law">20. LEGISLAÇÃO APLICÁVEL</h3>

<p>Estes Termos Legais são regidos e interpretados de acordo com as leis da Inglaterra, e a Convenção das Nações Unidas de Contratos para a Venda Internacional de Mercadorias é expressamente aplicada. Se a sua residência habitual for na UE, nos EUA ou em qualquer um dos outros 62 países partes na convenção, possui adicionalmente a proteção que lhe é proporcionada pelas disposições obrigatórias da lei do seu país de residência. Isso significa que você pode fazer uma reivindicação para defender seus direitos de proteção ao consumidor em relação a estes Termos Legais na Inglaterra ou em qualquer país parte da convenção onde você reside.</p>

<h3 id="disputes">21. RESOLUÇÃO DE LITÍGIOS</h3>

<h5>Arbitragem Vinculativa</h5>

<p>Se for residente da União Europeia, quaisquer litígios decorrentes ou relacionados com estes Termos Legais serão resolvidos por um árbitro nomeado de acordo com a Arbitragem e as Regras Internas do Tribunal Europeu de Arbitragem, que faz parte do Centro Europeu de Arbitragem com sede em Estrasburgo. O local para tal arbitragem será a Inglaterra. A língua predominante do processo é o inglês. A lei que rege estes processos são as leis da Inglaterra.</p>

<p>Se você for residente dos Estados Unidos, as disputas serão resolvidas por arbitragem nos Estados Unidos. A lei que rege estes procedimentos são as leis dos EUA.</p>

<p>Para residentes de qualquer outro país, o local e os procedimentos de arbitragem serão os mesmos que os estipulados para residentes da União Europeia.</p>

<h5>Restrições</h5>

<p>As Partes acordam que qualquer arbitragem se limitará ao Litígio entre as Partes individualmente. Na extensão máxima permitida por lei, (a) nenhuma arbitragem será associada a qualquer outro processo; (b) não existe qualquer direito ou autoridade para que qualquer Litígio seja arbitrado numa base de ação coletiva ou para utilizar procedimentos de ação coletiva; e (c) não há nenhum direito ou autoridade para que qualquer Disputa seja apresentada em uma suposta capacidade representativa em nome do público em geral ou de quaisquer outras pessoas.</p>

<h5>Exceções à Arbitragem</h5>

<p>As Partes concordam que os seguintes Litígios não estão sujeitos às disposições acima relativas à arbitragem vinculativa: (a) quaisquer Litígios que procurem fazer cumprir ou proteger, ou relativos à validade de, qualquer um dos direitos de propriedade intelectual de uma Parte; (b) qualquer Disputa relacionada a, ou decorrente de, alegações de roubo, pirataria, invasão de privacidade ou uso não autorizado; e c) qualquer pedido de providência cautelar. Se esta disposição for considerada ilegal ou inexequível, nenhuma das Partes optará por arbitrar qualquer Disputa que se enquadre na parte desta disposição considerada ilegal ou inexequível e tal Disputa será decidida por um tribunal de jurisdição competente dentro dos tribunais listados para jurisdição acima, e as Partes concordam em submeter-se à jurisdição pessoal desse tribunal.</p>

<h3 id="corrections">22. CORREÇÕES</h3>

<p>Pode haver informações nos Serviços que contenham erros tipográficos, imprecisões ou omissões, incluindo descrições, preços, disponibilidade e várias outras informações. Reservamo-nos o direito de corrigir quaisquer erros, imprecisões ou omissões e de alterar ou atualizar as informações nos Serviços a qualquer momento, sem aviso prévio.</p>

<h3 id="disclaimer">23. RENÚNCIA DE RESPONSABILIDADE</h3>

<p>OS SERVIÇOS SÃO PRESTADOS NO ESTADO EM QUE SE ENCONTRAM E CONFORME DISPONÍVEIS. VOCÊ CONCORDA QUE O USO DOS SERVIÇOS SERÁ POR SUA CONTA E RISCO. NA MÁXIMA EXTENSÃO PERMITIDA POR LEI, RENUNCIAMOS A TODAS AS GARANTIAS, EXPRESSAS OU IMPLÍCITAS, EM CONEXÃO COM OS SERVIÇOS E SEU USO DOS MESMOS, INCLUINDO, SEM LIMITAÇÃO, AS GARANTIAS IMPLÍCITAS DE COMERCIALIZAÇÃO, ADEQUAÇÃO A UMA FINALIDADE ESPECÍFICA E NÃO VIOLAÇÃO. NÃO DAMOS GARANTIAS OU REPRESENTAÇÕES SOBRE A PRECISÃO OU INTEGRIDADE DO CONTEÚDO DOS SERVIÇOS OU DO CONTEÚDO DE QUAISQUER SITES OU APLICATIVOS MÓVEIS VINCULADOS AOS SERVIÇOS E NÃO ASSUMIREMOS NENHUMA RESPONSABILIDADE POR QUAISQUER (1) ERROS, ERROS OU IMPRECISÕES DE CONTEÚDO E MATERIAIS, (2) DANOS PESSOAIS OU DANOS À PROPRIEDADE, DE QUALQUER NATUREZA,  RESULTANTES DO SEU ACESSO E UTILIZAÇÃO DOS SERVIÇOS, (3) QUALQUER ACESSO OU UTILIZAÇÃO NÃO AUTORIZADA DOS NOSSOS SERVIDORES SEGUROS E/OU TODA E QUALQUER INFORMAÇÃO PESSOAL E/OU INFORMAÇÃO FINANCEIRA ARMAZENADA NOS MESMOS, (4) QUALQUER INTERRUPÇÃO OU CESSAÇÃO DA TRANSMISSÃO DE OU PARA OS SERVIÇOS, (5) QUAISQUER BUGS, VÍRUS, CAVALOS DE TROIA OU SIMILARES QUE POSSAM SER TRANSMITIDOS PARA OU ATRAVÉS DOS SERVIÇOS POR TERCEIROS,  E/OU (6) QUAISQUER ERROS OU OMISSÕES EM QUALQUER CONTEÚDO E MATERIAIS OU POR QUALQUER PERDA OU DANO DE QUALQUER TIPO INCORRIDO COMO RESULTADO DO USO DE QUALQUER CONTEÚDO PUBLICADO, TRANSMITIDO OU DE OUTRA FORMA DISPONIBILIZADO ATRAVÉS DOS SERVIÇOS. NÃO GARANTIMOS, ENDOSSAMOS, GARANTIMOS OU ASSUMIMOS RESPONSABILIDADE POR QUALQUER PRODUTO OU SERVIÇO ANUNCIADO OU OFERECIDO POR TERCEIROS ATRAVÉS DOS SERVIÇOS, QUALQUER SITE HIPERLIGADO OU QUALQUER SITE OU APLICATIVO MÓVEL APRESENTADO EM QUALQUER BANNER OU OUTRA PUBLICIDADE, E NÃO SEREMOS PARTE OU DE QUALQUER FORMA SEREMOS RESPONSÁVEIS POR MONITORAR QUALQUER TRANSAÇÃO ENTRE VOCÊ E QUAISQUER FORNECEDORES TERCEIRIZADOS DE PRODUTOS OU SERVIÇOS. TAL COMO ACONTECE COM A COMPRA DE UM PRODUTO OU SERVIÇO ATRAVÉS DE QUALQUER MEIO OU EM QUALQUER AMBIENTE, DEVE USAR O SEU MELHOR JULGAMENTO E TER CAUTELA QUANDO APROPRIADO.</p>

<h3 id="liability">24. LIMITAÇÕES DE RESPONSABILIDADE</h3>

<p>EM NENHUMA CIRCUNSTÂNCIA NÓS OU NOSSOS DIRETORES, FUNCIONÁRIOS OU AGENTES SEREMOS RESPONSÁVEIS PERANTE VOCÊ OU QUALQUER TERCEIRO POR QUAISQUER DANOS DIRETOS, INDIRETOS, CONSEQUENCIAIS, EXEMPLARES, INCIDENTAIS, ESPECIAIS OU PUNITIVOS, INCLUINDO PERDA DE LUCROS, PERDA DE RECEITA, PERDA DE DADOS OU OUTROS DANOS DECORRENTES DO SEU USO DOS SERVIÇOS, MESMO QUE TENHAMOS SIDO AVISADOS DA POSSIBILIDADE DE TAIS DANOS. NÃO OBSTANTE QUALQUER DISPOSIÇÃO EM CONTRÁRIO CONTIDA NESTE DOCUMENTO, A NOSSA RESPONSABILIDADE PERANTE SI POR QUALQUER CAUSA E INDEPENDENTEMENTE DA FORMA DA AÇÃO, SERÁ SEMPRE LIMITADA AO MONTANTE PAGO, SE HOUVER, POR SI A NÓS DURANTE O PERÍODO DE SEIS (6) MESES ANTES DE QUALQUER CAUSA DE AÇÃO QUE SURJA. CERTAS LEIS ESTADUAIS DOS EUA E LEIS INTERNACIONAIS NÃO PERMITEM LIMITAÇÕES EM GARANTIAS IMPLÍCITAS OU A EXCLUSÃO OU LIMITAÇÃO DE CERTOS DANOS. SE ESSAS LEIS SE APLICAREM A VOCÊ, ALGUMAS OU TODAS AS ISENÇÕES OU LIMITAÇÕES ACIMA PODEM NÃO SE APLICAR A VOCÊ, E VOCÊ PODE TER DIREITOS ADICIONAIS.</p>

<h3 id="indemnification">25. INDEMNIZAÇÃO</h3>

<p>Você concorda em defender, indenizar e nos isentar de responsabilidade, incluindo nossas subsidiárias, afiliadas e todos os nossos respetivos executivos, agentes, parceiros e funcionários, de e contra qualquer perda, dano, responsabilidade, reivindicação ou demanda, incluindo honorários e despesas advocatícias razoáveis, feitas por terceiros devido ou decorrentes de: (1) suas Contribuições; (2) utilização dos Serviços; (3) violação destes Termos Legais; (4) qualquer violação das suas representações e garantias estabelecidas nestes Termos Legais; (5) sua violação dos direitos de terceiros, incluindo, mas não limitado a, direitos de propriedade intelectual; ou (6) qualquer ato nocivo manifesto para com qualquer outro utilizador dos Serviços com quem se ligou através dos Serviços. Não obstante o acima exposto, reservamo-nos o direito, às suas custas, de assumir a defesa e o controlo exclusivos de qualquer assunto pelo qual seja obrigado a indemnizar-nos, e concorda em cooperar, às suas custas, com a nossa defesa de tais reivindicações. Faremos todos os esforços razoáveis para notificá-lo de qualquer reclamação, ação ou processo que esteja sujeito a esta indenização ao tomar conhecimento dela.</p>

<h3 id="userdata">26. DADOS DO UTILIZADOR</h3>

<p>Manteremos determinados dados que você transmite aos Serviços com a finalidade de gerenciar o desempenho dos Serviços, bem como dados relacionados ao seu uso dos Serviços. Embora realizemos backups regulares de rotina dos dados, você é o único responsável por todos os dados que transmitir ou que se relacionem com qualquer atividade que tenha realizado usando os Serviços. Você concorda que não teremos nenhuma responsabilidade perante você por qualquer perda ou corrupção de tais dados, e você renuncia a qualquer direito de ação contra nós decorrente de tal perda ou corrupção de tais dados.</p>

<h3 id="electronic">27. COMUNICAÇÕES, TRANSAÇÕES E ASSINATURAS ELETRÓNICAS</h3>

<p>Visitar os Serviços, enviar-nos e-mails e preencher formulários online constituem comunicações eletrónicas. Você concorda em receber comunicações eletrônicas e concorda que todos os acordos, avisos, divulgações e outras comunicações que fornecemos a você eletronicamente, por e-mail e nos Serviços, satisfazem qualquer requisito legal de que tal comunicação seja por escrito. VOCÊ CONCORDA COM O USO DE ASSINATURAS ELETRÔNICAS, CONTRATOS, PEDIDOS E OUTROS REGISTROS, E COM A ENTREGA ELETRÔNICA DE AVISOS, POLÍTICAS E REGISTROS DE TRANSAÇÕES INICIADAS OU CONCLUÍDAS POR NÓS OU POR MEIO DOS SERVIÇOS. Pelo presente, renuncia a quaisquer direitos ou requisitos ao abrigo de quaisquer estatutos, regulamentos, regras, portarias ou outras leis em qualquer jurisdição que exijam uma assinatura original ou a entrega ou retenção de registos não eletrónicos, ou a pagamentos ou a concessão de créditos por qualquer meio que não seja eletrónico.</p>

<h3 id="california">28. UTILIZADORES E RESIDENTES DA CALIFÓRNIA</h3>

<p>Se alguma reclamação conosco não for resolvida satisfatoriamente, você pode entrar em contato com a Unidade de Assistência a Reclamações da Divisão de Serviços ao Consumidor do Departamento de Assuntos do Consumidor da Califórnia por escrito em 1625 North Market Blvd., Suite N 112, Sacramento, Califórnia 95834 ou por telefone em (800) 952-5210 ou (916) 445-1254.</p>

<h3 id="misc">29. DISPOSIÇÕES DIVERSAS</h3>

<p>Estes Termos Legais e quaisquer políticas ou regras operacionais publicadas por nós nos Serviços ou em relação aos Serviços constituem o acordo e entendimento integral entre você e nós. A nossa falha em exercer ou fazer cumprir qualquer direito ou disposição destes Termos Legais não funcionará como uma renúncia de tal direito ou disposição. Estes Termos Legais operam na máxima extensão permitida por lei. Podemos ceder qualquer um ou todos os nossos direitos e obrigações a terceiros a qualquer momento. Não seremos responsáveis por qualquer perda, dano, atraso ou falha em agir causado por qualquer causa fora do nosso controlo razoável. Se qualquer disposição ou parte de uma disposição destes Termos Legais for considerada ilegal, nula ou inexequível, essa disposição ou parte da disposição é considerada separável destes Termos Legais e não afeta a validade e aplicabilidade de quaisquer disposições restantes. Não existe nenhuma relação de joint venture, parceria, emprego ou agência criada entre si e nós como resultado destes Termos Legais ou da utilização dos Serviços. Você concorda que estes Termos Legais não serão interpretados contra nós em virtude de tê-los redigido. Você renuncia a toda e qualquer defesa que possa ter com base no formulário eletrônico destes Termos Legais e na falta de assinatura pelas partes para executar estes Termos Legais.</p>

<h3 id="contact">30. FALE CONNOSCO</h3>

<p>Para resolver uma reclamação relativa aos Serviços ou para receber mais informações sobre a utilização dos Serviços, contacte-nos através do seguinte endereço:</p>

<p> </p>
<p></p>
<p></p>

</div>
    </div>
</div>



        <footer class="footer-sp img-MbDiK-div">
            <div class="container-sp">
                <div class="ftop-sp">
                    <div class="footer-sp-item">
                        <a class="logo-link-sp" href="./">
                            <img class="logo-img" src="brandLogo.svg" width="37px" alt="">
                            Liquiloan
                        </a>
                        <p class="footer-sp__text">Bem-vindo à Liquiloan, o seu parceiro de confiança em planeamento financeiro e estratégias. Nós somos uma empresa dedicada a fornecer soluções financeiras personalizadas para ajudá-lo a alcançar os seus objetivos econômicos a longo prazo. Com anos de experiência na indústria financeira, a nossa equipa de especialistas está preparada para oferecer orientação segura e eficaz para a gestão dos seus ativos, investimentos e finanças pessoais. Na Liquiloan, acreditamos que o planeamento financeiro eficaz é a chave para uma vida tranquila e segura. Esforçamo-nos para proporcionar uma abordagem transparente, honesta e direcionada ao cliente, assegurando que todos os seus projetos pessoais e profissionais se realizem com sucesso. Confie na Liquiloan para elaborar uma estratégia financeira robusta que atenderá a todas as suas expectativas e necessidades. Deixe-nos ser o seu guia no caminho para a independência financeira e prosperidade.</p>
                    </div>
                    
                    <div class="footer-sp-item fbottom-pol">
                        <a href="privacy-info.php">Política de privacidade</a>
                        <a href="legalTerms.php">  Termo e condições</a>
                        <a href="content-disclaimer.php">Isenções de responsabilidade</a>
                    </div>
                </div>
                <div class="footer-sp-dec1">
                    <svg width="79" height="94" viewBox="0 0 79 94" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect opacity="0.3" x="-41" y="26.9426" width="66.6675" height="66.6675" transform="rotate(-22.9007 -41 26.9426)" fill="url(#paint0_linear_94:889)"></rect>
                    <rect x="-41" y="26.9426" width="66.6675" height="66.6675" transform="rotate(-22.9007 -41 26.9426)" stroke="url(#paint1_linear_94:889)" stroke-width="0.7"></rect>
                    <path opacity="0.3" d="M50.5215 7.42229L20.325 1.14771L46.2077 62.3249L77.1885 68.2073L50.5215 7.42229Z" fill="url(#paint2_linear_94:889)"></path>
                    <path d="M50.5215 7.42229L20.325 1.14771L46.2077 62.3249L76.7963 68.2073L50.5215 7.42229Z" stroke="url(#paint3_linear_94:889)" stroke-width="0.7"></path>
                    <path opacity="0.3" d="M17.9721 93.3057L-14.9695 88.2076L46.2077 62.325L77.1885 68.2074L17.9721 93.3057Z" fill="url(#paint4_linear_94:889)"></path>
                    <path d="M17.972 93.3057L-14.1852 88.2076L46.2077 62.325L77.1884 68.2074L17.972 93.3057Z" stroke="url(#paint5_linear_94:889)" stroke-width="0.7"></path>
                    <defs>
                    <linearGradient id="paint0_linear_94:889" x1="-41" y1="21.8445" x2="36.9671" y2="59.8878" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint1_linear_94:889" x1="25.6675" y1="95.9631" x2="-42.9608" y2="20.668" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    <linearGradient id="paint2_linear_94:889" x1="20.325" y1="-3.98039" x2="90.6248" y2="25.1062" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint3_linear_94:889" x1="18.3642" y1="-1.59742" x2="113.9" y2="80.6826" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    <linearGradient id="paint4_linear_94:889" x1="61.1098" y1="62.3249" x2="-8.82468" y2="58.2156" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0.62"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0"></stop>
                    </linearGradient>
                    <linearGradient id="paint5_linear_94:889" x1="65.4236" y1="65.0701" x2="24.0178" y2="41.6598" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#009500" stop-opacity="0"></stop>
                    <stop offset="1" stop-color="#009500" stop-opacity="0.51"></stop>
                    </linearGradient>
                    </defs>
                    </svg>
                </div>
                <div class=" footer-sp-dec2">
                    <svg width="55" height="99" viewBox="0 0 55 99" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="#959CB1"></circle>
                    <mask id="mask0_94:899" style="mask-type: alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="99" height="99">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="#009500"></circle>
                    </mask>
                    <g mask="url(#mask0_94:899)">
                    <circle opacity="0.8" cx="49.5" cy="49.5" r="49.5" fill="url(#paint0_radial_94:899)"></circle>
                    <g opacity="0.8" filter="url(#filter0_f_94:899)">
                    <circle cx="53.8676" cy="26.2061" r="20.3824" fill="white"></circle>
                    </g>
                    </g>
                    <defs>
                    <filter id="filter0_f_94:899" x="12.4852" y="-15.1763" width="82.7646" height="82.7646" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                    <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
                    <feGaussianBlur stdDeviation="10.5" result="effect1_foregroundBlur_94:899"></feGaussianBlur>
                    </filter>
                    <radialGradient id="paint0_radial_94:899" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(49.5 49.5) rotate(90) scale(53.1397)">
                    <stop stop-opacity="0.47"></stop>
                    <stop offset="1" stop-opacity="0"></stop>
                    </radialGradient>
                    </defs>
                    </svg>
                </div>
            </div>
        </footer>


 
      

        <a href="#" class="back-to-top">
            <i class="bi bi-chevron-up"></i>
        </a>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const toggleNav = document.querySelector('.menu-btn-sp');
    const navigation = document.querySelector('.mob-menu-sp');

    toggleNav.addEventListener('click', function(){
        toggleNav.classList.toggle('nav-expanded');
        navigation.classList.toggle('nav-visible');
    });
});


document.addEventListener("scroll", () => {
    const mainHeader = document.querySelector('.header-sp');
    const scrollToTopButton = document.querySelector('.back-to-top');
    const scrollPosition = window.scrollY;

    mainHeader.classList.toggle("header-scrolled", scrollPosition > 0);
    scrollToTopButton.classList.toggle("visible", scrollPosition > 100);
});

document.addEventListener("DOMContentLoaded", function() {
    const userForm = document.querySelector('.form-sp');
    const userSignup = document.querySelector('.signup-sp');

    if (!userForm) {
        userSignup.classList.add("exclusive-signup");
    }
});

document.addEventListener("DOMContentLoaded", function() {
    const commentBlock = document.querySelector('.comments-sp-item');
    const commentAuthor = document.querySelector('.comments-sp-author');

    if (commentBlock.classList.contains("flex-column")) {
        commentAuthor.style.cssText = "padding-top: 32px; margin-top: 32px; border-top: solid 1px;";
    } else {
        commentAuthor.style.cssText = "padding-bottom: 32px; margin-bottom: 32px; border-bottom: solid 1px;";
    }
});

(() => {
    document.querySelectorAll('.hero-inner-sp .welcome-title-sp, .hero-inner-sp .welcome-btn-sp, .features-sp-title, .marg, .features-sp-it, .main-sp-img-wraper, .video-title-wraper-sp, .intro-video-play-sp, .partners-wraper, .comments-sp-header, .comments-sp-wraper, .tarifs-sp-list, .forms .container-sp, .footer-sp').forEach(el => {
        el.classList.add('wow', 'animate__fadeInUp');
    });

    new WOW({
        animateClass: 'animate__animated',
    }).init();
})();


let menuBtn = document.querySelector('.menu-btn-sp');
let menu = document.querySelector('.mob-menu-sp');

menuBtn.addEventListener('click', function(){
    menuBtn.classList.toggle('active');
    menu.classList.toggle('active');
})
let headerDirection = document.querySelector('.nav-inner-sp');
let mobMenu = $('.mob-menu-sp');

if (headerDirection.classList.contains("flex-row")) {  
    mobMenu.css('right', "0");
} else {
    mobMenu.css('left', "0");
}
</script>

           

</body>
</html>
