<?php

require_once 'src/_condb.php';

function obterIpApi() {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT geoip_apikey FROM configuracoes");
    $stmt->execute();
    return $stmt->fetchColumn();
}

function obterInfoIP($ip) {
    $apiKey = obterIpApi();
    $url = "http://pro.ip-api.com/json/{$ip}?fields=17033757&key={$apiKey}&lang=pt-BR";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

function detectarDispositivoSistema($userAgent) {
    $dispositivo = "Desconhecido";
    $sistema = "Desconhecido";

    $regexAndroid = '/\(Linux;\s(?:U;)?\s?Android\s([\d\.]+);(?:\s\w{2}-\w{2};)?\s(.*?)(?:\/| Build\/)?([^\)]+)/';
    $regexIPhone = '/\(iPhone;.*?OS\s([\d_]+).*?\)/';
    $regexWindowsPhone = '/\(Windows\sPhone\s[\d\.]+;\s(?:Android\s([\d\.]+);)?\s(?:.*?;\s)?(.*?)\)/';
    $regexTablet = '/\(iPad;(.*?OS\s[\d_]+.*?)?\)/';
    $regexDesktop = '/\(Windows\sNT\s[\d\.]+;\s(?:WOW64;)?\s*(.*?)\)/';
    $regexBlackBerry = '/\(BB10;.*?\)/';
    $regexMac = '/\(Macintosh;\sIntel\sMac\sOS\sX\s([\d_]+)\).*?/';
    $regexLinux = '/\(X11;\sLinux\s.*?\)\sGecko\/\d+\sFirefox\/[\d\.]+/';
    $regexBot = '/Go-http-client\/|TelegramBot|Googlebot|bot/i';
    $regexWindows = '/\(Windows\sNT\s([\d_]+);\s(Win64;\sx64)\).*?/';

    if (preg_match($regexAndroid, $userAgent, $matches)) {
        $sistema = 'Android ' . $matches[1];
        $dispositivo = $matches[3];
        $dispositivo = preg_replace('/(\/|HMSCore).*?$/', '', $dispositivo);
        $dispositivo = str_replace(array(' Build', $matches[2]), '', $dispositivo);
    }
    elseif (preg_match($regexIPhone, $userAgent, $matches)) {
        $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "iPhone";
    }
    elseif (preg_match($regexWindowsPhone, $userAgent, $matches)) {
        $sistema = 'Android ' . $matches[1];
        $dispositivo = $matches[2];
    }
    elseif (preg_match($regexTablet, $userAgent, $matches)) {
        $sistema = 'iOS ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "iPad";
    }
    elseif (preg_match($regexDesktop, $userAgent, $matches)) {
        $sistema = 'Windows';
        $dispositivo = $matches[1];
    }
    elseif (preg_match($regexBlackBerry, $userAgent)) {
        $sistema = "BlackBerry";
        $dispositivo = "BlackBerry";
    }
    elseif (preg_match($regexMac, $userAgent, $matches)) {
        $sistema = 'Mac OSX ' . str_replace('_', '.', $matches[1]);
        $dispositivo = "Macintosh";
    }
    elseif (preg_match($regexLinux, $userAgent)) {
        $sistema = "Linux";
        $dispositivo = "Firefox";
    }
    elseif (preg_match($regexBot, $userAgent)) {
        if (stripos($userAgent, 'Go-http-client') !== false) {
            $sistema = "BOT";
            $dispositivo = "BOT";
        } elseif (stripos($userAgent, 'TelegramBot') !== false) {
            $sistema = "TelegramBot";
            $dispositivo = "TelegramBot";
        } elseif (stripos($userAgent, 'Googlebot') !== false) {
            $sistema = "Googlebot";
            $dispositivo = "Googlebot";
        }
    }
    elseif (preg_match($regexWindows, $userAgent, $matches)) {
        $sistema = 'Windows ' . str_replace('_', '.', $matches[1]);
        $dispositivo = $matches[2];
    }
    else {
        $sistema = "Desconhecido";
        $dispositivo = "Desconhecido";
    }

    return array($dispositivo, $sistema);
}


function verificarAcesso($ip) {
    $pdoAcs = conAcs();
    $pdoDb = conDb();

    $stmt = $pdoDb->query("SELECT * FROM configuracoes");
    $configuracoes = $stmt->fetch(PDO::FETCH_ASSOC);

    //error_log("Configurações: " . print_r($configuracoes, true));

    $infoIP = obterInfoIP($ip);
    //error_log("Informações de IP: " . print_r($infoIP, true));

    if (empty($infoIP['hostname'])) {
        $infoIP['hostname'] = gethostbyaddr($ip);
    }

    $stmt = $pdoAcs->prepare("SELECT * FROM acessos WHERE ip = ? ORDER BY dthr DESC LIMIT 1");
    $stmt->execute([$ip]);
    $acesso = $stmt->fetch();

    //error_log("Acesso encontrado: " . print_r($acesso, true));

    if ($acesso) {
        if ($configuracoes['restringir_paises'] == 'true' && !empty($infoIP['country']) && !verificarPaisPermitido($infoIP['country'], $pdoDb)) {
            error_log("Bloqueado por país.");
            return "PAIS BLOQUEADO";
        }
        if ($configuracoes['bloquear_asns'] == 'true' && !empty($infoIP['as']) && verificarAsnBloqueado($infoIP['as'], $pdoDb)) {
            error_log("Bloqueado por ASN.");
            return "ASN BLOQUEADO";
        }
        if ($configuracoes['bloquear_ips'] == 'true' && verificarIpBloqueado($ip, $pdoDb)) {
            error_log("Bloqueado por IP.");
            return "IP BLOQUEADO";
        }
        if ($configuracoes['bloquear_isps'] == 'true' && !empty($infoIP['isp']) && verificarIspBloqueado($infoIP['isp'], $pdoDb)) {
            error_log("Bloqueado por ISP.");
            return "ISP BLOQUEADO";
        }
        if ($configuracoes['bloquear_hostnames'] == 'true' && !empty($infoIP['hostname']) && verificarHostnameBloqueado($infoIP['hostname'], $pdoDb)) {
            error_log("Bloqueado por hostname.");
            return "HN BLOQUEADO";
        }
        if ($configuracoes['bloquear_useragents'] == 'true' && $acesso && verificarUserAgentBloqueado($acesso['useragent'], $pdoDb)) {
            error_log("Bloqueado por User Agent.");
            return "UA BLOQUEADO";
        }
        if ($configuracoes['bloquear_palavras'] == 'true' && !empty($infoIP['hostname']) && verificarPalavrasBloqueadas($infoIP['hostname'], $pdoDb)) {
            error_log("Bloqueado por palavra bloqueada.");
            return "PL BLOQUEADA";
        }

        //error_log("Status final de acesso: Liberado");
        return "Liberado";
    } else {
        return "VERIFICANDO";
    }
}
function registrarAcesso($ip, $numero, $nome, $status) {
    if ($status === 'VERIFICANDO') {
        return;
    }
    
    date_default_timezone_set('America/Sao_Paulo');
    $dataHora = date('d/m/Y H:i:s');
    $useragent = $_SERVER['HTTP_USER_AGENT'] ?? 'n/a';
    $referer = $_SERVER['HTTP_REFERER'] ?? ($_SERVER['HTTP_HOST'] ?? '') . ($_SERVER['REQUEST_URI'] ?? 'direto');
    $pdo = conAcs();

    $infoIP = obterInfoIP($ip);
    $hostname = $infoIP['hostname'] ?? gethostbyaddr($ip);
	$conexaoComponents = [
		'Mobile' => $infoIP['mobile'],
		'Proxy' => $infoIP['proxy'],
		'Hosting' => $infoIP['hosting']
	];
	$conexaoParts = array_keys(array_filter($conexaoComponents));
	$conexao = !empty($conexaoParts) ? implode('/', $conexaoParts) : 'Normal';

    //error_log("Registrando acesso: IP = $ip, UserAgent = $useragent, Número = $numero, Status = $status, Conexão = $conexao");

    $stmt = $pdo->prepare("SELECT * FROM acessos WHERE ip = ? AND useragent = ? AND numero = ? ORDER BY dthr DESC LIMIT 1");
    $stmt->execute([$ip, $useragent, $numero]);
    $ultimoAcesso = $stmt->fetch();

    if (!$ultimoAcesso) {
        list($dispositivo, $sistema) = detectarDispositivoSistema($useragent);
        $stmt = $pdo->prepare("INSERT INTO acessos (ip, hostname, isp, asn, cidade, estado, pais, referer, useragent, dispositivo, sistema, status, clicks, dthr, numero, nome, conexao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, ?, ?, ?, ?)");
        $stmt->execute([$ip, $hostname, $infoIP['isp'], $infoIP['as'], $infoIP['city'], $infoIP['region'], $infoIP['country'], $referer, $useragent, $dispositivo, $sistema, $status, $dataHora, $numero, $nome, $conexao]);

        //error_log("Novo acesso registrado.");
    } else {
        $stmt = $pdo->prepare("UPDATE acessos SET clicks = clicks + 1, dthr = ?, status = ? WHERE ip = ? AND useragent = ? AND numero = ?");
        $stmt->execute([$dataHora, $status, $ip, $useragent, $numero]);

        //error_log("Acesso existente atualizado.");
    }
}


function atualizarStatusAcesso($ip, $useragent, $numero, $status) {
    date_default_timezone_set('America/Sao_Paulo');
    $dataHora = date('d/m/Y H:i:s');
    $pdo = conAcs();

    $stmt = $pdo->prepare("UPDATE acessos SET status = ?, dthr = ? WHERE ip = ? AND useragent = ? AND numero = ?");
    $stmt->execute([$status, $dataHora, $ip, $useragent, $numero]);

    //error_log("Status do acesso atualizado para: $status");
}


function verificarPaisPermitido($pais, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM paises_permitidos WHERE pais = ?");
    $stmt->execute([$pais]);
    return $stmt->fetchColumn() > 0;
}

function verificarAsnBloqueado($asn, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM asns_bloqueados WHERE asn = ?");
    $stmt->execute([$asn]);
    return $stmt->fetchColumn() > 0;
}

function verificarIpBloqueado($ip, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM ips_bloqueados WHERE ip = ?");
    $stmt->execute([$ip]);
    return $stmt->fetchColumn() > 0;
}

function verificarIspBloqueado($isp, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM isps_bloqueados WHERE isp = ?");
    $stmt->execute([$isp]);
    return $stmt->fetchColumn() > 0;
}

function verificarHostnameBloqueado($hostname, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM hostnames_bloqueados WHERE hostname = ?");
    $stmt->execute([$hostname]);
    return $stmt->fetchColumn() > 0;
}

function verificarUserAgentBloqueado($useragent, $pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM useragents_bloqueados WHERE useragent = ?");
    $stmt->execute([$useragent]);
    return $stmt->fetchColumn() > 0;
}
function verificarPalavrasBloqueadas($hostname, $pdo) {
    // Preparar a consulta para buscar todas as palavras bloqueadas
    $stmt = $pdo->query("SELECT palavra FROM palavras_bloqueadas");
    $palavras = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Verificar se alguma das palavras bloqueadas está contida no hostname
    foreach ($palavras as $palavra) {
        if (strpos($hostname, $palavra) !== false) {
            return true;  // Palavra bloqueada encontrada
        }
    }
    return false;  // Nenhuma palavra bloqueada encontrada
}

function detectarDispositivoMovel($userAgent) {
    $dispositivosMoveis = array(
        'iPhone', 'iPad', 'iPod', 'Android', 'webOS', 'BlackBerry', 'Windows Phone'
    );

    $userAgent = strtolower($userAgent);

    foreach ($dispositivosMoveis as $dispositivo) {
        if (strpos($userAgent, strtolower($dispositivo)) !== false) {
            return true;
        }
    }

    return false;
}

function verificarRestricaoMobile() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT restringir_mobile FROM configuracoes");
    $restricaoMobile = $stmt->fetchColumn();
    return $restricaoMobile === 'true';
}

function verificarRestricaoNumeros() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT restringir_numeros FROM configuracoes");
    $restricaoNumeros = $stmt->fetchColumn();
    return $restricaoNumeros === 'true';
}


function verificarNumero($numero) {
    $pdo = conNum();
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM numeros WHERE numero_semcod = ?");
    $stmt->execute([$numero]);
    $existeNumero = $stmt->fetchColumn() > 0;
    return $existeNumero;
}
function obterNome($numero) {
    $pdo = conNum();
    $stmt = $pdo->prepare("SELECT nome FROM numeros WHERE numero_semcod = ?");
    $stmt->execute([$numero]);
    $nome = $stmt->fetchColumn();
    return $nome;
}

function obterGet() {
    $pdo = conDb();
    $stmt = $pdo->query("SELECT get_id FROM configuracoes");
    $get_id = $stmt->fetchColumn();
    return $get_id;
}
	

function obterUrl($tipo) {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT url_$tipo FROM configuracoes");
    $stmt->execute();
    return $stmt->fetchColumn();
}


function listarAcessos($tipoAba) {
    $pdo = conAcs();

    switch ($tipoAba) {
        case 'gerais':
        case 'acessos-gerais':
            $stmt = $pdo->query("SELECT * FROM acessos ORDER BY id DESC");
            break;
        case 'permitidos':
        case 'acessos-permitidos':
            $stmt = $pdo->query("SELECT * FROM acessos WHERE status LIKE '%LIBERADO%' ORDER BY id DESC");
            break;
        case 'bloqueados':
        case 'acessos-bloqueados':
            $stmt = $pdo->query("SELECT * FROM acessos WHERE status NOT LIKE '%LIBERADO%' ORDER BY id DESC");
            break;
        default:
            echo json_encode(['success' => false, 'message' => "Tipo de aba inválido: $tipoAba"]);
            return;
    }

    $acessos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($acessos);
}


function contarAcessos($tipo) {
    $pdo = conAcs();
    $stmt = null;

    switch ($tipo) {
        case 'gerais':
            $stmt = $pdo->query("SELECT COUNT(*) AS total FROM acessos");
            break;
        case 'permitidos':
            $stmt = $pdo->query("SELECT COUNT(*) AS total FROM acessos WHERE status LIKE '%LIBERADO%'");
            break;
        case 'bloqueados':
            $stmt = $pdo->query("SELECT COUNT(*) AS total FROM acessos WHERE status NOT LIKE '%LIBERADO%'");
            break;
        default:
            return null;
    }

    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $total = $result['total'];

    return $total;
}
function attContadorAcessos() {
    $qtdAcessosGerais = contarAcessos('gerais');
    $qtdAcessosPermitidos = contarAcessos('permitidos');
    $qtdAcessosBloqueados = contarAcessos('bloqueados');

    $contadores = array(
        'Gerais' => $qtdAcessosGerais,
        'Permitidos' => $qtdAcessosPermitidos,
        'Bloqueados' => $qtdAcessosBloqueados
    );
    echo json_encode($contadores);
}

function zerarAcessos($tipo) {
    $pdo = conAcs();

    switch ($tipo) {
        case 'gerais':
            $stmt = $pdo->prepare("DELETE from acessos");
            $stmt->execute();
            break;
        case 'permitidos':
            $stmt = $pdo->prepare("DELETE FROM acessos WHERE status LIKE '%LIBERADO%'");
            $stmt->execute();
            break;
        case 'bloqueados':
            $stmt = $pdo->prepare("DELETE FROM acessos WHERE status NOT LIKE '%LIBERADO%'");
            $stmt->execute();
            break;
        default:
            break;
    }
    echo "Acessos zerados com sucesso!";
}

function gerarUserHash($userId, $secretKey) {
    return hash_hmac('sha256', $userId, $secretKey);
}

$httperrors = [
    '404' => 'HTTP/1.1 404 Not Found',
    '403' => 'HTTP/1.1 403 Forbidden',
    '444' => 'HTTP/1.1 444 No Response', // Este não é um código padrão e pode não ser reconhecido por todos os clientes.
    '500' => 'HTTP/1.1 500 Internal Server Error',
    '502' => 'HTTP/1.1 502 Bad Gateway'
];

function redirecionar($tipoDispositivo, $obterget, $userId, $restringirNumeros = false) {
    global $httperrors;
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT redir_{$tipoDispositivo}_url, url_{$tipoDispositivo}, redir_{$tipoDispositivo}_erro, tipo_erro_{$tipoDispositivo} FROM configuracoes");
    $stmt->execute();
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    $secretKey = '6c3230942b9024faa4633b6014d3cb6f'; // Chave secreta para gerar o hash
    $userHash = gerarUserHash($userId, $secretKey); // Gerar hash do usuário

    if ($config["redir_{$tipoDispositivo}_url"] == 'true') {
        $finalUrl = $config["url_{$tipoDispositivo}"];
        // Adicionar parâmetro e hash se a restrição de números está ativa ou se userId é fornecido
        if ($restringirNumeros && $userId !== '') {
            $finalUrl .= '?' . $obterget . '=' . $userId . "&userHash=" . $userHash;
			
			
        } else {
    // Adicionar um userId aleatório quando não há restrição de números
		$randomUserId = bin2hex(random_bytes(8)); // Gera um identificador pseudo-aleatório
		$userHash = gerarUserHash($randomUserId, $secretKey); // Gerar hash do usuário com o identificador aleatório
		$finalUrl .= "?userId=" . $randomUserId . "&userHash=" . $userHash;
	}
        header("Location: " . $finalUrl);
        exit;
    } elseif ($config["redir_{$tipoDispositivo}_erro"] == 'true') {
        header($httperrors[$config["tipo_erro_{$tipoDispositivo}"]]);
        exit;
    }
}

function verificarAutoAtualizador() {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT auto_atualizar FROM configuracoes");
    $stmt->execute();
    $statusAutoAtualizador = $stmt->fetchColumn();
    return filter_var($statusAutoAtualizador, FILTER_VALIDATE_BOOLEAN);
}

function obterIntervalo() {
    $pdo = conDb();
    $stmt = $pdo->prepare("SELECT intervalo_atualizacao FROM configuracoes WHERE id = 1");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        return $result['intervalo_atualizacao'];
    } else {
        return null;
    }
}



if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    $action = $_POST['action'];
    
    switch ($action) {
        case 'listarAcessos':
            $tipoAba = $_POST['aba'] ?? 'gerais'; 
            listarAcessos($tipoAba);
            break;
        case 'atualizarCtdAcessos':
            attContadorAcessos();
            break;
        case 'zerarAcessos':
            $tabela = $_POST['tabela'];
            zerarAcessos($tabela);
            break;
	  case 'verificarAutoAtualizador':
            $autoAtualizar = verificarAutoAtualizador();
             echo json_encode(['auto_atualizar' => $autoAtualizar]);
      break;
		case 'obterIntervalo':
            $intervalo = obterIntervalo();
            echo json_encode(['intervalo' => $intervalo]);
            break;
        default:
            // Tratamento para outros tipos de solicitação, se necessário
            break;
    }
}

?>
