<?php
session_start();
require_once 'src/_hash.php';
require_once 'src/_lgn.php';

$error = '';
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] == '_vfl') {
    $username = isset($_POST['lgn']) ? $_POST['lgn'] : null;
    $password = isset($_POST['pws']) ? $_POST['pws'] : null;
    
    if ($username && $password) {
        $user = verificarLogin($username, $password);
        if ($user) {
            $_SESSION['user_id'] = 'userlogged_' . $user['id'];
            $hash = gerarHash($user['id']);
            $_SESSION['hash'] = $hash; 
            logUser($user['id'], $hash);
            header("Location: dash.php#dashboard");
            exit;
        } else {
            $error = 'Credenciais inválidas.';
        }
    } else {
        $error = 'Dados de login não fornecidos.';
    }	
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login</title>
  <!-- Bootstrap CSS -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/pako/2.0.3/pako.min.js"></script>

  <!-- Fonte -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;700&display=swap" rel="stylesheet">
   <style>
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #343a40;
      color: #fff;
    }
    .content {
	  background-color: #343a40; 
	  color: #fff; 
      margin-top: 100px; 
    }
    .topheader {
      z-index: 200;
    }
	.btn-center {
      display: block;
      margin: 0 auto;
    }
  </style>
</head>
<body>
  <header class="bg-dark text-white fixed-top topheader">
    <div class="container-fluid d-flex justify-content-between align-items-center py-2">
      <div>
        <span class="fs-5 text-primary">FL.®</span>
      </div>    
    </div>
  </header>
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-4 mt-5">
        <div class="card mt-5 bg-dark text-white shadow-lg">
          <div class="card-header bg-dark text-primary">
            <h5 class="card-title">Login</h5>
          </div>
          <div class="card-body">
		<form id="lgnf" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <form>
              <div class="mb-3">
				<label for="lgn" class="form-label text-white">Usuario</label>
                <input type="text" class="form-control bg-dark text-white" id="lgn" name="lgn">
              </div>
              <div class="mb-3">
                  <label for="pws" class="form-label text-white">Senha</label>
                <input type="password" class="form-control bg-dark text-white" id="pws" name="pws">
              </div>
			  <input type="hidden" id="action" name="action" value="_vfl">
              <button type="submit" class="btn btn-primary btn-center" id="lgnb" disabled>Login</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="errorModal" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content bg-dark text-white">
        <div class="modal-header">
          <h5 class="modal-title" id="errorModal">Login</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <?php echo $error; ?>
        </div>
      </div>
    </div>
  </div>

 <script>
$(document).ready(function() {
    $('#lgn, #pws').on('input', function() {
        if ($('#lgn').val().length >= 6 && $('#pws').val().length >= 6) {
            $('#lgnb').prop('disabled', false);
        } else {
            $('#lgnb').prop('disabled', true);
        }
    });

    <?php if(!empty($error)): ?>
        $('#loginModal').modal('show');
    <?php endif; ?>
});

  </script>

</body>
</html>
